"use strict";

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// https://github.com/elastic/eui/issues/2530
jest.mock('@elastic/eui/lib/components/icon', () => ({
  EuiIcon: () => /*#__PURE__*/_react.default.createElement("div", null, "EuiIconMock"),
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/components/icon/icon').COLORS
}));
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility', () => ({
  htmlIdGenerator: () => () => 'generated-id',
  cascadingMenuKeys: require('@elastic/eui/lib/services/accessibility/cascading_menu_keys'),
  comboBoxKeys: require('@elastic/eui/lib/services/accessibility/combo_box_keys'),
  accessibleClickKeys: require('@elastic/eui/lib/services/accessibility/accessible_click_keys')
})); // https://github.com/facebook/jest/issues/5785
// https://github.com/facebook/jest/pull/5267#issuecomment-356605468

beforeEach(() => {
  jest.spyOn(console, 'error');
  console.error.mockImplementation(() => {});
});
afterEach(() => {
  console.error.mockRestore();
});

window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNldHVwLmplc3QuanMiXSwibmFtZXMiOlsiamVzdCIsIm1vY2siLCJFdWlJY29uIiwiX19lc01vZHVsZSIsIkljb25Qcm9wVHlwZSIsInJlcXVpcmUiLCJJQ09OX1RZUEVTIiwiVFlQRVMiLCJJQ09OX1NJWkVTIiwiU0laRVMiLCJJQ09OX0NPTE9SUyIsIkNPTE9SUyIsImh0bWxJZEdlbmVyYXRvciIsImNhc2NhZGluZ01lbnVLZXlzIiwiY29tYm9Cb3hLZXlzIiwiYWNjZXNzaWJsZUNsaWNrS2V5cyIsImJlZm9yZUVhY2giLCJzcHlPbiIsImNvbnNvbGUiLCJlcnJvciIsIm1vY2tJbXBsZW1lbnRhdGlvbiIsImFmdGVyRWFjaCIsIm1vY2tSZXN0b3JlIiwid2luZG93IiwiVVJMIiwiY3JlYXRlT2JqZWN0VVJMIl0sIm1hcHBpbmdzIjoiOztBQUtBOzs7O0FBTEE7QUFDQTtBQUNBO0FBQ0E7QUFJQTtBQUNBQSxJQUFJLENBQUNDLElBQUwsQ0FBVSxrQ0FBVixFQUE4QyxPQUFPO0FBQ25EQyxFQUFBQSxPQUFPLEVBQUUsbUJBQU0sd0RBRG9DO0FBRW5EQyxFQUFBQSxVQUFVLEVBQUUsSUFGdUM7QUFHbkRDLEVBQUFBLFlBQVksRUFBRUMsT0FBTyxDQUFDLHVDQUFELENBQVAsQ0FBaURELFlBSFo7QUFJbkRFLEVBQUFBLFVBQVUsRUFBRUQsT0FBTyxDQUFDLHVDQUFELENBQVAsQ0FBaURFLEtBSlY7QUFLbkRDLEVBQUFBLFVBQVUsRUFBRUgsT0FBTyxDQUFDLHVDQUFELENBQVAsQ0FBaURJLEtBTFY7QUFNbkRDLEVBQUFBLFdBQVcsRUFBRUwsT0FBTyxDQUFDLHVDQUFELENBQVAsQ0FBaURNO0FBTlgsQ0FBUCxDQUE5QztBQVNBWCxJQUFJLENBQUNDLElBQUwsQ0FBVSxtREFBVixFQUErRCxNQUFNLE1BQU0sY0FBM0U7QUFFQUQsSUFBSSxDQUFDQyxJQUFMLENBQVUseUNBQVYsRUFBcUQsT0FBTztBQUMxRFcsRUFBQUEsZUFBZSxFQUFFLE1BQU0sTUFBTSxjQUQ2QjtBQUUxREMsRUFBQUEsaUJBQWlCLEVBQUVSLE9BQU8sQ0FBQyw2REFBRCxDQUZnQztBQUcxRFMsRUFBQUEsWUFBWSxFQUFFVCxPQUFPLENBQUMsd0RBQUQsQ0FIcUM7QUFJMURVLEVBQUFBLG1CQUFtQixFQUFFVixPQUFPLENBQUMsK0RBQUQ7QUFKOEIsQ0FBUCxDQUFyRCxFLENBT0E7QUFDQTs7QUFDQVcsVUFBVSxDQUFDLE1BQU07QUFDZmhCLEVBQUFBLElBQUksQ0FBQ2lCLEtBQUwsQ0FBV0MsT0FBWCxFQUFvQixPQUFwQjtBQUNBQSxFQUFBQSxPQUFPLENBQUNDLEtBQVIsQ0FBY0Msa0JBQWQsQ0FBaUMsTUFBTSxDQUFFLENBQXpDO0FBQ0QsQ0FIUyxDQUFWO0FBS0FDLFNBQVMsQ0FBQyxNQUFNO0FBQ2RILEVBQUFBLE9BQU8sQ0FBQ0MsS0FBUixDQUFjRyxXQUFkO0FBQ0QsQ0FGUSxDQUFUOztBQUdBQyxNQUFNLENBQUNDLEdBQVAsQ0FBV0MsZUFBWCxHQUE2QixZQUFZLENBQUUsQ0FBM0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5cbi8vIGh0dHBzOi8vZ2l0aHViLmNvbS9lbGFzdGljL2V1aS9pc3N1ZXMvMjUzMFxuamVzdC5tb2NrKCdAZWxhc3RpYy9ldWkvbGliL2NvbXBvbmVudHMvaWNvbicsICgpID0+ICh7XG4gIEV1aUljb246ICgpID0+IDxkaXY+RXVpSWNvbk1vY2s8L2Rpdj4sXG4gIF9fZXNNb2R1bGU6IHRydWUsXG4gIEljb25Qcm9wVHlwZTogcmVxdWlyZSgnQGVsYXN0aWMvZXVpL2xpYi9jb21wb25lbnRzL2ljb24vaWNvbicpLkljb25Qcm9wVHlwZSxcbiAgSUNPTl9UWVBFUzogcmVxdWlyZSgnQGVsYXN0aWMvZXVpL2xpYi9jb21wb25lbnRzL2ljb24vaWNvbicpLlRZUEVTLFxuICBJQ09OX1NJWkVTOiByZXF1aXJlKCdAZWxhc3RpYy9ldWkvbGliL2NvbXBvbmVudHMvaWNvbi9pY29uJykuU0laRVMsXG4gIElDT05fQ09MT1JTOiByZXF1aXJlKCdAZWxhc3RpYy9ldWkvbGliL2NvbXBvbmVudHMvaWNvbi9pY29uJykuQ09MT1JTLFxufSkpO1xuXG5qZXN0Lm1vY2soJ0BlbGFzdGljL2V1aS9saWIvY29tcG9uZW50cy9mb3JtL2Zvcm1fcm93L21ha2VfaWQnLCAoKSA9PiAoKSA9PiAnc29tZV9tYWtlX2lkJyk7XG5cbmplc3QubW9jaygnQGVsYXN0aWMvZXVpL2xpYi9zZXJ2aWNlcy9hY2Nlc3NpYmlsaXR5JywgKCkgPT4gKHtcbiAgaHRtbElkR2VuZXJhdG9yOiAoKSA9PiAoKSA9PiAnZ2VuZXJhdGVkLWlkJyxcbiAgY2FzY2FkaW5nTWVudUtleXM6IHJlcXVpcmUoJ0BlbGFzdGljL2V1aS9saWIvc2VydmljZXMvYWNjZXNzaWJpbGl0eS9jYXNjYWRpbmdfbWVudV9rZXlzJyksXG4gIGNvbWJvQm94S2V5czogcmVxdWlyZSgnQGVsYXN0aWMvZXVpL2xpYi9zZXJ2aWNlcy9hY2Nlc3NpYmlsaXR5L2NvbWJvX2JveF9rZXlzJyksXG4gIGFjY2Vzc2libGVDbGlja0tleXM6IHJlcXVpcmUoJ0BlbGFzdGljL2V1aS9saWIvc2VydmljZXMvYWNjZXNzaWJpbGl0eS9hY2Nlc3NpYmxlX2NsaWNrX2tleXMnKSxcbn0pKTtcblxuLy8gaHR0cHM6Ly9naXRodWIuY29tL2ZhY2Vib29rL2plc3QvaXNzdWVzLzU3ODVcbi8vIGh0dHBzOi8vZ2l0aHViLmNvbS9mYWNlYm9vay9qZXN0L3B1bGwvNTI2NyNpc3N1ZWNvbW1lbnQtMzU2NjA1NDY4XG5iZWZvcmVFYWNoKCgpID0+IHtcbiAgamVzdC5zcHlPbihjb25zb2xlLCAnZXJyb3InKTtcbiAgY29uc29sZS5lcnJvci5tb2NrSW1wbGVtZW50YXRpb24oKCkgPT4ge30pO1xufSk7XG5cbmFmdGVyRWFjaCgoKSA9PiB7XG4gIGNvbnNvbGUuZXJyb3IubW9ja1Jlc3RvcmUoKTtcbn0pO1xud2luZG93LlVSTC5jcmVhdGVPYmplY3RVUkwgPSBmdW5jdGlvbiAoKSB7fTtcbiJdfQ==