"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class TranslateService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "translateSQL", async request => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser('sql.translateSQL', params);
        const ret = {
          data: {
            ok: true,
            resp: queryResponse
          }
        };
        return ret;
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message
          }
        };
      }
    });

    _defineProperty(this, "translatePPL", async request => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser('sql.translatePPL', params);
        return {
          data: {
            ok: true,
            resp: queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message
          }
        };
      }
    });

    this.client = client;
  }

}

exports.default = TranslateService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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