"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateReportDefinition = void 0;

var _uiToBackend = require("../utils/converters/uiToBackend");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const updateReportDefinition = async (request, context, reportDefinition) => {
  // @ts-ignore
  const opensearchReportsClient = context.reporting_plugin.opensearchReportsClient.asScoped(request); // @ts-ignore

  const reportDefinitionId = request.params.reportDefinitionId; // create report definition

  const reqBody = {
    reportDefinitionId: reportDefinitionId,
    reportDefinition: (0, _uiToBackend.uiToBackendReportDefinition)(reportDefinition)
  };
  const opensearchResp = await opensearchReportsClient.callAsCurrentUser('opensearch_reports.updateReportDefinitionById', {
    reportDefinitionId: reportDefinitionId,
    body: reqBody
  });
  return opensearchResp;
};

exports.updateReportDefinition = updateReportDefinition;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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