/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;
import org.opensearch.knn.index.codec.util.SerializationMode;

public class KNNCodecUtil {
    public static final String HNSW_EXTENSION = ".hnsw";
    public static final String HNSW_COMPOUND_EXTENSION = ".hnswc";
    public static final int FLOAT_BYTE_SIZE = 4;
    public static final int JAVA_REFERENCE_SIZE = 4;
    public static final int JAVA_ARRAY_HEADER_SIZE = 12;
    public static final int JAVA_ROUNDING_NUMBER = 8;

    public static Pair getFloats(BinaryDocValues values) throws IOException {
        ArrayList<float[]> vectorList = new ArrayList<float[]>();
        ArrayList<Integer> docIdList = new ArrayList<Integer>();
        SerializationMode serializationMode = SerializationMode.COLLECTION_OF_FLOATS;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            BytesRef bytesref = values.binaryValue();
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytesref.bytes, bytesref.offset, bytesref.length);){
                serializationMode = KNNVectorSerializerFactory.serializerModeFromStream(byteStream);
                KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByStreamContent(byteStream);
                float[] vector = vectorSerializer.byteToFloatArray(byteStream);
                vectorList.add(vector);
            }
            docIdList.add(doc);
            doc = values.nextDoc();
        }
        return new Pair(docIdList.stream().mapToInt(Integer::intValue).toArray(), (float[][])vectorList.toArray((T[])new float[0][]), serializationMode);
    }

    public static long calculateArraySize(float[][] vectors, SerializationMode serializationMode) {
        int vectorsSize;
        int vectorLength = vectors[0].length;
        int numVectors = vectors.length;
        if (serializationMode == SerializationMode.ARRAY) {
            int vectorsSize2;
            int vectorSize = vectorLength * 4 + 12;
            if (vectorSize % 8 != 0) {
                vectorSize += vectorSize % 8;
            }
            if ((vectorsSize2 = numVectors * (vectorSize + 4) + 12) % 8 != 0) {
                vectorsSize2 += vectorsSize2 % 8;
            }
            return vectorsSize2;
        }
        int vectorSize = vectorLength * 4;
        if (vectorSize % 8 != 0) {
            vectorSize += vectorSize % 8;
        }
        if ((vectorsSize = numVectors * (vectorSize + 4)) % 8 != 0) {
            vectorsSize += vectorsSize % 8;
        }
        return vectorsSize;
    }

    public static String buildEngineFileName(String segmentName, String latestBuildVersion, String fieldName, String extension) {
        return String.format("%s%s%s", KNNCodecUtil.buildEngineFilePrefix(segmentName), latestBuildVersion, KNNCodecUtil.buildEngineFileSuffix(fieldName, extension));
    }

    public static String buildEngineFilePrefix(String segmentName) {
        return String.format("%s_", segmentName);
    }

    public static String buildEngineFileSuffix(String fieldName, String extension) {
        return String.format("_%s%s", fieldName, extension);
    }

    public static final class Pair {
        public int[] docs;
        public float[][] vectors;
        public SerializationMode serializationMode;

        public Pair(int[] docs, float[][] vectors, SerializationMode serializationMode) {
            this.docs = docs;
            this.vectors = vectors;
            this.serializationMode = serializationMode;
        }
    }
}

