/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.AccountSendingPausedException;
import com.amazonaws.services.simpleemail.model.AmazonSimpleEmailServiceException;
import com.amazonaws.services.simpleemail.model.ConfigurationSetDoesNotExistException;
import com.amazonaws.services.simpleemail.model.ConfigurationSetSendingPausedException;
import com.amazonaws.services.simpleemail.model.MailFromDomainNotVerifiedException;
import com.amazonaws.services.simpleemail.model.MessageRejectedException;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.notifications.core.client.EmailMessageValidator;
import org.opensearch.notifications.core.client.EmailMimeProvider;
import org.opensearch.notifications.core.credentials.SesClientFactory;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.SecurityAccess;
import org.opensearch.notifications.spi.model.DestinationMessageResponse;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.SesDestination;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/notifications/core/client/DestinationSesClient;", "", "sesClientFactory", "Lorg/opensearch/notifications/core/credentials/SesClientFactory;", "(Lorg/opensearch/notifications/core/credentials/SesClientFactory;)V", "execute", "Lorg/opensearch/notifications/spi/model/DestinationMessageResponse;", "sesDestination", "Lorg/opensearch/notifications/spi/model/destination/SesDestination;", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "referenceId", "", "getSdkExceptionText", "exception", "Lcom/amazonaws/SdkBaseException;", "getServiceExceptionText", "Lcom/amazonaws/AmazonServiceException;", "getSesExceptionText", "Lcom/amazonaws/services/simpleemail/model/AmazonSimpleEmailServiceException;", "prepareSession", "Ljavax/mail/Session;", "sendMimeMessage", "sesAwsRegion", "roleArn", "mimeMessage", "Ljavax/mail/internet/MimeMessage;", "Companion", "opensearch-notifications-core"})
public final class DestinationSesClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SesClientFactory sesClientFactory;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(DestinationSesClient.class);

    public DestinationSesClient(@NotNull SesClientFactory sesClientFactory) {
        Intrinsics.checkNotNullParameter((Object)sesClientFactory, (String)"sesClientFactory");
        this.sesClientFactory = sesClientFactory;
    }

    private final Session prepareSession() {
        Properties prop = new Properties();
        ((Map)prop).put("mail.transport.protocol", "smtp");
        Session session = Session.getInstance((Properties)prop);
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getInstance(prop)");
        return session;
    }

    @NotNull
    public final DestinationMessageResponse execute(@NotNull SesDestination sesDestination, @NotNull MessageContent message, @NotNull String referenceId) throws Exception {
        Intrinsics.checkNotNullParameter((Object)sesDestination, (String)"sesDestination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        if (EmailMessageValidator.INSTANCE.isMessageSizeOverLimit(message)) {
            return new DestinationMessageResponse(RestStatus.REQUEST_ENTITY_TOO_LARGE.getStatus(), "Email size larger than " + PluginSettings.INSTANCE.getEmailSizeLimit());
        }
        Session session = this.prepareSession();
        MimeMessage mimeMessage = EmailMimeProvider.INSTANCE.prepareMimeMessage(session, sesDestination.getFromAddress(), sesDestination.getRecipient(), message);
        return this.sendMimeMessage(referenceId, sesDestination.getAwsRegion(), sesDestination.getRoleArn(), mimeMessage);
    }

    private final DestinationMessageResponse sendMimeMessage(String referenceId, String sesAwsRegion, String roleArn, MimeMessage mimeMessage) {
        DestinationMessageResponse destinationMessageResponse;
        try {
            DestinationMessageResponse destinationMessageResponse2;
            DestinationSesClient.Companion.getLog().debug("notifications-core:Sending Email-SES:" + referenceId);
            AmazonSimpleEmailService client = this.sesClientFactory.createSesClient(sesAwsRegion, roleArn);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            SecurityAccess.INSTANCE.doPrivileged(() -> DestinationSesClient.sendMimeMessage$lambda$0(mimeMessage, outputStream));
            int emailSize = outputStream.size();
            if (emailSize <= PluginSettings.INSTANCE.getEmailSizeLimit()) {
                RawMessage rawMessage = new RawMessage(ByteBuffer.wrap(outputStream.toByteArray()));
                SendRawEmailRequest rawEmailRequest = new SendRawEmailRequest(rawMessage);
                SendRawEmailResult response = SecurityAccess.INSTANCE.doPrivileged(() -> DestinationSesClient.sendMimeMessage$lambda$1(client, rawEmailRequest));
                DestinationSesClient.Companion.getLog().info("notifications-core:Email-SES:" + referenceId + " status:" + response);
                destinationMessageResponse2 = new DestinationMessageResponse(RestStatus.OK.getStatus(), "Success:" + response.getMessageId());
            } else {
                destinationMessageResponse2 = new DestinationMessageResponse(RestStatus.REQUEST_ENTITY_TOO_LARGE.getStatus(), "Email size(" + emailSize + ") larger than " + PluginSettings.INSTANCE.getEmailSizeLimit());
            }
            destinationMessageResponse = destinationMessageResponse2;
        }
        catch (MessageRejectedException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (MailFromDomainNotVerifiedException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FORBIDDEN.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (ConfigurationSetDoesNotExistException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.NOT_IMPLEMENTED.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (ConfigurationSetSendingPausedException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (AccountSendingPausedException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.INSUFFICIENT_STORAGE.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (AmazonSimpleEmailServiceException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSesExceptionText(exception));
        }
        catch (AmazonServiceException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getServiceExceptionText(exception));
        }
        catch (SdkBaseException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSdkExceptionText(exception));
        }
        return destinationMessageResponse;
    }

    private final String getSesExceptionText(AmazonSimpleEmailServiceException exception) {
        DestinationSesClient.Companion.getLog().info("notifications-core:SesException " + exception);
        return "sendEmail Error, SES status:" + exception.getErrorMessage();
    }

    private final String getServiceExceptionText(AmazonServiceException exception) {
        DestinationSesClient.Companion.getLog().info("notifications-core:SesException " + exception);
        return "sendEmail Error(" + exception.getStatusCode() + "), SES status:(" + exception.getErrorType().name() + ")" + exception.getErrorCode() + ":" + exception.getErrorMessage();
    }

    private final String getSdkExceptionText(SdkBaseException exception) {
        DestinationSesClient.Companion.getLog().info("notifications-core:SdkException " + exception);
        return "sendEmail Error, SDK status:" + exception.getMessage();
    }

    private static final Unit sendMimeMessage$lambda$0(MimeMessage $mimeMessage, ByteArrayOutputStream $outputStream) {
        Intrinsics.checkNotNullParameter((Object)$mimeMessage, (String)"$mimeMessage");
        Intrinsics.checkNotNullParameter((Object)$outputStream, (String)"$outputStream");
        $mimeMessage.writeTo((OutputStream)$outputStream);
        return Unit.INSTANCE;
    }

    private static final SendRawEmailResult sendMimeMessage$lambda$1(AmazonSimpleEmailService $client, SendRawEmailRequest $rawEmailRequest) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$rawEmailRequest, (String)"$rawEmailRequest");
        return $client.sendRawEmail($rawEmailRequest);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/opensearch/notifications/core/client/DestinationSesClient$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opensearch-notifications-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

