/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileGC {
    private static final Logger LOG = LogManager.getLogger(FileGC.class);
    private final Path DB_DIR;
    private final String BASE_DB_FILENAME;
    private final TimeUnit TIME_UNIT;
    private final long PERIODICITY;
    private final int FILES_COUNT;
    private final String WILDCARD_CHARACTER = "*";
    protected Deque<File> eligibleForGc;

    FileGC(Path db_dir, String base_db_filename, TimeUnit time_unit, long periodicity1, int files_count) throws IOException {
        this(db_dir, base_db_filename, time_unit, periodicity1, files_count, System.currentTimeMillis());
    }

    FileGC(Path db_dir, String base_db_filename, TimeUnit time_unit, long periodicity1, int files_count, long currentMillis) throws IOException {
        this.DB_DIR = db_dir;
        this.BASE_DB_FILENAME = base_db_filename;
        this.TIME_UNIT = time_unit;
        this.PERIODICITY = periodicity1;
        this.FILES_COUNT = files_count;
        List<File> remainingFiles = this.cleanupAndGetRemaining(currentMillis);
        this.eligibleForGc = new LinkedList<File>(remainingFiles);
    }

    void eligibleForGc(String filename) throws IOException {
        File file = Paths.get(this.DB_DIR.toString(), filename).toFile();
        if (file.exists()) {
            this.eligibleForGc.addLast(file);
            if (this.eligibleForGc.size() > this.FILES_COUNT) {
                File oldestFile = this.eligibleForGc.removeFirst();
                this.delete(oldestFile);
            }
        }
    }

    protected List<File> cleanupAndGetRemaining(long currentMillis) throws IOException {
        String[] files = this.getDbFiles();
        List<File> afterCleaningOldFiles = this.timeBasedCleanup(files, currentMillis);
        return this.countBasedCleanup(afterCleaningOldFiles);
    }

    protected String[] getDbFiles() {
        return this.DB_DIR.toFile().list((FilenameFilter)new WildcardFileFilter(this.BASE_DB_FILENAME + ".*"));
    }

    protected List<File> timeBasedCleanup(String[] files, long currentMillis) throws IOException {
        long timeDelta = TimeUnit.MILLISECONDS.convert(this.PERIODICITY, this.TIME_UNIT) * (long)(this.FILES_COUNT + 1);
        long timeLimit = currentMillis - timeDelta;
        ArrayList<File> remainingFiles = new ArrayList<File>();
        for (String file : files) {
            Path filePath = Paths.get(this.DB_DIR.toString(), file);
            long lastModified = filePath.toFile().lastModified();
            if (lastModified < timeLimit) {
                this.delete(filePath.toFile());
                continue;
            }
            remainingFiles.add(filePath.toFile());
        }
        return remainingFiles;
    }

    protected List<File> countBasedCleanup(List<File> files) throws IOException {
        int numToDelete = files.size() - this.FILES_COUNT;
        Collections.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        int deletedSoFar = 0;
        ArrayList<File> remainingFiles = new ArrayList<File>();
        for (File file : files) {
            if (deletedSoFar < numToDelete) {
                this.delete(file);
                ++deletedSoFar;
                continue;
            }
            remainingFiles.add(file);
        }
        return remainingFiles;
    }

    private void delete(File file) throws IOException {
        Path path = Paths.get(file.toURI());
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOG.error("Could not delete file: {}. Error: {}", (Object)file, (Object)e);
            throw e;
        }
    }
}

