/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.commons.event_process.Event;
import org.opensearch.performanceanalyzer.commons.event_process.EventProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.ShardStateMetricsSnapshot;

public class ShardStateMetricsProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(ShardStateMetricsProcessor.class);
    private ShardStateMetricsSnapshot shardStateMetricsSnapshot;
    private BatchBindStep handle;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, String>> TYPE_REF = new TypeReference<HashMap<String, String>>(){};
    private long startTime;
    private long endTime;

    private ShardStateMetricsProcessor(ShardStateMetricsSnapshot snapshot) {
        this.shardStateMetricsSnapshot = snapshot;
    }

    static ShardStateMetricsProcessor buildShardStateMetricEventsProcessor(long currWindowStartTime, Connection conn, NavigableMap<Long, ShardStateMetricsSnapshot> shardStateEventMetricsMap) {
        ShardStateMetricsSnapshot shardStateSnap = (ShardStateMetricsSnapshot)shardStateEventMetricsMap.get(currWindowStartTime);
        if (shardStateSnap == null) {
            shardStateSnap = new ShardStateMetricsSnapshot(conn, currWindowStartTime);
            shardStateEventMetricsMap.put(currWindowStartTime, shardStateSnap);
        }
        return new ShardStateMetricsProcessor(shardStateSnap);
    }

    public void initializeProcessing(long startTime, long endTime) {
        this.handle = this.shardStateMetricsSnapshot.startBatchPut();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
        LOG.debug("Final ShardStateEvents metrics {}", this.shardStateMetricsSnapshot.fetchAll());
    }

    public void processEvent(Event event) {
        String[] lines = event.value.split(System.lineSeparator());
        String indexName = "";
        for (String line : lines) {
            Map<String, String> shardStateMap = ShardStateMetricsProcessor.extractEntryData(line);
            if (shardStateMap.containsKey(AllMetrics.ShardStateDimension.INDEX_NAME.toString())) {
                indexName = shardStateMap.get(AllMetrics.ShardStateDimension.INDEX_NAME.toString());
                continue;
            }
            if (shardStateMap.containsKey("current_time")) continue;
            this.handle.bind(new Object[]{indexName, shardStateMap.get(AllMetrics.ShardStateDimension.SHARD_ID.toString()), shardStateMap.get(AllMetrics.ShardStateDimension.SHARD_TYPE.toString()), shardStateMap.get(AllMetrics.ShardStateDimension.NODE_NAME.toString()), shardStateMap.get(AllMetrics.ShardStateDimension.SHARD_STATE.toString())});
        }
    }

    static Map<String, String> extractEntryData(String line) {
        try {
            return (Map)MAPPER.readValue(line, TYPE_REF);
        }
        catch (IOException ioe) {
            LOG.error("Error occurred while parsing tmp file", (Throwable)ioe);
            return new HashMap<String, String>();
        }
    }

    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("shard_state_metrics");
    }

    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.shardStateMetricsSnapshot.startBatchPut();
        }
    }
}

