/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.DefaultS3BaseClientBuilder;
import software.amazon.awssdk.services.s3.DefaultS3Client;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3ServiceClientConfiguration;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;

@SdkInternalApi
final class DefaultS3ClientBuilder
extends DefaultS3BaseClientBuilder<S3ClientBuilder, S3Client>
implements S3ClientBuilder {
    DefaultS3ClientBuilder() {
    }

    @Override
    public DefaultS3ClientBuilder endpointProvider(S3EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final S3Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultS3ClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        S3ServiceClientConfiguration serviceClientConfiguration = S3ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultS3Client(serviceClientConfiguration, clientConfiguration);
    }
}

