/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JakartaJsonArray;
import com.github.wnameless.json.base.JakartaJsonObject;
import com.github.wnameless.json.base.JsonValueCore;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class JakartaJsonValue
implements JsonValueCore<JakartaJsonValue> {
    private final JsonValue jsonValue;

    public JakartaJsonValue(JsonValue jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException();
        }
        this.jsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.jsonValue.getValueType() == JsonValue.ValueType.OBJECT;
    }

    @Override
    public boolean isArray() {
        return this.jsonValue.getValueType() == JsonValue.ValueType.ARRAY;
    }

    @Override
    public boolean isString() {
        return this.jsonValue.getValueType() == JsonValue.ValueType.STRING;
    }

    @Override
    public boolean isBoolean() {
        return this.jsonValue.getValueType() == JsonValue.ValueType.FALSE || this.jsonValue.getValueType() == JsonValue.ValueType.TRUE;
    }

    @Override
    public boolean isNumber() {
        return this.jsonValue.getValueType() == JsonValue.ValueType.NUMBER;
    }

    @Override
    public boolean isNull() {
        return this.jsonValue.getValueType() == JsonValue.ValueType.NULL;
    }

    @Override
    public String asString() {
        return ((JsonString)JsonString.class.cast(this.jsonValue)).getString();
    }

    @Override
    public boolean asBoolean() {
        if (this.jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
            return false;
        }
        if (this.jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
            return true;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        return ((JsonNumber)JsonNumber.class.cast(this.jsonValue)).intValue();
    }

    @Override
    public long asLong() {
        return ((JsonNumber)JsonNumber.class.cast(this.jsonValue)).longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return ((JsonNumber)JsonNumber.class.cast(this.jsonValue)).bigIntegerValue();
    }

    @Override
    public double asDouble() {
        return ((JsonNumber)JsonNumber.class.cast(this.jsonValue)).doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return ((JsonNumber)JsonNumber.class.cast(this.jsonValue)).bigDecimalValue();
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    @Override
    public Object getSource() {
        return this.jsonValue;
    }

    @Override
    public JakartaJsonObject asObject() {
        return new JakartaJsonObject(this.jsonValue.asJsonObject());
    }

    @Override
    public JakartaJsonArray asArray() {
        return new JakartaJsonArray(this.jsonValue.asJsonArray());
    }

    @Override
    public JakartaJsonValue asValue() {
        return this;
    }

    public int hashCode() {
        return this.jsonValue.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JakartaJsonValue)) {
            return false;
        }
        return Objects.equals(this.jsonValue, ((JakartaJsonValue)o).jsonValue);
    }

    public String toString() {
        return this.jsonValue.toString();
    }
}

