/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JsonObjectCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.OrgJsonArray;
import com.github.wnameless.json.base.OrgJsonValue;
import com.github.wnameless.json.base.TransformIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public final class OrgJsonObject
implements JsonObjectCore<OrgJsonValue> {
    private final JSONObject jsonObject;

    public OrgJsonObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.jsonObject = jsonObject;
    }

    @Override
    public void set(String name, JsonSource jsonValue) {
        this.jsonObject.put(name, jsonValue.getSource());
    }

    @Override
    public boolean remove(String name) {
        return this.jsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.jsonObject.has(name);
    }

    @Override
    public OrgJsonValue get(String name) {
        return this.contains(name) ? new OrgJsonValue(this.jsonObject.get(name)) : null;
    }

    @Override
    public int size() {
        return this.jsonObject.length();
    }

    @Override
    public Iterator<String> names() {
        return this.jsonObject.keys();
    }

    @Override
    public Iterator<Map.Entry<String, OrgJsonValue>> iterator() {
        return new TransformIterator<String, Map.Entry>(this.jsonObject.keys(), key -> new AbstractMap.SimpleImmutableEntry<String, OrgJsonValue>((String)key, new OrgJsonValue(this.jsonObject.get(key))));
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrgJsonObject asObject() {
        return this;
    }

    @Override
    public OrgJsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrgJsonValue asValue() {
        return new OrgJsonValue(this.jsonObject);
    }

    @Override
    public Object getSource() {
        return this.jsonObject;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrgJsonObject)) {
            return false;
        }
        return this.jsonObject.similar((Object)((OrgJsonObject)o).jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }
}

