/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Optional;
import org.opensearch.http.netty4.Netty4HttpChannel;
import org.opensearch.rest.RestRequest;

public class NettyAttribute {
    public static <T> Optional<T> popFrom(RestRequest request, AttributeKey<T> attribute) {
        if (request.getHttpChannel() instanceof Netty4HttpChannel) {
            Channel nettyChannel = ((Netty4HttpChannel)request.getHttpChannel()).getNettyChannel();
            return Optional.ofNullable(nettyChannel.attr(attribute).getAndSet(null));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> popFrom(ChannelHandlerContext ctx, AttributeKey<T> attribute) {
        return Optional.ofNullable(ctx.channel().attr(attribute).getAndSet(null));
    }

    public static <T> Optional<T> peekFrom(ChannelHandlerContext ctx, AttributeKey<T> attribute) {
        return Optional.ofNullable(ctx.channel().attr(attribute).get());
    }

    public static <T> void clearAttribute(RestRequest request, AttributeKey<T> attribute) {
        if (request.getHttpChannel() instanceof Netty4HttpChannel) {
            Channel nettyChannel = ((Netty4HttpChannel)request.getHttpChannel()).getNettyChannel();
            nettyChannel.attr(attribute).set(null);
        }
    }
}

