/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import lombok.Generated;

public final class SystemIndexUtils {
    public static final String TABLE_NAME_FOR_TABLES_INFO = "tables";
    private static final String SYS_TABLES_SUFFIX = "ODFE_SYS_TABLE";
    private static final String SYS_META_SUFFIX = "META_ODFE_SYS_TABLE";
    private static final String SYS_MAPPINGS_SUFFIX = "MAPPINGS_ODFE_SYS_TABLE";
    public static final String TABLE_INFO = "ALL.META_ODFE_SYS_TABLE";
    public static final String DATASOURCES_TABLE_NAME = ".DATASOURCES";

    public static Boolean isSystemIndex(String indexName) {
        return indexName.endsWith(SYS_TABLES_SUFFIX);
    }

    public static String mappingTable(String indexName) {
        return String.join((CharSequence)".", indexName, SYS_MAPPINGS_SUFFIX);
    }

    public static SystemTable systemTable(String indexName) {
        int lastDot = indexName.lastIndexOf(".");
        String suffix = indexName.substring(lastDot + 1);
        String tableName = indexName.substring(0, lastDot).replace("%", "*");
        if (suffix.equalsIgnoreCase(SYS_META_SUFFIX)) {
            return new SystemInfoTable(tableName);
        }
        if (suffix.equalsIgnoreCase(SYS_MAPPINGS_SUFFIX)) {
            return new MetaInfoTable(tableName);
        }
        throw new IllegalStateException("Invalid system index name: " + indexName);
    }

    @Generated
    private SystemIndexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class MetaInfoTable
    implements SystemTable {
        private final String tableName;

        @Override
        public boolean isMetaInfoTable() {
            return true;
        }

        @Override
        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public MetaInfoTable(String tableName) {
            this.tableName = tableName;
        }
    }

    public static class SystemInfoTable
    implements SystemTable {
        private final String tableName;

        @Override
        public boolean isSystemInfoTable() {
            return true;
        }

        @Override
        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public SystemInfoTable(String tableName) {
            this.tableName = tableName;
        }
    }

    public static interface SystemTable {
        public String getTableName();

        default public boolean isSystemInfoTable() {
            return false;
        }

        default public boolean isMetaInfoTable() {
            return false;
        }
    }
}

