/* preferences_dialog.c generated by valac 0.56.14, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2015-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "pamac-gtk.h"
#include <pamac.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_PREFERENCES_WINDOW (pamac_preferences_window_get_type ())
#define PAMAC_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindow))
#define PAMAC_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindowClass))
#define PAMAC_IS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PREFERENCES_WINDOW))
#define PAMAC_IS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PREFERENCES_WINDOW))
#define PAMAC_PREFERENCES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindowClass))

typedef struct _PamacPreferencesWindow PamacPreferencesWindow;
typedef struct _PamacPreferencesWindowClass PamacPreferencesWindowClass;
typedef struct _PamacPreferencesWindowPrivate PamacPreferencesWindowPrivate;
enum  {
	PAMAC_PREFERENCES_WINDOW_0_PROPERTY,
	PAMAC_PREFERENCES_WINDOW_NUM_PROPERTIES
};
static GParamSpec* pamac_preferences_window_properties[PAMAC_PREFERENCES_WINDOW_NUM_PROPERTIES];

#define PAMAC_TYPE_MANAGER_WINDOW (pamac_manager_window_get_type ())
#define PAMAC_MANAGER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindow))
#define PAMAC_MANAGER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindowClass))
#define PAMAC_IS_MANAGER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_MANAGER_WINDOW))
#define PAMAC_IS_MANAGER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_MANAGER_WINDOW))
#define PAMAC_MANAGER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindowClass))

typedef struct _PamacManagerWindow PamacManagerWindow;
typedef struct _PamacManagerWindowClass PamacManagerWindowClass;
typedef struct _PamacManagerWindowPrivate PamacManagerWindowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _PamacPreferencesWindowRefreshCleanCacheButtonData PamacPreferencesWindowRefreshCleanCacheButtonData;
typedef struct _PamacPreferencesWindowRefreshCleanBuildFilesButtonData PamacPreferencesWindowRefreshCleanBuildFilesButtonData;
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

struct _PamacPreferencesWindow {
	AdwPreferencesWindow parent_instance;
	PamacPreferencesWindowPrivate * priv;
};

struct _PamacPreferencesWindowClass {
	AdwPreferencesWindowClass parent_class;
};

struct _PamacPreferencesWindowPrivate {
	AdwPreferencesGroup* updates_preferences_group;
	AdwExpanderRow* check_updates_expander;
	AdwComboRow* refresh_period_comborow;
	AdwSwitchRow* no_update_hide_icon_button;
	AdwSwitchRow* download_updates_button;
	AdwSwitchRow* offline_upgrade_button;
	AdwComboRow* parallel_downloads_comborow;
	AdwPreferencesGroup* mirrors_preferences_group;
	AdwComboRow* mirrors_country_comborow;
	GtkButton* generate_mirrors_list_button;
	AdwComboRow* cache_keep_nb_comborow;
	AdwSwitchRow* cache_only_uninstalled_button;
	GtkLabel* clean_cache_label;
	GtkButton* clean_cache_button;
	AdwPreferencesPage* advanced_preferences_page;
	AdwSwitchRow* check_space_button;
	AdwSwitchRow* remove_unrequired_deps_button;
	AdwSwitchRow* simple_install_button;
	AdwSwitchRow* enable_downgrade_button;
	GtkListBox* ignorepkgs_listbox;
	AdwPreferencesPage* third_party_preferences_page;
	AdwPreferencesGroup* aur_preferences_group;
	AdwExpanderRow* enable_aur_expander;
	GtkButton* aur_build_dir_file_chooser;
	AdwSwitchRow* keep_built_pkgs_button;
	AdwSwitchRow* check_aur_updates_button;
	AdwSwitchRow* check_aur_vcs_updates_button;
	GtkButton* clean_build_files_button;
	GtkLabel* clean_build_files_label;
	AdwPreferencesGroup* flatpak_preferences_group;
	AdwExpanderRow* enable_flatpak_expander;
	AdwSwitchRow* check_flatpak_updates_button;
	AdwPreferencesGroup* snap_preferences_group;
	AdwSwitchRow* enable_snap_button;
	PamacLocalConfig* local_config;
	PamacConfig* config;
	PamacDatabase* database;
	PamacTransactionGtk* transaction;
	guint64 previous_refresh_period;
	gboolean transaction_running;
};

struct _PamacManagerWindow {
	AdwApplicationWindow parent_instance;
	PamacManagerWindowPrivate * priv;
	GtkStack* main_stack;
	GtkButton* button_back;
	GtkStack* browse_stack;
	GtkButton* search_button;
	GtkSearchEntry* search_entry;
	AdwOverlaySplitView* browse_splitview;
	AdwViewStack* view_stack;
	AdwViewSwitcher* view_stack_switcher;
	GtkButton* details_button;
	GtkButton* apply_button;
	GtkRevealer* infobox_revealer;
	AdwViewSwitcherBar* switcher_bar;
	GQueue* display_package_queue;
	PamacTransactionGtk* transaction;
	PamacLocalConfig* local_config;
	gboolean important_details;
	gboolean transaction_running;
	gboolean generate_mirrors_list;
};

struct _PamacManagerWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	GListStore* mirrors_store;
	gint index;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gchar* preferences_choosen_country;
};

struct _PamacPreferencesWindowRefreshCleanCacheButtonData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacPreferencesWindow* self;
	GHashTable* details;
	PamacDatabase* _tmp0_;
	GHashTable* _tmp1_;
	GHashTableIter iter;
	GHashTable* _tmp2_;
	guint64 total_size;
	guint files_nb;
	guint64* size;
	gconstpointer _tmp3_;
	gboolean _tmp4_;
	guint64* _tmp5_;
	guint64* _tmp6_;
	guint _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	guint _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
};

struct _PamacPreferencesWindowRefreshCleanBuildFilesButtonData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacPreferencesWindow* self;
	GHashTable* details;
	PamacDatabase* _tmp0_;
	GHashTable* _tmp1_;
	GHashTableIter iter;
	GHashTable* _tmp2_;
	guint64 total_size;
	guint files_nb;
	guint64* size;
	gconstpointer _tmp3_;
	gboolean _tmp4_;
	guint64* _tmp5_;
	guint64* _tmp6_;
	guint _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	guint _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
};

struct _Block3Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	GtkFileDialog* chooser;
};

struct _Block4Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	GtkListBoxRow* row;
	gchar* pkgname;
};

struct _Block5Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	PamacChoosePkgsDialog* choose_pkgs_dialog;
};

struct _Block6Data {
	int _ref_count_;
	PamacPreferencesWindow* self;
	PamacManagerWindow* manager_window;
};

static gint PamacPreferencesWindow_private_offset;
static gpointer pamac_preferences_window_parent_class = NULL;

VALA_EXTERN GType pamac_preferences_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacPreferencesWindow, g_object_unref)
VALA_EXTERN GType pamac_manager_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacManagerWindow, g_object_unref)
VALA_EXTERN PamacPreferencesWindow* pamac_preferences_window_new (PamacManagerWindow* window);
VALA_EXTERN PamacPreferencesWindow* pamac_preferences_window_construct (GType object_type,
                                                            PamacManagerWindow* window);
static void __lambda77_ (PamacPreferencesWindow* self,
                  GObject* object);
static void ___lambda77__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void __lambda78_ (PamacPreferencesWindow* self,
                  GObject* object);
static void ___lambda78__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void pamac_preferences_window_on_check_updates_expander_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_check_updates_expander_changed_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void pamac_preferences_window_on_refresh_period_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_refresh_period_comborow_changed_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self);
static void pamac_preferences_window_on_parallel_downloads_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_parallel_downloads_comborow_changed_g_object_notify (GObject* _sender,
                                                                                       GParamSpec* pspec,
                                                                                       gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda79_ (Block1Data* _data1_,
                   GObject* obj,
                   GAsyncResult* res);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda80_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static void pamac_preferences_window_on_mirrors_country_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_mirrors_country_comborow_changed_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self);
static void ___lambda80__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ____lambda79__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void pamac_preferences_window_on_cache_keep_nb_comborow_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_cache_keep_nb_comborow_changed_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void pamac_preferences_window_on_cache_only_uninstalled_button_changed (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_cache_only_uninstalled_button_changed_g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self);
static void pamac_preferences_window_refresh_clean_cache_button (PamacPreferencesWindow* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void pamac_preferences_window_refresh_clean_cache_button_finish (PamacPreferencesWindow* self,
                                                                 GAsyncResult* _res_);
static void pamac_preferences_window_populate_ignorepkgs_list (PamacPreferencesWindow* self);
static void pamac_preferences_window_refresh_clean_build_files_button (PamacPreferencesWindow* self,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static void pamac_preferences_window_refresh_clean_build_files_button_finish (PamacPreferencesWindow* self,
                                                                       GAsyncResult* _res_);
static void pamac_preferences_window_refresh_clean_cache_button_data_free (gpointer _data);
static gboolean pamac_preferences_window_refresh_clean_cache_button_co (PamacPreferencesWindowRefreshCleanCacheButtonData* _data_);
static void pamac_preferences_window_refresh_clean_cache_button_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static guint64* _uint64_dup (guint64* self);
static void pamac_preferences_window_refresh_clean_build_files_button_data_free (gpointer _data);
static gboolean pamac_preferences_window_refresh_clean_build_files_button_co (PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_);
static void pamac_preferences_window_on_aur_build_dir_file_chooser_clicked (PamacPreferencesWindow* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda84_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda84__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _pamac_preferences_window_on_aur_build_dir_file_chooser_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                         gpointer self);
static void pamac_preferences_window_on_add_ignorepkgs_button_clicked (PamacPreferencesWindow* self);
static void _pamac_preferences_window_on_add_ignorepkgs_button_clicked_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                            GtkListBoxRow* row,
                                                                                            gpointer self);
static void pamac_preferences_window_add_ignorepkg (PamacPreferencesWindow* self,
                                             const gchar* pkgname);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda83_ (Block4Data* _data4_);
static void ___lambda83__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda81_ (Block5Data* _data5_,
                  GObject* obj,
                  GAsyncResult* res);
static void _g_free0_ (gpointer var);
static void __lambda82_ (Block5Data* _data5_,
                  const gchar* response);
static void ___lambda82__adw_message_dialog_response (AdwMessageDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
static void ___lambda81__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void pamac_preferences_window_on_generate_mirrors_list_button_clicked (PamacPreferencesWindow* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda85_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda85__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _pamac_preferences_window_on_generate_mirrors_list_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                           gpointer self);
static void pamac_preferences_window_on_clean_cache_button_clicked (PamacPreferencesWindow* self);
static void __lambda86_ (PamacPreferencesWindow* self);
static void ___lambda86__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _pamac_preferences_window_on_clean_cache_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                 gpointer self);
static void pamac_preferences_window_on_clean_build_files_button_clicked (PamacPreferencesWindow* self);
static void __lambda87_ (PamacPreferencesWindow* self);
static void ___lambda87__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _pamac_preferences_window_on_clean_build_files_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                       gpointer self);
static void pamac_preferences_window_finalize (GObject * obj);
static GType pamac_preferences_window_get_type_once (void);

static inline gpointer
pamac_preferences_window_get_instance_private (PamacPreferencesWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PamacPreferencesWindow_private_offset);
}

static void
__lambda77_ (PamacPreferencesWindow* self,
             GObject* object)
{
	GtkListItem* listitem = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	g_return_if_fail (object != NULL);
	listitem = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_list_item_set_child (listitem, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
___lambda77__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	__lambda77_ ((PamacPreferencesWindow*) self, object);
}

static void
__lambda78_ (PamacPreferencesWindow* self,
             GObject* object)
{
	GtkListItem* listitem = NULL;
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkLabel* label = NULL;
	GObject* item_object = NULL;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GtkStringObject* string_object = NULL;
	const gchar* _tmp4_;
	g_return_if_fail (object != NULL);
	listitem = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = gtk_list_item_get_child (listitem);
	_tmp1_ = _tmp0_;
	child = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_label_get_type ()) ? ((GtkLabel*) child) : NULL;
	_tmp2_ = gtk_list_item_get_item (listitem);
	_tmp3_ = _tmp2_;
	item_object = _tmp3_;
	string_object = G_TYPE_CHECK_INSTANCE_TYPE (item_object, gtk_string_object_get_type ()) ? ((GtkStringObject*) item_object) : NULL;
	_tmp4_ = gtk_string_object_get_string (string_object);
	gtk_label_set_label (label, _tmp4_);
}

static void
___lambda78__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda78_ ((PamacPreferencesWindow*) self, object);
}

static void
_pamac_preferences_window_on_check_updates_expander_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	pamac_preferences_window_on_check_updates_expander_changed ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_refresh_period_comborow_changed_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self)
{
	pamac_preferences_window_on_refresh_period_comborow_changed ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_parallel_downloads_comborow_changed_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self)
{
	pamac_preferences_window_on_parallel_downloads_comborow_changed ((PamacPreferencesWindow*) self);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->mirrors_store);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data2_->_data1_->self;
		_g_free0 (_data2_->preferences_choosen_country);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
_pamac_preferences_window_on_mirrors_country_comborow_changed_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self)
{
	pamac_preferences_window_on_mirrors_country_comborow_changed ((PamacPreferencesWindow*) self);
}

static void
__lambda80_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	Block1Data* _data1_;
	PamacPreferencesWindow* self;
	GPtrArray* countries = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	AdwComboRow* _tmp10_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_mirrors_countries_finish (_tmp0_, res);
	_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
	countries = _tmp2_;
	_tmp3_ = countries;
	{
		GPtrArray* country_collection = NULL;
		guint country_index = 0U;
		country_collection = _tmp3_;
		for (country_index = 0; country_index < country_collection->len; country_index = country_index + 1) {
			const gchar* country = NULL;
			country = g_ptr_array_index (country_collection, country_index);
			{
				GtkStringObject* country_obj = NULL;
				const gchar* _tmp4_;
				GtkStringObject* _tmp5_;
				GListStore* _tmp6_;
				GtkStringObject* _tmp7_;
				const gchar* _tmp8_;
				_tmp4_ = country;
				_tmp5_ = gtk_string_object_new (_tmp4_);
				country_obj = _tmp5_;
				_tmp6_ = _data1_->mirrors_store;
				_tmp7_ = country_obj;
				g_list_store_append (_tmp6_, (GObject*) _tmp7_);
				_tmp8_ = country;
				if (g_strcmp0 (_tmp8_, _data2_->preferences_choosen_country) == 0) {
					AdwComboRow* _tmp9_;
					_tmp9_ = self->priv->mirrors_country_comborow;
					adw_combo_row_set_selected (_tmp9_, (guint) _data1_->index);
				}
				_data1_->index += 1;
				_g_object_unref0 (country_obj);
			}
		}
	}
	_tmp10_ = self->priv->mirrors_country_comborow;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::selected", (GCallback) _pamac_preferences_window_on_mirrors_country_comborow_changed_g_object_notify, self, 0);
	_g_ptr_array_unref0 (countries);
}

static void
___lambda80__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda80_ (self, source_object, res);
	block2_data_unref (self);
}

static void
___lambda79_ (Block1Data* _data1_,
              GObject* obj,
              GAsyncResult* res)
{
	PamacPreferencesWindow* self;
	Block2Data* _data2_;
	PamacDatabase* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	PamacDatabase* _tmp3_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->_data1_ = block1_data_ref (_data1_);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_mirrors_choosen_country_finish (_tmp0_, res);
	_tmp2_ = g_strdup (_tmp1_);
	_data2_->preferences_choosen_country = _tmp2_;
	_tmp3_ = self->priv->database;
	pamac_database_get_mirrors_countries_async (_tmp3_, ___lambda80__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
____lambda79__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda79_ (self, source_object, res);
	block1_data_unref (self);
}

static void
_pamac_preferences_window_on_cache_keep_nb_comborow_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	pamac_preferences_window_on_cache_keep_nb_comborow_changed ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_cache_only_uninstalled_button_changed_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self)
{
	pamac_preferences_window_on_cache_only_uninstalled_button_changed ((PamacPreferencesWindow*) self);
}

PamacPreferencesWindow*
pamac_preferences_window_construct (GType object_type,
                                    PamacManagerWindow* window)
{
	PamacPreferencesWindow * self = NULL;
	PamacTransactionGtk* _tmp0_;
	PamacTransactionGtk* _tmp1_;
	PamacDatabase* _tmp2_;
	PamacDatabase* _tmp3_;
	PamacDatabase* _tmp4_;
	PamacConfig* _tmp5_;
	PamacConfig* _tmp6_;
	PamacLocalConfig* _tmp7_;
	GListStore* store = NULL;
	GListStore* _tmp8_;
	GtkStringObject* obj = NULL;
	GtkStringObject* _tmp9_;
	GListStore* _tmp10_;
	GtkStringObject* _tmp11_;
	GtkStringObject* _tmp12_;
	GListStore* _tmp13_;
	GtkStringObject* _tmp14_;
	GtkStringObject* _tmp15_;
	GListStore* _tmp16_;
	GtkStringObject* _tmp17_;
	GtkStringObject* _tmp18_;
	GListStore* _tmp19_;
	GtkStringObject* _tmp20_;
	GtkStringObject* _tmp21_;
	GListStore* _tmp22_;
	GtkStringObject* _tmp23_;
	AdwComboRow* _tmp24_;
	GListStore* _tmp25_;
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp26_;
	GtkSignalListItemFactory* _tmp27_;
	GtkSignalListItemFactory* _tmp28_;
	AdwComboRow* _tmp29_;
	GtkSignalListItemFactory* _tmp30_;
	PamacConfig* _tmp31_;
	guint64 _tmp32_;
	guint64 _tmp33_;
	AdwExpanderRow* _tmp47_;
	AdwComboRow* _tmp48_;
	PamacConfig* _tmp49_;
	AdwSwitchRow* _tmp50_;
	PamacConfig* _tmp51_;
	AdwSwitchRow* _tmp52_;
	PamacConfig* _tmp53_;
	AdwSwitchRow* _tmp54_;
	PamacConfig* _tmp55_;
	AdwSwitchRow* _tmp56_;
	GListStore* _tmp57_;
	GtkStringObject* _tmp58_;
	GListStore* _tmp59_;
	GtkStringObject* _tmp60_;
	GtkStringObject* _tmp61_;
	GListStore* _tmp62_;
	GtkStringObject* _tmp63_;
	GtkStringObject* _tmp64_;
	GListStore* _tmp65_;
	GtkStringObject* _tmp66_;
	GtkStringObject* _tmp67_;
	GListStore* _tmp68_;
	GtkStringObject* _tmp69_;
	GtkStringObject* _tmp70_;
	GListStore* _tmp71_;
	GtkStringObject* _tmp72_;
	GtkStringObject* _tmp73_;
	GListStore* _tmp74_;
	GtkStringObject* _tmp75_;
	AdwComboRow* _tmp76_;
	GListStore* _tmp77_;
	AdwComboRow* _tmp78_;
	GtkSignalListItemFactory* _tmp79_;
	guint64 max_parallel_downloads = 0ULL;
	PamacConfig* _tmp80_;
	guint64 _tmp81_;
	guint64 _tmp82_;
	AdwComboRow* _tmp89_;
	PamacDatabase* _tmp90_;
	GListStore* _tmp101_;
	GtkStringObject* _tmp102_;
	GListStore* _tmp103_;
	GtkStringObject* _tmp104_;
	GtkStringObject* _tmp105_;
	GListStore* _tmp106_;
	GtkStringObject* _tmp107_;
	GtkStringObject* _tmp108_;
	GListStore* _tmp109_;
	GtkStringObject* _tmp110_;
	GtkStringObject* _tmp111_;
	GListStore* _tmp112_;
	GtkStringObject* _tmp113_;
	GtkStringObject* _tmp114_;
	GListStore* _tmp115_;
	GtkStringObject* _tmp116_;
	GtkStringObject* _tmp117_;
	GListStore* _tmp118_;
	GtkStringObject* _tmp119_;
	AdwComboRow* _tmp120_;
	GListStore* _tmp121_;
	AdwComboRow* _tmp122_;
	GtkSignalListItemFactory* _tmp123_;
	guint64 keep_num_pkgs = 0ULL;
	PamacConfig* _tmp124_;
	guint64 _tmp125_;
	guint64 _tmp126_;
	AdwComboRow* _tmp129_;
	PamacConfig* _tmp130_;
	AdwSwitchRow* _tmp131_;
	AdwSwitchRow* _tmp132_;
	PamacLocalConfig* _tmp133_;
	gboolean _tmp134_;
	gboolean _tmp135_;
	PamacConfig* _tmp137_;
	AdwSwitchRow* _tmp138_;
	PamacConfig* _tmp139_;
	AdwSwitchRow* _tmp140_;
	PamacConfig* _tmp141_;
	AdwSwitchRow* _tmp142_;
	PamacConfig* _tmp143_;
	AdwSwitchRow* _tmp144_;
	gboolean _tmp145_ = FALSE;
	gboolean _tmp146_ = FALSE;
	PamacLocalConfig* _tmp147_;
	gboolean _tmp148_;
	gboolean _tmp149_;
	PamacLocalConfig* _tmp157_;
	AdwPreferencesGroup* _tmp158_;
	PamacConfig* _tmp159_;
	AdwPreferencesGroup* _tmp160_;
	PamacConfig* _tmp161_;
	AdwExpanderRow* _tmp162_;
	PamacConfig* _tmp163_;
	AdwExpanderRow* _tmp164_;
	PamacConfig* _tmp165_;
	AdwSwitchRow* _tmp166_;
	PamacConfig* _tmp167_;
	AdwSwitchRow* _tmp168_;
	PamacConfig* _tmp169_;
	AdwSwitchRow* _tmp170_;
	PamacConfig* _tmp171_;
	AdwSwitchRow* _tmp172_;
	PamacConfig* _tmp173_;
	gboolean _tmp174_;
	gboolean _tmp175_;
	PamacConfig* _tmp182_;
	AdwPreferencesGroup* _tmp183_;
	PamacConfig* _tmp184_;
	AdwExpanderRow* _tmp185_;
	PamacConfig* _tmp186_;
	AdwExpanderRow* _tmp187_;
	PamacConfig* _tmp188_;
	AdwSwitchRow* _tmp189_;
	PamacConfig* _tmp190_;
	AdwPreferencesGroup* _tmp191_;
	PamacConfig* _tmp192_;
	AdwSwitchRow* _tmp193_;
	AdwPreferencesGroup* _tmp194_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (PamacPreferencesWindow*) g_object_new (object_type, "transient-for", window, NULL);
	_tmp0_ = window->transaction;
	self->priv->transaction = _tmp0_;
	_tmp1_ = self->priv->transaction;
	_tmp2_ = pamac_transaction_get_database ((PamacTransaction*) _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->database = _tmp3_;
	_tmp4_ = self->priv->database;
	_tmp5_ = pamac_database_get_config (_tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->config = _tmp6_;
	_tmp7_ = window->local_config;
	self->priv->local_config = _tmp7_;
	_tmp8_ = g_list_store_new (gtk_string_object_get_type ());
	store = _tmp8_;
	_tmp9_ = gtk_string_object_new (g_dgettext (NULL, "every 3 hours"));
	obj = _tmp9_;
	_tmp10_ = store;
	_tmp11_ = obj;
	g_list_store_append (_tmp10_, (GObject*) _tmp11_);
	_tmp12_ = gtk_string_object_new (g_dgettext (NULL, "every 6 hours"));
	_g_object_unref0 (obj);
	obj = _tmp12_;
	_tmp13_ = store;
	_tmp14_ = obj;
	g_list_store_append (_tmp13_, (GObject*) _tmp14_);
	_tmp15_ = gtk_string_object_new (g_dgettext (NULL, "every 12 hours"));
	_g_object_unref0 (obj);
	obj = _tmp15_;
	_tmp16_ = store;
	_tmp17_ = obj;
	g_list_store_append (_tmp16_, (GObject*) _tmp17_);
	_tmp18_ = gtk_string_object_new (g_dgettext (NULL, "every day"));
	_g_object_unref0 (obj);
	obj = _tmp18_;
	_tmp19_ = store;
	_tmp20_ = obj;
	g_list_store_append (_tmp19_, (GObject*) _tmp20_);
	_tmp21_ = gtk_string_object_new (g_dgettext (NULL, "every week"));
	_g_object_unref0 (obj);
	obj = _tmp21_;
	_tmp22_ = store;
	_tmp23_ = obj;
	g_list_store_append (_tmp22_, (GObject*) _tmp23_);
	_tmp24_ = self->priv->refresh_period_comborow;
	_tmp25_ = store;
	adw_combo_row_set_model (_tmp24_, (GListModel*) _tmp25_);
	_tmp26_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp26_;
	_tmp27_ = factory;
	g_signal_connect_object (_tmp27_, "setup", (GCallback) ___lambda77__gtk_signal_list_item_factory_setup, self, 0);
	_tmp28_ = factory;
	g_signal_connect_object (_tmp28_, "bind", (GCallback) ___lambda78__gtk_signal_list_item_factory_bind, self, 0);
	_tmp29_ = self->priv->refresh_period_comborow;
	_tmp30_ = factory;
	adw_combo_row_set_factory (_tmp29_, (GtkListItemFactory*) _tmp30_);
	_tmp31_ = self->priv->config;
	_tmp32_ = pamac_config_get_refresh_period (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ == ((guint64) 0)) {
		AdwExpanderRow* _tmp34_;
		AdwExpanderRow* _tmp35_;
		AdwComboRow* _tmp36_;
		_tmp34_ = self->priv->check_updates_expander;
		adw_expander_row_set_enable_expansion (_tmp34_, FALSE);
		_tmp35_ = self->priv->check_updates_expander;
		adw_expander_row_set_expanded (_tmp35_, FALSE);
		_tmp36_ = self->priv->refresh_period_comborow;
		adw_combo_row_set_selected (_tmp36_, (guint) 1);
		self->priv->previous_refresh_period = (guint64) 6;
	} else {
		AdwExpanderRow* _tmp37_;
		AdwExpanderRow* _tmp38_;
		guint64 refresh_period = 0ULL;
		PamacConfig* _tmp39_;
		guint64 _tmp40_;
		guint64 _tmp41_;
		_tmp37_ = self->priv->check_updates_expander;
		adw_expander_row_set_enable_expansion (_tmp37_, TRUE);
		_tmp38_ = self->priv->check_updates_expander;
		adw_expander_row_set_expanded (_tmp38_, TRUE);
		_tmp39_ = self->priv->config;
		_tmp40_ = pamac_config_get_refresh_period (_tmp39_);
		_tmp41_ = _tmp40_;
		refresh_period = _tmp41_;
		if (refresh_period <= ((guint64) 3)) {
			AdwComboRow* _tmp42_;
			_tmp42_ = self->priv->refresh_period_comborow;
			adw_combo_row_set_selected (_tmp42_, (guint) 0);
		} else {
			if (refresh_period <= ((guint64) 6)) {
				AdwComboRow* _tmp43_;
				_tmp43_ = self->priv->refresh_period_comborow;
				adw_combo_row_set_selected (_tmp43_, (guint) 1);
			} else {
				if (refresh_period <= ((guint64) 12)) {
					AdwComboRow* _tmp44_;
					_tmp44_ = self->priv->refresh_period_comborow;
					adw_combo_row_set_selected (_tmp44_, (guint) 2);
				} else {
					if (refresh_period <= ((guint64) 24)) {
						AdwComboRow* _tmp45_;
						_tmp45_ = self->priv->refresh_period_comborow;
						adw_combo_row_set_selected (_tmp45_, (guint) 3);
					} else {
						AdwComboRow* _tmp46_;
						_tmp46_ = self->priv->refresh_period_comborow;
						adw_combo_row_set_selected (_tmp46_, (guint) 4);
					}
				}
			}
		}
	}
	_tmp47_ = self->priv->check_updates_expander;
	g_signal_connect_object ((GObject*) _tmp47_, "notify::enable-expansion", (GCallback) _pamac_preferences_window_on_check_updates_expander_changed_g_object_notify, self, 0);
	_tmp48_ = self->priv->refresh_period_comborow;
	g_signal_connect_object ((GObject*) _tmp48_, "notify::selected", (GCallback) _pamac_preferences_window_on_refresh_period_comborow_changed_g_object_notify, self, 0);
	_tmp49_ = self->priv->config;
	_tmp50_ = self->priv->download_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp49_, "download_updates", (GObject*) _tmp50_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp51_ = self->priv->config;
	_tmp52_ = self->priv->offline_upgrade_button;
	g_object_bind_property_with_closures ((GObject*) _tmp51_, "offline_upgrade", (GObject*) _tmp52_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp53_ = self->priv->config;
	_tmp54_ = self->priv->offline_upgrade_button;
	g_object_bind_property_with_closures ((GObject*) _tmp53_, "download_updates", (GObject*) _tmp54_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp55_ = self->priv->config;
	_tmp56_ = self->priv->no_update_hide_icon_button;
	g_object_bind_property_with_closures ((GObject*) _tmp55_, "no_update_hide_icon", (GObject*) _tmp56_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp57_ = g_list_store_new (gtk_string_object_get_type ());
	_g_object_unref0 (store);
	store = _tmp57_;
	_tmp58_ = gtk_string_object_new (g_dgettext (NULL, "1"));
	_g_object_unref0 (obj);
	obj = _tmp58_;
	_tmp59_ = store;
	_tmp60_ = obj;
	g_list_store_append (_tmp59_, (GObject*) _tmp60_);
	_tmp61_ = gtk_string_object_new (g_dgettext (NULL, "2"));
	_g_object_unref0 (obj);
	obj = _tmp61_;
	_tmp62_ = store;
	_tmp63_ = obj;
	g_list_store_append (_tmp62_, (GObject*) _tmp63_);
	_tmp64_ = gtk_string_object_new (g_dgettext (NULL, "4"));
	_g_object_unref0 (obj);
	obj = _tmp64_;
	_tmp65_ = store;
	_tmp66_ = obj;
	g_list_store_append (_tmp65_, (GObject*) _tmp66_);
	_tmp67_ = gtk_string_object_new (g_dgettext (NULL, "6"));
	_g_object_unref0 (obj);
	obj = _tmp67_;
	_tmp68_ = store;
	_tmp69_ = obj;
	g_list_store_append (_tmp68_, (GObject*) _tmp69_);
	_tmp70_ = gtk_string_object_new (g_dgettext (NULL, "8"));
	_g_object_unref0 (obj);
	obj = _tmp70_;
	_tmp71_ = store;
	_tmp72_ = obj;
	g_list_store_append (_tmp71_, (GObject*) _tmp72_);
	_tmp73_ = gtk_string_object_new (g_dgettext (NULL, "10"));
	_g_object_unref0 (obj);
	obj = _tmp73_;
	_tmp74_ = store;
	_tmp75_ = obj;
	g_list_store_append (_tmp74_, (GObject*) _tmp75_);
	_tmp76_ = self->priv->parallel_downloads_comborow;
	_tmp77_ = store;
	adw_combo_row_set_model (_tmp76_, (GListModel*) _tmp77_);
	_tmp78_ = self->priv->parallel_downloads_comborow;
	_tmp79_ = factory;
	adw_combo_row_set_factory (_tmp78_, (GtkListItemFactory*) _tmp79_);
	_tmp80_ = self->priv->config;
	_tmp81_ = pamac_config_get_max_parallel_downloads (_tmp80_);
	_tmp82_ = _tmp81_;
	max_parallel_downloads = _tmp82_;
	if (max_parallel_downloads <= ((guint64) 1)) {
		AdwComboRow* _tmp83_;
		_tmp83_ = self->priv->parallel_downloads_comborow;
		adw_combo_row_set_selected (_tmp83_, (guint) 0);
	} else {
		if (max_parallel_downloads <= ((guint64) 2)) {
			AdwComboRow* _tmp84_;
			_tmp84_ = self->priv->parallel_downloads_comborow;
			adw_combo_row_set_selected (_tmp84_, (guint) 1);
		} else {
			if (max_parallel_downloads <= ((guint64) 4)) {
				AdwComboRow* _tmp85_;
				_tmp85_ = self->priv->parallel_downloads_comborow;
				adw_combo_row_set_selected (_tmp85_, (guint) 2);
			} else {
				if (max_parallel_downloads <= ((guint64) 6)) {
					AdwComboRow* _tmp86_;
					_tmp86_ = self->priv->parallel_downloads_comborow;
					adw_combo_row_set_selected (_tmp86_, (guint) 3);
				} else {
					if (max_parallel_downloads <= ((guint64) 8)) {
						AdwComboRow* _tmp87_;
						_tmp87_ = self->priv->parallel_downloads_comborow;
						adw_combo_row_set_selected (_tmp87_, (guint) 4);
					} else {
						AdwComboRow* _tmp88_;
						_tmp88_ = self->priv->parallel_downloads_comborow;
						adw_combo_row_set_selected (_tmp88_, (guint) 5);
					}
				}
			}
		}
	}
	_tmp89_ = self->priv->parallel_downloads_comborow;
	g_signal_connect_object ((GObject*) _tmp89_, "notify::selected", (GCallback) _pamac_preferences_window_on_parallel_downloads_comborow_changed_g_object_notify, self, 0);
	_tmp90_ = self->priv->database;
	if (pamac_database_has_installed_satisfier (_tmp90_, "pacman-mirrors")) {
		Block1Data* _data1_;
		GListStore* _tmp91_;
		GtkStringObject* _tmp92_;
		GListStore* _tmp93_;
		GtkStringObject* _tmp94_;
		PamacDatabase* _tmp95_;
		AdwComboRow* _tmp96_;
		GListStore* _tmp97_;
		AdwComboRow* _tmp98_;
		GtkSignalListItemFactory* _tmp99_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_tmp91_ = g_list_store_new (gtk_string_object_get_type ());
		_data1_->mirrors_store = _tmp91_;
		_tmp92_ = gtk_string_object_new (g_dgettext (NULL, "Worldwide"));
		_g_object_unref0 (obj);
		obj = _tmp92_;
		_tmp93_ = _data1_->mirrors_store;
		_tmp94_ = obj;
		g_list_store_append (_tmp93_, (GObject*) _tmp94_);
		_data1_->index = 1;
		_tmp95_ = self->priv->database;
		pamac_database_get_mirrors_choosen_country_async (_tmp95_, ____lambda79__gasync_ready_callback, block1_data_ref (_data1_));
		_tmp96_ = self->priv->mirrors_country_comborow;
		_tmp97_ = _data1_->mirrors_store;
		adw_combo_row_set_model (_tmp96_, (GListModel*) _tmp97_);
		_tmp98_ = self->priv->mirrors_country_comborow;
		_tmp99_ = factory;
		adw_combo_row_set_factory (_tmp98_, (GtkListItemFactory*) _tmp99_);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	} else {
		AdwPreferencesGroup* _tmp100_;
		_tmp100_ = self->priv->mirrors_preferences_group;
		gtk_widget_set_visible ((GtkWidget*) _tmp100_, FALSE);
	}
	_tmp101_ = g_list_store_new (gtk_string_object_get_type ());
	_g_object_unref0 (store);
	store = _tmp101_;
	_tmp102_ = gtk_string_object_new (g_dgettext (NULL, "0"));
	_g_object_unref0 (obj);
	obj = _tmp102_;
	_tmp103_ = store;
	_tmp104_ = obj;
	g_list_store_append (_tmp103_, (GObject*) _tmp104_);
	_tmp105_ = gtk_string_object_new (g_dgettext (NULL, "1"));
	_g_object_unref0 (obj);
	obj = _tmp105_;
	_tmp106_ = store;
	_tmp107_ = obj;
	g_list_store_append (_tmp106_, (GObject*) _tmp107_);
	_tmp108_ = gtk_string_object_new (g_dgettext (NULL, "2"));
	_g_object_unref0 (obj);
	obj = _tmp108_;
	_tmp109_ = store;
	_tmp110_ = obj;
	g_list_store_append (_tmp109_, (GObject*) _tmp110_);
	_tmp111_ = gtk_string_object_new (g_dgettext (NULL, "3"));
	_g_object_unref0 (obj);
	obj = _tmp111_;
	_tmp112_ = store;
	_tmp113_ = obj;
	g_list_store_append (_tmp112_, (GObject*) _tmp113_);
	_tmp114_ = gtk_string_object_new (g_dgettext (NULL, "4"));
	_g_object_unref0 (obj);
	obj = _tmp114_;
	_tmp115_ = store;
	_tmp116_ = obj;
	g_list_store_append (_tmp115_, (GObject*) _tmp116_);
	_tmp117_ = gtk_string_object_new (g_dgettext (NULL, "5"));
	_g_object_unref0 (obj);
	obj = _tmp117_;
	_tmp118_ = store;
	_tmp119_ = obj;
	g_list_store_append (_tmp118_, (GObject*) _tmp119_);
	_tmp120_ = self->priv->cache_keep_nb_comborow;
	_tmp121_ = store;
	adw_combo_row_set_model (_tmp120_, (GListModel*) _tmp121_);
	_tmp122_ = self->priv->cache_keep_nb_comborow;
	_tmp123_ = factory;
	adw_combo_row_set_factory (_tmp122_, (GtkListItemFactory*) _tmp123_);
	_tmp124_ = self->priv->config;
	_tmp125_ = pamac_config_get_clean_keep_num_pkgs (_tmp124_);
	_tmp126_ = _tmp125_;
	keep_num_pkgs = _tmp126_;
	if (keep_num_pkgs < ((guint64) 6)) {
		AdwComboRow* _tmp127_;
		_tmp127_ = self->priv->cache_keep_nb_comborow;
		adw_combo_row_set_selected (_tmp127_, (guint) ((gint) keep_num_pkgs));
	} else {
		AdwComboRow* _tmp128_;
		_tmp128_ = self->priv->cache_keep_nb_comborow;
		adw_combo_row_set_selected (_tmp128_, (guint) 5);
	}
	_tmp129_ = self->priv->cache_keep_nb_comborow;
	g_signal_connect_object ((GObject*) _tmp129_, "notify::selected", (GCallback) _pamac_preferences_window_on_cache_keep_nb_comborow_changed_g_object_notify, self, 0);
	_tmp130_ = self->priv->config;
	_tmp131_ = self->priv->cache_only_uninstalled_button;
	g_object_bind_property_with_closures ((GObject*) _tmp130_, "clean_rm_only_uninstalled", (GObject*) _tmp131_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp132_ = self->priv->cache_only_uninstalled_button;
	g_signal_connect_object ((GObject*) _tmp132_, "notify::active", (GCallback) _pamac_preferences_window_on_cache_only_uninstalled_button_changed_g_object_notify, self, 0);
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
	_tmp133_ = self->priv->local_config;
	_tmp134_ = pamac_local_config_get_software_mode (_tmp133_);
	_tmp135_ = _tmp134_;
	if (_tmp135_) {
		AdwPreferencesPage* _tmp136_;
		_tmp136_ = self->priv->advanced_preferences_page;
		adw_preferences_window_remove ((AdwPreferencesWindow*) self, _tmp136_);
	}
	_tmp137_ = self->priv->config;
	_tmp138_ = self->priv->check_space_button;
	g_object_bind_property_with_closures ((GObject*) _tmp137_, "checkspace", (GObject*) _tmp138_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp139_ = self->priv->config;
	_tmp140_ = self->priv->remove_unrequired_deps_button;
	g_object_bind_property_with_closures ((GObject*) _tmp139_, "recurse", (GObject*) _tmp140_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp141_ = self->priv->config;
	_tmp142_ = self->priv->simple_install_button;
	g_object_bind_property_with_closures ((GObject*) _tmp141_, "simple_install", (GObject*) _tmp142_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp143_ = self->priv->config;
	_tmp144_ = self->priv->enable_downgrade_button;
	g_object_bind_property_with_closures ((GObject*) _tmp143_, "enable_downgrade", (GObject*) _tmp144_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	pamac_preferences_window_populate_ignorepkgs_list (self);
	_tmp147_ = self->priv->local_config;
	_tmp148_ = pamac_local_config_get_software_mode (_tmp147_);
	_tmp149_ = _tmp148_;
	if (_tmp149_) {
		PamacConfig* _tmp150_;
		gboolean _tmp151_;
		gboolean _tmp152_;
		_tmp150_ = self->priv->config;
		_tmp151_ = pamac_config_get_support_flatpak (_tmp150_);
		_tmp152_ = _tmp151_;
		_tmp146_ = !_tmp152_;
	} else {
		_tmp146_ = FALSE;
	}
	if (_tmp146_) {
		PamacConfig* _tmp153_;
		gboolean _tmp154_;
		gboolean _tmp155_;
		_tmp153_ = self->priv->config;
		_tmp154_ = pamac_config_get_support_snap (_tmp153_);
		_tmp155_ = _tmp154_;
		_tmp145_ = !_tmp155_;
	} else {
		_tmp145_ = FALSE;
	}
	if (_tmp145_) {
		AdwPreferencesPage* _tmp156_;
		_tmp156_ = self->priv->third_party_preferences_page;
		adw_preferences_window_remove ((AdwPreferencesWindow*) self, _tmp156_);
	}
	_tmp157_ = self->priv->local_config;
	_tmp158_ = self->priv->aur_preferences_group;
	g_object_bind_property_with_closures ((GObject*) _tmp157_, "software_mode", (GObject*) _tmp158_, "visible", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp159_ = self->priv->config;
	_tmp160_ = self->priv->aur_preferences_group;
	g_object_bind_property_with_closures ((GObject*) _tmp159_, "support_aur", (GObject*) _tmp160_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp161_ = self->priv->config;
	_tmp162_ = self->priv->enable_aur_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp161_, "enable_aur", (GObject*) _tmp162_, "enable_expansion", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp163_ = self->priv->config;
	_tmp164_ = self->priv->enable_aur_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp163_, "enable_aur", (GObject*) _tmp164_, "expanded", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp165_ = self->priv->config;
	_tmp166_ = self->priv->keep_built_pkgs_button;
	g_object_bind_property_with_closures ((GObject*) _tmp165_, "keep_built_pkgs", (GObject*) _tmp166_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp167_ = self->priv->config;
	_tmp168_ = self->priv->check_aur_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp167_, "check_aur_updates", (GObject*) _tmp168_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp169_ = self->priv->config;
	_tmp170_ = self->priv->check_aur_vcs_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp169_, "check_aur_vcs_updates", (GObject*) _tmp170_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp171_ = self->priv->config;
	_tmp172_ = self->priv->check_aur_vcs_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp171_, "check_aur_updates", (GObject*) _tmp172_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp173_ = self->priv->config;
	_tmp174_ = pamac_config_get_support_aur (_tmp173_);
	_tmp175_ = _tmp174_;
	if (_tmp175_) {
		GtkButton* _tmp176_;
		PamacConfig* _tmp177_;
		const gchar* _tmp178_;
		const gchar* _tmp179_;
		gchar* _tmp180_;
		gchar* _tmp181_;
		_tmp176_ = self->priv->aur_build_dir_file_chooser;
		_tmp177_ = self->priv->config;
		_tmp178_ = pamac_config_get_aur_build_dir (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = g_path_get_basename (_tmp179_);
		_tmp181_ = _tmp180_;
		gtk_button_set_label (_tmp176_, _tmp181_);
		_g_free0 (_tmp181_);
		pamac_preferences_window_refresh_clean_build_files_button (self, NULL, NULL);
	}
	_tmp182_ = self->priv->config;
	_tmp183_ = self->priv->flatpak_preferences_group;
	g_object_bind_property_with_closures ((GObject*) _tmp182_, "support_flatpak", (GObject*) _tmp183_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp184_ = self->priv->config;
	_tmp185_ = self->priv->enable_flatpak_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp184_, "enable_flatpak", (GObject*) _tmp185_, "enable_expansion", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp186_ = self->priv->config;
	_tmp187_ = self->priv->enable_flatpak_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp186_, "enable_flatpak", (GObject*) _tmp187_, "expanded", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp188_ = self->priv->config;
	_tmp189_ = self->priv->check_flatpak_updates_button;
	g_object_bind_property_with_closures ((GObject*) _tmp188_, "check_flatpak_updates", (GObject*) _tmp189_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp190_ = self->priv->config;
	_tmp191_ = self->priv->snap_preferences_group;
	g_object_bind_property_with_closures ((GObject*) _tmp190_, "support_snap", (GObject*) _tmp191_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp192_ = self->priv->config;
	_tmp193_ = self->priv->enable_snap_button;
	g_object_bind_property_with_closures ((GObject*) _tmp192_, "enable_snap", (GObject*) _tmp193_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp194_ = self->priv->updates_preferences_group;
	gtk_widget_grab_focus ((GtkWidget*) _tmp194_);
	_g_object_unref0 (factory);
	_g_object_unref0 (obj);
	_g_object_unref0 (store);
	return self;
}

PamacPreferencesWindow*
pamac_preferences_window_new (PamacManagerWindow* window)
{
	return pamac_preferences_window_construct (PAMAC_TYPE_PREFERENCES_WINDOW, window);
}

static void
pamac_preferences_window_refresh_clean_cache_button_data_free (gpointer _data)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacPreferencesWindowRefreshCleanCacheButtonData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pamac_preferences_window_refresh_clean_cache_button (PamacPreferencesWindow* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	PamacPreferencesWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PamacPreferencesWindowRefreshCleanCacheButtonData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_preferences_window_refresh_clean_cache_button_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pamac_preferences_window_refresh_clean_cache_button_co (_data_);
}

static void
pamac_preferences_window_refresh_clean_cache_button_finish (PamacPreferencesWindow* self,
                                                            GAsyncResult* _res_)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
pamac_preferences_window_refresh_clean_cache_button_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	PamacPreferencesWindowRefreshCleanCacheButtonData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pamac_preferences_window_refresh_clean_cache_button_co (_data_);
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

static gboolean
pamac_preferences_window_refresh_clean_cache_button_co (PamacPreferencesWindowRefreshCleanCacheButtonData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->database;
	_data_->_state_ = 1;
	pamac_database_get_clean_cache_details_async (_data_->_tmp0_, pamac_preferences_window_refresh_clean_cache_button_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = pamac_database_get_clean_cache_details_finish (_data_->_tmp0_, _data_->_res_);
	_data_->details = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->details;
	g_hash_table_iter_init (&_data_->iter, _data_->_tmp2_);
	_data_->total_size = (guint64) 0;
	_data_->files_nb = (guint) 0;
	while (TRUE) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp4_ = g_hash_table_iter_next (&_data_->iter, (gpointer*) NULL, (gpointer*) (&_data_->_tmp3_));
		_g_free0 (_data_->size);
		_data_->_tmp5_ = __uint64_dup0 ((guint64*) _data_->_tmp3_);
		_data_->size = _data_->_tmp5_;
		if (!_data_->_tmp4_) {
			break;
		}
		_data_->_tmp6_ = _data_->size;
		_data_->total_size += *_data_->_tmp6_;
		_data_->_tmp7_ = _data_->files_nb;
		_data_->files_nb = _data_->_tmp7_ + 1;
	}
	_data_->_tmp8_ = _data_->self->priv->clean_cache_label;
	_data_->_tmp9_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) _data_->files_nb), _data_->files_nb);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_format_size_full (_data_->total_size, G_FORMAT_SIZE_DEFAULT);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("<b>%s:  %s  (%s)</b>", g_dgettext (NULL, "To delete"), _data_->_tmp10_, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	gtk_label_set_markup (_data_->_tmp8_, _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp16_ = _data_->files_nb;
	_data_->files_nb = _data_->_tmp16_ + 1;
	if (_data_->_tmp16_ > ((guint) 0)) {
		_data_->_tmp15_ = !_data_->self->priv->transaction_running;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp17_ = _data_->self->priv->clean_cache_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp17_, TRUE);
	} else {
		_data_->_tmp18_ = _data_->self->priv->clean_cache_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp18_, FALSE);
	}
	_g_free0 (_data_->size);
	_g_hash_table_unref0 (_data_->details);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_preferences_window_refresh_clean_build_files_button_data_free (gpointer _data)
{
	PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacPreferencesWindowRefreshCleanBuildFilesButtonData, _data_);
}

static void
pamac_preferences_window_refresh_clean_build_files_button (PamacPreferencesWindow* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_;
	PamacPreferencesWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PamacPreferencesWindowRefreshCleanBuildFilesButtonData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_preferences_window_refresh_clean_build_files_button_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pamac_preferences_window_refresh_clean_build_files_button_co (_data_);
}

static void
pamac_preferences_window_refresh_clean_build_files_button_finish (PamacPreferencesWindow* self,
                                                                  GAsyncResult* _res_)
{
	PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
pamac_preferences_window_refresh_clean_build_files_button_co (PamacPreferencesWindowRefreshCleanBuildFilesButtonData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->database;
	_data_->_tmp1_ = pamac_database_get_build_files_details (_data_->_tmp0_);
	_data_->details = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->details;
	g_hash_table_iter_init (&_data_->iter, _data_->_tmp2_);
	_data_->total_size = (guint64) 0;
	_data_->files_nb = (guint) 0;
	while (TRUE) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp4_ = g_hash_table_iter_next (&_data_->iter, (gpointer*) NULL, (gpointer*) (&_data_->_tmp3_));
		_g_free0 (_data_->size);
		_data_->_tmp5_ = __uint64_dup0 ((guint64*) _data_->_tmp3_);
		_data_->size = _data_->_tmp5_;
		if (!_data_->_tmp4_) {
			break;
		}
		_data_->_tmp6_ = _data_->size;
		_data_->total_size += *_data_->_tmp6_;
		_data_->_tmp7_ = _data_->files_nb;
		_data_->files_nb = _data_->_tmp7_ + 1;
	}
	_data_->_tmp8_ = _data_->self->priv->clean_build_files_label;
	_data_->_tmp9_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) _data_->files_nb), _data_->files_nb);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_format_size_full (_data_->total_size, G_FORMAT_SIZE_DEFAULT);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("<b>%s:  %s  (%s)</b>", g_dgettext (NULL, "To delete"), _data_->_tmp10_, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	gtk_label_set_markup (_data_->_tmp8_, _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp16_ = _data_->files_nb;
	_data_->files_nb = _data_->_tmp16_ + 1;
	if (_data_->_tmp16_ > ((guint) 0)) {
		_data_->_tmp15_ = !_data_->self->priv->transaction_running;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp17_ = _data_->self->priv->clean_build_files_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp17_, TRUE);
	} else {
		_data_->_tmp18_ = _data_->self->priv->clean_build_files_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp18_, FALSE);
	}
	_g_free0 (_data_->size);
	_g_hash_table_unref0 (_data_->details);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_preferences_window_on_check_updates_expander_changed (PamacPreferencesWindow* self)
{
	AdwExpanderRow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->check_updates_expander;
	_tmp1_ = adw_expander_row_get_enable_expansion (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PamacConfig* _tmp3_;
		_tmp3_ = self->priv->config;
		pamac_config_set_refresh_period (_tmp3_, self->priv->previous_refresh_period);
	} else {
		PamacConfig* _tmp4_;
		guint64 _tmp5_;
		guint64 _tmp6_;
		PamacConfig* _tmp7_;
		_tmp4_ = self->priv->config;
		_tmp5_ = pamac_config_get_refresh_period (_tmp4_);
		_tmp6_ = _tmp5_;
		self->priv->previous_refresh_period = _tmp6_;
		_tmp7_ = self->priv->config;
		pamac_config_set_refresh_period (_tmp7_, (guint64) 0);
	}
}

static void
pamac_preferences_window_on_refresh_period_comborow_changed (PamacPreferencesWindow* self)
{
	guint index = 0U;
	AdwComboRow* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->refresh_period_comborow;
	_tmp1_ = adw_combo_row_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	index = _tmp2_;
	if (index == ((guint) 0)) {
		PamacConfig* _tmp3_;
		_tmp3_ = self->priv->config;
		pamac_config_set_refresh_period (_tmp3_, (guint64) 3);
	} else {
		if (index == ((guint) 1)) {
			PamacConfig* _tmp4_;
			_tmp4_ = self->priv->config;
			pamac_config_set_refresh_period (_tmp4_, (guint64) 6);
		} else {
			if (index == ((guint) 2)) {
				PamacConfig* _tmp5_;
				_tmp5_ = self->priv->config;
				pamac_config_set_refresh_period (_tmp5_, (guint64) 12);
			} else {
				if (index == ((guint) 3)) {
					PamacConfig* _tmp6_;
					_tmp6_ = self->priv->config;
					pamac_config_set_refresh_period (_tmp6_, (guint64) 24);
				} else {
					PamacConfig* _tmp7_;
					_tmp7_ = self->priv->config;
					pamac_config_set_refresh_period (_tmp7_, (guint64) 168);
				}
			}
		}
	}
}

static void
pamac_preferences_window_on_parallel_downloads_comborow_changed (PamacPreferencesWindow* self)
{
	guint index = 0U;
	AdwComboRow* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parallel_downloads_comborow;
	_tmp1_ = adw_combo_row_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	index = _tmp2_;
	if (index == ((guint) 0)) {
		PamacConfig* _tmp3_;
		_tmp3_ = self->priv->config;
		pamac_config_set_max_parallel_downloads (_tmp3_, (guint64) 1);
	} else {
		if (index == ((guint) 1)) {
			PamacConfig* _tmp4_;
			_tmp4_ = self->priv->config;
			pamac_config_set_max_parallel_downloads (_tmp4_, (guint64) 2);
		} else {
			if (index == ((guint) 2)) {
				PamacConfig* _tmp5_;
				_tmp5_ = self->priv->config;
				pamac_config_set_max_parallel_downloads (_tmp5_, (guint64) 4);
			} else {
				if (index == ((guint) 3)) {
					PamacConfig* _tmp6_;
					_tmp6_ = self->priv->config;
					pamac_config_set_max_parallel_downloads (_tmp6_, (guint64) 6);
				} else {
					if (index == ((guint) 4)) {
						PamacConfig* _tmp7_;
						_tmp7_ = self->priv->config;
						pamac_config_set_max_parallel_downloads (_tmp7_, (guint64) 8);
					} else {
						PamacConfig* _tmp8_;
						_tmp8_ = self->priv->config;
						pamac_config_set_max_parallel_downloads (_tmp8_, (guint64) 10);
					}
				}
			}
		}
	}
}

static void
pamac_preferences_window_on_cache_keep_nb_comborow_changed (PamacPreferencesWindow* self)
{
	PamacConfig* _tmp0_;
	AdwComboRow* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->config;
	_tmp1_ = self->priv->cache_keep_nb_comborow;
	_tmp2_ = adw_combo_row_get_selected (_tmp1_);
	_tmp3_ = _tmp2_;
	pamac_config_set_clean_keep_num_pkgs (_tmp0_, (guint64) _tmp3_);
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
}

static void
pamac_preferences_window_on_cache_only_uninstalled_button_changed (PamacPreferencesWindow* self)
{
	g_return_if_fail (self != NULL);
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda84_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacPreferencesWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		GFile* choosen_dir = NULL;
		GFile* _tmp0_;
		GtkButton* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		PamacConfig* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp0_ = gtk_file_dialog_select_folder_finish (_data3_->chooser, res, &_inner_error0_);
		choosen_dir = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->aur_build_dir_file_chooser;
		_tmp2_ = g_file_get_basename (choosen_dir);
		_tmp3_ = _tmp2_;
		gtk_button_set_label (_tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->config;
		_tmp5_ = g_file_get_path (choosen_dir);
		_tmp6_ = _tmp5_;
		pamac_config_set_aur_build_dir (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
		pamac_preferences_window_refresh_clean_build_files_button (self, NULL, NULL);
		_g_object_unref0 (choosen_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("preferences_dialog.vala:379: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda84__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda84_ (self, source_object, res);
	block3_data_unref (self);
}

static void
pamac_preferences_window_on_aur_build_dir_file_chooser_clicked (PamacPreferencesWindow* self)
{
	Block3Data* _data3_;
	GtkFileDialog* _tmp0_;
	GFile* default_build_dir_file = NULL;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = gtk_file_dialog_new ();
	_data3_->chooser = _tmp0_;
	gtk_file_dialog_set_title (_data3_->chooser, g_dgettext (NULL, "Select Build Directory"));
	_tmp1_ = g_file_new_for_path ("/var/tmp");
	default_build_dir_file = _tmp1_;
	gtk_file_dialog_set_initial_folder (_data3_->chooser, default_build_dir_file);
	gtk_file_dialog_select_folder (_data3_->chooser, (GtkWindow*) self, NULL, ___lambda84__gasync_ready_callback, block3_data_ref (_data3_));
	_g_object_unref0 (default_build_dir_file);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
_pamac_preferences_window_on_aur_build_dir_file_chooser_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                    gpointer self)
{
	pamac_preferences_window_on_aur_build_dir_file_chooser_clicked ((PamacPreferencesWindow*) self);
}

static void
_pamac_preferences_window_on_add_ignorepkgs_button_clicked_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                       GtkListBoxRow* row,
                                                                                       gpointer self)
{
	pamac_preferences_window_on_add_ignorepkgs_button_clicked ((PamacPreferencesWindow*) self);
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
pamac_preferences_window_populate_ignorepkgs_list (PamacPreferencesWindow* self)
{
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkListBox* _tmp6_;
	GtkImage* _tmp7_;
	GtkListBox* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic");
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = image;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 12);
	_tmp2_ = image;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp2_, 12);
	_tmp3_ = image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp3_, 12);
	_tmp4_ = image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp4_, 12);
	_tmp5_ = image;
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->ignorepkgs_listbox;
	_tmp7_ = image;
	gtk_list_box_append (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->ignorepkgs_listbox;
	g_signal_connect_object (_tmp8_, "row-activated", (GCallback) _pamac_preferences_window_on_add_ignorepkgs_button_clicked_gtk_list_box_row_activated, self, 0);
	{
		GHashTableIter _ignorepkg_it = {0};
		PamacConfig* _tmp9_;
		GHashTable* _tmp10_;
		GHashTable* _tmp11_;
		GHashTableIter _tmp12_ = {0};
		const gchar* ignorepkg = NULL;
		_tmp9_ = self->priv->config;
		_tmp10_ = pamac_config_get_ignorepkgs (_tmp9_);
		_tmp11_ = _tmp10_;
		g_hash_table_iter_init (&_tmp12_, _tmp11_);
		_ignorepkg_it = _tmp12_;
		while (TRUE) {
			gconstpointer _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = _vala_hash_set_next_value (&_ignorepkg_it);
			ignorepkg = (const gchar*) _tmp13_;
			_tmp14_ = ignorepkg;
			if (!(_tmp14_ != NULL)) {
				break;
			}
			_tmp15_ = ignorepkg;
			pamac_preferences_window_add_ignorepkg (self, _tmp15_);
		}
	}
	_g_object_unref0 (image);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->row);
		_g_free0 (_data4_->pkgname);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda83_ (Block4Data* _data4_)
{
	PamacPreferencesWindow* self;
	GtkListBox* _tmp0_;
	PamacConfig* _tmp1_;
	self = _data4_->self;
	_tmp0_ = self->priv->ignorepkgs_listbox;
	gtk_list_box_remove (_tmp0_, (GtkWidget*) _data4_->row);
	_tmp1_ = self->priv->config;
	pamac_config_remove_ignorepkg (_tmp1_, _data4_->pkgname);
}

static void
___lambda83__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda83_ (self);
}

static void
pamac_preferences_window_add_ignorepkg (PamacPreferencesWindow* self,
                                        const gchar* pkgname)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkBox* box = NULL;
	GtkBox* _tmp2_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp3_;
	GtkButton* button = NULL;
	GtkButton* _tmp4_;
	GtkListBox* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgname != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup (pkgname);
	_g_free0 (_data4_->pkgname);
	_data4_->pkgname = _tmp0_;
	_tmp1_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp1_);
	_data4_->row = _tmp1_;
	gtk_list_box_row_set_activatable (_data4_->row, FALSE);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp2_);
	box = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_data4_->pkgname);
	g_object_ref_sink (_tmp3_);
	label = _tmp3_;
	gtk_widget_set_margin_top ((GtkWidget*) label, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 12);
	gtk_widget_set_margin_start ((GtkWidget*) label, 12);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) label, TRUE);
	gtk_label_set_wrap (label, TRUE);
	gtk_box_append (box, (GtkWidget*) label);
	_tmp4_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp4_);
	button = _tmp4_;
	gtk_widget_set_margin_end ((GtkWidget*) button, 12);
	gtk_button_set_has_frame (button, FALSE);
	gtk_widget_set_valign ((GtkWidget*) button, GTK_ALIGN_CENTER);
	gtk_button_set_icon_name (button, "list-remove-symbolic");
	g_signal_connect_data (button, "clicked", (GCallback) ___lambda83__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	gtk_box_append (box, (GtkWidget*) button);
	gtk_list_box_row_set_child (_data4_->row, (GtkWidget*) box);
	_tmp5_ = self->priv->ignorepkgs_listbox;
	gtk_list_box_append (_tmp5_, (GtkWidget*) _data4_->row);
	_g_object_unref0 (button);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->choose_pkgs_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
__lambda82_ (Block5Data* _data5_,
             const gchar* response)
{
	PamacPreferencesWindow* self;
	self = _data5_->self;
	g_return_if_fail (response != NULL);
	if (g_strcmp0 (response, "choose") == 0) {
		GPtrArray* _tmp0_;
		_tmp0_ = pamac_choose_pkgs_dialog_get_selected_pkgs (_data5_->choose_pkgs_dialog);
		{
			GPtrArray* pkgname_collection = NULL;
			guint pkgname_index = 0U;
			pkgname_collection = _tmp0_;
			for (pkgname_index = 0; pkgname_index < pkgname_collection->len; pkgname_index = pkgname_index + 1) {
				const gchar* pkgname = NULL;
				pkgname = g_ptr_array_index (pkgname_collection, pkgname_index);
				{
					PamacConfig* _tmp1_;
					const gchar* _tmp2_;
					const gchar* _tmp3_;
					_tmp1_ = self->priv->config;
					_tmp2_ = pkgname;
					pamac_config_add_ignorepkg (_tmp1_, _tmp2_);
					_tmp3_ = pkgname;
					pamac_preferences_window_add_ignorepkg (self, _tmp3_);
				}
			}
			_g_ptr_array_unref0 (pkgname_collection);
		}
	}
}

static void
___lambda82__adw_message_dialog_response (AdwMessageDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	__lambda82_ (self, response);
}

static void
__lambda81_ (Block5Data* _data5_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacPreferencesWindow* self;
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	GHashTable* ignorepkgs_unique = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GPtrArray* _tmp5_;
	GdkCursor* _tmp19_;
	GdkCursor* _tmp20_;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_installed_pkgs_finish (_tmp0_, res);
	pkgs = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_free0_);
	ignorepkgs_unique = _tmp4_;
	_tmp5_ = pkgs;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = _tmp5_;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacPackage* pkg = NULL;
			pkg = g_ptr_array_index (pkg_collection, pkg_index);
			{
				const gchar* pkgname = NULL;
				PamacPackage* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				GHashTable* _tmp9_;
				const gchar* _tmp10_;
				PamacConfig* _tmp11_;
				GHashTable* _tmp12_;
				GHashTable* _tmp13_;
				const gchar* _tmp14_;
				GHashTable* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp6_ = pkg;
				_tmp7_ = pamac_package_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				pkgname = _tmp8_;
				_tmp9_ = ignorepkgs_unique;
				_tmp10_ = pkgname;
				if (g_hash_table_contains (_tmp9_, _tmp10_)) {
					continue;
				}
				_tmp11_ = self->priv->config;
				_tmp12_ = pamac_config_get_ignorepkgs (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = pkgname;
				if (g_hash_table_contains (_tmp13_, _tmp14_)) {
					continue;
				}
				_tmp15_ = ignorepkgs_unique;
				_tmp16_ = pkgname;
				_tmp17_ = g_strdup (_tmp16_);
				g_hash_table_add (_tmp15_, _tmp17_);
				_tmp18_ = pkgname;
				pamac_choose_pkgs_dialog_add_pkg (_data5_->choose_pkgs_dialog, _tmp18_);
			}
		}
	}
	_tmp19_ = gdk_cursor_new_from_name ("default", NULL);
	_tmp20_ = _tmp19_;
	gtk_widget_set_cursor ((GtkWidget*) self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	g_signal_connect_data ((AdwMessageDialog*) _data5_->choose_pkgs_dialog, "response", (GCallback) ___lambda82__adw_message_dialog_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	pamac_choose_pkgs_dialog_enable_search (_data5_->choose_pkgs_dialog);
	gtk_window_present ((GtkWindow*) _data5_->choose_pkgs_dialog);
	_g_hash_table_unref0 (ignorepkgs_unique);
	_g_ptr_array_unref0 (pkgs);
}

static void
___lambda81__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda81_ (self, source_object, res);
	block5_data_unref (self);
}

static void
pamac_preferences_window_on_add_ignorepkgs_button_clicked (PamacPreferencesWindow* self)
{
	Block5Data* _data5_;
	PamacTransactionGtk* _tmp0_;
	PamacChoosePkgsDialog* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	PamacDatabase* _tmp4_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->transaction;
	_tmp1_ = pamac_transaction_gtk_create_choose_pkgs_dialog (_tmp0_);
	_data5_->choose_pkgs_dialog = _tmp1_;
	adw_message_dialog_set_heading ((AdwMessageDialog*) _data5_->choose_pkgs_dialog, g_dgettext (NULL, "Choose Ignored Upgrades"));
	_tmp2_ = gdk_cursor_new_from_name ("progress", NULL);
	_tmp3_ = _tmp2_;
	gtk_widget_set_cursor ((GtkWidget*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->database;
	pamac_database_get_installed_pkgs_async (_tmp4_, ___lambda81__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
pamac_preferences_window_on_mirrors_country_comborow_changed (PamacPreferencesWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->generate_mirrors_list_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp0_, "suggested-action");
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PamacPreferencesWindow* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda85_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacPreferencesWindow* self;
	PamacManagerWindow* _tmp0_;
	PamacTransactionGtk* _tmp1_;
	GtkButton* _tmp2_;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data6_->manager_window;
	_tmp0_->generate_mirrors_list = FALSE;
	_tmp1_ = self->priv->transaction;
	pamac_transaction_gtk_reset_progress_box (_tmp1_);
	_tmp2_ = self->priv->generate_mirrors_list_button;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp2_, "suggested-action");
}

static void
___lambda85__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda85_ (self, source_object, res);
	block6_data_unref (self);
}

static void
pamac_preferences_window_on_generate_mirrors_list_button_clicked (PamacPreferencesWindow* self)
{
	Block6Data* _data6_;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	PamacManagerWindow* _tmp3_;
	GObject* object = NULL;
	AdwComboRow* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	GObject* _tmp8_;
	GtkStringObject* string_object = NULL;
	GObject* _tmp9_;
	gchar* preferences_choosen_country = NULL;
	GtkStringObject* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	PamacTransactionGtk* _tmp15_;
	PamacManagerWindow* _tmp16_;
	PamacManagerWindow* _tmp17_;
	PamacManagerWindow* _tmp18_;
	GtkButton* _tmp19_;
	PamacManagerWindow* _tmp20_;
	GtkButton* _tmp21_;
	PamacManagerWindow* _tmp22_;
	GtkRevealer* _tmp23_;
	PamacTransactionGtk* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = gtk_window_get_transient_for ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_data6_->manager_window = PAMAC_IS_MANAGER_WINDOW (_tmp1_) ? ((PamacManagerWindow*) _tmp1_) : NULL;
	_tmp3_ = _data6_->manager_window;
	if (_tmp3_->transaction_running) {
		_tmp2_ = TRUE;
	} else {
		PamacManagerWindow* _tmp4_;
		_tmp4_ = _data6_->manager_window;
		_tmp2_ = _tmp4_->generate_mirrors_list;
	}
	if (_tmp2_) {
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	_tmp5_ = self->priv->mirrors_country_comborow;
	_tmp6_ = adw_combo_row_get_selected_item (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	object = _tmp8_;
	_tmp9_ = object;
	string_object = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_string_object_get_type ()) ? ((GtkStringObject*) _tmp9_) : NULL;
	_tmp10_ = string_object;
	_tmp11_ = gtk_string_object_get_string (_tmp10_);
	_tmp12_ = g_strdup (_tmp11_);
	preferences_choosen_country = _tmp12_;
	_tmp13_ = preferences_choosen_country;
	if (g_strcmp0 (_tmp13_, g_dgettext (NULL, "Worldwide")) == 0) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("all");
		_g_free0 (preferences_choosen_country);
		preferences_choosen_country = _tmp14_;
	}
	_tmp15_ = self->priv->transaction;
	pamac_transaction_gtk_start_progressbar_pulse (_tmp15_);
	_tmp16_ = _data6_->manager_window;
	_tmp16_->important_details = TRUE;
	_tmp17_ = _data6_->manager_window;
	_tmp17_->generate_mirrors_list = TRUE;
	_tmp18_ = _data6_->manager_window;
	_tmp19_ = _tmp18_->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	_tmp20_ = _data6_->manager_window;
	_tmp21_ = _tmp20_->details_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, TRUE);
	_tmp22_ = _data6_->manager_window;
	_tmp23_ = _tmp22_->infobox_revealer;
	gtk_revealer_set_reveal_child (_tmp23_, TRUE);
	_tmp24_ = self->priv->transaction;
	_tmp25_ = preferences_choosen_country;
	pamac_transaction_generate_mirrors_list_async ((PamacTransaction*) _tmp24_, _tmp25_, ___lambda85__gasync_ready_callback, block6_data_ref (_data6_));
	_g_free0 (preferences_choosen_country);
	_g_object_unref0 (object);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
_pamac_preferences_window_on_generate_mirrors_list_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                      gpointer self)
{
	pamac_preferences_window_on_generate_mirrors_list_button_clicked ((PamacPreferencesWindow*) self);
}

static void
__lambda86_ (PamacPreferencesWindow* self)
{
	pamac_preferences_window_refresh_clean_cache_button (self, NULL, NULL);
}

static void
___lambda86__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda86_ ((PamacPreferencesWindow*) self);
	g_object_unref (self);
}

static void
pamac_preferences_window_on_clean_cache_button_clicked (PamacPreferencesWindow* self)
{
	PamacTransactionGtk* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->transaction;
	pamac_transaction_clean_cache_async ((PamacTransaction*) _tmp0_, ___lambda86__gasync_ready_callback, g_object_ref (self));
}

static void
_pamac_preferences_window_on_clean_cache_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self)
{
	pamac_preferences_window_on_clean_cache_button_clicked ((PamacPreferencesWindow*) self);
}

static void
__lambda87_ (PamacPreferencesWindow* self)
{
	pamac_preferences_window_refresh_clean_build_files_button (self, NULL, NULL);
}

static void
___lambda87__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda87_ ((PamacPreferencesWindow*) self);
	g_object_unref (self);
}

static void
pamac_preferences_window_on_clean_build_files_button_clicked (PamacPreferencesWindow* self)
{
	PamacTransactionGtk* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->transaction;
	pamac_transaction_clean_build_files_async ((PamacTransaction*) _tmp0_, ___lambda87__gasync_ready_callback, g_object_ref (self));
}

static void
_pamac_preferences_window_on_clean_build_files_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self)
{
	pamac_preferences_window_on_clean_build_files_button_clicked ((PamacPreferencesWindow*) self);
}

static void
pamac_preferences_window_class_init (PamacPreferencesWindowClass * klass,
                                     gpointer klass_data)
{
	pamac_preferences_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacPreferencesWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_preferences_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/manjaro/pamac/preferences/preferences_dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "updates_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, updates_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_updates_expander", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_updates_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "refresh_period_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, refresh_period_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "no_update_hide_icon_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, no_update_hide_icon_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "download_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, download_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "offline_upgrade_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, offline_upgrade_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "parallel_downloads_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, parallel_downloads_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mirrors_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, mirrors_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mirrors_country_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, mirrors_country_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "generate_mirrors_list_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, generate_mirrors_list_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cache_keep_nb_comborow", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, cache_keep_nb_comborow));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cache_only_uninstalled_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, cache_only_uninstalled_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_cache_label", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_cache_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_cache_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_cache_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "advanced_preferences_page", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, advanced_preferences_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_space_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_space_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_unrequired_deps_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, remove_unrequired_deps_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "simple_install_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, simple_install_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_downgrade_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_downgrade_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ignorepkgs_listbox", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, ignorepkgs_listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "third_party_preferences_page", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, third_party_preferences_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aur_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, aur_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_aur_expander", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_aur_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aur_build_dir_file_chooser", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, aur_build_dir_file_chooser));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "keep_built_pkgs_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, keep_built_pkgs_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_aur_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_aur_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_aur_vcs_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_aur_vcs_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_build_files_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_build_files_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clean_build_files_label", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, clean_build_files_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "flatpak_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, flatpak_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_flatpak_expander", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_flatpak_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "check_flatpak_updates_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, check_flatpak_updates_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "snap_preferences_group", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, snap_preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enable_snap_button", FALSE, PamacPreferencesWindow_private_offset + G_STRUCT_OFFSET (PamacPreferencesWindowPrivate, enable_snap_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_aur_build_dir_file_chooser_clicked", G_CALLBACK(_pamac_preferences_window_on_aur_build_dir_file_chooser_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_generate_mirrors_list_button_clicked", G_CALLBACK(_pamac_preferences_window_on_generate_mirrors_list_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clean_cache_button_clicked", G_CALLBACK(_pamac_preferences_window_on_clean_cache_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clean_build_files_button_clicked", G_CALLBACK(_pamac_preferences_window_on_clean_build_files_button_clicked_gtk_button_clicked));
}

static void
pamac_preferences_window_instance_init (PamacPreferencesWindow * self,
                                        gpointer klass)
{
	self->priv = pamac_preferences_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pamac_preferences_window_finalize (GObject * obj)
{
	PamacPreferencesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_PREFERENCES_WINDOW, PamacPreferencesWindow);
	G_OBJECT_CLASS (pamac_preferences_window_parent_class)->finalize (obj);
}

static GType
pamac_preferences_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacPreferencesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_preferences_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacPreferencesWindow), 0, (GInstanceInitFunc) pamac_preferences_window_instance_init, NULL };
	GType pamac_preferences_window_type_id;
	pamac_preferences_window_type_id = g_type_register_static (adw_preferences_window_get_type (), "PamacPreferencesWindow", &g_define_type_info, 0);
	PamacPreferencesWindow_private_offset = g_type_add_instance_private (pamac_preferences_window_type_id, sizeof (PamacPreferencesWindowPrivate));
	return pamac_preferences_window_type_id;
}

GType
pamac_preferences_window_get_type (void)
{
	static volatile gsize pamac_preferences_window_type_id__once = 0;
	if (g_once_init_enter (&pamac_preferences_window_type_id__once)) {
		GType pamac_preferences_window_type_id;
		pamac_preferences_window_type_id = pamac_preferences_window_get_type_once ();
		g_once_init_leave (&pamac_preferences_window_type_id__once, pamac_preferences_window_type_id);
	}
	return pamac_preferences_window_type_id__once;
}

