/*
 * Decompiled with CFR 0.152.
 */
package net.atmp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.abel.Bag;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityFactory;
import net.sourceforge.plantuml.abel.EntityGender;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.Together;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.HideOrShow;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.cucadiagram.LinkConstraint;
import net.sourceforge.plantuml.cucadiagram.Magma;
import net.sourceforge.plantuml.cucadiagram.MagmaList;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.elk.CucaDiagramFileMakerElk;
import net.sourceforge.plantuml.graphml.CucaDiagramGraphmlMaker;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.sdot.CucaDiagramFileMakerSmetana;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmlsc.StateDiagramScxmlMaker;

public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower,
ICucaDiagram {
    private final List<HideOrShow> hides2 = new ArrayList<HideOrShow>();
    private final List<HideOrShow> removed = new ArrayList<HideOrShow>();
    protected final EntityFactory entityFactory = new EntityFactory(this.hides2, this.removed, this);
    private List<Bag> stacks = new ArrayList<Bag>();
    private boolean visibilityModifierPresent;
    private String warningOrError;
    private final List<EntityHideOrShow> hideOrShows = new ArrayList<EntityHideOrShow>();
    private final Set<VisibilityModifier> hides = new HashSet<VisibilityModifier>();
    protected Entity lastEntity = null;
    private final AtomicInteger cpt = new AtomicInteger(1);

    @Override
    public final void setNamespaceSeparator(String namespaceSeparator) {
        super.setNamespaceSeparator(namespaceSeparator);
        this.entityFactory.setSeparator(namespaceSeparator);
    }

    public CucaDiagram(UmlSource source, UmlDiagramType type, Map<String, String> orig) {
        super(source, type, orig);
        this.stacks.add(this.entityFactory.root().getData());
    }

    public String getPortFor(String entString, Quark<Entity> ident) {
        int x = entString.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        if (entString.startsWith(ident.getName())) {
            return entString.substring(x + 2);
        }
        return null;
    }

    public final Entity getCurrentGroup() {
        for (int pos = this.stacks.size() - 1; pos >= 0; --pos) {
            Bag tmp = this.stacks.get(pos);
            if (!(tmp instanceof Entity)) continue;
            return (Entity)tmp;
        }
        throw new IllegalStateException();
    }

    public final Together currentTogether() {
        int pos = this.stacks.size() - 1;
        Bag tmp = this.stacks.get(pos);
        if (tmp instanceof Together) {
            return (Together)tmp;
        }
        return null;
    }

    public String cleanId(String id) {
        if (id == null) {
            return null;
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(id);
    }

    @Override
    public boolean hasUrl() {
        for (Quark<Entity> quark : this.entityFactory.quarks()) {
            Entity ent = quark.getData();
            if (ent == null || !ent.hasUrl()) continue;
            return true;
        }
        return false;
    }

    public final void setLastEntity(Entity foo) {
        this.lastEntity = foo;
    }

    protected void updateLasts(Entity result) {
    }

    public final Entity reallyCreateLeaf(Quark<Entity> ident, Display display, LeafType type, USymbol symbol) {
        Objects.requireNonNull(type);
        if (ident.getData() != null) {
            throw new IllegalStateException();
        }
        if (Display.isNull(display)) {
            throw new IllegalArgumentException();
        }
        Entity result = this.entityFactory.createLeaf(ident, type, this.getHides());
        result.setUSymbol(symbol);
        this.lastEntity = result;
        result.setTogether(this.currentTogether());
        this.updateLasts(result);
        result.setDisplay(display);
        if (type.isLikeClass()) {
            this.eventuallyBuildPhantomGroups();
        }
        return result;
    }

    public final Quark<Entity> quarkInContext(boolean reuseExistingChild, String full) {
        boolean firstPackageDoesExist;
        String sep = this.getNamespaceSeparator();
        if (sep == null) {
            Quark<Entity> result = this.entityFactory.firstWithName(full);
            if (result != null) {
                return result;
            }
            return this.getCurrentGroup().getQuark().child(full);
        }
        Quark<Entity> currentQuark = this.getCurrentGroup().getQuark();
        if (full.startsWith(sep)) {
            return this.entityFactory.root().child(full.substring(sep.length()));
        }
        int x = full.indexOf(sep);
        if (x == -1) {
            if (reuseExistingChild && this.entityFactory.countByName(full) == 1) {
                Quark<Entity> byName = this.entityFactory.firstWithName(full);
                assert (byName != null);
                if (byName != currentQuark) {
                    return byName;
                }
            }
            return currentQuark.child(full);
        }
        String first = full.substring(0, x);
        boolean bl = firstPackageDoesExist = this.entityFactory.root().childIfExists(first) != null;
        if (firstPackageDoesExist) {
            return this.entityFactory.root().child(full);
        }
        return currentQuark.child(full);
    }

    public String removePortId(String id) {
        if ("::".equals(this.getNamespaceSeparator())) {
            return id;
        }
        int x = id.lastIndexOf("::");
        if (x == -1) {
            return id;
        }
        return id.substring(0, x);
    }

    public String getPortId(String id) {
        if ("::".equals(this.getNamespaceSeparator())) {
            return null;
        }
        int x = id.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        return id.substring(x + 2);
    }

    public Quark<Entity> firstWithName(String name) {
        return this.entityFactory.firstWithName(name);
    }

    @Override
    public final Collection<Entity> getChildrenGroups(Entity entity) {
        return entity.groups();
    }

    private void eventuallyBuildPhantomGroups() {
        for (Quark<Entity> quark : this.entityFactory.quarks()) {
            int countChildren;
            if (quark.getData() != null || (countChildren = quark.countChildren()) <= 0) continue;
            Display display = Display.getWithNewlines(quark.getName());
            Entity result = this.entityFactory.createGroup(quark, GroupType.PACKAGE, this.getHides());
            result.setDisplay(display);
        }
    }

    public final CommandExecutionResult gotoTogether() {
        this.stacks.add(new Together(this.currentTogether()));
        return CommandExecutionResult.ok();
    }

    public final CommandExecutionResult gotoGroup(Quark<Entity> quark, Display display, GroupType type) {
        if (quark.getData() == null) {
            Entity result = this.entityFactory.createGroup(quark, type, this.getHides());
            result.setTogether(this.currentTogether());
            result.setDisplay(display);
        }
        Entity ent = quark.getData();
        ent.muteToGroupType(type);
        this.stacks.add(quark.getData());
        return CommandExecutionResult.ok();
    }

    public boolean endGroup() {
        if (this.stacks.size() > 0) {
            this.stacks.remove(this.stacks.size() - 1);
            return true;
        }
        return false;
    }

    public final Entity getGroup(String code) {
        Quark<Entity> quark = this.entityFactory.firstWithName(code);
        if (quark == null) {
            return null;
        }
        return quark.getData();
    }

    public final boolean isGroup(String code) {
        Quark<Entity> quark = this.entityFactory.firstWithName(code);
        if (quark == null) {
            return false;
        }
        return this.isGroup(quark);
    }

    public final boolean isGroup(Quark<Entity> quark) {
        Entity ent = quark.getData();
        if (ent == null) {
            return false;
        }
        return ent.isGroup();
    }

    @Override
    public Entity getRootGroup() {
        return this.entityFactory.root().getData();
    }

    public final void addLink(Link link) {
        this.entityFactory.addLink(link);
    }

    protected final void removeLink(Link link) {
        this.entityFactory.removeLink(link);
    }

    public final List<Link> getLinks() {
        return this.entityFactory.getLinks();
    }

    protected abstract List<String> getDotStrings();

    @Override
    public final String[] getDotStringSkek() {
        String ratio;
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getDotStrings()) {
            if (!s.startsWith("nodesep") && !s.startsWith("ranksep") && !s.startsWith("layout")) continue;
            result.add(s);
        }
        String aspect = this.getPragma().getValue("aspect");
        if (aspect != null) {
            aspect = aspect.replace(',', '.');
            result.add("aspect=" + aspect + ";");
        }
        if ((ratio = this.getPragma().getValue("ratio")) != null) {
            result.add("ratio=" + ratio + ";");
        }
        return result.toArray(new String[result.size()]);
    }

    private void createFilesGraphml(OutputStream suggestedFile) throws IOException {
        CucaDiagramGraphmlMaker maker = new CucaDiagramGraphmlMaker(this);
        maker.createFiles(suggestedFile);
    }

    private void createFilesXmi(OutputStream suggestedFile, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker maker = new CucaDiagramXmiMaker(this, fileFormat);
        maker.createFiles(suggestedFile);
    }

    private void createFilesScxml(OutputStream suggestedFile) throws IOException {
        StateDiagramScxmlMaker maker = new StateDiagramScxmlMaker((StateDiagram)this);
        maker.createFiles(suggestedFile);
    }

    private void createFilesTxt(OutputStream os, int index, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker maker = new CucaDiagramTxtMaker(this, fileFormat);
        maker.createFiles(os, index);
    }

    @Override
    public final void exportDiagramGraphic(UGraphic ug, FileFormatOption fileFormatOption) {
        CucaDiagramFileMakerSmetana maker = new CucaDiagramFileMakerSmetana(this, ug.getStringBounder());
        maker.createOneGraphic(ug);
    }

    @Override
    protected final TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(os, index, fileFormat);
            }
            catch (Throwable t) {
                t.printStackTrace(SecurityUtils.createPrintStream(os));
            }
            return ImageDataSimple.ok();
        }
        if (fileFormat == FileFormat.GRAPHML) {
            this.createFilesGraphml(os);
            return ImageDataSimple.ok();
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(os, fileFormat);
            return ImageDataSimple.ok();
        }
        if (fileFormat == FileFormat.SCXML) {
            this.createFilesScxml(os);
            return ImageDataSimple.ok();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            throw new UnsupportedOperationException();
        }
        this.eventuallyBuildPhantomGroups();
        CucaDiagramFileMaker maker = this.isUseElk() ? new CucaDiagramFileMakerElk(this, fileFormatOption.getDefaultStringBounder(this.getSkinParam())) : (this.isUseSmetana() ? new CucaDiagramFileMakerSmetana(this, fileFormatOption.getDefaultStringBounder(this.getSkinParam())) : new CucaDiagramFileMakerSvek(this));
        ImageData result = maker.createFile(os, this.getDotStrings(), fileFormatOption);
        if (result == null) {
            return ImageDataSimple.error();
        }
        this.warningOrError = result.getWarningOrError();
        return result;
    }

    @Override
    public String getWarningOrError() {
        String generalWarningOrError = super.getWarningOrError();
        if (this.warningOrError == null) {
            return generalWarningOrError;
        }
        if (generalWarningOrError == null) {
            return this.warningOrError;
        }
        return generalWarningOrError + "\n" + this.warningOrError;
    }

    private static boolean isNumber(String s) {
        return s.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String s;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(s = this.getPragma().getValue("labeldistance"))) {
            return s;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(s = this.getPragma().getValue("defaultlabeldistance"))) {
            return s;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String s;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(s = this.getPragma().getValue("labelangle"))) {
            return s;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(s = this.getPragma().getValue("defaultlabelangle"))) {
            return s;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(Entity entity) {
        return entity.isEmpty();
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean visibilityModifierPresent) {
        this.visibilityModifierPresent = visibilityModifierPresent;
    }

    @Override
    public final boolean showPortion(EntityPortion portion, Entity entity) {
        if (this.getSkinParam().strictUmlStyle() && portion == EntityPortion.CIRCLED_CHARACTER) {
            return false;
        }
        boolean result = true;
        for (EntityHideOrShow cmd : this.hideOrShows) {
            if (cmd.portion != portion || !cmd.gender.contains(entity)) continue;
            result = cmd.show;
        }
        return result;
    }

    @Override
    public List<String> getVisibleStereotypeLabels(Entity entity) {
        Stereotype stereotype = entity.getStereotype();
        if (stereotype == null) {
            return null;
        }
        ArrayList<EntityHideOrShow> commands = new ArrayList<EntityHideOrShow>();
        for (EntityHideOrShow hideOrShowEntry : this.hideOrShows) {
            if (hideOrShowEntry.portion != EntityPortion.STEREOTYPE) continue;
            commands.add(hideOrShowEntry);
        }
        ArrayList<String> visibleStereotypeLabels = new ArrayList<String>();
        for (String stereoTypeLabel : entity.getStereotype().getLabels(Guillemet.DOUBLE_COMPARATOR)) {
            if (!this.isHiddenStereotypeLabel(stereoTypeLabel, commands)) continue;
            visibleStereotypeLabels.add(stereoTypeLabel);
        }
        return visibleStereotypeLabels;
    }

    private boolean isHiddenStereotypeLabel(String stereoTypeLabel, List<EntityHideOrShow> commands) {
        for (EntityHideOrShow cmd : commands) {
            String gender = cmd.gender.getGender();
            if (gender == null || !gender.equals(stereoTypeLabel)) continue;
            return false;
        }
        return true;
    }

    public final void hideOrShow(EntityGender gender, EntityPortion portions, boolean show) {
        for (EntityPortion portion : portions.asSet()) {
            this.hideOrShows.add(new EntityHideOrShow(gender, portion, show));
        }
    }

    public void hideOrShow(Set<VisibilityModifier> visibilities, boolean show) {
        if (show) {
            this.hides.removeAll(visibilities);
        } else {
            this.hides.addAll(visibilities);
        }
    }

    public void hideOrShow2(String what, boolean show) {
        this.hides2.add(new HideOrShow(what, show));
    }

    public void removeOrRestore(String what, boolean show) {
        this.removed.add(new HideOrShow(what, show));
    }

    public final Set<VisibilityModifier> getHides() {
        return Collections.unmodifiableSet(this.hides);
    }

    public final boolean isStandalone(Entity ent) {
        for (Link link : this.getLinks()) {
            if (link.getEntity1() != ent && link.getEntity2() != ent) continue;
            return false;
        }
        return true;
    }

    public final boolean isStandaloneForArgo(Entity ent) {
        for (Link link : this.getLinks()) {
            if (link.isHidden() || link.isInvis() || link.getEntity1() != ent && link.getEntity2() != ent) continue;
            return false;
        }
        return true;
    }

    public final Link getLastLink() {
        Collection links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link link = (Link)links.get(i);
            if (link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            return link;
        }
        return null;
    }

    public final List<Link> getTwoLastLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        Collection links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link link = (Link)links.get(i);
            if (link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            result.add(link);
            if (result.size() != 2) continue;
            return Collections.unmodifiableList(result);
        }
        return null;
    }

    public final Entity getLastEntity() {
        return this.lastEntity;
    }

    @Override
    public final EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void applySingleStrategy() {
        MagmaList magmaList = new MagmaList();
        Collection<Entity> groups = this.getEntityFactory().groupsAndRoot();
        for (Entity g : groups) {
            ArrayList<Entity> standalones = new ArrayList<Entity>();
            for (Entity ent : g.leafs()) {
                if (!this.isStandalone(ent)) continue;
                standalones.add(ent);
            }
            if (standalones.size() < 3) continue;
            Magma magma = new Magma(this, standalones);
            magma.putInSquare();
            magmaList.add(magma);
        }
        for (Entity g : groups) {
            MagmaList magmas = magmaList.getMagmas(g);
            if (magmas.size() < 3) continue;
            magmas.putInSquare();
        }
    }

    @Override
    public boolean isHideEmptyDescriptionForState() {
        return false;
    }

    protected void incRawLayout() {
        this.entityFactory.incRawLayout();
    }

    public CommandExecutionResult constraintOnLinks(Link link1, Link link2, Display display) {
        LinkConstraint linkConstraint = new LinkConstraint(link1, link2, display);
        link1.setLinkConstraint(linkConstraint);
        link2.setLinkConstraint(linkConstraint);
        return CommandExecutionResult.ok();
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.topRightBottomLeft(0.0, 5.0, 5.0, 0.0);
    }

    @Override
    public int getUniqueSequence() {
        return this.cpt.addAndGet(1);
    }

    public String getUniqueSequence(String prefix) {
        return prefix + this.getUniqueSequence();
    }

    static class EntityHideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        public EntityHideOrShow(EntityGender gender, EntityPortion portion, boolean show) {
            this.gender = gender;
            this.portion = portion;
            this.show = show;
        }
    }
}

