/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.renderer;

import zext.plantuml.com.ctreber.acearth.renderer.RowTypeRenderer;
import zext.plantuml.com.ctreber.acearth.scanbit.ScanBit;

public class RowTypeRendererScanBit
implements RowTypeRenderer {
    private int fScanBitIndex;
    private ScanBit[] fScanBits;
    private final int[] fScanToPixelType = new int[256];

    @Override
    public void startNewRun() {
        this.fScanBitIndex = 0;
        this.generateScanToPixelTypeTable();
    }

    @Override
    public void getPixelTypes(int pRowNo, int[] pPixelTypes) {
        while (this.fScanBitIndex < this.fScanBits.length && this.fScanBits[this.fScanBitIndex].getY() == pRowNo) {
            int i = this.fScanBits[this.fScanBitIndex].getlXFrom();
            while (i <= this.fScanBits[this.fScanBitIndex].getXTo()) {
                int n = i++;
                pPixelTypes[n] = pPixelTypes[n] + this.fScanBits[this.fScanBitIndex].getType();
            }
            ++this.fScanBitIndex;
        }
        for (int lCol = 0; lCol < pPixelTypes.length; ++lCol) {
            pPixelTypes[lCol] = this.fScanToPixelType[pPixelTypes[lCol] & 0xFF];
        }
    }

    private void generateScanToPixelTypeTable() {
        for (int i = 0; i < 256; ++i) {
            this.fScanToPixelType[i] = i == 0 ? 0 : (i > 64 ? 1 : 2);
        }
    }

    public void setScanBits(ScanBit[] pScanBits) {
        this.fScanBits = pScanBits;
    }
}

