/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.scanbit;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import zext.plantuml.com.ctreber.acearth.projection.Projection;
import zext.plantuml.com.ctreber.acearth.scanbit.ScanBit;
import zext.plantuml.com.ctreber.acearth.scanbit.ScanBitGenerator;
import zext.plantuml.com.ctreber.acearth.scanbit.ScanBuf;
import zext.plantuml.com.ctreber.acearth.util.EdgeCrossing;
import zext.plantuml.com.ctreber.acearth.util.Point2D;
import zext.plantuml.com.ctreber.acearth.util.Point3D;
import zext.plantuml.com.ctreber.acearth.util.Polygon;
import zext.plantuml.com.ctreber.aclib.sort.CTSort;
import zext.plantuml.com.ctreber.aclib.sort.QuickSort;

public abstract class BitGeneratorMap
extends ScanBitGenerator {
    public static final int PixTypeSpace = 0;
    public static final int PixTypeLand = 1;
    public static final int PixTypeWater = 2;
    public static final int PixTypeStar = 3;
    public static final int PixTypeGridLand = 4;
    public static final int PixTypeGridWater = 5;
    private Polygon[] fMapData;
    Projection fProjection;
    private List fScanbitsVector = new ArrayList();
    List fEdgeCrossings;

    protected abstract ScanBuf scanOutline();

    protected abstract void handleCrossings(ScanBuf var1, EdgeCrossing[] var2);

    protected abstract Comparator getEdgeXingComparator();

    protected abstract void scanPolygon(ScanBuf var1, Point3D[] var2, Point2D[] var3, int var4);

    public BitGeneratorMap(Projection pProjection) {
        this.fProjection = pProjection;
    }

    @Override
    public void generateScanBits() {
        this.fScanbitsVector = new ArrayList();
        this.fProjection.setImageWidth(this.fImageWidth);
        this.fProjection.setImageHeight(this.fImageHeight);
        this.fProjection.initTransformTable();
        ScanBuf lScanBuf = this.scanOutline();
        this.fScanbitsVector.addAll(lScanBuf.getScanbits(64));
        this.scanPolygons();
        QuickSort lSort = new QuickSort();
        this.fScanBitsArray = this.fScanbitsVector.toArray(new ScanBit[0]);
        lSort.sort(this.fScanBitsArray);
    }

    private void scanPolygons() {
        for (int lPolyNo = 0; lPolyNo < this.fMapData.length; ++lPolyNo) {
            Polygon lPolygon = this.fMapData[lPolyNo];
            Point3D[] lPoints3D = new Point3D[lPolygon.getSize()];
            Point2D[] lPoints2D = new Point2D[lPolygon.getSize()];
            this.transformPolygonPoints(lPolygon, lPoints3D, lPoints2D);
            this.fEdgeCrossings = new ArrayList();
            ScanBuf lScanBuf = new ScanBuf(this.fImageHeight, this.fImageWidth);
            for (int i = 0; i < lPoints2D.length; ++i) {
                this.scanPolygon(lScanBuf, lPoints3D, lPoints2D, i);
            }
            if (this.fEdgeCrossings.size() > 0) {
                Object[] xings = this.fEdgeCrossings.toArray(new EdgeCrossing[0]);
                QuickSort lSort = new QuickSort();
                ((CTSort)lSort).sort(xings, this.getEdgeXingComparator());
                this.handleCrossings(lScanBuf, (EdgeCrossing[])xings);
            }
            if (!lScanBuf.containsPoints()) continue;
            this.fScanbitsVector.addAll(lScanBuf.getScanbits(lPolygon.getType()));
        }
    }

    private void transformPolygonPoints(Polygon pPolygon, Point3D[] pPoints3D, Point2D[] pPoints2D) {
        for (int i = 0; i < pPolygon.getPoints().length; ++i) {
            Point3D lPointRotated;
            Point3D lPoint = pPolygon.getPoints()[i];
            pPoints3D[i] = lPointRotated = this.fProjection.rotate(lPoint);
            pPoints2D[i] = this.fProjection.project2D(lPointRotated);
        }
    }

    public void setMapData(Polygon[] pMapData) {
        this.fMapData = pMapData;
    }

    protected void addEdgeXing(EdgeCrossing pEdgeXing) {
        this.fEdgeCrossings.add(pEdgeXing);
    }
}

