/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public final class NullReferenceExpression
extends Expression {
    private static final String NULL_TEXT = "null";
    private TextLocation _startLocation;
    private TextLocation _endLocation;

    public NullReferenceExpression() {
        this(-34, TextLocation.EMPTY);
    }

    public NullReferenceExpression(int offset) {
        this(offset, TextLocation.EMPTY);
    }

    public NullReferenceExpression(TextLocation startLocation) {
        super(-34);
        this._startLocation = VerifyArgument.notNull(startLocation, "startLocation");
        this._endLocation = new TextLocation(startLocation.line(), startLocation.column() + NULL_TEXT.length());
    }

    public NullReferenceExpression(int offset, TextLocation startLocation) {
        super(offset);
        this._startLocation = VerifyArgument.notNull(startLocation, "startLocation");
        this._endLocation = new TextLocation(startLocation.line(), startLocation.column() + NULL_TEXT.length());
    }

    @Override
    public TextLocation getStartLocation() {
        return this._startLocation;
    }

    @Override
    public TextLocation getEndLocation() {
        return this._endLocation;
    }

    public void setStartLocation(TextLocation startLocation) {
        this._startLocation = VerifyArgument.notNull(startLocation, "startLocation");
        this._endLocation = new TextLocation(startLocation.line(), startLocation.column() + NULL_TEXT.length());
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitNullReferenceExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof NullReferenceExpression;
    }
}

