from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.IFSelect import *
from OCC.Core.Interface import *
from OCC.Core.TCollection import *
from OCC.Core.StepData import *
from OCC.Core.HeaderSection import *


class APIHeaderSection_EditHeader(IFSelect_Editor):
    def __init__(self) -> None: ...
    def Apply(self, form: IFSelect_EditForm, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
    def Label(self) -> str: ...
    def Load(self, form: IFSelect_EditForm, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
    def Recognize(self, form: IFSelect_EditForm) -> bool: ...
    def StringValue(self, form: IFSelect_EditForm, num: int) -> TCollection_HAsciiString: ...

class APIHeaderSection_MakeHeader:
    @overload
    def __init__(self, shapetype: Optional[int] = 0) -> None: ...
    @overload
    def __init__(self, model: StepData_StepModel) -> None: ...
    def AddSchemaIdentifier(self, aSchemaIdentifier: TCollection_HAsciiString) -> None: ...
    def Apply(self, model: StepData_StepModel) -> None: ...
    def Author(self) -> Interface_HArray1OfHAsciiString: ...
    def AuthorValue(self, num: int) -> TCollection_HAsciiString: ...
    def Authorisation(self) -> TCollection_HAsciiString: ...
    def Description(self) -> Interface_HArray1OfHAsciiString: ...
    def DescriptionValue(self, num: int) -> TCollection_HAsciiString: ...
    def FdValue(self) -> HeaderSection_FileDescription: ...
    def FnValue(self) -> HeaderSection_FileName: ...
    def FsValue(self) -> HeaderSection_FileSchema: ...
    def HasFd(self) -> bool: ...
    def HasFn(self) -> bool: ...
    def HasFs(self) -> bool: ...
    def ImplementationLevel(self) -> TCollection_HAsciiString: ...
    def Init(self, nameval: str) -> None: ...
    def IsDone(self) -> bool: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def NbAuthor(self) -> int: ...
    def NbDescription(self) -> int: ...
    def NbOrganization(self) -> int: ...
    def NbSchemaIdentifiers(self) -> int: ...
    def NewModel(self, protocol: Interface_Protocol) -> StepData_StepModel: ...
    def Organization(self) -> Interface_HArray1OfHAsciiString: ...
    def OrganizationValue(self, num: int) -> TCollection_HAsciiString: ...
    def OriginatingSystem(self) -> TCollection_HAsciiString: ...
    def PreprocessorVersion(self) -> TCollection_HAsciiString: ...
    def SchemaIdentifiers(self) -> Interface_HArray1OfHAsciiString: ...
    def SchemaIdentifiersValue(self, num: int) -> TCollection_HAsciiString: ...
    def SetAuthor(self, aAuthor: Interface_HArray1OfHAsciiString) -> None: ...
    def SetAuthorValue(self, num: int, aAuthor: TCollection_HAsciiString) -> None: ...
    def SetAuthorisation(self, aAuthorisation: TCollection_HAsciiString) -> None: ...
    def SetDescription(self, aDescription: Interface_HArray1OfHAsciiString) -> None: ...
    def SetDescriptionValue(self, num: int, aDescription: TCollection_HAsciiString) -> None: ...
    def SetImplementationLevel(self, aImplementationLevel: TCollection_HAsciiString) -> None: ...
    def SetName(self, aName: TCollection_HAsciiString) -> None: ...
    def SetOrganization(self, aOrganization: Interface_HArray1OfHAsciiString) -> None: ...
    def SetOrganizationValue(self, num: int, aOrganization: TCollection_HAsciiString) -> None: ...
    def SetOriginatingSystem(self, aOriginatingSystem: TCollection_HAsciiString) -> None: ...
    def SetPreprocessorVersion(self, aPreprocessorVersion: TCollection_HAsciiString) -> None: ...
    def SetSchemaIdentifiers(self, aSchemaIdentifiers: Interface_HArray1OfHAsciiString) -> None: ...
    def SetSchemaIdentifiersValue(self, num: int, aSchemaIdentifier: TCollection_HAsciiString) -> None: ...
    def SetTimeStamp(self, aTimeStamp: TCollection_HAsciiString) -> None: ...
    def TimeStamp(self) -> TCollection_HAsciiString: ...

# harray1 classes
# harray2 classes
# hsequence classes

