# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
ShapeUpgrade module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_shapeupgrade.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ShapeUpgrade
else:
    import _ShapeUpgrade

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ShapeUpgrade.delete_SwigPyIterator

    def value(self):
        return _ShapeUpgrade.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _ShapeUpgrade.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _ShapeUpgrade.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _ShapeUpgrade.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _ShapeUpgrade.SwigPyIterator_equal(self, x)

    def copy(self):
        return _ShapeUpgrade.SwigPyIterator_copy(self)

    def next(self):
        return _ShapeUpgrade.SwigPyIterator_next(self)

    def __next__(self):
        return _ShapeUpgrade.SwigPyIterator___next__(self)

    def previous(self):
        return _ShapeUpgrade.SwigPyIterator_previous(self)

    def advance(self, n):
        return _ShapeUpgrade.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _ShapeUpgrade.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _ShapeUpgrade.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _ShapeUpgrade.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _ShapeUpgrade.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _ShapeUpgrade.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _ShapeUpgrade.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _ShapeUpgrade:
_ShapeUpgrade.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _ShapeUpgrade.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TColGeom
import OCC.Core.Geom2d
import OCC.Core.TColGeom2d
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.ShapeBuild
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.TopTools
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.ShapeExtend
import OCC.Core.ShapeAnalysis
import OCC.Core.Adaptor3d
import OCC.Core.Adaptor2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.IntRes2d

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_ShapeUpgrade_RemoveLocations_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_RemoveLocations_Create()

def Handle_ShapeUpgrade_RemoveLocations_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_RemoveLocations_DownCast(t)

def Handle_ShapeUpgrade_RemoveLocations_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_RemoveLocations_IsNull(t)

def Handle_ShapeUpgrade_SplitCurve_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve_Create()

def Handle_ShapeUpgrade_SplitCurve_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve_DownCast(t)

def Handle_ShapeUpgrade_SplitCurve_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve_IsNull(t)

def Handle_ShapeUpgrade_SplitSurface_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurface_Create()

def Handle_ShapeUpgrade_SplitSurface_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurface_DownCast(t)

def Handle_ShapeUpgrade_SplitSurface_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurface_IsNull(t)

def Handle_ShapeUpgrade_Tool_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_Tool_Create()

def Handle_ShapeUpgrade_Tool_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_Tool_DownCast(t)

def Handle_ShapeUpgrade_Tool_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_Tool_IsNull(t)

def Handle_ShapeUpgrade_UnifySameDomain_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_UnifySameDomain_Create()

def Handle_ShapeUpgrade_UnifySameDomain_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_UnifySameDomain_DownCast(t)

def Handle_ShapeUpgrade_UnifySameDomain_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_UnifySameDomain_IsNull(t)

def Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_Create()

def Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_DownCast(t)

def Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_IsNull(t)

def Handle_ShapeUpgrade_EdgeDivide_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_EdgeDivide_Create()

def Handle_ShapeUpgrade_EdgeDivide_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_EdgeDivide_DownCast(t)

def Handle_ShapeUpgrade_EdgeDivide_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_EdgeDivide_IsNull(t)

def Handle_ShapeUpgrade_FaceDivide_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_FaceDivide_Create()

def Handle_ShapeUpgrade_FaceDivide_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FaceDivide_DownCast(t)

def Handle_ShapeUpgrade_FaceDivide_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FaceDivide_IsNull(t)

def Handle_ShapeUpgrade_FixSmallCurves_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_FixSmallCurves_Create()

def Handle_ShapeUpgrade_FixSmallCurves_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FixSmallCurves_DownCast(t)

def Handle_ShapeUpgrade_FixSmallCurves_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FixSmallCurves_IsNull(t)

def Handle_ShapeUpgrade_RemoveInternalWires_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_RemoveInternalWires_Create()

def Handle_ShapeUpgrade_RemoveInternalWires_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_RemoveInternalWires_DownCast(t)

def Handle_ShapeUpgrade_RemoveInternalWires_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_RemoveInternalWires_IsNull(t)

def Handle_ShapeUpgrade_SplitCurve2d_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve2d_Create()

def Handle_ShapeUpgrade_SplitCurve2d_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve2d_DownCast(t)

def Handle_ShapeUpgrade_SplitCurve2d_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve2d_IsNull(t)

def Handle_ShapeUpgrade_SplitCurve3d_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve3d_Create()

def Handle_ShapeUpgrade_SplitCurve3d_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve3d_DownCast(t)

def Handle_ShapeUpgrade_SplitCurve3d_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve3d_IsNull(t)

def Handle_ShapeUpgrade_SplitSurfaceAngle_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceAngle_Create()

def Handle_ShapeUpgrade_SplitSurfaceAngle_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceAngle_DownCast(t)

def Handle_ShapeUpgrade_SplitSurfaceAngle_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceAngle_IsNull(t)

def Handle_ShapeUpgrade_SplitSurfaceArea_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceArea_Create()

def Handle_ShapeUpgrade_SplitSurfaceArea_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceArea_DownCast(t)

def Handle_ShapeUpgrade_SplitSurfaceArea_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceArea_IsNull(t)

def Handle_ShapeUpgrade_SplitSurfaceContinuity_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceContinuity_Create()

def Handle_ShapeUpgrade_SplitSurfaceContinuity_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceContinuity_DownCast(t)

def Handle_ShapeUpgrade_SplitSurfaceContinuity_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitSurfaceContinuity_IsNull(t)

def Handle_ShapeUpgrade_WireDivide_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_WireDivide_Create()

def Handle_ShapeUpgrade_WireDivide_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_WireDivide_DownCast(t)

def Handle_ShapeUpgrade_WireDivide_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_WireDivide_IsNull(t)

def Handle_ShapeUpgrade_ClosedEdgeDivide_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_ClosedEdgeDivide_Create()

def Handle_ShapeUpgrade_ClosedEdgeDivide_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ClosedEdgeDivide_DownCast(t)

def Handle_ShapeUpgrade_ClosedEdgeDivide_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ClosedEdgeDivide_IsNull(t)

def Handle_ShapeUpgrade_ClosedFaceDivide_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_ClosedFaceDivide_Create()

def Handle_ShapeUpgrade_ClosedFaceDivide_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ClosedFaceDivide_DownCast(t)

def Handle_ShapeUpgrade_ClosedFaceDivide_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ClosedFaceDivide_IsNull(t)

def Handle_ShapeUpgrade_ConvertCurve2dToBezier_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertCurve2dToBezier_Create()

def Handle_ShapeUpgrade_ConvertCurve2dToBezier_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertCurve2dToBezier_DownCast(t)

def Handle_ShapeUpgrade_ConvertCurve2dToBezier_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertCurve2dToBezier_IsNull(t)

def Handle_ShapeUpgrade_ConvertCurve3dToBezier_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertCurve3dToBezier_Create()

def Handle_ShapeUpgrade_ConvertCurve3dToBezier_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertCurve3dToBezier_DownCast(t)

def Handle_ShapeUpgrade_ConvertCurve3dToBezier_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_ConvertCurve3dToBezier_IsNull(t)

def Handle_ShapeUpgrade_FaceDivideArea_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_FaceDivideArea_Create()

def Handle_ShapeUpgrade_FaceDivideArea_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FaceDivideArea_DownCast(t)

def Handle_ShapeUpgrade_FaceDivideArea_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FaceDivideArea_IsNull(t)

def Handle_ShapeUpgrade_FixSmallBezierCurves_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_FixSmallBezierCurves_Create()

def Handle_ShapeUpgrade_FixSmallBezierCurves_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FixSmallBezierCurves_DownCast(t)

def Handle_ShapeUpgrade_FixSmallBezierCurves_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_FixSmallBezierCurves_IsNull(t)

def Handle_ShapeUpgrade_SplitCurve2dContinuity_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve2dContinuity_Create()

def Handle_ShapeUpgrade_SplitCurve2dContinuity_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve2dContinuity_DownCast(t)

def Handle_ShapeUpgrade_SplitCurve2dContinuity_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve2dContinuity_IsNull(t)

def Handle_ShapeUpgrade_SplitCurve3dContinuity_Create():
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve3dContinuity_Create()

def Handle_ShapeUpgrade_SplitCurve3dContinuity_DownCast(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve3dContinuity_DownCast(t)

def Handle_ShapeUpgrade_SplitCurve3dContinuity_IsNull(t):
    return _ShapeUpgrade.Handle_ShapeUpgrade_SplitCurve3dContinuity_IsNull(t)
class shapeupgrade(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def C0BSplineToSequenceOfC1BSplineCurve(*args):
        r"""

        Parameters
        ----------
        BS: Geom_BSplineCurve
        seqBS: TColGeom_HSequenceOfBoundedCurve

        Return
        -------
        bool

        Description
        -----------
        Unifies same domain faces and edges of specified shape.

        Parameters
        ----------
        BS: Geom2d_BSplineCurve
        seqBS: TColGeom2d_HSequenceOfBoundedCurve

        Return
        -------
        bool

        Description
        -----------
        Converts c0 b-spline curve into sequence of c1 b-spline curves. this method splits b-spline at the knots with multiplicities equal to degree, i.e. unlike method geomconvert::c0bsplinetoarrayofc1bsplinecurve this one does not use any tolerance and therefore does not change the geometry of b-spline. returns true if c0 b-spline was successfully split, else returns false (if bs is c1 b-spline).

        """
        return _ShapeUpgrade.shapeupgrade_C0BSplineToSequenceOfC1BSplineCurve(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeUpgrade.shapeupgrade_swiginit(self, _ShapeUpgrade.new_shapeupgrade())
    __swig_destroy__ = _ShapeUpgrade.delete_shapeupgrade

# Register shapeupgrade in _ShapeUpgrade:
_ShapeUpgrade.shapeupgrade_swigregister(shapeupgrade)
class ShapeUpgrade_RemoveLocations(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_RemoveLocations_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_RemoveLocations(*args))

    def GetResult(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns shape with removed locations.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveLocations_GetResult(self, *args)

    def ModifiedShape(self, *args):
        r"""

        Parameters
        ----------
        theInitShape: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns modified shape obtained from initial shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveLocations_ModifiedShape(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Removes all location correspodingly to removelevel.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveLocations_Remove(self, *args)

    def RemoveLevel(self, *args):
        r"""
        Return
        -------
        TopAbs_ShapeEnum

        Description
        -----------
        Sets level starting with that location will be removed.value of level can be set to topabs_shape,topabs_compound,topabs_solid,topabs_shell,topabs_face.by default topabs_shape. in this case location will be removed for all shape types for exception of compound.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveLocations_RemoveLevel(self, *args)

    def SetRemoveLevel(self, *args):
        r"""

        Parameters
        ----------
        theLevel: TopAbs_ShapeEnum

        Return
        -------
        None

        Description
        -----------
        Sets level starting with that location will be removed, by default topabs_shape. in this case locations will be kept for specified shape and if specified shape is topabs_compound for sub-shapes of first level.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveLocations_SetRemoveLevel(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_RemoveLocations_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_RemoveLocations

# Register ShapeUpgrade_RemoveLocations in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_RemoveLocations_swigregister(ShapeUpgrade_RemoveLocations)
class ShapeUpgrade_ShapeDivide(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialize by a shape.

        """
        _ShapeUpgrade.ShapeUpgrade_ShapeDivide_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShapeDivide(*args))

    def GetContext(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeBuild_ReShape>

        Description
        -----------
        Returns context with all the modifications made during last call(s) to perform() recorded.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_GetContext(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialize by a shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_Init(self, *args)

    def MsgRegistrator(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeExtend_BasicMsgRegistrator>

        Description
        -----------
        Returns message registrator.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_MsgRegistrator(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        newContext: bool (optional, default to Standard_True)

        Return
        -------
        bool

        Description
        -----------
        Performs splitting and computes the resulting shape if newcontext is true (default), the internal context will be cleared at start, else previous substitutions will be acting.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_Perform(self, *args)

    def Result(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Gives the resulting shape, or null shape if not done.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_Result(self, *args)

    def SendMsg(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        message: Message_Msg
        gravity: Message_Gravity (optional, default to Message_Info)

        Return
        -------
        None

        Description
        -----------
        Sends a message to be attached to the shape. calls corresponding message of message registrator.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SendMsg(self, *args)

    def SetContext(self, *args):
        r"""

        Parameters
        ----------
        context: ShapeBuild_ReShape

        Return
        -------
        None

        Description
        -----------
        Sets context with recorded modifications to be applied during next call(s) to perform(shape,standard_false).

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetContext(self, *args)

    def SetEdgeMode(self, *args):
        r"""

        Parameters
        ----------
        aEdgeMode: int

        Return
        -------
        None

        Description
        -----------
        Sets mode for splitting 3d curves from edges. 0 - only curve 3d from free edges. 1 - only curve 3d from shared edges. 2 - all curve 3d.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetEdgeMode(self, *args)

    def SetMaxTolerance(self, *args):
        r"""

        Parameters
        ----------
        maxtol: float

        Return
        -------
        None

        Description
        -----------
        Sets maximal allowed tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetMaxTolerance(self, *args)

    def SetMinTolerance(self, *args):
        r"""

        Parameters
        ----------
        mintol: float

        Return
        -------
        None

        Description
        -----------
        Sets minimal allowed tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetMinTolerance(self, *args)

    def SetMsgRegistrator(self, *args):
        r"""

        Parameters
        ----------
        msgreg: ShapeExtend_BasicMsgRegistrator

        Return
        -------
        None

        Description
        -----------
        Sets message registrator.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetMsgRegistrator(self, *args)

    def SetPrecision(self, *args):
        r"""

        Parameters
        ----------
        Prec: float

        Return
        -------
        None

        Description
        -----------
        Defines the spatial precision used for splitting.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetPrecision(self, *args)

    def SetSplitFaceTool(self, *args):
        r"""

        Parameters
        ----------
        splitFaceTool: ShapeUpgrade_FaceDivide

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting faces.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetSplitFaceTool(self, *args)

    def SetSurfaceSegmentMode(self, *args):
        r"""

        Parameters
        ----------
        Segment: bool

        Return
        -------
        None

        Description
        -----------
        Purpose sets mode for trimming (segment) surface by wire uv bounds.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_SetSurfaceSegmentMode(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Queries the status of last call to perform ok: no splitting was done (or no call to perform) done1: some edges were split done2: surface was split fail1: some errors occurred.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivide_Status(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShapeDivide

# Register ShapeUpgrade_ShapeDivide in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShapeDivide_swigregister(ShapeUpgrade_ShapeDivide)
class ShapeUpgrade_ShellSewing(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a shellsewing, empty.

        """
        _ShapeUpgrade.ShapeUpgrade_ShellSewing_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShellSewing(*args))

    def ApplySewing(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        tol: float (optional, default to 0.0)

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Builds a new shape from a former one, by calling sewing from brepbuilderapi. rebuilt solids are oriented to be 'not infinite' //! if <tol> is not given (i.e. value 0. by default), it is computed as the mean tolerance recorded in <shape> //! if no shell has been sewed, this method returns the input shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShellSewing_ApplySewing(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShellSewing

# Register ShapeUpgrade_ShellSewing in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShellSewing_swigregister(ShapeUpgrade_ShellSewing)
class ShapeUpgrade_SplitCurve(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitCurve_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitCurve(*args))

    def Build(self, *args):
        r"""

        Parameters
        ----------
        Segment: bool

        Return
        -------
        None

        Description
        -----------
        If segment is true, the result is composed with segments of the curve bounded by the splitvalues. if segment is false, the result is composed with trimmed curves all based on the same complete curve.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve_Build(self, *args)

    def Compute(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Calculates points for correction/splitting of the curve.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve_Compute(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        First: float
        Last: float

        Return
        -------
        None

        Description
        -----------
        Initializes with curve first and last parameters.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve_Init(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Segment: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Performs correction/splitting of the curve. first defines splitting values by method compute(), then calls method build().

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve_Perform(self, *args)

    def SetSplitValues(self, *args):
        r"""

        Parameters
        ----------
        SplitValues: TColStd_HSequenceOfReal

        Return
        -------
        None

        Description
        -----------
        Sets the parameters where splitting has to be done.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve_SetSplitValues(self, *args)

    def SplitValues(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfReal>

        Description
        -----------
        Returns all the splitting values including the first and last parameters of the input curve merges input split values and new ones into myglobalknots.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve_SplitValues(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Returns the status ok - no splitting is needed done1 - splitting required and gives more than one segment done2 - splitting is required, but gives only one segment (initial) done3 - geometric form of the curve or parametrisation is modified.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitCurve

# Register ShapeUpgrade_SplitCurve in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitCurve_swigregister(ShapeUpgrade_SplitCurve)
class ShapeUpgrade_SplitSurface(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitSurface_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitSurface(*args))

    def Build(self, *args):
        r"""

        Parameters
        ----------
        Segment: bool

        Return
        -------
        None

        Description
        -----------
        Performs splitting of the supporting surface. if resulting surface is b-spline and segment is true, the result is composed with segments of the surface bounded by the u and v splitvalues (method geom_bsplinesurface::segment is used). if segment is false, the result is composed with geom_rectangulartrimmedsurface all based on the same complete surface. fields mynbresultingrow and mynbresultingcol must be set to specify the size of resulting grid of surfaces.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_Build(self, *args)

    def Compute(self, *args):
        r"""

        Parameters
        ----------
        Segment: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Calculates points for correction/splitting of the surface.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_Compute(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        Initializes with single supporting surface.

        Parameters
        ----------
        S: Geom_Surface
        UFirst: float
        ULast: float
        VFirst: float
        VLast: float
        theArea: float (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Initializes with single supporting surface with bounding parameters.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_Init(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Segment: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Performs correction/splitting of the surface. first defines splitting values by method compute(), then calls method build().

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_Perform(self, *args)

    def ResSurfaces(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeExtend_CompositeSurface>

        Description
        -----------
        Returns obtained surfaces after splitting as compositesurface.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_ResSurfaces(self, *args)

    def SetUSplitValues(self, *args):
        r"""

        Parameters
        ----------
        UValues: TColStd_HSequenceOfReal

        Return
        -------
        None

        Description
        -----------
        Sets u parameters where splitting has to be done.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_SetUSplitValues(self, *args)

    def SetVSplitValues(self, *args):
        r"""

        Parameters
        ----------
        VValues: TColStd_HSequenceOfReal

        Return
        -------
        None

        Description
        -----------
        Sets v parameters where splitting has to be done.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_SetVSplitValues(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Returns the status ok - no splitting is needed done1 - splitting required and gives more than one patch done2 - splitting is required, but gives only single patch (initial) done3 - geometric form of the surface or parametrisation is modified.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_Status(self, *args)

    def USplitValues(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfReal>

        Description
        -----------
        Returns all the u splitting values including the first and last parameters of the input surface.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_USplitValues(self, *args)

    def VSplitValues(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfReal>

        Description
        -----------
        Returns all the splitting v values including the first and last parameters of the input surface.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurface_VSplitValues(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitSurface

# Register ShapeUpgrade_SplitSurface in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitSurface_swigregister(ShapeUpgrade_SplitSurface)
class ShapeUpgrade_Tool(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_Tool_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_Tool(*args))

    def Context(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeBuild_ReShape>

        Description
        -----------
        Returns context.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_Context(self, *args)

    def LimitTolerance(self, *args):
        r"""

        Parameters
        ----------
        toler: float

        Return
        -------
        float

        Description
        -----------
        Returns tolerance limited by [mymintol,mymaxtol].

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_LimitTolerance(self, *args)

    def MaxTolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns maximal allowed tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_MaxTolerance(self, *args)

    def MinTolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns minimal allowed tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_MinTolerance(self, *args)

    def Precision(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns basic precision value.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_Precision(self, *args)

    def Set(self, *args):
        r"""

        Parameters
        ----------
        tool: ShapeUpgrade_Tool

        Return
        -------
        None

        Description
        -----------
        Copy all fields from another root object.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_Set(self, *args)

    def SetContext(self, *args):
        r"""

        Parameters
        ----------
        context: ShapeBuild_ReShape

        Return
        -------
        None

        Description
        -----------
        Sets context.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_SetContext(self, *args)

    def SetMaxTolerance(self, *args):
        r"""

        Parameters
        ----------
        maxtol: float

        Return
        -------
        None

        Description
        -----------
        Sets maximal allowed tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_SetMaxTolerance(self, *args)

    def SetMinTolerance(self, *args):
        r"""

        Parameters
        ----------
        mintol: float

        Return
        -------
        None

        Description
        -----------
        Sets minimal allowed tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_SetMinTolerance(self, *args)

    def SetPrecision(self, *args):
        r"""

        Parameters
        ----------
        preci: float

        Return
        -------
        None

        Description
        -----------
        Sets basic precision value.

        """
        return _ShapeUpgrade.ShapeUpgrade_Tool_SetPrecision(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_Tool_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_Tool

# Register ShapeUpgrade_Tool in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_Tool_swigregister(ShapeUpgrade_Tool)
class ShapeUpgrade_UnifySameDomain(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        aShape: TopoDS_Shape
        UnifyEdges: bool (optional, default to Standard_True)
        UnifyFaces: bool (optional, default to Standard_True)
        ConcatBSplines: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructor defining input shape and necessary flags. it does not perform unification.

        """
        _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_UnifySameDomain(*args))

    def AllowInternalEdges(self, *args):
        r"""

        Parameters
        ----------
        theValue: bool

        Return
        -------
        None

        Description
        -----------
        Sets the flag defining whether it is allowed to create internal edges inside merged faces in the case of non-manifold topology. without this flag merging through multi connected edge is forbidden. default value is false.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_AllowInternalEdges(self, *args)

    def Build(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Performs unification and builds the resulting shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_Build(self, *args)

    def History(self, *args):
        r"""
        Return
        -------
        opencascade::handle<BRepTools_History>

        Description
        -----------
        Returns the history of the processed shapes.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_History(self, *args)

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        aShape: TopoDS_Shape
        UnifyEdges: bool (optional, default to Standard_True)
        UnifyFaces: bool (optional, default to Standard_True)
        ConcatBSplines: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes with a shape and necessary flags. it does not perform unification. if you intend to nullify the history place holder do it after initialization.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_Initialize(self, *args)

    def KeepShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets the shape for avoid merging of the faces/edges. this shape can be vertex or edge. if the shape is a vertex it forbids merging of connected edges. if the shape is a edge it forbids merging of connected faces. this method can be called several times to keep several shapes.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_KeepShape(self, *args)

    def KeepShapes(self, *args):
        r"""

        Parameters
        ----------
        theShapes: TopTools_MapOfShape

        Return
        -------
        None

        Description
        -----------
        Sets the map of shapes for avoid merging of the faces/edges. it allows passing a ready to use map instead of calling many times the method keepshape.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_KeepShapes(self, *args)

    def SetAngularTolerance(self, *args):
        r"""

        Parameters
        ----------
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Sets the angular tolerance. if two shapes form a connection angle greater than this value they will not be merged. default value is precision::angular().

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_SetAngularTolerance(self, *args)

    def SetLinearTolerance(self, *args):
        r"""

        Parameters
        ----------
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Sets the linear tolerance. it plays the role of chord error when taking decision about merging of shapes. default value is precision::confusion().

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_SetLinearTolerance(self, *args)

    def SetSafeInputMode(self, *args):
        r"""

        Parameters
        ----------
        theValue: bool

        Return
        -------
        None

        Description
        -----------
        Sets the flag defining the behavior of the algorithm regarding modification of input shape. if this flag is equal to true then the input (original) shape can't be modified during modification process. default value is true.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_SetSafeInputMode(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Gives the resulting shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_UnifySameDomain_Shape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_UnifySameDomain_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_UnifySameDomain

# Register ShapeUpgrade_UnifySameDomain in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_UnifySameDomain_swigregister(ShapeUpgrade_UnifySameDomain)
class ShapeUpgrade_ConvertSurfaceToBezierBasis(ShapeUpgrade_SplitSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ConvertSurfaceToBezierBasis(*args))

    def GetBSplineMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_bsplinesurface conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_GetBSplineMode(self, *args)

    def GetExtrusionMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_surfaceoflinearextrusion conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_GetExtrusionMode(self, *args)

    def GetPlaneMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_pline conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_GetPlaneMode(self, *args)

    def GetRevolutionMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_surfaceofrevolution conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_GetRevolutionMode(self, *args)

    def Segments(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeExtend_CompositeSurface>

        Description
        -----------
        Returns the grid of bezier based surfaces correspondent to original surface.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_Segments(self, *args)

    def SetBSplineMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_bsplinesurface to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_SetBSplineMode(self, *args)

    def SetExtrusionMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_surfaceoflinearextrusion to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_SetExtrusionMode(self, *args)

    def SetPlaneMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_plane to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_SetPlaneMode(self, *args)

    def SetRevolutionMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_surfaceofrevolution to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_SetRevolutionMode(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ConvertSurfaceToBezierBasis

# Register ShapeUpgrade_ConvertSurfaceToBezierBasis in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ConvertSurfaceToBezierBasis_swigregister(ShapeUpgrade_ConvertSurfaceToBezierBasis)
class ShapeUpgrade_EdgeDivide(ShapeUpgrade_Tool):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_EdgeDivide_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_EdgeDivide(*args))

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_Clear(self, *args)

    def Compute(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_Compute(self, *args)

    def GetSplitCurve2dTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeUpgrade_SplitCurve2d>

        Description
        -----------
        Returns the tool for splitting pcurves.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_GetSplitCurve2dTool(self, *args)

    def GetSplitCurve3dTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeUpgrade_SplitCurve3d>

        Description
        -----------
        Returns the tool for splitting 3d curves.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_GetSplitCurve3dTool(self, *args)

    def HasCurve2d(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_HasCurve2d(self, *args)

    def HasCurve3d(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_HasCurve3d(self, *args)

    def Knots2d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfReal>

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_Knots2d(self, *args)

    def Knots3d(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfReal>

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_Knots3d(self, *args)

    def SetFace(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Sets supporting surface by face.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_SetFace(self, *args)

    def SetSplitCurve2dTool(self, *args):
        r"""

        Parameters
        ----------
        splitCurve2dTool: ShapeUpgrade_SplitCurve2d

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting pcurves.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_SetSplitCurve2dTool(self, *args)

    def SetSplitCurve3dTool(self, *args):
        r"""

        Parameters
        ----------
        splitCurve3dTool: ShapeUpgrade_SplitCurve3d

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting 3d curves.

        """
        return _ShapeUpgrade.ShapeUpgrade_EdgeDivide_SetSplitCurve3dTool(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_EdgeDivide_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_EdgeDivide

# Register ShapeUpgrade_EdgeDivide in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_EdgeDivide_swigregister(ShapeUpgrade_EdgeDivide)
class ShapeUpgrade_FaceDivide(ShapeUpgrade_Tool):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates empty constructor.

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initialize by a face.

        """
        _ShapeUpgrade.ShapeUpgrade_FaceDivide_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_FaceDivide(*args))

    def GetSplitSurfaceTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeUpgrade_SplitSurface>

        Description
        -----------
        Returns the tool for splitting surfaces. this tool must be already initialized.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_GetSplitSurfaceTool(self, *args)

    def GetWireDivideTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeUpgrade_WireDivide>

        Description
        -----------
        Returns the tool for dividing edges on face. this tool must be already initialized.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_GetWireDivideTool(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initialize by a face.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_Init(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theArea: float (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Performs splitting and computes the resulting shell the context is used to keep track of former splittings in order to keep sharings. it is updated according to modifications made. the optional argument <thearea> is used to initialize the tool for splitting surface in the case of splitting into n parts where n is user-defined.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_Perform(self, *args)

    def Result(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Gives the resulting shell, or face, or null shape if not done.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_Result(self, *args)

    def SetSplitSurfaceTool(self, *args):
        r"""

        Parameters
        ----------
        splitSurfaceTool: ShapeUpgrade_SplitSurface

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting surfaces.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_SetSplitSurfaceTool(self, *args)

    def SetSurfaceSegmentMode(self, *args):
        r"""

        Parameters
        ----------
        Segment: bool

        Return
        -------
        None

        Description
        -----------
        Purpose sets mode for trimming (segment) surface by wire uv bounds.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_SetSurfaceSegmentMode(self, *args)

    def SetWireDivideTool(self, *args):
        r"""

        Parameters
        ----------
        wireDivideTool: ShapeUpgrade_WireDivide

        Return
        -------
        None

        Description
        -----------
        Sets the tool for dividing edges on face.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_SetWireDivideTool(self, *args)

    def SplitCurves(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Performs splitting of curves of all the edges in the shape and divides these edges.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_SplitCurves(self, *args)

    def SplitSurface(self, *args):
        r"""

        Parameters
        ----------
        theArea: float (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Performs splitting of surface and computes the shell from source face. the optional argument <thearea> is used to initialize the tool for splitting surface in the case of splitting into n parts where n is user-defined.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_SplitSurface(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Queries the status of last call to perform ok: no splitting was done (or no call to perform) done1: some edges were split done2: surface was split done3: surface was modified without splitting fail1: some fails encountered during splitting wires fail2: face cannot be split.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivide_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_FaceDivide_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_FaceDivide

# Register ShapeUpgrade_FaceDivide in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_FaceDivide_swigregister(ShapeUpgrade_FaceDivide)
class ShapeUpgrade_FixSmallCurves(ShapeUpgrade_Tool):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeUpgrade.ShapeUpgrade_FixSmallCurves_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_FixSmallCurves(*args))

    def Approx(self, *args):
        r"""

        Parameters
        ----------
        Curve3d: Geom_Curve
        Curve2d: Geom2d_Curve
        Curve2dR: Geom2d_Curve

        Return
        -------
        First: float
        Last: float

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_FixSmallCurves_Approx(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_FixSmallCurves_Init(self, *args)

    def SetSplitCurve2dTool(self, *args):
        r"""

        Parameters
        ----------
        splitCurve2dTool: ShapeUpgrade_SplitCurve2d

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting pcurves.

        """
        return _ShapeUpgrade.ShapeUpgrade_FixSmallCurves_SetSplitCurve2dTool(self, *args)

    def SetSplitCurve3dTool(self, *args):
        r"""

        Parameters
        ----------
        splitCurve3dTool: ShapeUpgrade_SplitCurve3d

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting 3d curves.

        """
        return _ShapeUpgrade.ShapeUpgrade_FixSmallCurves_SetSplitCurve3dTool(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Queries the status of last call to perform ok: done1: done2: fail1:.

        """
        return _ShapeUpgrade.ShapeUpgrade_FixSmallCurves_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_FixSmallCurves_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_FixSmallCurves

# Register ShapeUpgrade_FixSmallCurves in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_FixSmallCurves_swigregister(ShapeUpgrade_FixSmallCurves)
class ShapeUpgrade_RemoveInternalWires(ShapeUpgrade_Tool):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates empty constructor.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_RemoveInternalWires(*args))

    def GetResult(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Get result shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_GetResult(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialize by a shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_Init(self, *args)

    def GetMinArea(self):
        r"""GetMinArea(ShapeUpgrade_RemoveInternalWires self) -> Standard_Real"""
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_GetMinArea(self)

    def SetMinArea(self, value):
        r"""SetMinArea(ShapeUpgrade_RemoveInternalWires self, Standard_Real value)"""
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_SetMinArea(self, value)

    def Perform(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Removes all internal wires having area less than area specified as minimal allowed area.

        Parameters
        ----------
        theSeqShapes: TopTools_SequenceOfShape

        Return
        -------
        bool

        Description
        -----------
        If specified sequence of shape contains - 1.wires then these wires will be removed if they have area less than allowed min area. 2.faces than internal wires from these faces will be removed if they have area less than allowed min area.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_Perform(self, *args)

    def GetRemoveFaceMode(self):
        r"""GetRemoveFaceMode(ShapeUpgrade_RemoveInternalWires self) -> Standard_Boolean"""
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_GetRemoveFaceMode(self)

    def SetRemoveFaceMode(self, value):
        r"""SetRemoveFaceMode(ShapeUpgrade_RemoveInternalWires self, Standard_Boolean value)"""
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_SetRemoveFaceMode(self, value)

    def RemovedFaces(self, *args):
        r"""
        Return
        -------
        TopTools_SequenceOfShape

        Description
        -----------
        Returns sequence of removed faces.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_RemovedFaces(self, *args)

    def RemovedWires(self, *args):
        r"""
        Return
        -------
        TopTools_SequenceOfShape

        Description
        -----------
        Returns sequence of removed faces.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_RemovedWires(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        theStatus: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Queries status of last call to perform(): ok - nothing was done :done1 - internal wires were removed :done2 - small faces were removed. :fail1 - initial shape is not specified :fail2 - specified sub-shape is not belonged to inotial shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_RemoveInternalWires_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_RemoveInternalWires

# Register ShapeUpgrade_RemoveInternalWires in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_RemoveInternalWires_swigregister(ShapeUpgrade_RemoveInternalWires)
class ShapeUpgrade_ShapeConvertToBezier(ShapeUpgrade_ShapeDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialize by a shape.

        """
        _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShapeConvertToBezier(*args))

    def Get2dConversion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the 2d conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Get2dConversion(self, *args)

    def Get3dCircleConversion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_circle conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Get3dCircleConversion(self, *args)

    def Get3dConicConversion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_conic conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Get3dConicConversion(self, *args)

    def Get3dConversion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the 3d conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Get3dConversion(self, *args)

    def Get3dLineConversion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_line conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Get3dLineConversion(self, *args)

    def GetBSplineMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_bsplinesurface conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_GetBSplineMode(self, *args)

    def GetExtrusionMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_surfaceoflinearextrusion conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_GetExtrusionMode(self, *args)

    def GetPlaneMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_pline conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_GetPlaneMode(self, *args)

    def GetRevolutionMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_surfaceofrevolution conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_GetRevolutionMode(self, *args)

    def GetSurfaceConversion(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the surface conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_GetSurfaceConversion(self, *args)

    def Set2dConversion(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion 2d curves to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Set2dConversion(self, *args)

    def Set3dCircleConversion(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_circle to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Set3dCircleConversion(self, *args)

    def Set3dConicConversion(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_conic to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Set3dConicConversion(self, *args)

    def Set3dConversion(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion 3d curves to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Set3dConversion(self, *args)

    def Set3dLineConversion(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_line to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_Set3dLineConversion(self, *args)

    def SetBSplineMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_bsplinesurface to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_SetBSplineMode(self, *args)

    def SetExtrusionMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_surfaceoflinearextrusion to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_SetExtrusionMode(self, *args)

    def SetPlaneMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_plane to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_SetPlaneMode(self, *args)

    def SetRevolutionMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_surfaceofrevolution to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_SetRevolutionMode(self, *args)

    def SetSurfaceConversion(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion surfaces curves to bezier basis.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_SetSurfaceConversion(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShapeConvertToBezier

# Register ShapeUpgrade_ShapeConvertToBezier in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShapeConvertToBezier_swigregister(ShapeUpgrade_ShapeConvertToBezier)
class ShapeUpgrade_ShapeDivideAngle(ShapeUpgrade_ShapeDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        MaxAngle: float

        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        MaxAngle: float
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialize by a shape.

        """
        _ShapeUpgrade.ShapeUpgrade_ShapeDivideAngle_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShapeDivideAngle(*args))

    def InitTool(self, *args):
        r"""

        Parameters
        ----------
        MaxAngle: float

        Return
        -------
        None

        Description
        -----------
        Resets tool for splitting face with given angle.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideAngle_InitTool(self, *args)

    def MaxAngle(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns maximal angle.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideAngle_MaxAngle(self, *args)

    def SetMaxAngle(self, *args):
        r"""

        Parameters
        ----------
        MaxAngle: float

        Return
        -------
        None

        Description
        -----------
        Set maximal angle (calls inittool).

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideAngle_SetMaxAngle(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShapeDivideAngle

# Register ShapeUpgrade_ShapeDivideAngle in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShapeDivideAngle_swigregister(ShapeUpgrade_ShapeDivideAngle)
class ShapeUpgrade_ShapeDivideArea(ShapeUpgrade_ShapeDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialize by a shape.

        """
        _ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShapeDivideArea(*args))

    def GetMaxArea(self):
        r"""GetMaxArea(ShapeUpgrade_ShapeDivideArea self) -> Standard_Real"""
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_GetMaxArea(self)

    def SetMaxArea(self, value):
        r"""SetMaxArea(ShapeUpgrade_ShapeDivideArea self, Standard_Real value)"""
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_SetMaxArea(self, value)

    def GetNbParts(self):
        r"""GetNbParts(ShapeUpgrade_ShapeDivideArea self) -> Standard_Integer"""
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_GetNbParts(self)

    def SetNbParts(self, value):
        r"""SetNbParts(ShapeUpgrade_ShapeDivideArea self, Standard_Integer value)"""
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_SetNbParts(self, value)

    def SetNumbersUVSplits(self, *args):
        r"""

        Parameters
        ----------
        theNbUsplits: int
        theNbVsplits: int

        Return
        -------
        None

        Description
        -----------
        Set fixed numbers of splits in u and v directions. only for 'splitting by numbers' mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_SetNumbersUVSplits(self, *args)

    def SetSplittingByNumber(self, *args):
        r"""

        Parameters
        ----------
        theIsSplittingByNumber: bool

        Return
        -------
        None

        Description
        -----------
        Set splitting mode if the mode is 'splitting by number', the face is splitted approximately into <mynbparts> parts, the parts are similar to squares in 2d.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_SetSplittingByNumber(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShapeDivideArea

# Register ShapeUpgrade_ShapeDivideArea in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShapeDivideArea_swigregister(ShapeUpgrade_ShapeDivideArea)
class ShapeUpgrade_ShapeDivideClosed(ShapeUpgrade_ShapeDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialises tool with shape and default parameter.

        """
        _ShapeUpgrade.ShapeUpgrade_ShapeDivideClosed_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShapeDivideClosed(*args))

    def SetNbSplitPoints(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        None

        Description
        -----------
        Sets the number of cuts applied to divide closed faces. the number of resulting faces will be num+1.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideClosed_SetNbSplitPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShapeDivideClosed

# Register ShapeUpgrade_ShapeDivideClosed in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShapeDivideClosed_swigregister(ShapeUpgrade_ShapeDivideClosed)
class ShapeUpgrade_ShapeDivideClosedEdges(ShapeUpgrade_ShapeDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialises tool with shape and default parameter.

        """
        _ShapeUpgrade.ShapeUpgrade_ShapeDivideClosedEdges_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShapeDivideClosedEdges(*args))

    def SetNbSplitPoints(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        None

        Description
        -----------
        Sets the number of cuts applied to divide closed edges. the number of resulting faces will be num+1.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideClosedEdges_SetNbSplitPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShapeDivideClosedEdges

# Register ShapeUpgrade_ShapeDivideClosedEdges in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShapeDivideClosedEdges_swigregister(ShapeUpgrade_ShapeDivideClosedEdges)
class ShapeUpgrade_ShapeDivideContinuity(ShapeUpgrade_ShapeDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initialize by a shape.

        """
        _ShapeUpgrade.ShapeUpgrade_ShapeDivideContinuity_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ShapeDivideContinuity(*args))

    def SetBoundaryCriterion(self, *args):
        r"""

        Parameters
        ----------
        Criterion: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Defines a criterion of continuity for the boundary (all the wires) //! the possible values are c0, g1, c1, g2, c2, c3, cn the default is c1 to respect the cas.cade shape validity. g1 and g2 are not authorized.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideContinuity_SetBoundaryCriterion(self, *args)

    def SetPCurveCriterion(self, *args):
        r"""

        Parameters
        ----------
        Criterion: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Defines a criterion of continuity for the boundary (all the pcurves of wires) //! the possible values are c0, g1, c1, g2, c2, c3, cn the default is c1 to respect the cas.cade shape validity. g1 and g2 are not authorized.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideContinuity_SetPCurveCriterion(self, *args)

    def SetSurfaceCriterion(self, *args):
        r"""

        Parameters
        ----------
        Criterion: GeomAbs_Shape (optional, default to GeomAbs_C1)

        Return
        -------
        None

        Description
        -----------
        Defines a criterion of continuity for the boundary (all the wires) //! the possible values are c0, g1, c1, g2, c2, c3, cn the default is c1 to respect the cas.cade shape validity. g1 and g2 are not authorized.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideContinuity_SetSurfaceCriterion(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Sets tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideContinuity_SetTolerance(self, *args)

    def SetTolerance2d(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Sets tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_ShapeDivideContinuity_SetTolerance2d(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ShapeDivideContinuity

# Register ShapeUpgrade_ShapeDivideContinuity in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ShapeDivideContinuity_swigregister(ShapeUpgrade_ShapeDivideContinuity)
class ShapeUpgrade_SplitCurve2d(ShapeUpgrade_SplitCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitCurve2d_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitCurve2d(*args))

    def GetCurves(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColGeom2d_HArray1OfCurve>

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve2d_GetCurves(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        C: Geom2d_Curve

        Return
        -------
        None

        Description
        -----------
        Initializes with pcurve with its first and last parameters.

        Parameters
        ----------
        C: Geom2d_Curve
        First: float
        Last: float

        Return
        -------
        None

        Description
        -----------
        Initializes with pcurve with its parameters.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve2d_Init(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitCurve2d_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitCurve2d

# Register ShapeUpgrade_SplitCurve2d in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitCurve2d_swigregister(ShapeUpgrade_SplitCurve2d)
class ShapeUpgrade_SplitCurve3d(ShapeUpgrade_SplitCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitCurve3d_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitCurve3d(*args))

    def GetCurves(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColGeom_HArray1OfCurve>

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve3d_GetCurves(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve

        Return
        -------
        None

        Description
        -----------
        Initializes with curve with its first and last parameters.

        Parameters
        ----------
        C: Geom_Curve
        First: float
        Last: float

        Return
        -------
        None

        Description
        -----------
        Initializes with curve with its parameters.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve3d_Init(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitCurve3d_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitCurve3d

# Register ShapeUpgrade_SplitCurve3d in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitCurve3d_swigregister(ShapeUpgrade_SplitCurve3d)
class ShapeUpgrade_SplitSurfaceAngle(ShapeUpgrade_SplitSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        MaxAngle: float

        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitSurfaceAngle_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitSurfaceAngle(*args))

    def MaxAngle(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns maximal angle.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceAngle_MaxAngle(self, *args)

    def SetMaxAngle(self, *args):
        r"""

        Parameters
        ----------
        MaxAngle: float

        Return
        -------
        None

        Description
        -----------
        Set maximal angle.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceAngle_SetMaxAngle(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitSurfaceAngle_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitSurfaceAngle

# Register ShapeUpgrade_SplitSurfaceAngle in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitSurfaceAngle_swigregister(ShapeUpgrade_SplitSurfaceAngle)
class ShapeUpgrade_SplitSurfaceArea(ShapeUpgrade_SplitSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitSurfaceArea_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitSurfaceArea(*args))

    def GetNbParts(self):
        r"""GetNbParts(ShapeUpgrade_SplitSurfaceArea self) -> Standard_Integer"""
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceArea_GetNbParts(self)

    def SetNbParts(self, value):
        r"""SetNbParts(ShapeUpgrade_SplitSurfaceArea self, Standard_Integer value)"""
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceArea_SetNbParts(self, value)

    def SetNumbersUVSplits(self, *args):
        r"""

        Parameters
        ----------
        theNbUsplits: int
        theNbVsplits: int

        Return
        -------
        None

        Description
        -----------
        Set fixed numbers of splits in u and v directions. only for 'splitting into squares' mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceArea_SetNumbersUVSplits(self, *args)

    def SetSplittingIntoSquares(self, *args):
        r"""

        Parameters
        ----------
        theIsSplittingIntoSquares: bool

        Return
        -------
        None

        Description
        -----------
        Set splitting mode if the mode is 'splitting into squares', the face is splitted approximately into <mynbparts> parts, the parts are similar to squares in 2d.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceArea_SetSplittingIntoSquares(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitSurfaceArea_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitSurfaceArea

# Register ShapeUpgrade_SplitSurfaceArea in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitSurfaceArea_swigregister(ShapeUpgrade_SplitSurfaceArea)
class ShapeUpgrade_SplitSurfaceContinuity(ShapeUpgrade_SplitSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitSurfaceContinuity_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitSurfaceContinuity(*args))

    def SetCriterion(self, *args):
        r"""

        Parameters
        ----------
        Criterion: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Sets criterion for splitting.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceContinuity_SetCriterion(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Sets tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitSurfaceContinuity_SetTolerance(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitSurfaceContinuity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitSurfaceContinuity

# Register ShapeUpgrade_SplitSurfaceContinuity in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitSurfaceContinuity_swigregister(ShapeUpgrade_SplitSurfaceContinuity)
class ShapeUpgrade_WireDivide(ShapeUpgrade_Tool):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_WireDivide_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_WireDivide(*args))

    def GetEdgeDivideTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeUpgrade_EdgeDivide>

        Description
        -----------
        Returns tool for splitting edges.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_GetEdgeDivideTool(self, *args)

    def GetFixSmallCurveTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeUpgrade_FixSmallCurves>

        Description
        -----------
        Returns tool for fixing small curves.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_GetFixSmallCurveTool(self, *args)

    def GetTransferParamTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeAnalysis_TransferParameters>

        Description
        -----------
        Returns the tool for transfer of parameters.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_GetTransferParamTool(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initializes by wire and face.

        Parameters
        ----------
        W: TopoDS_Wire
        S: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        Initializes by wire and surface.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_Init(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Loads working wire.

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Creates wire of one edge and calls load for wire.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_Load(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Computes the resulting wire by splitting all the edges according to splitting criteria. all the modifications made are recorded in context (shapebuild_reshape). this tool is applied to all edges before splitting them in order to keep sharings. if no supporting face or surface is defined, only 3d splitting criteria are used.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_Perform(self, *args)

    def SetEdgeDivideTool(self, *args):
        r"""

        Parameters
        ----------
        edgeDivideTool: ShapeUpgrade_EdgeDivide

        Return
        -------
        None

        Description
        -----------
        Sets tool for splitting edge.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetEdgeDivideTool(self, *args)

    def SetEdgeMode(self, *args):
        r"""

        Parameters
        ----------
        EdgeMode: int

        Return
        -------
        None

        Description
        -----------
        Sets mode for splitting 3d curves from edges. 0 - only curve 3d from free edges. 1 - only curve 3d from shared edges. 2 - all curve 3d.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetEdgeMode(self, *args)

    def SetFace(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Sets supporting surface by face.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetFace(self, *args)

    def SetFixSmallCurveTool(self, *args):
        r"""

        Parameters
        ----------
        FixSmallCurvesTool: ShapeUpgrade_FixSmallCurves

        Return
        -------
        None

        Description
        -----------
        Sets tool for fixing small curves with specified min tolerance;.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetFixSmallCurveTool(self, *args)

    def SetSplitCurve2dTool(self, *args):
        r"""

        Parameters
        ----------
        splitCurve2dTool: ShapeUpgrade_SplitCurve2d

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting pcurves.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetSplitCurve2dTool(self, *args)

    def SetSplitCurve3dTool(self, *args):
        r"""

        Parameters
        ----------
        splitCurve3dTool: ShapeUpgrade_SplitCurve3d

        Return
        -------
        None

        Description
        -----------
        Sets the tool for splitting 3d curves.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetSplitCurve3dTool(self, *args)

    def SetSurface(self, *args):
        r"""

        Parameters
        ----------
        S: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        Sets supporting surface.

        Parameters
        ----------
        S: Geom_Surface
        L: TopLoc_Location

        Return
        -------
        None

        Description
        -----------
        Sets supporting surface with location.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetSurface(self, *args)

    def SetTransferParamTool(self, *args):
        r"""

        Parameters
        ----------
        TransferParam: ShapeAnalysis_TransferParameters

        Return
        -------
        None

        Description
        -----------
        Sets the tool for transfer parameters between curves and pcurves.

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_SetTransferParamTool(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Queries status of last call to perform() ok - no edges were split, wire left untouched done1 - some edges were split fail1 - some edges have no 3d curve (skipped) fail2 - some edges have no pcurve (skipped).

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_Status(self, *args)

    def Wire(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Gives the resulting wire (equal to initial one if not done or null if not loaded).

        """
        return _ShapeUpgrade.ShapeUpgrade_WireDivide_Wire(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_WireDivide_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_WireDivide

# Register ShapeUpgrade_WireDivide in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_WireDivide_swigregister(ShapeUpgrade_WireDivide)
class ShapeUpgrade_ClosedEdgeDivide(ShapeUpgrade_EdgeDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_ClosedEdgeDivide_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ClosedEdgeDivide(*args))


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_ClosedEdgeDivide_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ClosedEdgeDivide

# Register ShapeUpgrade_ClosedEdgeDivide in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ClosedEdgeDivide_swigregister(ShapeUpgrade_ClosedEdgeDivide)
class ShapeUpgrade_ClosedFaceDivide(ShapeUpgrade_FaceDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates empty constructor.

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Initialize by a face.

        """
        _ShapeUpgrade.ShapeUpgrade_ClosedFaceDivide_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ClosedFaceDivide(*args))

    def GetNbSplitPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of splitting points.

        """
        return _ShapeUpgrade.ShapeUpgrade_ClosedFaceDivide_GetNbSplitPoints(self, *args)

    def SetNbSplitPoints(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        None

        Description
        -----------
        Sets the number of cutting lines by which closed face will be split. the resulting faces will be num+1.

        """
        return _ShapeUpgrade.ShapeUpgrade_ClosedFaceDivide_SetNbSplitPoints(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_ClosedFaceDivide_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ClosedFaceDivide

# Register ShapeUpgrade_ClosedFaceDivide in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ClosedFaceDivide_swigregister(ShapeUpgrade_ClosedFaceDivide)
class ShapeUpgrade_ConvertCurve2dToBezier(ShapeUpgrade_SplitCurve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_ConvertCurve2dToBezier_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ConvertCurve2dToBezier(*args))

    def SplitParams(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfReal>

        Description
        -----------
        Returns the list of split parameters in original curve parametrisation.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve2dToBezier_SplitParams(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_ConvertCurve2dToBezier_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ConvertCurve2dToBezier

# Register ShapeUpgrade_ConvertCurve2dToBezier in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ConvertCurve2dToBezier_swigregister(ShapeUpgrade_ConvertCurve2dToBezier)
class ShapeUpgrade_ConvertCurve3dToBezier(ShapeUpgrade_SplitCurve3d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_ConvertCurve3dToBezier(*args))

    def GetCircleMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_circle conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_GetCircleMode(self, *args)

    def GetConicMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Performs converting and computes the resulting shape.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_GetConicMode(self, *args)

    def GetLineMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the geom_line conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_GetLineMode(self, *args)

    def SetCircleMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_circle to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_SetCircleMode(self, *args)

    def SetConicMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Returns the geom_conic conversion mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_SetConicMode(self, *args)

    def SetLineMode(self, *args):
        r"""

        Parameters
        ----------
        mode: bool

        Return
        -------
        None

        Description
        -----------
        Sets mode for conversion geom_line to bezier.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_SetLineMode(self, *args)

    def SplitParams(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfReal>

        Description
        -----------
        Returns the list of split parameters in original curve parametrisation.

        """
        return _ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_SplitParams(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_ConvertCurve3dToBezier_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_ConvertCurve3dToBezier

# Register ShapeUpgrade_ConvertCurve3dToBezier in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_ConvertCurve3dToBezier_swigregister(ShapeUpgrade_ConvertCurve3dToBezier)
class ShapeUpgrade_FaceDivideArea(ShapeUpgrade_FaceDivide):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates empty constructor.

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeUpgrade.ShapeUpgrade_FaceDivideArea_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_FaceDivideArea(*args))

    def GetMaxArea(self):
        r"""GetMaxArea(ShapeUpgrade_FaceDivideArea self) -> Standard_Real"""
        return _ShapeUpgrade.ShapeUpgrade_FaceDivideArea_GetMaxArea(self)

    def SetMaxArea(self, value):
        r"""SetMaxArea(ShapeUpgrade_FaceDivideArea self, Standard_Real value)"""
        return _ShapeUpgrade.ShapeUpgrade_FaceDivideArea_SetMaxArea(self, value)

    def GetNbParts(self):
        r"""GetNbParts(ShapeUpgrade_FaceDivideArea self) -> Standard_Integer"""
        return _ShapeUpgrade.ShapeUpgrade_FaceDivideArea_GetNbParts(self)

    def SetNbParts(self, value):
        r"""SetNbParts(ShapeUpgrade_FaceDivideArea self, Standard_Integer value)"""
        return _ShapeUpgrade.ShapeUpgrade_FaceDivideArea_SetNbParts(self, value)

    def SetNumbersUVSplits(self, *args):
        r"""

        Parameters
        ----------
        theNbUsplits: int
        theNbVsplits: int

        Return
        -------
        None

        Description
        -----------
        Set fixed numbers of splits in u and v directions. only for 'splitting by numbers' mode.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivideArea_SetNumbersUVSplits(self, *args)

    def SetSplittingByNumber(self, *args):
        r"""

        Parameters
        ----------
        theIsSplittingByNumber: bool

        Return
        -------
        None

        Description
        -----------
        Set splitting mode if the mode is 'splitting by number', the face is splitted approximately into <mynbparts> parts, the parts are similar to squares in 2d.

        """
        return _ShapeUpgrade.ShapeUpgrade_FaceDivideArea_SetSplittingByNumber(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_FaceDivideArea_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_FaceDivideArea

# Register ShapeUpgrade_FaceDivideArea in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_FaceDivideArea_swigregister(ShapeUpgrade_FaceDivideArea)
class ShapeUpgrade_FixSmallBezierCurves(ShapeUpgrade_FixSmallCurves):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeUpgrade.ShapeUpgrade_FixSmallBezierCurves_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_FixSmallBezierCurves(*args))


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_FixSmallBezierCurves_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_FixSmallBezierCurves

# Register ShapeUpgrade_FixSmallBezierCurves in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_FixSmallBezierCurves_swigregister(ShapeUpgrade_FixSmallBezierCurves)
class ShapeUpgrade_SplitCurve2dContinuity(ShapeUpgrade_SplitCurve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitCurve2dContinuity_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitCurve2dContinuity(*args))

    def SetCriterion(self, *args):
        r"""

        Parameters
        ----------
        Criterion: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Sets criterion for splitting.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve2dContinuity_SetCriterion(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Sets tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve2dContinuity_SetTolerance(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitCurve2dContinuity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitCurve2dContinuity

# Register ShapeUpgrade_SplitCurve2dContinuity in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitCurve2dContinuity_swigregister(ShapeUpgrade_SplitCurve2dContinuity)
class ShapeUpgrade_SplitCurve3dContinuity(ShapeUpgrade_SplitCurve3d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeUpgrade.ShapeUpgrade_SplitCurve3dContinuity_swiginit(self, _ShapeUpgrade.new_ShapeUpgrade_SplitCurve3dContinuity(*args))

    def GetCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        No available documentation.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve3dContinuity_GetCurve(self, *args)

    def SetCriterion(self, *args):
        r"""

        Parameters
        ----------
        Criterion: GeomAbs_Shape

        Return
        -------
        None

        Description
        -----------
        Sets criterion for splitting.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve3dContinuity_SetCriterion(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Sets tolerance.

        """
        return _ShapeUpgrade.ShapeUpgrade_SplitCurve3dContinuity_SetTolerance(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeUpgrade_SplitCurve3dContinuity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeUpgrade.delete_ShapeUpgrade_SplitCurve3dContinuity

# Register ShapeUpgrade_SplitCurve3dContinuity in _ShapeUpgrade:
_ShapeUpgrade.ShapeUpgrade_SplitCurve3dContinuity_swigregister(ShapeUpgrade_SplitCurve3dContinuity)



@deprecated
def shapeupgrade_C0BSplineToSequenceOfC1BSplineCurve(*args):
	return shapeupgrade.C0BSplineToSequenceOfC1BSplineCurve(*args)

@deprecated
def shapeupgrade_C0BSplineToSequenceOfC1BSplineCurve(*args):
	return shapeupgrade.C0BSplineToSequenceOfC1BSplineCurve(*args)



