/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCompleteDocument;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.FontNameComboBox;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LabelController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelPanel
extends JPanel
implements DialogView {
    private final boolean labelModification;
    private final LabelController controller;
    private JLabel textLabel;
    private JTextArea textTextArea;
    private JLabel alignmentLabel;
    private JRadioButton leftAlignmentRadioButton;
    private JRadioButton centerAlignmentRadioButton;
    private JRadioButton rightAlignmentRadioButton;
    private JLabel fontNameLabel;
    private FontNameComboBox fontNameComboBox;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JLabel colorLabel;
    private ColorButton colorButton;
    private NullableCheckBox visibleIn3DViewCheckBox;
    private JLabel pitchLabel;
    private JRadioButton pitch0DegreeRadioButton;
    private JRadioButton pitch90DegreeRadioButton;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private String dialogTitle;

    public LabelPanel(boolean bl, UserPreferences userPreferences, LabelController labelController) {
        super(new GridBagLayout());
        this.labelModification = bl;
        this.controller = labelController;
        this.createComponents(bl, userPreferences, labelController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(labelController, userPreferences);
    }

    private void createComponents(boolean bl, UserPreferences userPreferences, final LabelController labelController) {
        this.textLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "textLabel.text", new Object[0]));
        this.textTextArea = new JTextArea(labelController.getText(), 3, 20);
        if (!OperatingSystem.isMacOSX()) {
            this.textTextArea.setFont(UIManager.getFont("TextField.font"));
        }
        this.textTextArea.setDocument(new AutoCompleteDocument(this.textTextArea, userPreferences.getAutoCompletionStrings("LabelText")));
        this.textTextArea.setFocusTraversalKeys(0, new HashSet<KeyStroke>(Arrays.asList(KeyStroke.getKeyStroke("pressed TAB"))));
        this.textTextArea.setFocusTraversalKeys(1, new HashSet<KeyStroke>(Arrays.asList(KeyStroke.getKeyStroke("shift pressed TAB"))));
        SwingTools.addAutoSelectionOnFocusGain(this.textTextArea);
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((AutoCompleteDocument)LabelPanel.this.textTextArea.getDocument()).setAutoCompletionEnabled(false);
                LabelPanel.this.textTextArea.setText(labelController.getText());
                ((AutoCompleteDocument)LabelPanel.this.textTextArea.getDocument()).setAutoCompletionEnabled(true);
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
                String string = LabelPanel.this.textTextArea.getText();
                if (string == null || string.trim().length() == 0) {
                    labelController.setText("");
                } else {
                    labelController.setText(string);
                }
                labelController.addPropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
        this.textTextArea.getDocument().addDocumentListener(documentListener);
        this.alignmentLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "alignmentLabel.text", new Object[0]));
        this.leftAlignmentRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "leftAlignmentRadioButton.text", new Object[0]));
        this.centerAlignmentRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "centerAlignmentRadioButton.text", new Object[0]));
        this.rightAlignmentRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "rightAlignmentRadioButton.text", new Object[0]));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (LabelPanel.this.leftAlignmentRadioButton.isSelected()) {
                    labelController.setAlignment(TextStyle.Alignment.LEFT);
                } else if (LabelPanel.this.centerAlignmentRadioButton.isSelected()) {
                    labelController.setAlignment(TextStyle.Alignment.CENTER);
                } else if (LabelPanel.this.rightAlignmentRadioButton.isSelected()) {
                    labelController.setAlignment(TextStyle.Alignment.RIGHT);
                }
            }
        };
        this.leftAlignmentRadioButton.addItemListener(itemListener);
        this.centerAlignmentRadioButton.addItemListener(itemListener);
        this.rightAlignmentRadioButton.addItemListener(itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.leftAlignmentRadioButton);
        buttonGroup.add(this.centerAlignmentRadioButton);
        buttonGroup.add(this.rightAlignmentRadioButton);
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (labelController.getAlignment() == TextStyle.Alignment.LEFT) {
                    LabelPanel.this.leftAlignmentRadioButton.setSelected(true);
                } else if (labelController.getAlignment() == TextStyle.Alignment.CENTER) {
                    LabelPanel.this.centerAlignmentRadioButton.setSelected(true);
                } else if (labelController.getAlignment() == TextStyle.Alignment.RIGHT) {
                    LabelPanel.this.rightAlignmentRadioButton.setSelected(true);
                } else {
                    SwingTools.deselectAllRadioButtons(LabelPanel.this.leftAlignmentRadioButton, LabelPanel.this.centerAlignmentRadioButton, LabelPanel.this.rightAlignmentRadioButton);
                }
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.ALIGNMENT, propertyChangeListener2);
        propertyChangeListener2.propertyChange(null);
        this.fontNameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "fontNameLabel.text", new Object[0]));
        this.fontNameComboBox = new FontNameComboBox(userPreferences);
        this.fontNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)LabelPanel.this.fontNameComboBox.getSelectedItem();
                labelController.setFontName(string == "DEFAULT_SYSTEM_FONT_NAME" ? null : string);
            }
        });
        PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (labelController.isFontNameSet()) {
                    String string = labelController.getFontName();
                    LabelPanel.this.fontNameComboBox.setSelectedItem(string == null ? "DEFAULT_SYSTEM_FONT_NAME" : string);
                } else {
                    LabelPanel.this.fontNameComboBox.setSelectedItem(null);
                }
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.FONT_NAME, propertyChangeListener3);
        propertyChangeListener3.propertyChange(null);
        String string = userPreferences.getLengthUnit().getName();
        this.fontSizeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "fontSizeLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 5.0f, 999.0f);
        this.fontSizeSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f = labelController.getFontSize();
                nullableSpinnerLengthModel.setNullable(f == null);
                nullableSpinnerLengthModel.setLength(f);
            }
        };
        propertyChangeListener4.propertyChange(null);
        labelController.addPropertyChangeListener(LabelController.Property.FONT_SIZE, propertyChangeListener4);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.FONT_SIZE, propertyChangeListener4);
                labelController.setFontSize(nullableSpinnerLengthModel.getLength());
                labelController.addPropertyChangeListener(LabelController.Property.FONT_SIZE, propertyChangeListener4);
            }
        });
        this.colorLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "colorLabel.text", new Object[0]));
        this.colorButton = new ColorButton(userPreferences);
        if (OperatingSystem.isMacOSX()) {
            this.colorButton.putClientProperty("JButton.buttonType", "segmented");
            this.colorButton.putClientProperty("JButton.segmentPosition", "only");
        }
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(LabelPanel.class, "colorDialog.title", new Object[0]));
        this.colorButton.setColor(labelController.getColor() != null ? labelController.getColor().intValue() : this.getForeground().getRGB());
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                labelController.setColor(LabelPanel.this.colorButton.getColor());
            }
        });
        labelController.addPropertyChangeListener(LabelController.Property.COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.colorButton.setColor(labelController.getColor());
            }
        });
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.update3DViewComponents(labelController);
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.PITCH, propertyChangeListener5);
        this.visibleIn3DViewCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "visibleIn3DViewCheckBox.text", new Object[0]));
        if (labelController.isPitchEnabled() != null) {
            this.visibleIn3DViewCheckBox.setValue(labelController.isPitchEnabled());
        } else {
            this.visibleIn3DViewCheckBox.setNullable(true);
            this.visibleIn3DViewCheckBox.setValue(null);
        }
        this.visibleIn3DViewCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.PITCH, propertyChangeListener5);
                if (LabelPanel.this.visibleIn3DViewCheckBox.isNullable()) {
                    LabelPanel.this.visibleIn3DViewCheckBox.setNullable(false);
                }
                if (Boolean.FALSE.equals(LabelPanel.this.visibleIn3DViewCheckBox.getValue())) {
                    labelController.setPitch(null);
                } else if (LabelPanel.this.pitch90DegreeRadioButton.isSelected()) {
                    labelController.setPitch(Float.valueOf(1.5707964f));
                } else {
                    labelController.setPitch(Float.valueOf(0.0f));
                }
                LabelPanel.this.update3DViewComponents(labelController);
                labelController.addPropertyChangeListener(LabelController.Property.PITCH, propertyChangeListener5);
            }
        });
        this.pitchLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "pitchLabel.text", new Object[0]));
        this.pitch0DegreeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "pitch0DegreeRadioButton.text", new Object[0]));
        ItemListener itemListener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (LabelPanel.this.pitch0DegreeRadioButton.isSelected()) {
                    labelController.setPitch(Float.valueOf(0.0f));
                } else if (LabelPanel.this.pitch90DegreeRadioButton.isSelected()) {
                    labelController.setPitch(Float.valueOf(1.5707964f));
                }
            }
        };
        this.pitch0DegreeRadioButton.addItemListener(itemListener2);
        this.pitch90DegreeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "pitch90DegreeRadioButton.text", new Object[0]));
        this.pitch90DegreeRadioButton.addItemListener(itemListener2);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.pitch0DegreeRadioButton);
        buttonGroup2.add(this.pitch90DegreeRadioButton);
        this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "elevationLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, userPreferences.getLengthUnit().getMaximumElevation());
        this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setNullable(labelController.getElevation() == null);
        nullableSpinnerLengthModel2.setLength(labelController.getElevation());
        final PropertyChangeListener propertyChangeListener6 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.ELEVATION, propertyChangeListener6);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.ELEVATION, propertyChangeListener6);
                labelController.setElevation(nullableSpinnerLengthModel2.getLength());
                labelController.addPropertyChangeListener(LabelController.Property.ELEVATION, propertyChangeListener6);
            }
        });
        this.update3DViewComponents(labelController);
        this.dialogTitle = userPreferences.getLocalizedString(LabelPanel.class, bl ? "labelModification.title" : "labelCreation.title", new Object[0]);
    }

    private void update3DViewComponents(LabelController labelController) {
        boolean bl = Boolean.TRUE.equals(labelController.isPitchEnabled());
        this.pitch0DegreeRadioButton.setEnabled(bl);
        this.pitch90DegreeRadioButton.setEnabled(bl);
        this.elevationSpinner.setEnabled(bl);
        if (labelController.getPitch() != null) {
            if (labelController.getPitch().floatValue() == 0.0f) {
                this.pitch0DegreeRadioButton.setSelected(true);
            } else if (labelController.getPitch().floatValue() == 1.5707964f) {
                this.pitch90DegreeRadioButton.setSelected(true);
            }
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.textLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "textLabel.mnemonic", new Object[0])).getKeyCode());
            this.textLabel.setLabelFor(this.textTextArea);
            this.leftAlignmentRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "leftAlignmentRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.centerAlignmentRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "centerAlignmentRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.rightAlignmentRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "rightAlignmentRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.fontNameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "fontNameLabel.mnemonic", new Object[0])).getKeyCode());
            this.fontNameLabel.setLabelFor(this.fontNameComboBox);
            this.fontSizeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "fontSizeLabel.mnemonic", new Object[0])).getKeyCode());
            this.fontSizeLabel.setLabelFor(this.fontSizeSpinner);
            this.visibleIn3DViewCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "visibleIn3DViewCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.pitch0DegreeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "pitch0DegreeRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.pitch90DegreeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "pitch90DegreeRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setLabelFor(this.elevationSpinner);
        }
    }

    private void layoutComponents(LabelController labelController, UserPreferences userPreferences) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(LabelPanel.class, "textAndStylePanel.title", new Object[0]));
        jPanel.add((Component)this.textLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, OperatingSystem.isMacOSX() ? 12 : 18, 0, new Insets(OperatingSystem.isMacOSX() ? 0 : n2, 0, n2, 5), 0, 0));
        jPanel.add((Component)SwingTools.createScrollPane(this.textTextArea), new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 21, 2, new Insets(OperatingSystem.isMacOSX() ? 0 : n2, 0, n2, 0), 0, 0));
        jPanel.add((Component)this.alignmentLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)this.leftAlignmentRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel2.add((Component)this.centerAlignmentRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel2.add((Component)this.rightAlignmentRadioButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), 0, 0));
        jPanel.add((Component)this.fontNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        Dimension dimension = this.fontNameComboBox.getPreferredSize();
        dimension.width = Math.min(dimension.width, this.textTextArea.getPreferredSize().width);
        this.fontNameComboBox.setPreferredSize(dimension);
        jPanel.add((Component)this.fontNameComboBox, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), 0, 0));
        jPanel.add((Component)this.fontSizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel.add((Component)this.fontSizeSpinner, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 5, 0));
        jPanel.add((Component)this.colorLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 10, 0, n2), 0, 0));
        jPanel.add((Component)this.colorButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, OperatingSystem.isMacOSX() ? 6 : 0), 0, 0));
        int n3 = OperatingSystem.isMacOSXLeopardOrSuperior() ? 0 : n2;
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, n3, 0), 0, 0));
        JPanel jPanel3 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(LabelPanel.class, "rendering3DPanel.title", new Object[0]));
        jPanel3.add((Component)this.visibleIn3DViewCheckBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, OperatingSystem.isMacOSX() ? -8 : 0, n2, 0), 0, 0));
        jPanel3.add((Component)this.pitchLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel3.add((Component)this.pitch0DegreeRadioButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel3.add((Component)this.pitch90DegreeRadioButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), 0, 0));
        jPanel3.add((Component)this.elevationLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel3.add((Component)this.elevationSpinner, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.textTextArea) == 0 && this.controller != null) {
            if (this.labelModification) {
                this.controller.modifyLabels();
            } else {
                this.controller.createLabel();
            }
        }
    }
}

