/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.startup.WebappServiceLoader;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.Introspection;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.bcel.classfile.AnnotationElementValue;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ArrayElementValue;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ClassParser;
import org.apache.tomcat.util.bcel.classfile.ElementValue;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.descriptor.InputSourceUtil;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.FragmentJarScannerCallback;
import org.apache.tomcat.util.descriptor.web.JspPropertyGroup;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.descriptor.web.MultipartDef;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.descriptor.web.SecurityRoleRef;
import org.apache.tomcat.util.descriptor.web.ServletDef;
import org.apache.tomcat.util.descriptor.web.SessionConfig;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ContextConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(ContextConfig.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    protected static final LoginConfig DUMMY_LOGIN_CONFIG = new LoginConfig("NONE", null, null, null);
    protected static final Properties authenticators;
    protected static long deploymentCount;
    protected static final Map<Host, DefaultWebXmlCacheEntry> hostWebXmlCache;
    private static final Set<ServletContainerInitializer> EMPTY_SCI_SET;
    protected Map<String, Authenticator> customAuthenticators;
    protected volatile Context context = null;
    protected String defaultWebXml = null;
    protected boolean ok = false;
    protected String originalDocBase = null;
    private File antiLockingDocBase = null;
    protected final Map<ServletContainerInitializer, Set<Class<?>>> initializerClassMap = new LinkedHashMap();
    protected final Map<Class<?>, Set<ServletContainerInitializer>> typeInitializerMap = new HashMap();
    protected boolean handlesTypesAnnotations = false;
    protected boolean handlesTypesNonAnnotations = false;

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String string) {
        this.defaultWebXml = string;
    }

    public void setCustomAuthenticators(Map<String, Authenticator> map) {
        this.customAuthenticators = map;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            this.context = (Context)lifecycleEvent.getLifecycle();
        }
        catch (ClassCastException classCastException) {
            log.error((Object)sm.getString("contextConfig.cce", new Object[]{lifecycleEvent.getLifecycle()}), (Throwable)classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("configure_start")) {
            this.configureStart();
        } else if (lifecycleEvent.getType().equals("before_start")) {
            this.beforeStart();
        } else if (lifecycleEvent.getType().equals("after_start")) {
            if (this.originalDocBase != null) {
                this.context.setDocBase(this.originalDocBase);
            }
        } else if (lifecycleEvent.getType().equals("configure_stop")) {
            this.configureStop();
        } else if (lifecycleEvent.getType().equals("after_init")) {
            this.init();
        } else if (lifecycleEvent.getType().equals("after_destroy")) {
            this.destroy();
        }
    }

    protected void applicationAnnotationsConfig() {
        long l = System.currentTimeMillis();
        WebAnnotationSet.loadApplicationAnnotations(this.context);
        long l2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(l2 - l + ((StandardContext)this.context).getStartupTime());
        }
    }

    protected void authenticatorConfig() {
        Object object;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = DUMMY_LOGIN_CONFIG;
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context.getAuthenticator() != null) {
            return;
        }
        if (this.context.getRealm() == null) {
            log.error((Object)sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        Valve valve = null;
        if (this.customAuthenticators != null) {
            valve = (Valve)((Object)this.customAuthenticators.get(loginConfig.getAuthMethod()));
        }
        if (valve == null) {
            if (authenticators == null) {
                log.error((Object)sm.getString("contextConfig.authenticatorResources"));
                this.ok = false;
                return;
            }
            object = authenticators.getProperty(loginConfig.getAuthMethod());
            if (object == null) {
                log.error((Object)sm.getString("contextConfig.authenticatorMissing", new Object[]{loginConfig.getAuthMethod()}));
                this.ok = false;
                return;
            }
            try {
                Class<?> clazz = Class.forName((String)object);
                valve = (Valve)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("contextConfig.authenticatorInstantiate", new Object[]{object}), throwable);
                this.ok = false;
            }
        }
        if (valve != null && (object = this.context.getPipeline()) != null) {
            object.addValve(valve);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", new Object[]{loginConfig.getAuthMethod()}));
            }
        }
    }

    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("className");
        hashMap.put(Object.class, arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("source");
        hashMap.put(StandardContext.class, arrayList2);
        digester.setFakeAttributes(hashMap);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet((RuleSet)contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet((RuleSet)namingRuleSet);
        return digester;
    }

    protected boolean getGenerateCode() {
        Catalina catalina = Container.getService(this.context).getServer().getCatalina();
        if (catalina != null) {
            return catalina.getGenerateCode();
        }
        return false;
    }

    protected boolean getUseGeneratedCode() {
        Catalina catalina = Container.getService(this.context).getServer().getCatalina();
        if (catalina != null) {
            return catalina.getUseGeneratedCode();
        }
        return false;
    }

    protected File getGeneratedCodeLocation() {
        Catalina catalina = Container.getService(this.context).getServer().getCatalina();
        if (catalina != null) {
            return catalina.getGeneratedCodeLocation();
        }
        return null;
    }

    protected String getGeneratedCodePackage() {
        Catalina catalina = Container.getService(this.context).getServer().getCatalina();
        if (catalina != null) {
            return catalina.getGeneratedCodePackage();
        }
        return "generatedCodePackage";
    }

    protected static String getContextXmlPackageName(String string, Container container) {
        StringBuilder stringBuilder = new StringBuilder();
        Container container2 = null;
        Container container3 = null;
        while (container != null) {
            if (container instanceof Host) {
                container2 = container;
            } else if (container instanceof Engine) {
                container3 = container;
            }
            container = container.getParent();
        }
        stringBuilder.append(string);
        if (container3 != null) {
            stringBuilder.append('.');
        }
        if (container3 != null) {
            stringBuilder.append(container3.getName());
            if (container2 != null) {
                stringBuilder.append('.');
            }
        }
        if (container2 != null) {
            stringBuilder.append(container2.getName());
        }
        return stringBuilder.toString();
    }

    protected File getContextXmlJavaSource(String string, String string2) {
        String string3;
        File file = this.getGeneratedCodeLocation();
        File file2 = new File(file, string3 = string.replace('.', File.separatorChar));
        if (file2.isDirectory() || file2.mkdirs()) {
            return new File(file2, string2 + ".java");
        }
        return null;
    }

    protected void generateClassHeader(Digester digester, String string, String string2) {
        StringBuilder stringBuilder = digester.getGeneratedCode();
        stringBuilder.append("package ").append(string).append(';').append(System.lineSeparator());
        stringBuilder.append("public class ").append(string2).append(" implements ");
        stringBuilder.append(ContextXml.class.getName().replace('$', '.'));
        stringBuilder.append(" {").append(System.lineSeparator());
        stringBuilder.append("public void load(");
        stringBuilder.append(Context.class.getName());
        String string3 = digester.toVariableName((Object)this.context);
        stringBuilder.append(' ').append(string3).append(") {").append(System.lineSeparator());
        digester.setKnown((Object)this.context);
        stringBuilder.append(this.context.getClass().getName()).append(' ').append(digester.toVariableName((Object)this.context));
        stringBuilder.append(" = (").append(this.context.getClass().getName()).append(") ").append(string3);
        stringBuilder.append(';').append(System.lineSeparator());
    }

    protected void generateClassFooter(Digester digester) {
        StringBuilder stringBuilder = digester.getGeneratedCode();
        stringBuilder.append('}').append(System.lineSeparator());
        stringBuilder.append('}').append(System.lineSeparator());
    }

    protected void contextConfig(Digester digester) {
        Object object;
        ContextXml contextXml;
        File file;
        String string;
        Object object2;
        String string2;
        boolean bl;
        boolean bl2;
        block62: {
            String string3 = null;
            bl2 = this.getGenerateCode();
            bl = this.getUseGeneratedCode();
            string2 = null;
            object2 = null;
            string = null;
            file = null;
            if (this.context instanceof StandardContext) {
                string3 = ((StandardContext)this.context).getDefaultContextXml();
            }
            if (string3 == null) {
                string3 = "conf/context.xml";
            }
            contextXml = null;
            if (!this.context.getOverride()) {
                Object object3;
                URL uRL;
                block60: {
                    if (bl || bl2) {
                        string2 = this.getGeneratedCodePackage();
                        object2 = "ContextXmlDefault";
                        string = string2 + "." + (String)object2;
                    }
                    if (bl) {
                        contextXml = (ContextXml)Digester.loadGeneratedClass(string);
                    }
                    if (contextXml != null) {
                        contextXml.load(this.context);
                        contextXml = null;
                    } else if (!bl) {
                        try {
                            object = ConfigFileLoader.getSource().getResource(string3);
                            try {
                                if (bl2) {
                                    file = this.getContextXmlJavaSource(string2, (String)object2);
                                    if (file != null) {
                                        digester.startGeneratingCode();
                                        this.generateClassHeader(digester, string2, (String)object2);
                                    } else {
                                        bl2 = false;
                                    }
                                }
                                uRL = object.getURI().toURL();
                                this.processContextConfig(digester, uRL, object.getInputStream());
                                if (!bl2) break block60;
                                this.generateClassFooter(digester);
                                object3 = new FileWriter(file);
                                try {
                                    ((Writer)object3).write(digester.getGeneratedCode().toString());
                                }
                                finally {
                                    ((OutputStreamWriter)object3).close();
                                }
                                digester.endGeneratingCode();
                                Digester.addGeneratedClass((String)string);
                            }
                            finally {
                                if (object != null) {
                                    object.close();
                                }
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            log.error((Object)sm.getString("contextConfig.badUrl", new Object[]{string3}), (Throwable)malformedURLException);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (bl || bl2) {
                    string2 = ContextConfig.getContextXmlPackageName(this.getGeneratedCodePackage(), this.context);
                    object2 = "ContextXmlDefault";
                    string = string2 + "." + (String)object2;
                }
                if (bl) {
                    contextXml = (ContextXml)Digester.loadGeneratedClass((String)string);
                }
                if (contextXml != null) {
                    contextXml.load(this.context);
                    contextXml = null;
                } else if (!bl) {
                    object = Container.getConfigPath(this.context, "context.xml.default");
                    try {
                        uRL = ConfigFileLoader.getSource().getResource((String)object);
                        try {
                            if (bl2) {
                                file = this.getContextXmlJavaSource(string2, (String)object2);
                                digester.startGeneratingCode();
                                this.generateClassHeader(digester, string2, (String)object2);
                            }
                            object3 = uRL.getURI().toURL();
                            this.processContextConfig(digester, (URL)object3, uRL.getInputStream());
                            if (!bl2) break block62;
                            this.generateClassFooter(digester);
                            try (FileWriter fileWriter = new FileWriter(file);){
                                fileWriter.write(digester.getGeneratedCode().toString());
                            }
                            digester.endGeneratingCode();
                            Digester.addGeneratedClass((String)string);
                        }
                        finally {
                            if (uRL != null) {
                                uRL.close();
                            }
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("contextConfig.badUrl", new Object[]{object}), (Throwable)malformedURLException);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.context.getConfigFile() != null) {
            if (bl || bl2) {
                string2 = ContextConfig.getContextXmlPackageName(this.getGeneratedCodePackage(), this.context);
                object2 = "ContextXml_" + this.context.getName().replace('/', '_').replace("-", "__");
                string = string2 + "." + (String)object2;
            }
            if (bl) {
                contextXml = (ContextXml)Digester.loadGeneratedClass((String)string);
            }
            if (contextXml != null) {
                contextXml.load(this.context);
                contextXml = null;
            } else if (!bl) {
                if (bl2) {
                    file = this.getContextXmlJavaSource(string2, (String)object2);
                    digester.startGeneratingCode();
                    this.generateClassHeader(digester, string2, (String)object2);
                }
                this.processContextConfig(digester, this.context.getConfigFile(), null);
                if (bl2) {
                    this.generateClassFooter(digester);
                    try {
                        object = new FileWriter(file);
                        try {
                            ((Writer)object).write(digester.getGeneratedCode().toString());
                        }
                        finally {
                            ((OutputStreamWriter)object).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    digester.endGeneratingCode();
                    Digester.addGeneratedClass((String)string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(Digester digester, URL uRL, InputStream inputStream) {
        URLConnection uRLConnection;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing context [" + this.context.getName() + "] configuration file [" + uRL + "]"));
        }
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(uRL.toString());
            if (inputStream == null) {
                uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                inputStream = uRLConnection.getInputStream();
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("contextConfig.contextMissing", new Object[]{uRL}), (Throwable)exception);
        }
        if (inputSource == null) {
            return;
        }
        try {
            inputSource.setByteStream(inputStream);
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.setUseContextClassLoader(false);
            digester.push((Object)this.context.getParent());
            digester.push((Object)this.context);
            uRLConnection = new XmlErrorHandler();
            digester.setErrorHandler((ErrorHandler)((Object)uRLConnection));
            digester.parse(inputSource);
            if (uRLConnection.getWarnings().size() > 0 || uRLConnection.getErrors().size() > 0) {
                uRLConnection.logFindings(log, uRL.toString());
                this.ok = false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully processed context [" + this.context.getName() + "] configuration file [" + uRL + "]"));
            }
        }
        catch (SAXParseException sAXParseException) {
            log.error((Object)sm.getString("contextConfig.contextParse", new Object[]{this.context.getName()}), (Throwable)sAXParseException);
            log.error((Object)sm.getString("contextConfig.defaultPosition", new Object[]{"" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()}));
            this.ok = false;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("contextConfig.contextParse", new Object[]{this.context.getName()}), (Throwable)exception);
            this.ok = false;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)iOException);
            }
        }
    }

    protected void fixDocBase() throws IOException {
        String string;
        Object object;
        Object object2;
        String string2;
        Host host = (Host)this.context.getParent();
        File file = host.getAppBaseFile();
        String string3 = this.context.getDocBase();
        if (string3 == null) {
            string2 = this.context.getPath();
            if (string2 == null) {
                return;
            }
            object2 = new ContextName(string2, this.context.getWebappVersion());
            string3 = ((ContextName)object2).getBaseName();
        }
        string2 = !((File)(object2 = new File(string3))).isAbsolute() ? new File(file, string3).getAbsolutePath() : ((File)object2).getAbsolutePath();
        Object object3 = new File(string2);
        String string4 = string2;
        ContextName contextName = new ContextName(this.context.getPath(), this.context.getWebappVersion());
        String string5 = contextName.getBaseName();
        boolean bl = true;
        if (host instanceof StandardHost && (bl = ((StandardHost)host).isUnpackWARs()) && this.context instanceof StandardContext) {
            bl = ((StandardContext)this.context).getUnpackWAR();
        }
        boolean bl2 = string2.startsWith(file.getPath() + File.separatorChar);
        if (string2.toLowerCase(Locale.ENGLISH).endsWith(".war") && !((File)object3).isDirectory()) {
            object = UriUtil.buildJarUrl((File)object3);
            if (bl) {
                string2 = ExpandWar.expand(host, (URL)object, string5);
                object3 = new File(string2);
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(string4);
                }
            } else {
                ExpandWar.validate(host, (URL)object, string5);
            }
        } else {
            object = new File(string2 + ".war");
            URL uRL = null;
            if (((File)object).exists() && bl2) {
                uRL = UriUtil.buildJarUrl((File)object);
            }
            if (((File)object3).exists()) {
                if (uRL != null && bl) {
                    ExpandWar.expand(host, uRL, string5);
                }
            } else {
                if (uRL != null) {
                    if (bl) {
                        string2 = ExpandWar.expand(host, uRL, string5);
                        object3 = new File(string2);
                    } else {
                        object3 = object;
                        ExpandWar.validate(host, uRL, string5);
                    }
                }
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(string4);
                }
            }
        }
        object = ((File)object3).getCanonicalPath();
        boolean bl3 = ((File)object3).getCanonicalFile().toPath().startsWith(file.toPath());
        if (bl3) {
            string = ((String)object).substring(file.getPath().length());
            if ((string = string.replace(File.separatorChar, '/')).startsWith("/")) {
                string = string.substring(1);
            }
        } else {
            string = ((String)object).replace(File.separatorChar, '/');
        }
        this.context.setDocBase(string);
    }

    protected void antiLocking() {
        if (this.context instanceof StandardContext && ((StandardContext)this.context).getAntiResourceLocking()) {
            String string;
            Host host = (Host)this.context.getParent();
            String string2 = this.context.getDocBase();
            if (string2 == null) {
                return;
            }
            this.originalDocBase = string2;
            File file = new File(string2);
            if (!file.isAbsolute()) {
                file = new File(host.getAppBaseFile(), string2);
            }
            if ((string = this.context.getPath()) == null) {
                return;
            }
            ContextName contextName = new ContextName(string, this.context.getWebappVersion());
            string2 = contextName.getBaseName();
            String string3 = System.getProperty("java.io.tmpdir");
            File file2 = new File(string3);
            if (!file2.isDirectory()) {
                log.error((Object)sm.getString("contextConfig.noAntiLocking", new Object[]{string3, this.context.getName()}));
                return;
            }
            this.antiLockingDocBase = this.originalDocBase.toLowerCase(Locale.ENGLISH).endsWith(".war") ? new File(file2, deploymentCount++ + "-" + string2 + ".war") : new File(file2, deploymentCount++ + "-" + string2);
            this.antiLockingDocBase = this.antiLockingDocBase.getAbsoluteFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Anti locking context[" + this.context.getName() + "] setting docBase to " + this.antiLockingDocBase.getPath()));
            }
            ExpandWar.delete(this.antiLockingDocBase);
            if (ExpandWar.copy(file, this.antiLockingDocBase)) {
                this.context.setDocBase(this.antiLockingDocBase.getPath());
            }
        }
    }

    protected synchronized void init() {
        Digester digester = null;
        if (!this.getUseGeneratedCode()) {
            digester = this.createContextDigester();
            digester.getParser();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.init"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        this.contextConfig(digester);
    }

    protected synchronized void beforeStart() {
        try {
            this.fixDocBase();
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("contextConfig.fixDocBase", new Object[]{this.context.getName()}), (Throwable)iOException);
        }
        this.antiLocking();
    }

    protected synchronized void configureStart() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.start"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.xmlSettings", new Object[]{this.context.getName(), this.context.getXmlValidation(), this.context.getXmlNamespaceAware()}));
        }
        this.webConfig();
        if (!this.context.getIgnoreAnnotations()) {
            this.applicationAnnotationsConfig();
        }
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pipeline Configuration:");
            Pipeline pipeline = this.context.getPipeline();
            Valve[] valveArray = null;
            if (pipeline != null) {
                valveArray = pipeline.getValves();
            }
            if (valveArray != null) {
                for (Valve valve : valveArray) {
                    log.debug((Object)("  " + valve.getClass().getName()));
                }
            }
            log.debug((Object)"======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    protected synchronized void configureStop() {
        int n;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.stop"));
        }
        Container[] containerArray = this.context.findChildren();
        for (n = 0; n < containerArray.length; ++n) {
            this.context.removeChild(containerArray[n]);
        }
        SecurityConstraint[] securityConstraintArray = this.context.findConstraints();
        for (n = 0; n < securityConstraintArray.length; ++n) {
            this.context.removeConstraint(securityConstraintArray[n]);
        }
        ErrorPage[] errorPageArray = this.context.findErrorPages();
        for (n = 0; n < errorPageArray.length; ++n) {
            this.context.removeErrorPage(errorPageArray[n]);
        }
        FilterDef[] filterDefArray = this.context.findFilterDefs();
        for (n = 0; n < filterDefArray.length; ++n) {
            this.context.removeFilterDef(filterDefArray[n]);
        }
        FilterMap[] filterMapArray = this.context.findFilterMaps();
        for (n = 0; n < filterMapArray.length; ++n) {
            this.context.removeFilterMap(filterMapArray[n]);
        }
        String[] stringArray = this.context.findMimeMappings();
        for (n = 0; n < stringArray.length; ++n) {
            this.context.removeMimeMapping(stringArray[n]);
        }
        String[] stringArray2 = this.context.findParameters();
        for (n = 0; n < stringArray2.length; ++n) {
            this.context.removeParameter(stringArray2[n]);
        }
        String[] stringArray3 = this.context.findSecurityRoles();
        for (n = 0; n < stringArray3.length; ++n) {
            this.context.removeSecurityRole(stringArray3[n]);
        }
        String[] stringArray4 = this.context.findServletMappings();
        for (n = 0; n < stringArray4.length; ++n) {
            this.context.removeServletMapping(stringArray4[n]);
        }
        String[] stringArray5 = this.context.findWelcomeFiles();
        for (n = 0; n < stringArray5.length; ++n) {
            this.context.removeWelcomeFile(stringArray5[n]);
        }
        String[] stringArray6 = this.context.findWrapperLifecycles();
        for (n = 0; n < stringArray6.length; ++n) {
            this.context.removeWrapperLifecycle(stringArray6[n]);
        }
        String[] stringArray7 = this.context.findWrapperListeners();
        for (n = 0; n < stringArray7.length; ++n) {
            this.context.removeWrapperListener(stringArray7[n]);
        }
        if (this.antiLockingDocBase != null) {
            ExpandWar.delete(this.antiLockingDocBase, false);
        }
        this.initializerClassMap.clear();
        this.typeInitializerMap.clear();
        this.ok = true;
    }

    protected synchronized void destroy() {
        String string;
        Server server;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.destroy"));
        }
        if ((server = this.getServer()) != null && !server.getState().isAvailable()) {
            return;
        }
        if (this.context instanceof StandardContext && (string = ((StandardContext)this.context).getWorkPath()) != null) {
            ExpandWar.delete(new File(string));
        }
    }

    private Server getServer() {
        Container container;
        for (container = this.context; container != null && !(container instanceof Engine); container = container.getParent()) {
        }
        if (container == null) {
            return null;
        }
        Service service = ((Engine)container).getService();
        if (service == null) {
            return null;
        }
        return service.getServer();
    }

    protected void validateSecurityRoles() {
        SecurityConstraint[] securityConstraintArray;
        Object[] objectArray = securityConstraintArray = this.context.findConstraints();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            SecurityConstraint securityConstraint = objectArray[i];
            SecurityConstraint securityConstraint2 = securityConstraint.findAuthRoles();
            for (String[] stringArray : securityConstraint2) {
                if ("*".equals(stringArray) || this.context.findSecurityRole((String)stringArray)) continue;
                log.warn((Object)sm.getString("contextConfig.role.auth", new Object[]{stringArray}));
                this.context.addSecurityRole((String)stringArray);
            }
        }
        for (SecurityConstraint securityConstraint2 : objectArray = this.context.findChildren()) {
            String[] stringArray;
            Wrapper wrapper = (Wrapper)securityConstraint2;
            String string = wrapper.getRunAs();
            if (string != null && !this.context.findSecurityRole(string)) {
                log.warn((Object)sm.getString("contextConfig.role.runas", new Object[]{string}));
                this.context.addSecurityRole(string);
            }
            for (String string2 : stringArray = wrapper.findSecurityReferences()) {
                String string3 = wrapper.findSecurityReference(string2);
                if (string3 == null || this.context.findSecurityRole(string3)) continue;
                log.warn((Object)sm.getString("contextConfig.role.link", new Object[]{string3}));
                this.context.addSecurityRole(string3);
            }
        }
    }

    protected File getHostConfigBase() {
        File file = null;
        if (this.context.getParent() instanceof Host) {
            file = ((Host)this.context.getParent()).getConfigBaseFile();
        }
        return file;
    }

    protected void webConfig() {
        WebXmlParser webXmlParser = new WebXmlParser(this.context.getXmlNamespaceAware(), this.context.getXmlValidation(), this.context.getXmlBlockExternal());
        HashSet<WebXml> hashSet = new HashSet<WebXml>();
        hashSet.add(this.getDefaultWebXmlFragment(webXmlParser));
        HashSet<WebXml> hashSet2 = new HashSet<WebXml>();
        hashSet2.add(this.getTomcatWebXmlFragment(webXmlParser));
        WebXml webXml = this.createWebXml();
        InputSource inputSource = this.getContextWebXmlSource();
        if (!webXmlParser.parseWebXml(inputSource, webXml, false)) {
            this.ok = false;
        }
        ServletContext servletContext = this.context.getServletContext();
        Map<String, WebXml> map = this.processJarsForWebFragments(webXml, webXmlParser);
        Set set = null;
        set = WebXml.orderWebFragments((WebXml)webXml, map, (ServletContext)servletContext);
        if (this.ok) {
            this.processServletContainerInitializers();
        }
        if (!webXml.isMetadataComplete() || this.typeInitializerMap.size() > 0) {
            this.processClasses(webXml, set);
        }
        if (!webXml.isMetadataComplete()) {
            if (this.ok) {
                this.ok = webXml.merge(set);
            }
            webXml.merge(hashSet2);
            webXml.merge(hashSet);
            if (this.ok) {
                this.convertJsps(webXml);
            }
            if (this.ok) {
                this.configureContext(webXml);
            }
        } else {
            webXml.merge(hashSet2);
            webXml.merge(hashSet);
            this.convertJsps(webXml);
            this.configureContext(webXml);
        }
        if (this.context.getLogEffectiveWebXml()) {
            log.info((Object)sm.getString("contextConfig.effectiveWebXml", new Object[]{webXml.toXml()}));
        }
        if (this.ok) {
            LinkedHashSet linkedHashSet = new LinkedHashSet(set);
            for (WebXml webXml2 : map.values()) {
                if (linkedHashSet.contains(webXml2)) continue;
                linkedHashSet.add(webXml2);
            }
            this.processResourceJARs(linkedHashSet);
        }
        if (this.ok) {
            for (Map.Entry entry : this.initializerClassMap.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) {
                    this.context.addServletContainerInitializer((ServletContainerInitializer)entry.getKey(), null);
                    continue;
                }
                this.context.addServletContainerInitializer((ServletContainerInitializer)entry.getKey(), (Set)entry.getValue());
            }
        }
    }

    protected void processClasses(WebXml webXml, Set<WebXml> set) {
        AbstractMap abstractMap = this.context.getParallelAnnotationScanning() ? new ConcurrentHashMap() : new HashMap();
        if (this.ok) {
            WebResource[] webResourceArray;
            for (WebResource webResource : webResourceArray = this.context.getResources().listResources("/WEB-INF/classes")) {
                if ("META-INF".equals(webResource.getName())) continue;
                this.processAnnotationsWebResource(webResource, webXml, webXml.isMetadataComplete(), abstractMap);
            }
        }
        if (this.ok) {
            this.processAnnotations(set, webXml.isMetadataComplete(), abstractMap);
        }
        abstractMap.clear();
    }

    private void configureContext(WebXml webXml) {
        Object object;
        this.context.setPublicId(webXml.getPublicId());
        this.context.setEffectiveMajorVersion(webXml.getMajorVersion());
        this.context.setEffectiveMinorVersion(webXml.getMinorVersion());
        for (Map.Entry object32 : webXml.getContextParams().entrySet()) {
            this.context.addParameter((String)object32.getKey(), (String)object32.getValue());
        }
        this.context.setDenyUncoveredHttpMethods(webXml.getDenyUncoveredHttpMethods());
        this.context.setDisplayName(webXml.getDisplayName());
        this.context.setDistributable(webXml.isDistributable());
        for (ContextLocalEjb contextLocalEjb : webXml.getEjbLocalRefs().values()) {
            this.context.getNamingResources().addLocalEjb(contextLocalEjb);
        }
        for (ContextEjb contextEjb : webXml.getEjbRefs().values()) {
            this.context.getNamingResources().addEjb(contextEjb);
        }
        for (ContextEnvironment contextEnvironment : webXml.getEnvEntries().values()) {
            this.context.getNamingResources().addEnvironment(contextEnvironment);
        }
        for (ErrorPage errorPage : webXml.getErrorPages().values()) {
            this.context.addErrorPage(errorPage);
        }
        for (FilterDef filterDef : webXml.getFilters().values()) {
            if (filterDef.getAsyncSupported() == null) {
                filterDef.setAsyncSupported("false");
            }
            this.context.addFilterDef(filterDef);
        }
        for (FilterMap filterMap : webXml.getFilterMappings()) {
            this.context.addFilterMap(filterMap);
        }
        this.context.setJspConfigDescriptor(webXml.getJspConfigDescriptor());
        for (String string : webXml.getListeners()) {
            this.context.addApplicationListener(string);
        }
        for (Map.Entry entry : webXml.getLocaleEncodingMappings().entrySet()) {
            this.context.addLocaleEncodingMappingParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (webXml.getLoginConfig() != null) {
            this.context.setLoginConfig(webXml.getLoginConfig());
        }
        for (MessageDestinationRef messageDestinationRef : webXml.getMessageDestinationRefs().values()) {
            this.context.getNamingResources().addMessageDestinationRef(messageDestinationRef);
        }
        this.context.setIgnoreAnnotations(webXml.isMetadataComplete());
        for (Map.Entry entry : webXml.getMimeMappings().entrySet()) {
            this.context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
        }
        this.context.setRequestCharacterEncoding(webXml.getRequestCharacterEncoding());
        for (ContextResourceEnvRef contextResourceEnvRef : webXml.getResourceEnvRefs().values()) {
            this.context.getNamingResources().addResourceEnvRef(contextResourceEnvRef);
        }
        for (ContextResource contextResource : webXml.getResourceRefs().values()) {
            this.context.getNamingResources().addResource(contextResource);
        }
        this.context.setResponseCharacterEncoding(webXml.getResponseCharacterEncoding());
        boolean bl = webXml.getSecurityRoles().contains("**");
        for (SecurityConstraint securityConstraint : webXml.getSecurityConstraints()) {
            if (bl) {
                securityConstraint.treatAllAuthenticatedUsersAsApplicationRole();
            }
            this.context.addConstraint(securityConstraint);
        }
        for (String string : webXml.getSecurityRoles()) {
            this.context.addSecurityRole(string);
        }
        for (ContextService contextService : webXml.getServiceRefs().values()) {
            this.context.getNamingResources().addService(contextService);
        }
        for (ServletDef servletDef : webXml.getServlets().values()) {
            Wrapper wrapper = this.context.createWrapper();
            if (servletDef.getLoadOnStartup() != null) {
                wrapper.setLoadOnStartup(servletDef.getLoadOnStartup());
            }
            if (servletDef.getEnabled() != null) {
                wrapper.setEnabled(servletDef.getEnabled());
            }
            wrapper.setName(servletDef.getServletName());
            object = servletDef.getParameterMap();
            for (Map.Entry entry : object.entrySet()) {
                wrapper.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
            wrapper.setRunAs(servletDef.getRunAs());
            Set set = servletDef.getSecurityRoleRefs();
            for (SecurityRoleRef securityRoleRef : set) {
                wrapper.addSecurityReference(securityRoleRef.getName(), securityRoleRef.getLink());
            }
            wrapper.setServletClass(servletDef.getServletClass());
            MultipartDef multipartDef = servletDef.getMultipartDef();
            if (multipartDef != null) {
                long l = -1L;
                long l2 = -1L;
                int n = 0;
                if (null != multipartDef.getMaxFileSize()) {
                    l = Long.parseLong(multipartDef.getMaxFileSize());
                }
                if (null != multipartDef.getMaxRequestSize()) {
                    l2 = Long.parseLong(multipartDef.getMaxRequestSize());
                }
                if (null != multipartDef.getFileSizeThreshold()) {
                    n = Integer.parseInt(multipartDef.getFileSizeThreshold());
                }
                wrapper.setMultipartConfigElement(new MultipartConfigElement(multipartDef.getLocation(), l, l2, n));
            }
            if (servletDef.getAsyncSupported() != null) {
                wrapper.setAsyncSupported(servletDef.getAsyncSupported());
            }
            wrapper.setOverridable(servletDef.isOverridable());
            this.context.addChild(wrapper);
        }
        for (Map.Entry entry : webXml.getServletMappings().entrySet()) {
            this.context.addServletMappingDecoded((String)entry.getKey(), (String)entry.getValue());
        }
        SessionConfig sessionConfig = webXml.getSessionConfig();
        if (sessionConfig != null) {
            if (sessionConfig.getSessionTimeout() != null) {
                this.context.setSessionTimeout(sessionConfig.getSessionTimeout());
            }
            SessionCookieConfig sessionCookieConfig = this.context.getServletContext().getSessionCookieConfig();
            sessionCookieConfig.setName(sessionConfig.getCookieName());
            Map map = sessionConfig.getCookieAttributes();
            for (Map.Entry entry : map.entrySet()) {
                sessionCookieConfig.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            if (sessionConfig.getSessionTrackingModes().size() > 0) {
                this.context.getServletContext().setSessionTrackingModes((Set)sessionConfig.getSessionTrackingModes());
            }
        }
        for (String string : webXml.getWelcomeFiles()) {
            if (string == null || string.length() <= 0) continue;
            this.context.addWelcomeFile(string);
        }
        for (JspPropertyGroup jspPropertyGroup : webXml.getJspPropertyGroups()) {
            object = this.context.findServletMapping("*.jsp");
            if (object == null) {
                object = "jsp";
            }
            if (this.context.findChild((String)object) != null) {
                for (String string : jspPropertyGroup.getUrlPatterns()) {
                    this.context.addServletMappingDecoded(string, (String)object, true);
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            for (String string : jspPropertyGroup.getUrlPatterns()) {
                log.debug((Object)("Skipping " + string + " , no servlet " + (String)object));
            }
        }
        for (Map.Entry entry : webXml.getPostConstructMethods().entrySet()) {
            this.context.addPostConstructMethod((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : webXml.getPreDestroyMethods().entrySet()) {
            this.context.addPreDestroyMethod((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private WebXml getTomcatWebXmlFragment(WebXmlParser webXmlParser) {
        WebXml webXml = this.createWebXml();
        webXml.setOverridable(true);
        webXml.setDistributable(true);
        webXml.setAlwaysAddWelcomeFiles(false);
        WebResource webResource = this.context.getResources().getResource("/WEB-INF/tomcat-web.xml");
        if (webResource.isFile()) {
            try {
                InputSource inputSource = new InputSource(webResource.getURL().toURI().toString());
                inputSource.setByteStream(webResource.getInputStream());
                if (!webXmlParser.parseWebXml(inputSource, webXml, false)) {
                    this.ok = false;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                log.error((Object)sm.getString("contextConfig.tomcatWebXmlError"), (Throwable)uRISyntaxException);
            }
        }
        return webXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebXml getDefaultWebXmlFragment(WebXmlParser webXmlParser) {
        URL uRL;
        URI uRI;
        Object object;
        Host host = (Host)this.context.getParent();
        DefaultWebXmlCacheEntry defaultWebXmlCacheEntry = hostWebXmlCache.get(host);
        InputSource inputSource = this.getGlobalWebXmlSource();
        InputSource inputSource2 = this.getHostWebXmlSource();
        long l = 0L;
        long l2 = 0L;
        if (inputSource != null) {
            object = null;
            try {
                uRI = new URI(inputSource.getSystemId());
                uRL = uRI.toURL();
                object = uRL.openConnection();
                l = ((URLConnection)object).getLastModified();
            }
            catch (IOException | IllegalArgumentException | URISyntaxException exception) {
                l = -1L;
            }
            finally {
                if (object != null) {
                    try {
                        ((URLConnection)object).getInputStream().close();
                    }
                    catch (IOException iOException) {
                        ExceptionUtils.handleThrowable((Throwable)iOException);
                        l = -1L;
                    }
                }
            }
        }
        if (inputSource2 != null) {
            object = null;
            try {
                uRI = new URI(inputSource2.getSystemId());
                uRL = uRI.toURL();
                object = uRL.openConnection();
                l2 = ((URLConnection)object).getLastModified();
            }
            catch (IOException | IllegalArgumentException | URISyntaxException exception) {
                l2 = -1L;
            }
            finally {
                if (object != null) {
                    try {
                        ((URLConnection)object).getInputStream().close();
                    }
                    catch (IOException iOException) {
                        ExceptionUtils.handleThrowable((Throwable)iOException);
                        l2 = -1L;
                    }
                }
            }
        }
        if (defaultWebXmlCacheEntry != null && defaultWebXmlCacheEntry.getGlobalTimeStamp() == l && defaultWebXmlCacheEntry.getHostTimeStamp() == l2) {
            InputSourceUtil.close((InputSource)inputSource);
            InputSourceUtil.close((InputSource)inputSource2);
            return defaultWebXmlCacheEntry.getWebXml();
        }
        object = host.getPipeline();
        synchronized (object) {
            defaultWebXmlCacheEntry = hostWebXmlCache.get(host);
            if (defaultWebXmlCacheEntry != null && defaultWebXmlCacheEntry.getGlobalTimeStamp() == l && defaultWebXmlCacheEntry.getHostTimeStamp() == l2) {
                return defaultWebXmlCacheEntry.getWebXml();
            }
            uRI = this.createWebXml();
            uRI.setOverridable(true);
            uRI.setDistributable(true);
            uRI.setAlwaysAddWelcomeFiles(false);
            if (inputSource == null) {
                log.info((Object)sm.getString("contextConfig.defaultMissing"));
            } else if (!webXmlParser.parseWebXml(inputSource, (WebXml)uRI, false)) {
                this.ok = false;
            }
            uRI.setReplaceWelcomeFiles(true);
            if (!webXmlParser.parseWebXml(inputSource2, (WebXml)uRI, false)) {
                this.ok = false;
            }
            if (l != -1L && l2 != -1L) {
                defaultWebXmlCacheEntry = new DefaultWebXmlCacheEntry((WebXml)uRI, l, l2);
                hostWebXmlCache.put(host, defaultWebXmlCacheEntry);
                host.addLifecycleListener(new HostWebXmlCacheCleaner());
            }
            return uRI;
        }
    }

    private void convertJsps(WebXml webXml) {
        HashMap<String, String> hashMap;
        ServletDef servletDef = (ServletDef)webXml.getServlets().get("jsp");
        if (servletDef == null) {
            hashMap = new HashMap<String, String>();
            Wrapper wrapper = (Wrapper)this.context.findChild("jsp");
            if (wrapper != null) {
                ServletDef servletDef2;
                for (ServletDef servletDef3 : servletDef2 = wrapper.findInitParameters()) {
                    hashMap.put((String)servletDef3, wrapper.findInitParameter((String)servletDef3));
                }
            }
        } else {
            hashMap = servletDef.getParameterMap();
        }
        for (ServletDef servletDef2 : webXml.getServlets().values()) {
            if (servletDef2.getJspFile() == null) continue;
            this.convertJsp(servletDef2, hashMap);
        }
    }

    private void convertJsp(ServletDef servletDef, Map<String, String> map) {
        servletDef.setServletClass("org.apache.jasper.servlet.JspServlet");
        Object object = servletDef.getJspFile();
        if (object != null && !((String)object).startsWith("/")) {
            if (this.context.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("contextConfig.jspFile.warning", new Object[]{object}));
                }
                object = "/" + (String)object;
            } else {
                throw new IllegalArgumentException(sm.getString("contextConfig.jspFile.error", new Object[]{object}));
            }
        }
        servletDef.getParameterMap().put("jspFile", object);
        servletDef.setJspFile(null);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            servletDef.addInitParameter(entry.getKey(), entry.getValue());
        }
    }

    protected WebXml createWebXml() {
        return new WebXml();
    }

    protected void processServletContainerInitializers() {
        List<ServletContainerInitializer> list;
        try {
            WebappServiceLoader<ServletContainerInitializer> webappServiceLoader = new WebappServiceLoader<ServletContainerInitializer>(this.context);
            list = webappServiceLoader.load(ServletContainerInitializer.class);
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("contextConfig.servletContainerInitializerFail", new Object[]{this.context.getName()}), (Throwable)iOException);
            this.ok = false;
            return;
        }
        for (ServletContainerInitializer servletContainerInitializer : list) {
            Class[] classArray;
            HandlesTypes handlesTypes;
            this.initializerClassMap.put(servletContainerInitializer, new HashSet());
            try {
                handlesTypes = servletContainerInitializer.getClass().getAnnotation(HandlesTypes.class);
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.info((Object)sm.getString("contextConfig.sci.debug", new Object[]{servletContainerInitializer.getClass().getName()}), (Throwable)exception);
                    continue;
                }
                log.info((Object)sm.getString("contextConfig.sci.info", new Object[]{servletContainerInitializer.getClass().getName()}));
                continue;
            }
            if (handlesTypes == null || (classArray = handlesTypes.value()) == null) continue;
            for (Class clazz2 : classArray) {
                if (clazz2.isAnnotation()) {
                    this.handlesTypesAnnotations = true;
                } else {
                    this.handlesTypesNonAnnotations = true;
                }
                this.typeInitializerMap.computeIfAbsent(clazz2, clazz -> new HashSet()).add(servletContainerInitializer);
            }
        }
    }

    protected void processResourceJARs(Set<WebXml> set) {
        block7: for (WebXml webXml : set) {
            URL uRL = webXml.getURL();
            try {
                Object object;
                Object object2;
                if ("jar".equals(uRL.getProtocol()) || uRL.toString().endsWith(".jar")) {
                    object2 = JarFactory.newInstance((URL)uRL);
                    try {
                        object2.nextEntry();
                        object = object2.getEntryName();
                        while (object != null) {
                            if (((String)object).startsWith("META-INF/resources/")) {
                                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", uRL, "/META-INF/resources");
                                continue block7;
                            }
                            object2.nextEntry();
                            object = object2.getEntryName();
                        }
                        continue;
                    }
                    finally {
                        if (object2 != null) {
                            object2.close();
                        }
                        continue;
                    }
                }
                if (!"file".equals(uRL.getProtocol()) || !((File)(object = new File((File)(object2 = new File(uRL.toURI())), "META-INF/resources/"))).isDirectory()) continue;
                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", ((File)object).getAbsolutePath(), null, "/");
            }
            catch (IOException | URISyntaxException exception) {
                log.error((Object)sm.getString("contextConfig.resourceJarFail", new Object[]{uRL, this.context.getName()}));
            }
        }
    }

    protected InputSource getGlobalWebXmlSource() {
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if ("org/apache/catalina/startup/NO_DEFAULT_XML".equals(this.defaultWebXml)) {
            return null;
        }
        return this.getWebXmlSource(this.defaultWebXml, true);
    }

    protected InputSource getHostWebXmlSource() {
        File file = this.getHostConfigBase();
        if (file == null) {
            return null;
        }
        return this.getWebXmlSource(file.getPath(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputSource getContextWebXmlSource() {
        InputStream inputStream = null;
        InputSource inputSource = null;
        URL uRL = null;
        String string = null;
        ServletContext servletContext = this.context.getServletContext();
        try {
            if (servletContext != null) {
                string = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
                if (string != null) {
                    try {
                        inputStream = new FileInputStream(string);
                        uRL = new File(string).toURI().toURL();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error((Object)sm.getString("contextConfig.altDDNotFound", new Object[]{string}));
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("contextConfig.applicationUrl"));
                    }
                } else {
                    inputStream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
                    try {
                        uRL = servletContext.getResource("/WEB-INF/web.xml");
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("contextConfig.applicationUrl"));
                    }
                }
            }
            if (inputStream == null || uRL == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sm.getString("contextConfig.applicationMissing") + " " + this.context));
                }
            } else {
                inputSource = new InputSource(uRL.toExternalForm());
                inputSource.setByteStream(inputStream);
            }
        }
        finally {
            if (inputSource == null && inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return inputSource;
    }

    public String getConfigBasePath() {
        String string = null;
        if (this.context.getParent() instanceof Host) {
            Host host = (Host)this.context.getParent();
            if (host.getXmlBase() != null) {
                string = host.getXmlBase();
            } else {
                StringBuilder stringBuilder = new StringBuilder("conf");
                Container container = host.getParent();
                if (container instanceof Engine) {
                    stringBuilder.append('/');
                    stringBuilder.append(container.getName());
                }
                stringBuilder.append('/');
                stringBuilder.append(host.getName());
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputSource getWebXmlSource(String string, boolean bl) {
        Object object;
        ConfigurationSource.Resource resource = null;
        try {
            if (bl) {
                resource = "conf/web.xml".equals(string) ? ConfigFileLoader.getSource().getSharedWebXml() : ConfigFileLoader.getSource().getResource(string);
            } else {
                object = Container.getConfigPath(this.context, "web.xml.default");
                resource = ConfigFileLoader.getSource().getResource((String)object);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        object = null;
        InputSource inputSource = null;
        try {
            object = resource.getInputStream();
            inputSource = new InputSource(resource.getURI().toString());
            if (object != null) {
                inputSource.setByteStream((InputStream)object);
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("contextConfig.defaultError", new Object[]{string, resource.getURI()}), (Throwable)exception);
        }
        finally {
            if (inputSource == null && object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
        return inputSource;
    }

    protected Map<String, WebXml> processJarsForWebFragments(WebXml webXml, WebXmlParser webXmlParser) {
        JarScanner jarScanner = this.context.getJarScanner();
        boolean bl = false;
        if (this.context instanceof StandardContext) {
            bl = ((StandardContext)this.context).getDelegate();
        }
        boolean bl2 = true;
        Set set = webXml.getAbsoluteOrdering();
        if (set != null && set.isEmpty() && !this.context.getXmlValidation()) {
            bl2 = false;
        }
        FragmentJarScannerCallback fragmentJarScannerCallback = new FragmentJarScannerCallback(webXmlParser, bl, bl2);
        jarScanner.scan(JarScanType.PLUGGABILITY, this.context.getServletContext(), (JarScannerCallback)fragmentJarScannerCallback);
        if (!fragmentJarScannerCallback.isOk()) {
            this.ok = false;
        }
        return fragmentJarScannerCallback.getFragments();
    }

    protected void processAnnotations(Set<WebXml> set, boolean bl, Map<String, JavaClassCacheEntry> map) {
        if (this.context.getParallelAnnotationScanning()) {
            this.processAnnotationsInParallel(set, bl, map);
        } else {
            for (WebXml webXml : set) {
                this.scanWebXmlFragment(bl, webXml, map);
            }
        }
    }

    private void scanWebXmlFragment(boolean bl, WebXml webXml, Map<String, JavaClassCacheEntry> map) {
        boolean bl2 = bl || !webXml.getWebappJar() || webXml.isMetadataComplete();
        WebXml webXml2 = new WebXml();
        webXml2.setDistributable(true);
        URL uRL = webXml.getURL();
        this.processAnnotationsUrl(uRL, webXml2, bl2, map);
        HashSet<WebXml> hashSet = new HashSet<WebXml>();
        hashSet.add(webXml2);
        webXml.merge(hashSet);
    }

    protected void processAnnotationsInParallel(Set<WebXml> set, boolean bl, Map<String, JavaClassCacheEntry> map) {
        ScheduledExecutorService scheduledExecutorService;
        Server server = this.getServer();
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService = server == null ? null : server.getUtilityExecutor();
        if (scheduledExecutorService != null) {
            ArrayList arrayList = new ArrayList(set.size());
            for (WebXml object : set) {
                AnnotationScanTask annotationScanTask = new AnnotationScanTask(object, bl, map);
                arrayList.add(scheduledExecutorService.submit(annotationScanTask));
            }
            try {
                for (Future future : arrayList) {
                    future.get();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(sm.getString("contextConfig.processAnnotationsInParallelFailure"), exception);
            }
        } else {
            for (WebXml webXml : set) {
                this.scanWebXmlFragment(bl, webXml, map);
            }
        }
    }

    protected void processAnnotationsWebResource(WebResource webResource, WebXml webXml, boolean bl, Map<String, JavaClassCacheEntry> map) {
        if (webResource.isDirectory()) {
            WebResource[] webResourceArray = webResource.getWebResourceRoot().listResources(webResource.getWebappPath());
            if (webResourceArray.length > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("contextConfig.processAnnotationsWebDir.debug", new Object[]{webResource.getURL()}));
                }
                for (WebResource webResource2 : webResourceArray) {
                    this.processAnnotationsWebResource(webResource2, webXml, bl, map);
                }
            }
        } else if (webResource.isFile() && webResource.getName().endsWith(".class")) {
            try (InputStream inputStream = webResource.getInputStream();){
                this.processAnnotationsStream(inputStream, webXml, bl, map);
            }
            catch (IOException | ClassFormatException throwable) {
                log.error((Object)sm.getString("contextConfig.inputStreamWebResource", new Object[]{webResource.getWebappPath()}), throwable);
            }
        }
    }

    protected void processAnnotationsUrl(URL uRL, WebXml webXml, boolean bl, Map<String, JavaClassCacheEntry> map) {
        if (uRL == null) {
            return;
        }
        if ("jar".equals(uRL.getProtocol()) || uRL.toString().endsWith(".jar")) {
            this.processAnnotationsJar(uRL, webXml, bl, map);
        } else if ("file".equals(uRL.getProtocol())) {
            try {
                this.processAnnotationsFile(new File(uRL.toURI()), webXml, bl, map);
            }
            catch (URISyntaxException uRISyntaxException) {
                log.error((Object)sm.getString("contextConfig.fileUrl", new Object[]{uRL}), (Throwable)uRISyntaxException);
            }
        } else {
            log.error((Object)sm.getString("contextConfig.unknownUrlProtocol", new Object[]{uRL.getProtocol(), uRL}));
        }
    }

    protected void processAnnotationsJar(URL uRL, WebXml webXml, boolean bl, Map<String, JavaClassCacheEntry> map) {
        try (Jar jar = JarFactory.newInstance((URL)uRL);){
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.processAnnotationsJar.debug", new Object[]{uRL}));
            }
            jar.nextEntry();
            String string = jar.getEntryName();
            while (string != null) {
                if (string.endsWith(".class")) {
                    try (InputStream inputStream = jar.getEntryInputStream();){
                        this.processAnnotationsStream(inputStream, webXml, bl, map);
                    }
                    catch (IOException | ClassFormatException throwable) {
                        log.error((Object)sm.getString("contextConfig.inputStreamJar", new Object[]{string, uRL}), throwable);
                    }
                }
                jar.nextEntry();
                string = jar.getEntryName();
            }
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("contextConfig.jarFile", new Object[]{uRL}), (Throwable)iOException);
        }
    }

    protected void processAnnotationsFile(File file, WebXml webXml, boolean bl, Map<String, JavaClassCacheEntry> map) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("contextConfig.processAnnotationsDir.debug", new Object[]{file}));
                }
                for (String string : stringArray) {
                    this.processAnnotationsFile(new File(file, string), webXml, bl, map);
                }
            }
        } else if (file.getName().endsWith(".class") && file.canRead()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.processAnnotationsStream(fileInputStream, webXml, bl, map);
            }
            catch (IOException | ClassFormatException throwable) {
                log.error((Object)sm.getString("contextConfig.inputStreamFile", new Object[]{file.getAbsolutePath()}), throwable);
            }
        }
    }

    protected void processAnnotationsStream(InputStream inputStream, WebXml webXml, boolean bl, Map<String, JavaClassCacheEntry> map) throws ClassFormatException, IOException {
        ClassParser classParser = new ClassParser(inputStream);
        JavaClass javaClass = classParser.parse();
        this.checkHandlesTypes(javaClass, map);
        if (bl) {
            return;
        }
        this.processClass(webXml, javaClass);
    }

    protected void processClass(WebXml webXml, JavaClass javaClass) {
        AnnotationEntry[] annotationEntryArray = javaClass.getAnnotationEntries();
        if (annotationEntryArray != null) {
            String string = javaClass.getClassName();
            for (AnnotationEntry annotationEntry : annotationEntryArray) {
                String string2 = annotationEntry.getAnnotationType();
                if ("Ljakarta/servlet/annotation/WebServlet;".equals(string2)) {
                    this.processAnnotationWebServlet(string, annotationEntry, webXml);
                    continue;
                }
                if ("Ljakarta/servlet/annotation/WebFilter;".equals(string2)) {
                    this.processAnnotationWebFilter(string, annotationEntry, webXml);
                    continue;
                }
                if (!"Ljakarta/servlet/annotation/WebListener;".equals(string2)) continue;
                webXml.addListener(string);
            }
        }
    }

    protected void checkHandlesTypes(JavaClass javaClass, Map<String, JavaClassCacheEntry> map) {
        Object object;
        Object object2;
        if (this.typeInitializerMap.size() == 0) {
            return;
        }
        if ((javaClass.getAccessFlags() & 0x2000) != 0) {
            return;
        }
        String string = javaClass.getClassName();
        Class<?> clazz = null;
        if (this.handlesTypesNonAnnotations) {
            this.populateJavaClassCache(string, javaClass, map);
            object2 = map.get(string);
            if (((JavaClassCacheEntry)object2).getSciSet() == null) {
                try {
                    this.populateSCIsForCacheEntry((JavaClassCacheEntry)object2, map);
                }
                catch (StackOverflowError stackOverflowError) {
                    throw new IllegalStateException(sm.getString("contextConfig.annotationsStackOverflow", new Object[]{this.context.getName(), this.classHierarchyToString(string, (JavaClassCacheEntry)object2, map)}));
                }
            }
            if (!((JavaClassCacheEntry)object2).getSciSet().isEmpty()) {
                clazz = Introspection.loadClass(this.context, string);
                if (clazz == null) {
                    return;
                }
                for (ServletContainerInitializer servletContainerInitializer2 : ((JavaClassCacheEntry)object2).getSciSet()) {
                    object = this.initializerClassMap.computeIfAbsent(servletContainerInitializer2, servletContainerInitializer -> new HashSet());
                    object.add(clazz);
                }
            }
        }
        if (this.handlesTypesAnnotations && (object2 = javaClass.getAllAnnotationEntries()) != null) {
            block3: for (Map.Entry<Class<?>, Set<ServletContainerInitializer>> entry : this.typeInitializerMap.entrySet()) {
                if (!entry.getKey().isAnnotation()) continue;
                object = entry.getKey().getName();
                for (Object object3 : object2) {
                    if (!((String)object).equals(ContextConfig.getClassName(object3.getAnnotationType()))) continue;
                    if (clazz == null && (clazz = Introspection.loadClass(this.context, string)) == null) {
                        return;
                    }
                    for (ServletContainerInitializer servletContainerInitializer2 : entry.getValue()) {
                        this.initializerClassMap.get(servletContainerInitializer2).add(clazz);
                    }
                    continue block3;
                }
            }
        }
    }

    private String classHierarchyToString(String string, JavaClassCacheEntry javaClassCacheEntry, Map<String, JavaClassCacheEntry> map) {
        JavaClassCacheEntry javaClassCacheEntry2 = javaClassCacheEntry;
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("->");
        String string2 = javaClassCacheEntry.getSuperclassName();
        JavaClassCacheEntry javaClassCacheEntry3 = map.get(string2);
        for (int i = 0; i < 100 && javaClassCacheEntry3 != null && javaClassCacheEntry3 != javaClassCacheEntry2; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("->");
            string2 = javaClassCacheEntry3.getSuperclassName();
            javaClassCacheEntry3 = map.get(string2);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void populateJavaClassCache(String string, JavaClass javaClass, Map<String, JavaClassCacheEntry> map) {
        if (map.containsKey(string)) {
            return;
        }
        map.put(string, new JavaClassCacheEntry(javaClass));
        this.populateJavaClassCache(javaClass.getSuperclassName(), map);
        for (String string2 : javaClass.getInterfaceNames()) {
            this.populateJavaClassCache(string2, map);
        }
    }

    private void populateJavaClassCache(String string, Map<String, JavaClassCacheEntry> map) {
        if (!map.containsKey(string)) {
            String string2 = string.replace('.', '/') + ".class";
            try (InputStream inputStream = this.context.getLoader().getClassLoader().getResourceAsStream(string2);){
                if (inputStream == null) {
                    return;
                }
                ClassParser classParser = new ClassParser(inputStream);
                JavaClass javaClass = classParser.parse();
                this.populateJavaClassCache(javaClass.getClassName(), javaClass, map);
            }
            catch (IOException | ClassFormatException throwable) {
                log.debug((Object)sm.getString("contextConfig.invalidSciHandlesTypes", new Object[]{string}), throwable);
            }
        }
    }

    private void populateSCIsForCacheEntry(JavaClassCacheEntry javaClassCacheEntry, Map<String, JavaClassCacheEntry> map) {
        HashSet<ServletContainerInitializer> hashSet = new HashSet<ServletContainerInitializer>();
        String string = javaClassCacheEntry.getSuperclassName();
        JavaClassCacheEntry javaClassCacheEntry2 = map.get(string);
        if (javaClassCacheEntry.equals(javaClassCacheEntry2)) {
            javaClassCacheEntry.setSciSet(EMPTY_SCI_SET);
            return;
        }
        if (javaClassCacheEntry2 != null) {
            if (javaClassCacheEntry2.getSciSet() == null) {
                this.populateSCIsForCacheEntry(javaClassCacheEntry2, map);
            }
            hashSet.addAll(javaClassCacheEntry2.getSciSet());
        }
        hashSet.addAll(this.getSCIsForClass(string));
        for (String string2 : javaClassCacheEntry.getInterfaceNames()) {
            JavaClassCacheEntry javaClassCacheEntry3 = map.get(string2);
            if (javaClassCacheEntry3 != null) {
                if (javaClassCacheEntry3.getSciSet() == null) {
                    this.populateSCIsForCacheEntry(javaClassCacheEntry3, map);
                }
                hashSet.addAll(javaClassCacheEntry3.getSciSet());
            }
            hashSet.addAll(this.getSCIsForClass(string2));
        }
        javaClassCacheEntry.setSciSet(hashSet.isEmpty() ? EMPTY_SCI_SET : hashSet);
    }

    private Set<ServletContainerInitializer> getSCIsForClass(String string) {
        for (Map.Entry<Class<?>, Set<ServletContainerInitializer>> entry : this.typeInitializerMap.entrySet()) {
            Class<?> clazz = entry.getKey();
            if (clazz.isAnnotation() || !clazz.getName().equals(string)) continue;
            return entry.getValue();
        }
        return EMPTY_SCI_SET;
    }

    private static String getClassName(String string) {
        if (!string.startsWith("L")) {
            return string;
        }
        return string.substring(1, string.length() - 1).replace('/', '.');
    }

    protected void processAnnotationWebServlet(String string, AnnotationEntry annotationEntry, WebXml webXml) {
        boolean bl;
        String string2 = null;
        List list = annotationEntry.getElementValuePairs();
        ServletDef servletDef = list.iterator();
        while (servletDef.hasNext()) {
            ElementValuePair elementValuePair = (ElementValuePair)servletDef.next();
            String string3 = elementValuePair.getNameString();
            if (!"name".equals(string3)) continue;
            string2 = elementValuePair.getValue().stringifyValue();
            break;
        }
        if (string2 == null) {
            string2 = string;
        }
        if ((servletDef = (ServletDef)webXml.getServlets().get(string2)) == null) {
            servletDef = new ServletDef();
            servletDef.setServletName(string2);
            servletDef.setServletClass(string);
            bl = false;
        } else {
            bl = true;
        }
        boolean bl2 = false;
        String[] stringArray = null;
        for (ElementValuePair elementValuePair : list) {
            String string4 = elementValuePair.getNameString();
            if ("value".equals(string4) || "urlPatterns".equals(string4)) {
                if (bl2) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.urlPatternValue", new Object[]{"WebServlet", string}));
                }
                bl2 = true;
                stringArray = this.processAnnotationsStringArray(elementValuePair.getValue());
                continue;
            }
            if ("description".equals(string4)) {
                if (servletDef.getDescription() != null) continue;
                servletDef.setDescription(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("displayName".equals(string4)) {
                if (servletDef.getDisplayName() != null) continue;
                servletDef.setDisplayName(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("largeIcon".equals(string4)) {
                if (servletDef.getLargeIcon() != null) continue;
                servletDef.setLargeIcon(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("smallIcon".equals(string4)) {
                if (servletDef.getSmallIcon() != null) continue;
                servletDef.setSmallIcon(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("asyncSupported".equals(string4)) {
                if (servletDef.getAsyncSupported() != null) continue;
                servletDef.setAsyncSupported(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("loadOnStartup".equals(string4)) {
                if (servletDef.getLoadOnStartup() != null) continue;
                servletDef.setLoadOnStartup(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if (!"initParams".equals(string4)) continue;
            Map<String, String> object = this.processAnnotationWebInitParams(elementValuePair.getValue());
            if (bl) {
                Map map = servletDef.getParameterMap();
                for (Map.Entry<String, String> entry : object.entrySet()) {
                    if (map.get(entry.getKey()) != null) continue;
                    servletDef.addInitParameter(entry.getKey(), entry.getValue());
                }
                continue;
            }
            for (Map.Entry entry : object.entrySet()) {
                servletDef.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!bl && stringArray != null) {
            webXml.addServlet(servletDef);
        }
        if (stringArray != null && !webXml.getServletMappings().containsValue(string2)) {
            for (Iterator iterator : stringArray) {
                webXml.addServletMapping(iterator, string2);
            }
        }
    }

    protected void processAnnotationWebFilter(String string, AnnotationEntry annotationEntry, WebXml webXml) {
        Object object;
        Object object2;
        boolean bl;
        ElementValuePair elementValuePair2;
        String string2 = null;
        List list = annotationEntry.getElementValuePairs();
        for (ElementValuePair elementValuePair2 : list) {
            String string3 = elementValuePair2.getNameString();
            if (!"filterName".equals(string3)) continue;
            string2 = elementValuePair2.getValue().stringifyValue();
            break;
        }
        if (string2 == null) {
            string2 = string;
        }
        FilterDef filterDef = (FilterDef)webXml.getFilters().get(string2);
        elementValuePair2 = new FilterMap();
        if (filterDef == null) {
            filterDef = new FilterDef();
            filterDef.setFilterName(string2);
            filterDef.setFilterClass(string);
            bl = false;
        } else {
            bl = true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String[] stringArray = null;
        for (String[] stringArray2 : list) {
            String string4;
            int n;
            object2 = stringArray2.getNameString();
            if ("value".equals(object2) || "urlPatterns".equals(object2)) {
                if (bl2) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.urlPatternValue", new Object[]{"WebFilter", string}));
                }
                stringArray = this.processAnnotationsStringArray(stringArray2.getValue());
                bl2 = stringArray.length > 0;
                for (String string5 : stringArray) {
                    elementValuePair2.addURLPattern(string5);
                }
                continue;
            }
            if ("servletNames".equals(object2)) {
                object = this.processAnnotationsStringArray(stringArray2.getValue());
                bl3 = ((String[])object).length > 0;
                String[] stringArray3 = object;
                int n2 = stringArray3.length;
                for (n = 0; n < n2; ++n) {
                    string4 = stringArray3[n];
                    elementValuePair2.addServletName(string4);
                }
                continue;
            }
            if ("dispatcherTypes".equals(object2)) {
                object = this.processAnnotationsStringArray(stringArray2.getValue());
                bl4 = ((String[])object).length > 0;
                String[] stringArray4 = object;
                int n3 = stringArray4.length;
                for (n = 0; n < n3; ++n) {
                    string4 = stringArray4[n];
                    elementValuePair2.setDispatcher(string4);
                }
                continue;
            }
            if ("description".equals(object2)) {
                if (filterDef.getDescription() != null) continue;
                filterDef.setDescription(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("displayName".equals(object2)) {
                if (filterDef.getDisplayName() != null) continue;
                filterDef.setDisplayName(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("largeIcon".equals(object2)) {
                if (filterDef.getLargeIcon() != null) continue;
                filterDef.setLargeIcon(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("smallIcon".equals(object2)) {
                if (filterDef.getSmallIcon() != null) continue;
                filterDef.setSmallIcon(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("asyncSupported".equals(object2)) {
                if (filterDef.getAsyncSupported() != null) continue;
                filterDef.setAsyncSupported(stringArray2.getValue().stringifyValue());
                continue;
            }
            if (!"initParams".equals(object2)) continue;
            object = this.processAnnotationWebInitParams(stringArray2.getValue());
            if (bl) {
                Map map = filterDef.getParameterMap();
                for (Map.Entry entry : object.entrySet()) {
                    if (map.get(entry.getKey()) != null) continue;
                    filterDef.addInitParameter((String)entry.getKey(), (String)entry.getValue());
                }
                continue;
            }
            for (Map.Entry entry : object.entrySet()) {
                filterDef.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!bl) {
            webXml.addFilter(filterDef);
            if (bl2 || bl3) {
                elementValuePair2.setFilterName(string2);
                webXml.addFilterMapping((FilterMap)elementValuePair2);
            }
        }
        if (bl2 || bl4) {
            String[] stringArray2;
            Set set = webXml.getFilterMappings();
            stringArray2 = null;
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String[])object2.next();
                if (!string2.equals(object.getFilterName())) continue;
                stringArray2 = object;
                break;
            }
            if (stringArray2 != null) {
                object2 = stringArray2.getURLPatterns();
                if (bl2 && (object2 == null || ((String[])object2).length == 0)) {
                    for (String string6 : elementValuePair2.getURLPatterns()) {
                        stringArray2.addURLPattern(string6);
                    }
                }
                object = stringArray2.getDispatcherNames();
                if (bl4 && (object == null || ((String[])object).length == 0)) {
                    for (String string4 : elementValuePair2.getDispatcherNames()) {
                        stringArray2.setDispatcher(string4);
                    }
                }
            }
        }
    }

    protected String[] processAnnotationsStringArray(ElementValue elementValue) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (elementValue instanceof ArrayElementValue) {
            ElementValue[] elementValueArray;
            for (ElementValue elementValue2 : elementValueArray = ((ArrayElementValue)elementValue).getElementValuesArray()) {
                arrayList.add(elementValue2.stringifyValue());
            }
        } else {
            arrayList.add(elementValue.stringifyValue());
        }
        return arrayList.toArray(new String[0]);
    }

    protected Map<String, String> processAnnotationWebInitParams(ElementValue elementValue) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (elementValue instanceof ArrayElementValue) {
            ElementValue[] elementValueArray;
            for (ElementValue elementValue2 : elementValueArray = ((ArrayElementValue)elementValue).getElementValuesArray()) {
                if (!(elementValue2 instanceof AnnotationElementValue)) continue;
                List list = ((AnnotationElementValue)elementValue2).getAnnotationEntry().getElementValuePairs();
                String string = null;
                String string2 = null;
                for (ElementValuePair elementValuePair : list) {
                    if ("name".equals(elementValuePair.getNameString())) {
                        string = elementValuePair.getValue().stringifyValue();
                        continue;
                    }
                    if (!"value".equals(elementValuePair.getNameString())) continue;
                    string2 = elementValuePair.getValue().stringifyValue();
                }
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    static {
        Properties properties = new Properties();
        try (InputStream inputStream = ContextConfig.class.getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");){
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            properties = null;
        }
        authenticators = properties;
        deploymentCount = 0L;
        hostWebXmlCache = new ConcurrentHashMap<Host, DefaultWebXmlCacheEntry>();
        EMPTY_SCI_SET = Collections.emptySet();
    }

    public static interface ContextXml {
        public void load(Context var1);
    }

    private static class DefaultWebXmlCacheEntry {
        private final WebXml webXml;
        private final long globalTimeStamp;
        private final long hostTimeStamp;

        DefaultWebXmlCacheEntry(WebXml webXml, long l, long l2) {
            this.webXml = webXml;
            this.globalTimeStamp = l;
            this.hostTimeStamp = l2;
        }

        public WebXml getWebXml() {
            return this.webXml;
        }

        public long getGlobalTimeStamp() {
            return this.globalTimeStamp;
        }

        public long getHostTimeStamp() {
            return this.hostTimeStamp;
        }
    }

    private static class HostWebXmlCacheCleaner
    implements LifecycleListener {
        private HostWebXmlCacheCleaner() {
        }

        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if ("after_destroy".equals(lifecycleEvent.getType())) {
                Host host = (Host)lifecycleEvent.getSource();
                hostWebXmlCache.remove(host);
            }
        }
    }

    private class AnnotationScanTask
    implements Runnable {
        private final WebXml fragment;
        private final boolean handlesTypesOnly;
        private Map<String, JavaClassCacheEntry> javaClassCache;

        private AnnotationScanTask(WebXml webXml, boolean bl, Map<String, JavaClassCacheEntry> map) {
            this.fragment = webXml;
            this.handlesTypesOnly = bl;
            this.javaClassCache = map;
        }

        @Override
        public void run() {
            ContextConfig.this.scanWebXmlFragment(this.handlesTypesOnly, this.fragment, this.javaClassCache);
        }
    }

    static class JavaClassCacheEntry {
        public final String superclassName;
        public final String[] interfaceNames;
        private Set<ServletContainerInitializer> sciSet = null;

        JavaClassCacheEntry(JavaClass javaClass) {
            this.superclassName = javaClass.getSuperclassName();
            this.interfaceNames = javaClass.getInterfaceNames();
        }

        public String getSuperclassName() {
            return this.superclassName;
        }

        public String[] getInterfaceNames() {
            return this.interfaceNames;
        }

        public Set<ServletContainerInitializer> getSciSet() {
            return this.sciSet;
        }

        public void setSciSet(Set<ServletContainerInitializer> set) {
            this.sciSet = set;
        }
    }
}

