/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;

public class RequestInfo {
    private RequestGroupInfo global = null;
    private final Request req;
    private int stage = 0;
    private String workerThreadName;
    private ObjectName rpName;
    private long bytesSent;
    private long bytesReceived;
    private long processingTime;
    private long maxTime;
    private String maxRequestUri;
    private int requestCount;
    private int errorCount;
    private long lastRequestProcessingTime = 0L;

    public RequestInfo(Request request) {
        this.req = request;
    }

    public RequestGroupInfo getGlobalProcessor() {
        return this.global;
    }

    public void setGlobalProcessor(RequestGroupInfo requestGroupInfo) {
        if (requestGroupInfo != null) {
            this.global = requestGroupInfo;
            requestGroupInfo.addRequestProcessor(this);
        } else if (this.global != null) {
            this.global.removeRequestProcessor(this);
            this.global = null;
        }
    }

    public String getMethod() {
        return this.req.method().toString();
    }

    public String getCurrentUri() {
        return this.req.requestURI().toString();
    }

    public String getCurrentQueryString() {
        return this.req.queryString().toString();
    }

    public String getProtocol() {
        return this.req.protocol().toString();
    }

    public String getVirtualHost() {
        return this.req.serverName().toString();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public String getRemoteAddr() {
        this.req.action(ActionCode.REQ_HOST_ADDR_ATTRIBUTE, null);
        return this.req.remoteAddr().toString();
    }

    public String getPeerAddr() {
        this.req.action(ActionCode.REQ_PEER_ADDR_ATTRIBUTE, null);
        return this.req.peerAddr().toString();
    }

    public String getRemoteAddrForwarded() {
        String string = (String)this.req.getAttribute("org.apache.tomcat.remoteAddr");
        if (string == null) {
            return this.getRemoteAddr();
        }
        return string;
    }

    public int getContentLength() {
        return this.req.getContentLength();
    }

    public long getRequestBytesReceived() {
        return this.req.getBytesRead();
    }

    public long getRequestBytesSent() {
        return this.req.getResponse().getContentWritten();
    }

    public long getRequestProcessingTime() {
        long l = this.req.getStartTimeNanos();
        if (this.getStage() == 7 || l < 0L) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
    }

    void updateCounters() {
        long l;
        this.bytesReceived += this.req.getBytesRead();
        this.bytesSent += this.req.getResponse().getContentWritten();
        ++this.requestCount;
        if (this.req.getResponse().getStatus() >= 400) {
            ++this.errorCount;
        }
        this.lastRequestProcessingTime = l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.req.getStartTimeNanos());
        this.processingTime += l;
        if (this.maxTime < l) {
            this.maxTime = l;
            this.maxRequestUri = this.req.requestURI().toString();
        }
    }

    public int getStage() {
        return this.stage;
    }

    public void setStage(int n) {
        this.stage = n;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long l) {
        this.bytesSent = l;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(long l) {
        this.bytesReceived = l;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long l) {
        this.processingTime = l;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long l) {
        this.maxTime = l;
    }

    public String getMaxRequestUri() {
        return this.maxRequestUri;
    }

    public void setMaxRequestUri(String string) {
        this.maxRequestUri = string;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int n) {
        this.requestCount = n;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int n) {
        this.errorCount = n;
    }

    public String getWorkerThreadName() {
        return this.workerThreadName;
    }

    public ObjectName getRpName() {
        return this.rpName;
    }

    public long getLastRequestProcessingTime() {
        return this.lastRequestProcessingTime;
    }

    public void setWorkerThreadName(String string) {
        this.workerThreadName = string;
    }

    public void setRpName(ObjectName objectName) {
        this.rpName = objectName;
    }

    public void setLastRequestProcessingTime(long l) {
        this.lastRequestProcessingTime = l;
    }
}

