/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;

@SupportedAnnotationTypes(value={"org.netbeans.api.editor.mimelookup.MimeRegistration", "org.netbeans.api.editor.mimelookup.MimeRegistrations", "org.netbeans.spi.editor.mimelookup.MimeLocation"})
public class CreateRegistrationProcessor
extends LayerGeneratingProcessor {
    private static final String[] DEFAULT_COMPLETIONS = new String[]{"text/plain", "text/xml", "text/x-java"};
    private Processor COMPLETIONS;

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.api.editor.mimelookup.MimeRegistration");
        for (Element object2 : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
            for (AnnotationMirror annotationMirror : object2.getAnnotationMirrors()) {
                if (!typeElement.equals(annotationMirror.getAnnotationType().asElement())) continue;
                this.process(object2, annotationMirror);
            }
        }
        TypeElement typeElement2 = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.api.editor.mimelookup.MimeRegistrations");
        for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement2)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!typeElement2.equals(annotationMirror.getAnnotationType().asElement())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                    for (AnnotationMirror annotationMirror2 : NbCollections.iterable((Iterator)NbCollections.checkedIteratorByFilter(((Iterable)entry.getValue().getValue()).iterator(), AnnotationMirror.class, (boolean)true))) {
                        this.process(element, annotationMirror2);
                    }
                }
            }
        }
        TypeElement typeElement3 = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.spi.editor.mimelookup.MimeLocation");
        for (TypeElement typeElement4 : ElementFilter.typesIn(roundEnvironment.getElementsAnnotatedWith(typeElement3))) {
            for (AnnotationMirror annotationMirror : typeElement4.getAnnotationMirrors()) {
                if (!typeElement3.equals(annotationMirror.getAnnotationType().asElement())) continue;
                this.checkMimeLocation(typeElement4, annotationMirror);
            }
        }
        return true;
    }

    private void process(Element element, AnnotationMirror annotationMirror) throws LayerGenerationException {
        Object object;
        TypeMirror typeMirror = null;
        String string = null;
        int n = Integer.MAX_VALUE;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            object = entry.getKey().getSimpleName();
            if (object.contentEquals("service")) {
                typeMirror = (TypeMirror)entry.getValue().getValue();
                continue;
            }
            if (object.contentEquals("mimeType")) {
                string = (String)((AnnotationValue)entry.getValue()).getValue();
                continue;
            }
            if (!object.contentEquals("position")) continue;
            n = (Integer)((AnnotationValue)entry.getValue()).getValue();
        }
        if (string != null) {
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry;
            if (string.length() != 0) {
                string = "/" + string;
            }
            Object object2 = "";
            entry = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
            object = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.spi.editor.mimelookup.MimeLocation");
            block1: for (AnnotationMirror annotationMirror2 : entry.getAnnotationMirrors()) {
                if (!object.equals(annotationMirror2.getAnnotationType().asElement())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry2 : annotationMirror2.getElementValues().entrySet()) {
                    if (!entry2.getKey().getSimpleName().contentEquals("subfolderName")) continue;
                    object2 = "/" + (String)entry2.getValue().getValue();
                    break block1;
                }
            }
            this.instantiableClassOrMethod(element, (TypeElement)((Object)entry));
            this.layer(new Element[]{element}).instanceFile("Editors" + string + (String)object2, null, null).position(n).stringvalue("instanceOf", this.processingEnv.getElementUtils().getBinaryName((TypeElement)((Object)entry)).toString()).write();
        }
    }

    private void instantiableClassOrMethod(Element element, TypeElement typeElement) throws IllegalArgumentException, LayerGenerationException {
        DeclaredType declaredType = this.processingEnv.getTypeUtils().getDeclaredType(typeElement, new TypeMirror[0]);
        switch (element.getKind()) {
            case CLASS: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(string + " must not be abstract", element);
                }
                boolean bl = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                    if (!executableElement.getParameters().isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new LayerGenerationException(string + " must have a no-argument constructor", element);
                }
                if (declaredType != null && !this.processingEnv.getTypeUtils().isAssignable(element.asType(), declaredType)) {
                    throw new LayerGenerationException(string + " is not assignable to " + declaredType, element);
                }
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(string + " is not public", element);
                }
                return;
            }
            case METHOD: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element.getEnclosingElement()).toString();
                String string2 = element.getSimpleName().toString();
                if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(string + "." + string2 + " must be static", element);
                }
                if (!((ExecutableElement)element).getParameters().isEmpty()) {
                    throw new LayerGenerationException(string + "." + string2 + " must not take arguments", element);
                }
                if (declaredType != null && !this.processingEnv.getTypeUtils().isAssignable(((ExecutableElement)element).getReturnType(), declaredType)) {
                    throw new LayerGenerationException(string + "." + string2 + " is not assignable to " + declaredType, element);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }

    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        if (this.processingEnv == null || element == null || !element.getKind().isClass()) {
            return Collections.emptyList();
        }
        if (annotationMirror == null || !"org.netbeans.api.editor.mimelookup.MimeRegistration".contentEquals(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName())) {
            return Collections.emptyList();
        }
        if ("mimeType".contentEquals(executableElement.getSimpleName())) {
            return this.completeMimePath(element, annotationMirror, executableElement, string);
        }
        if (!"service".contentEquals(executableElement.getSimpleName())) {
            return Collections.emptyList();
        }
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement("java.lang.Object");
        if (typeElement == null) {
            return Collections.emptyList();
        }
        LinkedList<TypeCompletion> linkedList = new LinkedList<TypeCompletion>();
        LinkedList<TypeElement> linkedList2 = new LinkedList<TypeElement>();
        linkedList2.add((TypeElement)element);
        while (!linkedList2.isEmpty()) {
            TypeElement typeElement2 = (TypeElement)linkedList2.remove(0);
            linkedList.add(new TypeCompletion(typeElement2.getQualifiedName().toString() + ".class"));
            LinkedList<? extends TypeMirror> linkedList3 = new LinkedList<TypeMirror>();
            linkedList3.add(typeElement2.getSuperclass());
            linkedList3.addAll(typeElement2.getInterfaces());
            for (TypeMirror typeMirror : linkedList3) {
                TypeElement typeElement3;
                if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED || typeElement.equals(typeElement3 = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror))) continue;
                linkedList2.add(typeElement3);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    private Iterable<? extends Completion> completeMimePath(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        if (string == null) {
            string = "";
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        HashSet<TypeCompletion> hashSet = new HashSet<TypeCompletion>();
        if (this.COMPLETIONS == null) {
            String[] stringArray = System.getProperty("org.openide.awt.ActionReference.completion");
            if (stringArray != null) {
                void var7_9;
                ClassLoader object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (object == null) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (var7_9 == null) {
                    ClassLoader classLoader = CreateRegistrationProcessor.class.getClassLoader();
                }
                try {
                    void var7_11;
                    this.COMPLETIONS = (Processor)Class.forName((String)stringArray, true, (ClassLoader)var7_11).newInstance();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    this.COMPLETIONS = this;
                }
            } else {
                return hashSet;
            }
        }
        if (this.COMPLETIONS != null && this.COMPLETIONS != this) {
            this.COMPLETIONS.init(this.processingEnv);
            for (Completion completion : this.COMPLETIONS.getCompletions(element, annotationMirror, executableElement, "Editors/" + string)) {
                String[] stringArray;
                String string2 = completion.getValue();
                if (string2 == null || (stringArray = string2.split("/")).length > 3 || stringArray.length < 2 || !stringArray[0].equals("\"Editors") || stringArray[1].length() == 0 || Character.isUpperCase(stringArray[1].charAt(0))) continue;
                if (stringArray.length > 2) {
                    hashSet.add(new TypeCompletion('\"' + stringArray[1] + '/' + stringArray[2]));
                    continue;
                }
                hashSet.add(new TypeCompletion('\"' + stringArray[1] + '/'));
            }
        }
        if (hashSet.isEmpty()) {
            for (String string3 : DEFAULT_COMPLETIONS) {
                if (!string3.startsWith(string)) continue;
                hashSet.add(new TypeCompletion("\"" + string3));
            }
        }
        return hashSet;
    }

    private void checkMimeLocation(TypeElement typeElement, AnnotationMirror annotationMirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            TypeElement typeElement2;
            TypeMirror typeMirror;
            if (!entry.getKey().getSimpleName().contentEquals("instanceProviderClass") || (typeMirror = (TypeMirror)entry.getValue().getValue()) == null || typeMirror.getKind() != TypeKind.DECLARED) continue;
            TypeElement typeElement3 = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.spi.editor.mimelookup.InstanceProvider");
            if (typeElement3 == null) {
                return;
            }
            ExecutableElement object2 = null;
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement3.getEnclosedElements())) {
                if (!executableElement.getSimpleName().contentEquals("createInstance")) continue;
                object2 = executableElement;
                break;
            }
            if (object2 == null) {
                throw new IllegalStateException("No instanceCreate in InstanceProvider!");
            }
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Types object3 = this.processingEnv.getTypeUtils();
            ExecutableType executableType = (ExecutableType)object3.asMemberOf(declaredType, object2);
            TypeMirror typeMirror2 = executableType.getReturnType();
            TypeMirror typeMirror3 = this.processingEnv.getElementUtils().getTypeElement("java.lang.Object").asType();
            if (!object3.isSameType(object3.erasure(typeMirror2), typeMirror3) && !object3.isSubtype(object3.erasure(typeMirror2), object3.erasure(typeElement.asType()))) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The InstanceProvider does not create instances of type " + typeElement.getQualifiedName(), typeElement, annotationMirror, entry.getValue());
            }
            if (!(typeElement2 = (TypeElement)declaredType.asElement()).getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The InstanceProvider implementation is not public.", typeElement, annotationMirror, entry.getValue());
            }
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement2.getEnclosedElements())) {
                if (!executableElement.getParameters().isEmpty() || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                return;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The InstanceProvider implementation does not provide a public no-arg constructor.", typeElement, annotationMirror, entry.getValue());
        }
    }

    private static final class TypeCompletion
    implements Completion {
        private final String type;

        public TypeCompletion(String string) {
            this.type = string;
        }

        @Override
        public String getValue() {
            return this.type;
        }

        @Override
        public String getMessage() {
            return null;
        }
    }
}

