"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const previewer = __importStar(require("../utils/previewer"));
const shared_1 = require("../shared");
function register(ctx) {
    const { ts } = ctx;
    return (uri, position, documentOnly = false) => {
        const document = ctx.getTextDocument(uri);
        if (!document)
            return;
        const fileName = ctx.env.uriToFileName(document.uri);
        const offset = document.offsetAt(position);
        const info = (0, shared_1.safeCall)(() => ctx.typescript.languageService.getQuickInfoAtPosition(fileName, offset));
        if (!info)
            return;
        const parts = [];
        const displayString = ts.displayPartsToString(info.displayParts);
        const documentation = previewer.markdownDocumentation(info.documentation ?? [], info.tags, { toResource }, ctx);
        if (displayString && !documentOnly) {
            parts.push(['```typescript', displayString, '```'].join('\n'));
        }
        if (documentation) {
            parts.push(documentation);
        }
        const markdown = {
            kind: 'markdown',
            value: parts.join('\n\n'),
        };
        return {
            contents: markdown,
            range: {
                start: document.positionAt(info.textSpan.start),
                end: document.positionAt(info.textSpan.start + info.textSpan.length),
            },
        };
        function toResource(path) {
            return ctx.env.fileNameToUri(path);
        }
    };
}
exports.register = register;
//# sourceMappingURL=hover.js.map