"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextArea = exports.TEXTAREA_CLASSNAME = exports.textAreaStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const React = __importStar(require("react"));
const Identity_1 = require("../Identity");
const util_1 = require("../util");
const textAreaStyle = (theme, { markInvalid = false, placeholderTextTransform = 'none', disabled = false }) => {
    const placeholderStyle = {
        color: theme.Input.placeholderColor,
        fontSize: theme.fontSizes.base,
        textTransform: placeholderTextTransform,
    };
    return {
        '&::-moz-placeholder': Object.assign(Object.assign({}, placeholderStyle), { opacity: 1 }),
        '&::-ms-input-placeholder': Object.assign({}, placeholderStyle),
        '&::-webkit-input-placeholder': Object.assign({}, placeholderStyle),
        '&:focus': {
            boxShadow: `0 0 0 1px ${Identity_1.COLOR.BLUE}`,
        },
        '&:invalid': !markInvalid
            ? {
                boxShadow: `0 0 0 1px ${Identity_1.COLOR.GRAY}`,
            }
            : {},
        background: disabled ? theme.Input.backgroundColorDisabled : theme.Input.backgroundColor,
        border: 'none',
        borderRadius: '4px',
        boxShadow: markInvalid ? `0 0 0 1px ${Identity_1.COLOR.RED}` : `0 0 0 1px ${Identity_1.COLOR.GRAY}`,
        caretColor: Identity_1.COLOR.BLUE,
        color: theme.general.color,
        fontWeight: 400,
        lineHeight: '1.5rem',
        margin: '0 0 16px',
        outline: 'none',
        padding: '16px 16px',
        resize: 'none',
        width: '100%',
    };
};
exports.textAreaStyle = textAreaStyle;
exports.TEXTAREA_CLASSNAME = 'textarea';
const filterTextAreaProps = (props) => (0, util_1.filterProps)(props, ['markInvalid', 'placeholderTextTransform']);
exports.TextArea = React.forwardRef((props, ref) => ((0, jsx_runtime_1.jsx)("textarea", Object.assign({ className: exports.TEXTAREA_CLASSNAME, css: (theme) => (0, exports.textAreaStyle)(theme, props), ref: ref }, filterTextAreaProps(props)))));
exports.TextArea.displayName = 'TextArea';
