"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const exposes = __importStar(require("../lib/exposes"));
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const reporting = __importStar(require("../lib/reporting"));
const e = exposes.presets;
const definitions = [
    {
        zigbeeModel: ['PERCALE2 D1.00P1.01Z1.00', 'PERCALE2 D1.00P1.02Z1.00', 'PERCALE2 D1.00P1.03Z1.00', 'TAFFETAS2 D1.00P1.03Z1.00'],
        model: 'PERCALE2',
        vendor: 'Acova',
        description: 'Percale 2 heater',
        fromZigbee: [fromZigbee_1.default.thermostat, fromZigbee_1.default.hvac_user_interface],
        toZigbee: [
            toZigbee_1.default.thermostat_local_temperature,
            toZigbee_1.default.thermostat_system_mode,
            toZigbee_1.default.thermostat_occupied_heating_setpoint,
            toZigbee_1.default.thermostat_unoccupied_heating_setpoint,
            toZigbee_1.default.thermostat_occupied_cooling_setpoint,
            toZigbee_1.default.thermostat_running_state,
        ],
        exposes: [
            e.climate()
                .withSetpoint('occupied_heating_setpoint', 7, 28, 0.5)
                .withSetpoint('unoccupied_heating_setpoint', 7, 28, 0.5)
                .withLocalTemperature()
                .withSystemMode(['off', 'heat', 'auto'])
                .withRunningState(['idle', 'heat']),
        ],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ['genPowerCfg', 'hvacThermostat']);
            await reporting.thermostatTemperature(endpoint);
            await reporting.thermostatRunningState(endpoint);
            await reporting.thermostatOccupiedHeatingSetpoint(endpoint);
            await reporting.thermostatUnoccupiedHeatingSetpoint(endpoint);
        },
    },
    {
        zigbeeModel: ['ALCANTARA2 D1.00P1.01Z1.00\u0000\u0000\u0000\u0000\u0000\u0000',
            'ALCANTARA2 D1.00P1.02Z1.00\u0000\u0000\u0000\u0000\u0000\u0000'],
        model: 'ALCANTARA2',
        vendor: 'Acova',
        description: 'Alcantara 2 heater',
        fromZigbee: [fromZigbee_1.default.thermostat, fromZigbee_1.default.hvac_user_interface],
        toZigbee: [
            toZigbee_1.default.thermostat_local_temperature,
            toZigbee_1.default.thermostat_system_mode,
            toZigbee_1.default.thermostat_occupied_heating_setpoint,
            toZigbee_1.default.thermostat_unoccupied_heating_setpoint,
            toZigbee_1.default.thermostat_running_state,
        ],
        exposes: [
            e.climate()
                .withSetpoint('occupied_heating_setpoint', 7, 28, 0.5)
                .withSetpoint('unoccupied_heating_setpoint', 7, 28, 0.5)
                .withLocalTemperature()
                .withSystemMode(['off', 'heat', 'auto'])
                .withRunningState(['idle', 'heat']),
        ],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ['genPowerCfg', 'hvacThermostat']);
            await reporting.thermostatTemperature(endpoint);
            await reporting.thermostatRunningState(endpoint);
            await reporting.thermostatOccupiedHeatingSetpoint(endpoint);
            await reporting.thermostatUnoccupiedHeatingSetpoint(endpoint);
        },
    },
    {
        zigbeeModel: ['TAFFETAS2 D1.00P1.02Z1.00\u0000\u0000\u0000\u0000\u0000\u0000\u0000',
            'TAFFETAS2 D1.00P1.01Z1.00\u0000\u0000\u0000\u0000\u0000\u0000\u0000'],
        model: 'TAFFETAS2',
        vendor: 'Acova',
        description: 'Taffetas 2 heater',
        fromZigbee: [fromZigbee_1.default.thermostat, fromZigbee_1.default.hvac_user_interface, fromZigbee_1.default.occupancy],
        toZigbee: [
            toZigbee_1.default.thermostat_local_temperature,
            toZigbee_1.default.thermostat_system_mode,
            toZigbee_1.default.thermostat_occupied_heating_setpoint,
            toZigbee_1.default.thermostat_unoccupied_heating_setpoint,
            toZigbee_1.default.thermostat_running_state,
            toZigbee_1.default.thermostat_local_temperature_calibration,
        ],
        exposes: [
            e.climate()
                .withSetpoint('occupied_heating_setpoint', 7, 28, 0.5)
                .withSetpoint('unoccupied_heating_setpoint', 7, 28, 0.5)
                .withLocalTemperature()
                .withSystemMode(['off', 'heat', 'auto'])
                .withRunningState(['idle', 'heat'])
                .withLocalTemperatureCalibration(),
            e.occupancy(),
        ],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            const endpoint2 = device.getEndpoint(2);
            await reporting.bind(endpoint, coordinatorEndpoint, ['genPowerCfg', 'hvacThermostat']);
            await reporting.bind(endpoint2, coordinatorEndpoint, ['msOccupancySensing']);
            await reporting.thermostatTemperature(endpoint);
            await reporting.thermostatRunningState(endpoint);
            await reporting.thermostatOccupiedHeatingSetpoint(endpoint);
            await reporting.thermostatUnoccupiedHeatingSetpoint(endpoint);
            await reporting.thermostatTemperatureCalibration(endpoint);
            await reporting.occupancy(endpoint2);
        },
    },
];
module.exports = definitions;
//# sourceMappingURL=acova.js.map