"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const extend_1 = __importDefault(require("../lib/extend"));
const definitions = [
    {
        zigbeeModel: ['020B0B'],
        model: '020B0B',
        vendor: 'Fischer & Honsel',
        description: 'LED Tischleuchte Beta Zig',
        extend: extend_1.default.light_onoff_brightness_colortemp_color({ colorTempRange: [153, 370] }),
        endpoint: (device) => {
            // https://github.com/Koenkk/zigbee-herdsman-converters/issues/5463
            const endpoint = device.endpoints.find((e) => e.inputClusters.includes(6)).ID;
            return { 'default': endpoint };
        },
    },
];
module.exports = definitions;
//# sourceMappingURL=seastar_intelligence.js.map