/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.net.URI;
import javax.swing.Icon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.ObjectAndIcon;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;

public class LinkTransformer
extends AbstractContentTransformer {
    private static Icon localLinkIcon = ResourceController.getResourceController().getIcon("link_local_icon");
    private ModeController modeController;

    public LinkTransformer(ModeController modeController, int priority) {
        super(priority);
        this.modeController = modeController;
    }

    @Override
    public Object transformContent(NodeModel node, Object nodeProperty, Object content, TextController textController, IContentTransformer.Mode mode) {
        if ("NO_FORMAT".equals(textController.getNodeFormat(node))) {
            return content;
        }
        if (!(content instanceof Hyperlink) && !(content instanceof URI)) {
            return content;
        }
        String string = content.toString();
        if (!string.startsWith("#")) {
            return content;
        }
        String reference = string.substring(1);
        NodeModel target = this.modeController.getExtension(MapExplorerController.class).getNodeAt(node, reference);
        if (target != null) {
            String shortText = TextController.getController(this.modeController).getShortPlainText(target);
            return new ObjectAndIcon(shortText, localLinkIcon);
        }
        return content;
    }
}

