/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.ControllerPopupMenuListener;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.AltCodeChecker;

public class DefaultNodeKeyListener
implements KeyListener {
    private final IEditHandler editHandler;

    public DefaultNodeKeyListener(IEditHandler editHandler) {
        this.editHandler = editHandler;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean checkForScrollMap = e.isShiftDown() && e.isControlDown() && e.isAltDown();
        MapView mapView = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        if (mapView == null || SwingUtilities.isDescendingFrom(mapView, e.getComponent())) {
            return;
        }
        ActionAcceleratorManager acceleratorManager = ResourceController.getResourceController().getAcceleratorManager();
        if (acceleratorManager.canProcessKeyEvent(e)) {
            return;
        }
        if (checkForScrollMap) {
            switch (e.getKeyCode()) {
                case 38: {
                    mapView.scroll(MapView.SelectionDirection.UP);
                    e.consume();
                    return;
                }
                case 40: {
                    mapView.scroll(MapView.SelectionDirection.DOWN);
                    e.consume();
                    return;
                }
                case 37: {
                    mapView.scroll(MapView.SelectionDirection.LEFT);
                    e.consume();
                    return;
                }
                case 39: {
                    mapView.scroll(MapView.SelectionDirection.RIGHT);
                    e.consume();
                }
            }
            return;
        }
        if (e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 9: 
            case 10: 
            case 16: 
            case 27: 
            case 32: 
            case 127: 
            case 155: {
                return;
            }
        }
        boolean continious = e.isShiftDown();
        switch (e.getKeyCode()) {
            case 38: {
                if (mapView.selectUp(continious)) {
                    e.consume();
                }
                return;
            }
            case 40: {
                if (mapView.selectDown(continious)) {
                    e.consume();
                }
                return;
            }
            case 37: {
                if (mapView.selectLeft(continious)) {
                    e.consume();
                }
                return;
            }
            case 39: {
                if (mapView.selectRight(continious)) {
                    e.consume();
                }
                return;
            }
            case 33: {
                if (mapView.selectPageUp(continious)) {
                    e.consume();
                }
                return;
            }
            case 34: {
                if (mapView.selectPageDown(continious)) {
                    e.consume();
                }
                return;
            }
            case 8: 
            case 35: 
            case 36: {
                if (this.editHandler != null) {
                    this.editHandler.edit(e, IEditHandler.FirstAction.EDIT_CURRENT, false);
                }
                return;
            }
            case 525: {
                ModeController modeController = Controller.getCurrentModeController();
                NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
                NodeView nodeView = mapView.getNodeView(node);
                JPopupMenu popupmenu = modeController.getUserInputListenerFactory().getNodePopupMenu();
                if (popupmenu == null) break;
                popupmenu.addHierarchyListener(new ControllerPopupMenuListener());
                MainView mainView = nodeView.getMainView();
                popupmenu.show(mainView, mainView.getX(), mainView.getY());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.isAltDown() && !Compat.isMacOsX() || e.isControlDown() || e.isMetaDown() || AltCodeChecker.isAltCode(e.getKeyChar())) {
            return;
        }
        String keyTypeActionString = ResourceController.getResourceController().getProperty("key_type_action", IEditHandler.FirstAction.EDIT_CURRENT.toString());
        IEditHandler.FirstAction keyTypeAction = IEditHandler.FirstAction.valueOf(keyTypeActionString);
        if (!IEditHandler.FirstAction.IGNORE.equals((Object)keyTypeAction) && !this.isActionEvent(e)) {
            if (this.editHandler != null) {
                this.editHandler.edit(e, keyTypeAction, false);
            }
            return;
        }
    }

    private boolean isActionEvent(KeyEvent e) {
        return e.isActionKey() || this.isControlCharacter(e.getKeyChar());
    }

    private boolean isControlCharacter(char keyChar) {
        return keyChar == '\uffff' || keyChar <= ' ' || keyChar == '\u007f';
    }
}

