/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExample;
import org.openapitools.openapidiff.core.model.ChangedExamples;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedMediaType
implements ComposedChanged {
    private final Schema oldSchema;
    private final Schema newSchema;
    private final DiffContext context;
    private ChangedSchema schema;
    private ChangedExamples examples;
    private ChangedExample example;

    public ChangedMediaType(Schema oldSchema, Schema newSchema, DiffContext context) {
        this.oldSchema = oldSchema;
        this.newSchema = newSchema;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.schema, this.examples, this.example);
    }

    @Override
    public DiffResult isCoreChanged() {
        return DiffResult.NO_CHANGES;
    }

    public Schema getOldSchema() {
        return this.oldSchema;
    }

    public Schema getNewSchema() {
        return this.newSchema;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public ChangedSchema getSchema() {
        return this.schema;
    }

    public ChangedExamples getExamples() {
        return this.examples;
    }

    public ChangedExample getExample() {
        return this.example;
    }

    public ChangedMediaType setSchema(ChangedSchema schema) {
        this.schema = schema;
        return this;
    }

    public ChangedMediaType setExamples(ChangedExamples examples) {
        this.examples = examples;
        return this;
    }

    public ChangedMediaType setExample(ChangedExample example) {
        this.example = example;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedMediaType that = (ChangedMediaType)o;
        return Objects.equals(this.oldSchema, that.oldSchema) && Objects.equals(this.newSchema, that.newSchema) && Objects.equals(this.context, that.context) && Objects.equals(this.schema, that.schema) && Objects.equals(this.examples, that.examples) && Objects.equals(this.example, that.example);
    }

    public int hashCode() {
        return Objects.hash(this.oldSchema, this.newSchema, this.context, this.schema, this.examples, this.example);
    }

    public String toString() {
        return "ChangedMediaType(oldSchema=" + this.getOldSchema() + ", newSchema=" + this.getNewSchema() + ", context=" + this.getContext() + ", schema=" + this.getSchema() + ", examples=" + this.getExamples() + ", example=" + this.getExample() + ")";
    }
}

