/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Booleans;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.lifecycle.Lifecycle;
import org.opensearch.common.metrics.MeanMetric;
import org.opensearch.common.network.CloseableChannel;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.network.NetworkUtils;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.NetworkExceptionHelper;
import org.opensearch.common.transport.PortsRange;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.node.Node;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.BindTransportException;
import org.opensearch.transport.CloseableConnection;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.InboundHandler;
import org.opensearch.transport.InboundMessage;
import org.opensearch.transport.NodeNotConnectedException;
import org.opensearch.transport.OutboundHandler;
import org.opensearch.transport.ProtocolInboundMessage;
import org.opensearch.transport.StatsTracker;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TcpServerChannel;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportHandshaker;
import org.opensearch.transport.TransportKeepAlive;
import org.opensearch.transport.TransportMessageListener;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportSettings;
import org.opensearch.transport.TransportStats;
import org.opensearch.transport.Transports;
import org.opensearch.transport.nativeprotocol.NativeOutboundHandler;

@PublicApi(since="1.0.0")
public abstract class TcpTransport
extends AbstractLifecycleComponent
implements Transport {
    private static final Logger logger = LogManager.getLogger(TcpTransport.class);
    public static final String TRANSPORT_WORKER_THREAD_NAME_PREFIX = "transport_worker";
    private static final int BYTES_NEEDED_FOR_MESSAGE_SIZE = 6;
    private static final long THIRTY_PER_HEAP_SIZE = (long)((double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() * 0.3);
    final StatsTracker statsTracker = new StatsTracker();
    private static final int LIMIT_LOCAL_PORTS_COUNT = 6;
    protected final Settings settings;
    private final Version version;
    protected final ThreadPool threadPool;
    protected final PageCacheRecycler pageCacheRecycler;
    protected final NetworkService networkService;
    protected final Set<ProfileSettings> profileSettings;
    private final CircuitBreakerService circuitBreakerService;
    private final ConcurrentMap<String, BoundTransportAddress> profileBoundAddresses = ConcurrentCollections.newConcurrentMap();
    private final Map<String, List<TcpServerChannel>> serverChannels = ConcurrentCollections.newConcurrentMap();
    private final Set<TcpChannel> acceptedChannels = ConcurrentCollections.newConcurrentSet();
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile BoundTransportAddress boundAddress;
    private final TransportHandshaker handshaker;
    private final TransportKeepAlive keepAlive;
    private final OutboundHandler outboundHandler;
    private final InboundHandler inboundHandler;
    private final NativeOutboundHandler handshakerHandler;
    private final Transport.ResponseHandlers responseHandlers = new Transport.ResponseHandlers();
    private final Transport.RequestHandlers requestHandlers = new Transport.RequestHandlers();
    private final AtomicLong outboundConnectionCount = new AtomicLong();
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::([\\d\\-]*))?$");

    public TcpTransport(Settings settings, Version version, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, Tracer tracer) {
        String[] features;
        this.settings = settings;
        this.profileSettings = TcpTransport.getProfileSettings(settings);
        this.version = version;
        this.threadPool = threadPool;
        this.pageCacheRecycler = pageCacheRecycler;
        this.circuitBreakerService = circuitBreakerService;
        this.networkService = networkService;
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        Settings defaultFeatures = TransportSettings.DEFAULT_FEATURES_SETTING.get(settings);
        if (defaultFeatures == null) {
            features = new String[]{};
        } else {
            defaultFeatures.names().forEach(key -> {
                if (!Booleans.parseBoolean((String)defaultFeatures.get((String)key))) {
                    throw new IllegalArgumentException("feature settings must have default [true] value");
                }
            });
            features = new TreeSet<String>(defaultFeatures.names()).toArray(new String[defaultFeatures.names().size()]);
        }
        BigArrays bigArrays = new BigArrays(pageCacheRecycler, circuitBreakerService, "in_flight_requests");
        this.outboundHandler = new OutboundHandler(this.statsTracker, threadPool);
        this.handshakerHandler = new NativeOutboundHandler(nodeName, version, features, this.statsTracker, threadPool, bigArrays, this.outboundHandler);
        this.handshaker = new TransportHandshaker(version, threadPool, (node, channel, requestId, v) -> this.handshakerHandler.sendRequest(node, channel, requestId, "internal:tcp/handshake", new TransportHandshaker.HandshakeRequest(version), TransportRequestOptions.EMPTY, v, false, true));
        this.keepAlive = new TransportKeepAlive(threadPool, this.outboundHandler::sendBytes);
        this.inboundHandler = new InboundHandler(nodeName, version, features, this.statsTracker, threadPool, bigArrays, this.outboundHandler, namedWriteableRegistry, this.handshaker, this.keepAlive, this.requestHandlers, this.responseHandlers, tracer);
    }

    public Version getVersion() {
        return this.version;
    }

    public StatsTracker getStatsTracker() {
        return this.statsTracker;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Supplier<CircuitBreaker> getInflightBreaker() {
        return () -> this.circuitBreakerService.getBreaker("in_flight_requests");
    }

    protected void doStart() {
    }

    @Override
    public synchronized void setMessageListener(TransportMessageListener listener) {
        this.handshakerHandler.setMessageListener(listener);
        this.inboundHandler.setMessageListener(listener);
    }

    @Override
    public void setSlowLogThreshold(TimeValue slowLogThreshold) {
        this.inboundHandler.setSlowLogThreshold(slowLogThreshold);
    }

    protected ConnectionProfile maybeOverrideConnectionProfile(ConnectionProfile connectionProfile) {
        return connectionProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        Objects.requireNonNull(profile, "connection profile cannot be null");
        if (node == null) {
            throw new ConnectTransportException(null, "can't open connection to a null node");
        }
        ConnectionProfile finalProfile = this.maybeOverrideConnectionProfile(profile);
        this.closeLock.readLock().lock();
        try {
            this.ensureOpen();
            this.initiateConnection(node, finalProfile, listener);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private List<TcpChannel> initiateConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        int numConnections = connectionProfile.getNumConnections();
        assert (numConnections > 0) : "A connection profile must be configured with at least one connection";
        ArrayList<TcpChannel> channels = new ArrayList<TcpChannel>(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            try {
                TcpChannel channel = this.initiateChannel(node);
                logger.trace(() -> new ParameterizedMessage("Tcp transport channel opened: {}", (Object)channel));
                channels.add(channel);
                continue;
            }
            catch (ConnectTransportException e) {
                CloseableChannel.closeChannels(channels, false);
                listener.onFailure((Exception)((Object)e));
                return channels;
            }
            catch (Exception e) {
                CloseableChannel.closeChannels(channels, false);
                listener.onFailure((Exception)((Object)new ConnectTransportException(node, "general node connection failure", e)));
                return channels;
            }
        }
        ChannelsConnectedListener channelsConnectedListener = new ChannelsConnectedListener(node, connectionProfile, channels, new ThreadedActionListener<Transport.Connection>(logger, this.threadPool, "generic", listener, false));
        for (TcpChannel channel : channels) {
            channel.addConnectListener(channelsConnectedListener);
        }
        TimeValue connectTimeout = connectionProfile.getConnectTimeout();
        this.threadPool.schedule(channelsConnectedListener::onTimeout, connectTimeout, "generic");
        return channels;
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return Collections.unmodifiableMap(new HashMap<String, BoundTransportAddress>(this.profileBoundAddresses));
    }

    @Override
    public List<String> getDefaultSeedAddresses() {
        ArrayList<String> local = new ArrayList<String>();
        local.add("127.0.0.1");
        if (NetworkUtils.SUPPORTS_V6) {
            local.add("[::1]");
        }
        return local.stream().flatMap(address -> Arrays.stream(this.defaultPortRange()).limit(6L).mapToObj(port -> address + ":" + port)).collect(Collectors.toList());
    }

    protected void bindServer(ProfileSettings profileSettings) {
        InetAddress[] hostAddresses;
        List<String> profileBindHosts = profileSettings.bindHosts;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(profileBindHosts.toArray(Strings.EMPTY_ARRAY));
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host " + String.valueOf(profileBindHosts), e);
        }
        if (logger.isDebugEnabled()) {
            String[] addresses = new String[hostAddresses.length];
            for (int i = 0; i < hostAddresses.length; ++i) {
                addresses[i] = NetworkAddress.format((InetAddress)hostAddresses[i]);
            }
            logger.debug("binding server bootstrap to: {}", (Object)addresses);
        }
        assert (hostAddresses.length > 0);
        ArrayList<InetSocketAddress> boundAddresses = new ArrayList<InetSocketAddress>();
        for (InetAddress hostAddress : hostAddresses) {
            boundAddresses.add(this.bindToPort(profileSettings.profileName, hostAddress, profileSettings.portOrRange));
        }
        BoundTransportAddress boundTransportAddress = this.createBoundTransportAddress(profileSettings, boundAddresses);
        if (profileSettings.isDefaultProfile) {
            this.boundAddress = boundTransportAddress;
        } else {
            this.profileBoundAddresses.put(profileSettings.profileName, boundTransportAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress bindToPort(String name, InetAddress hostAddress, String port) {
        PortsRange portsRange = new PortsRange(port);
        AtomicReference lastException = new AtomicReference();
        AtomicReference boundSocket = new AtomicReference();
        this.closeLock.writeLock().lock();
        try {
            if (!this.lifecycle.initialized() && !this.lifecycle.started()) {
                throw new IllegalStateException("transport has been stopped");
            }
            boolean success = portsRange.iterate(portNumber -> {
                try {
                    TcpServerChannel channel = this.bind(name, new InetSocketAddress(hostAddress, portNumber));
                    this.serverChannels.computeIfAbsent(name, k -> new ArrayList()).add(channel);
                    boundSocket.set(channel.getLocalAddress());
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            });
            if (!success) {
                throw new BindTransportException("Failed to bind to " + NetworkAddress.format((InetAddress)hostAddress, (PortsRange)portsRange), (Throwable)lastException.get());
            }
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bound profile [{}] to address {{}}", (Object)name, (Object)NetworkAddress.format((InetSocketAddress)((InetSocketAddress)boundSocket.get())));
        }
        return (InetSocketAddress)boundSocket.get();
    }

    private BoundTransportAddress createBoundTransportAddress(ProfileSettings profileSettings, List<InetSocketAddress> boundAddresses) {
        InetAddress publishInetAddress;
        String[] boundAddressesHostStrings = new String[boundAddresses.size()];
        TransportAddress[] transportBoundAddresses = new TransportAddress[boundAddresses.size()];
        for (int i = 0; i < boundAddresses.size(); ++i) {
            InetSocketAddress boundAddress = boundAddresses.get(i);
            boundAddressesHostStrings[i] = boundAddress.getHostString();
            transportBoundAddresses[i] = new TransportAddress(boundAddress);
        }
        List<String> publishHosts = profileSettings.publishHosts;
        if (!profileSettings.isDefaultProfile && publishHosts.isEmpty()) {
            publishHosts = Arrays.asList(boundAddressesHostStrings);
        }
        if (publishHosts.isEmpty()) {
            publishHosts = NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(this.settings);
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(publishHosts.toArray(Strings.EMPTY_ARRAY));
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = Transport.resolvePublishPort(profileSettings.publishPort, boundAddresses, publishInetAddress);
        if (publishPort == -1) {
            String profileExplanation = profileSettings.isDefaultProfile ? "" : " for profile " + profileSettings.profileName;
            throw new BindTransportException("Failed to auto-resolve publish port" + profileExplanation + ", multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). Please specify a unique port by setting " + TransportSettings.PORT.getKey() + " or " + TransportSettings.PUBLISH_PORT.getKey());
        }
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        return new BoundTransportAddress(transportBoundAddresses, publishAddress);
    }

    @Override
    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return TcpTransport.parse(address, this.defaultPortRange()[0]);
    }

    private int[] defaultPortRange() {
        return new PortsRange(this.settings.get(TransportSettings.PORT_PROFILE.getConcreteSettingForNamespace("default").getKey(), TransportSettings.PORT.get(this.settings))).ports();
    }

    static TransportAddress[] parse(String hostPortString, int defaultPort) throws UnknownHostException {
        String host;
        Objects.requireNonNull(hostPortString);
        String portString = null;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid bracketed host/port range: " + hostPortString);
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                if (colonPos >= 0) {
                    throw new IllegalArgumentException("IPv6 addresses must be bracketed: " + hostPortString);
                }
            }
        }
        int port = portString == null || portString.isEmpty() ? defaultPort : Integer.parseInt(portString);
        return (TransportAddress[])Arrays.stream(InetAddress.getAllByName(host)).distinct().map(address -> new TransportAddress(address, port)).toArray(TransportAddress[]::new);
    }

    protected final void doClose() {
    }

    protected final void doStop() {
        CountDownLatch latch = new CountDownLatch(1);
        assert (!this.threadPool.generic().isShutdown()) : "Must stop transport before terminating underlying threadpool";
        this.threadPool.generic().execute(() -> {
            this.closeLock.writeLock().lock();
            try {
                this.keepAlive.close();
                for (Map.Entry<String, List<TcpServerChannel>> entry : this.serverChannels.entrySet()) {
                    String profile = entry.getKey();
                    List<TcpServerChannel> channels = entry.getValue();
                    ActionListener closeFailLogger = ActionListener.wrap(c -> {}, e -> logger.warn(() -> new ParameterizedMessage("Error closing serverChannel for profile [{}]", (Object)profile), (Throwable)e));
                    channels.forEach(c -> c.addCloseListener((ActionListener<Void>)closeFailLogger));
                    CloseableChannel.closeChannels(channels, true);
                }
                this.serverChannels.clear();
                CloseableChannel.closeChannels(new ArrayList<TcpChannel>(this.acceptedChannels), true);
                this.acceptedChannels.clear();
                this.stopInternal();
            }
            finally {
                this.closeLock.writeLock().unlock();
                latch.countDown();
            }
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onException(TcpChannel channel, Exception e) {
        TcpTransport.handleException(channel, e, this.lifecycle, this.outboundHandler);
    }

    static void handleException(TcpChannel channel, Exception e, Lifecycle lifecycle, OutboundHandler outboundHandler) {
        if (!lifecycle.started()) {
            CloseableChannel.closeChannel(channel);
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException((Throwable)e)) {
            logger.debug(() -> new ParameterizedMessage("close connection exception caught on transport layer [{}], disconnecting from relevant node", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (NetworkExceptionHelper.isConnectException((Throwable)e)) {
            logger.debug(() -> new ParameterizedMessage("connect exception caught on transport layer [{}]", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof BindException) {
            logger.debug(() -> new ParameterizedMessage("bind exception caught on transport layer [{}]", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof CancelledKeyException) {
            logger.debug(() -> new ParameterizedMessage("cancelled key exception caught on transport layer [{}], disconnecting from relevant node", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof HttpRequestOnTransportException) {
            if (channel.isOpen()) {
                BytesArray message = new BytesArray(e.getMessage().getBytes(StandardCharsets.UTF_8));
                outboundHandler.sendBytes(channel, (BytesReference)message, (ActionListener<Void>)ActionListener.wrap(() -> CloseableChannel.closeChannel(channel)));
            }
        } else if (e instanceof StreamCorruptedException) {
            logger.warn(() -> new ParameterizedMessage("{}, [{}], closing connection", (Object)e.getMessage(), (Object)channel));
            CloseableChannel.closeChannel(channel);
        } else {
            logger.warn(() -> new ParameterizedMessage("exception caught on transport layer [{}], closing connection", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        }
    }

    protected void onServerException(TcpServerChannel channel, Exception e) {
        if (e instanceof BindException) {
            logger.debug(() -> new ParameterizedMessage("bind exception from server channel caught on transport layer [{}]", (Object)channel), (Throwable)e);
        } else {
            logger.error((Message)new ParameterizedMessage("exception from server channel caught on transport layer [{}]", (Object)channel), (Throwable)e);
        }
    }

    protected void serverAcceptedChannel(TcpChannel channel) {
        boolean addedOnThisCall = this.acceptedChannels.add(channel);
        assert (addedOnThisCall) : "Channel should only be added to accepted channel set once";
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        channel.addCloseListener((ActionListener<Void>)ActionListener.wrap(() -> this.acceptedChannels.remove(channel)));
        logger.trace(() -> new ParameterizedMessage("Tcp transport channel accepted: {}", (Object)channel));
    }

    protected abstract TcpServerChannel bind(String var1, InetSocketAddress var2) throws IOException;

    protected abstract TcpChannel initiateChannel(DiscoveryNode var1) throws IOException;

    protected abstract void stopInternal();

    @Deprecated
    public void inboundMessage(TcpChannel channel, ProtocolInboundMessage message) {
        this.inboundMessage(channel, (InboundMessage)message);
    }

    public void inboundMessage(TcpChannel channel, InboundMessage message) {
        try {
            this.inboundHandler.inboundMessage(channel, message);
        }
        catch (Exception e) {
            this.onException(channel, e);
        }
    }

    public static int readMessageLength(BytesReference networkBytes) throws IOException {
        if (networkBytes.length() < 6) {
            return -1;
        }
        return TcpTransport.readHeaderBuffer(networkBytes);
    }

    private static int readHeaderBuffer(BytesReference headerBuffer) throws IOException {
        if (headerBuffer.get(0) != 69 || headerBuffer.get(1) != 83) {
            if (TcpTransport.appearsToBeHTTPRequest(headerBuffer)) {
                throw new HttpRequestOnTransportException("This is not an HTTP port");
            }
            if (TcpTransport.appearsToBeHTTPResponse(headerBuffer)) {
                throw new StreamCorruptedException("received HTTP response on transport port, ensure that transport port (not HTTP port) of a remote node is specified in the configuration");
            }
            String firstBytes = "(" + Integer.toHexString(headerBuffer.get(0) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(1) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(2) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(3) & 0xFF) + ")";
            if (TcpTransport.appearsToBeTLS(headerBuffer)) {
                throw new StreamCorruptedException("SSL/TLS request received but SSL/TLS is not enabled on this node, got " + firstBytes);
            }
            throw new StreamCorruptedException("invalid internal transport message format, got " + firstBytes);
        }
        int messageLength = headerBuffer.getInt(2);
        if (messageLength == -1) {
            return 0;
        }
        if (messageLength <= 0) {
            throw new StreamCorruptedException("invalid data length: " + messageLength);
        }
        if ((long)messageLength > THIRTY_PER_HEAP_SIZE) {
            throw new IllegalArgumentException("transport content length received [" + String.valueOf(new ByteSizeValue((long)messageLength)) + "] exceeded [" + String.valueOf(new ByteSizeValue(THIRTY_PER_HEAP_SIZE)) + "]");
        }
        return messageLength;
    }

    private static boolean appearsToBeHTTPRequest(BytesReference headerBuffer) {
        return TcpTransport.bufferStartsWith(headerBuffer, "GET") || TcpTransport.bufferStartsWith(headerBuffer, "POST") || TcpTransport.bufferStartsWith(headerBuffer, "PUT") || TcpTransport.bufferStartsWith(headerBuffer, "HEAD") || TcpTransport.bufferStartsWith(headerBuffer, "DELETE") || TcpTransport.bufferStartsWith(headerBuffer, "OPTION") || TcpTransport.bufferStartsWith(headerBuffer, "PATCH") || TcpTransport.bufferStartsWith(headerBuffer, "TRACE");
    }

    private static boolean appearsToBeHTTPResponse(BytesReference headerBuffer) {
        return TcpTransport.bufferStartsWith(headerBuffer, "HTTP");
    }

    private static boolean appearsToBeTLS(BytesReference headerBuffer) {
        return headerBuffer.get(0) == 22 && headerBuffer.get(1) == 3;
    }

    private static boolean bufferStartsWith(BytesReference buffer, String method) {
        char[] chars = method.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (buffer.get(i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    public void executeHandshake(DiscoveryNode node, TcpChannel channel, ConnectionProfile profile, ActionListener<Version> listener) {
        long requestId = this.responseHandlers.newRequestId();
        this.handshaker.sendHandshake(requestId, node, channel, profile.getHandshakeTimeout(), listener);
    }

    final TransportKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    final int getNumPendingHandshakes() {
        return this.handshaker.getNumPendingHandshakes();
    }

    final long getNumHandshakes() {
        return this.handshaker.getNumHandshakes();
    }

    final Set<TcpChannel> getAcceptedChannels() {
        return Collections.unmodifiableSet(this.acceptedChannels);
    }

    private void ensureOpen() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("transport has been stopped");
        }
    }

    @Override
    public final TransportStats getStats() {
        MeanMetric writeBytesMetric = this.statsTracker.getWriteBytes();
        long bytesWritten = this.statsTracker.getBytesWritten();
        long messagesSent = this.statsTracker.getMessagesSent();
        long messagesReceived = this.statsTracker.getMessagesReceived();
        long bytesRead = this.statsTracker.getBytesRead();
        return new TransportStats(this.acceptedChannels.size(), this.outboundConnectionCount.get(), messagesReceived, bytesRead, messagesSent, bytesWritten);
    }

    public static Set<ProfileSettings> getProfileSettings(Settings settings) {
        HashSet<ProfileSettings> profiles = new HashSet<ProfileSettings>();
        boolean isDefaultSet = false;
        for (String profile : settings.getGroups("transport.profiles.", true).keySet()) {
            profiles.add(new ProfileSettings(settings, profile));
            if (!"default".equals(profile)) continue;
            isDefaultSet = true;
        }
        if (!isDefaultSet) {
            profiles.add(new ProfileSettings(settings, "default"));
        }
        return Collections.unmodifiableSet(profiles);
    }

    @Override
    public final Transport.ResponseHandlers getResponseHandlers() {
        return this.responseHandlers;
    }

    @Override
    public final Transport.RequestHandlers getRequestHandlers() {
        return this.requestHandlers;
    }

    private final class ChannelsConnectedListener
    implements ActionListener<Void> {
        private final DiscoveryNode node;
        private final ConnectionProfile connectionProfile;
        private final List<TcpChannel> channels;
        private final ActionListener<Transport.Connection> listener;
        private final CountDown countDown;

        private ChannelsConnectedListener(DiscoveryNode node, ConnectionProfile connectionProfile, List<TcpChannel> channels, ActionListener<Transport.Connection> listener) {
            this.node = node;
            this.connectionProfile = connectionProfile;
            this.channels = channels;
            this.listener = listener;
            this.countDown = new CountDown(channels.size());
        }

        public void onResponse(Void v) {
            if (this.countDown.countDown()) {
                TcpChannel handshakeChannel = this.channels.get(0);
                try {
                    TcpTransport.this.executeHandshake(this.node, handshakeChannel, this.connectionProfile, (ActionListener<Version>)ActionListener.wrap(version -> {
                        long connectionId = TcpTransport.this.outboundConnectionCount.incrementAndGet();
                        logger.debug("opened transport connection [{}] to [{}] using channels [{}]", (Object)connectionId, (Object)this.node, this.channels);
                        NodeChannels nodeChannels = new NodeChannels(this.node, this.channels, this.connectionProfile, (Version)version);
                        long relativeMillisTime = TcpTransport.this.threadPool.relativeTimeInMillis();
                        nodeChannels.channels.forEach(ch -> {
                            ch.getChannelStats().markAccessed(relativeMillisTime);
                            ch.addCloseListener((ActionListener<Void>)ActionListener.wrap(nodeChannels::close));
                        });
                        TcpTransport.this.keepAlive.registerNodeConnection(nodeChannels.channels, this.connectionProfile);
                        nodeChannels.addCloseListener(new ChannelCloseLogger(this.node, connectionId, relativeMillisTime));
                        this.listener.onResponse((Object)nodeChannels);
                    }, e -> this.closeAndFail((Exception)(e instanceof ConnectTransportException ? e : new ConnectTransportException(this.node, "general node connection failure", (Throwable)e)))));
                }
                catch (Exception ex) {
                    this.closeAndFail(ex);
                }
            }
        }

        public void onFailure(Exception ex) {
            if (this.countDown.fastForward()) {
                this.closeAndFail((Exception)((Object)new ConnectTransportException(this.node, "connect_exception", ex)));
            }
        }

        public void onTimeout() {
            if (this.countDown.fastForward()) {
                this.closeAndFail((Exception)((Object)new ConnectTransportException(this.node, "connect_timeout[" + String.valueOf(this.connectionProfile.getConnectTimeout()) + "]")));
            }
        }

        private void closeAndFail(Exception e) {
            try {
                CloseableChannel.closeChannels(this.channels, false);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            finally {
                this.listener.onFailure(e);
            }
        }
    }

    @PublicApi(since="1.0.0")
    public static final class ProfileSettings {
        public final String profileName;
        public final boolean tcpNoDelay;
        public final boolean tcpKeepAlive;
        public final int tcpKeepIdle;
        public final int tcpKeepInterval;
        public final int tcpKeepCount;
        public final boolean reuseAddress;
        public final ByteSizeValue sendBufferSize;
        public final ByteSizeValue receiveBufferSize;
        public final List<String> bindHosts;
        public final List<String> publishHosts;
        public final String portOrRange;
        public final int publishPort;
        public final boolean isDefaultProfile;

        public ProfileSettings(Settings settings, String profileName) {
            this.profileName = profileName;
            this.isDefaultProfile = "default".equals(profileName);
            this.tcpKeepAlive = TransportSettings.TCP_KEEP_ALIVE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpKeepIdle = TransportSettings.TCP_KEEP_IDLE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpKeepInterval = TransportSettings.TCP_KEEP_INTERVAL_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpKeepCount = TransportSettings.TCP_KEEP_COUNT_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpNoDelay = TransportSettings.TCP_NO_DELAY_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.reuseAddress = TransportSettings.TCP_REUSE_ADDRESS_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.sendBufferSize = TransportSettings.TCP_SEND_BUFFER_SIZE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.receiveBufferSize = TransportSettings.TCP_RECEIVE_BUFFER_SIZE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            List<String> profileBindHosts = TransportSettings.BIND_HOST_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.bindHosts = profileBindHosts.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : profileBindHosts;
            this.publishHosts = TransportSettings.PUBLISH_HOST_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            Setting<String> concretePort = TransportSettings.PORT_PROFILE.getConcreteSettingForNamespace(profileName);
            if (!concretePort.exists(settings) && !this.isDefaultProfile) {
                throw new IllegalStateException("profile [" + profileName + "] has no port configured");
            }
            this.portOrRange = TransportSettings.PORT_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.publishPort = this.isDefaultProfile ? TransportSettings.PUBLISH_PORT.get(settings) : TransportSettings.PUBLISH_PORT_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
        }
    }

    public static class HttpRequestOnTransportException
    extends OpenSearchException {
        HttpRequestOnTransportException(String msg) {
            super(msg, new Object[0]);
        }

        public RestStatus status() {
            return RestStatus.BAD_REQUEST;
        }

        public HttpRequestOnTransportException(StreamInput in) throws IOException {
            super(in);
        }
    }

    private class ChannelCloseLogger
    implements ActionListener<Void> {
        private final DiscoveryNode node;
        private final long connectionId;
        private final long openTimeMillis;

        ChannelCloseLogger(DiscoveryNode node, long connectionId, long openTimeMillis) {
            this.node = node;
            this.connectionId = connectionId;
            this.openTimeMillis = openTimeMillis;
        }

        public void onResponse(Void ignored) {
            long closeTimeMillis = TcpTransport.this.threadPool.relativeTimeInMillis();
            logger.debug("closed transport connection [{}] to [{}] with age [{}ms]", (Object)this.connectionId, (Object)this.node, (Object)(closeTimeMillis - this.openTimeMillis));
        }

        public void onFailure(Exception e) {
            assert (false) : e;
        }
    }

    public final class NodeChannels
    extends CloseableConnection {
        private final Map<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle> typeMapping;
        private final List<TcpChannel> channels;
        private final DiscoveryNode node;
        private final Version version;
        private final boolean compress;
        private final AtomicBoolean isClosing = new AtomicBoolean(false);

        NodeChannels(DiscoveryNode node, List<TcpChannel> channels, ConnectionProfile connectionProfile, Version handshakeVersion) {
            this.node = node;
            this.channels = Collections.unmodifiableList(channels);
            assert (channels.size() == connectionProfile.getNumConnections()) : "expected channels size to be == " + connectionProfile.getNumConnections() + " but was: [" + channels.size() + "]";
            this.typeMapping = new EnumMap<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle>(TransportRequestOptions.Type.class);
            for (ConnectionProfile.ConnectionTypeHandle handle : connectionProfile.getHandles()) {
                for (TransportRequestOptions.Type type : handle.getTypes()) {
                    this.typeMapping.put(type, handle);
                }
            }
            this.version = handshakeVersion;
            this.compress = connectionProfile.getCompressionEnabled();
        }

        @Override
        public Version getVersion() {
            return this.version;
        }

        public List<TcpChannel> getChannels() {
            return this.channels;
        }

        public TcpChannel channel(TransportRequestOptions.Type type) {
            ConnectionProfile.ConnectionTypeHandle connectionTypeHandle = this.typeMapping.get((Object)type);
            if (connectionTypeHandle == null) {
                throw new IllegalArgumentException("no type channel for [" + String.valueOf((Object)type) + "]");
            }
            return connectionTypeHandle.getChannel(this.channels);
        }

        @Override
        public void close() {
            if (this.isClosing.compareAndSet(false, true)) {
                try {
                    boolean block = TcpTransport.this.lifecycle.stopped() && !Transports.isTransportThread(Thread.currentThread());
                    CloseableChannel.closeChannels(this.channels, block);
                }
                finally {
                    super.close();
                }
            }
        }

        @Override
        public DiscoveryNode getNode() {
            return this.node;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            if (this.isClosing.get()) {
                throw new NodeNotConnectedException(this.node, "connection already closed");
            }
            TcpChannel channel = this.channel(options.type());
            TcpTransport.this.handshakerHandler.sendRequest(this.node, channel, requestId, action, request, options, this.getVersion(), this.compress, false);
        }
    }
}

