/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.task;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.ForecastTask;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.UpdateByQueryAction;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.script.Script;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.common.exception.DuplicateTaskException;
import org.opensearch.timeseries.common.exception.ResourceNotFoundException;
import org.opensearch.timeseries.common.exception.TaskCancelledException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.function.BiCheckedFunction;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.function.ResponseTransformer;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.TaskState;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.task.RealtimeTaskCache;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.transport.JobResponse;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class TaskManager<TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>> {
    protected static int DEFAULT_MAINTAIN_INTERVAL_IN_SECONDS = 5;
    private final Logger logger = LogManager.getLogger(TaskManager.class);
    protected final TaskCacheManagerType taskCacheManager;
    protected final ClusterService clusterService;
    protected final Client client;
    protected final String stateIndex;
    protected final List<TaskTypeEnum> realTimeTaskTypes;
    private final List<TaskTypeEnum> historicalTaskTypes;
    private final List<TaskTypeEnum> runOnceTaskTypes;
    protected final IndexManagementType indexManagement;
    protected final NodeStateManager nodeStateManager;
    protected final AnalysisType analysisType;
    protected final NamedXContentRegistry xContentRegistry;
    protected final String configIdFieldName;
    protected volatile Integer maxOldTaskDocsPerConfig;
    protected final ThreadPool threadPool;
    private final String allResultIndexPattern;
    private final String batchTaskThreadPoolName;
    private volatile boolean deleteResultWhenDeleteConfig;
    private final TaskState stopped;

    public TaskManager(TaskCacheManagerType taskCacheManager, ClusterService clusterService, Client client, String stateIndex, List<TaskTypeEnum> realTimeTaskTypes, List<TaskTypeEnum> historicalTaskTypes, List<TaskTypeEnum> runOnceTaskTypes, IndexManagementType indexManagement, NodeStateManager nodeStateManager, AnalysisType analysisType, NamedXContentRegistry xContentRegistry, String configIdFieldName, Setting<Integer> maxOldADTaskDocsPerConfigSetting, Settings settings, ThreadPool threadPool, String allResultIndexPattern, String batchTaskThreadPoolName, Setting<Boolean> deleteResultWhenDeleteConfigSetting, TaskState stopped) {
        this.taskCacheManager = taskCacheManager;
        this.clusterService = clusterService;
        this.client = client;
        this.stateIndex = stateIndex;
        this.realTimeTaskTypes = realTimeTaskTypes;
        this.historicalTaskTypes = historicalTaskTypes;
        this.runOnceTaskTypes = runOnceTaskTypes;
        this.indexManagement = indexManagement;
        this.nodeStateManager = nodeStateManager;
        this.analysisType = analysisType;
        this.xContentRegistry = xContentRegistry;
        this.configIdFieldName = configIdFieldName;
        this.maxOldTaskDocsPerConfig = (Integer)maxOldADTaskDocsPerConfigSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(maxOldADTaskDocsPerConfigSetting, it -> {
            this.maxOldTaskDocsPerConfig = it;
        });
        this.threadPool = threadPool;
        this.allResultIndexPattern = allResultIndexPattern;
        this.batchTaskThreadPoolName = batchTaskThreadPoolName;
        this.deleteResultWhenDeleteConfig = (Boolean)deleteResultWhenDeleteConfigSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(deleteResultWhenDeleteConfigSetting, it -> {
            this.deleteResultWhenDeleteConfig = it;
        });
        this.stopped = stopped;
    }

    public boolean skipUpdateRealtimeTask(String configId, String error) {
        RealtimeTaskCache realtimeTaskCache = ((TaskCacheManager)this.taskCacheManager).getRealtimeTaskCache(configId);
        return realtimeTaskCache != null && realtimeTaskCache.getInitProgress() != null && (double)realtimeTaskCache.getInitProgress().floatValue() == 1.0 && Objects.equals(error, realtimeTaskCache.getError());
    }

    public boolean isRealtimeTaskStartInitializing(String configId) {
        RealtimeTaskCache realtimeTaskCache = ((TaskCacheManager)this.taskCacheManager).getRealtimeTaskCache(configId);
        return realtimeTaskCache != null && realtimeTaskCache.getInitProgress() != null && realtimeTaskCache.getInitProgress().floatValue() > 0.0f;
    }

    public void maintainRunningRealtimeTasks() {
        String[] configIds = ((TaskCacheManager)this.taskCacheManager).getConfigIdsInRealtimeTaskCache();
        if (configIds == null || configIds.length == 0) {
            return;
        }
        for (int i = 0; i < configIds.length; ++i) {
            String configId = configIds[i];
            RealtimeTaskCache taskCache = ((TaskCacheManager)this.taskCacheManager).getRealtimeTaskCache(configId);
            if (taskCache == null || !taskCache.expired()) continue;
            ((TaskCacheManager)this.taskCacheManager).removeRealtimeTaskCache(configId);
        }
    }

    public void refreshRealtimeJobRunTime(String detectorId) {
        ((TaskCacheManager)this.taskCacheManager).refreshRealtimeJobRunTime(detectorId);
    }

    public void removeRealtimeTaskCache(String detectorId) {
        ((TaskCacheManager)this.taskCacheManager).removeRealtimeTaskCache(detectorId);
    }

    public void updateLatestRealtimeTask(String configId, String state, Long rcfTotalUpdates, Long intervalInMinutes, String error, boolean coordinatingNode, Boolean hasResult, ActionListener<UpdateResponse> listener) {
        Float initProgress = null;
        String newState = null;
        newState = state != null ? state : this.triageState(hasResult, error, rcfTotalUpdates);
        error = Optional.ofNullable(error).orElse("");
        if (intervalInMinutes != null && rcfTotalUpdates != null) {
            initProgress = rcfTotalUpdates < 32L ? Float.valueOf((float)rcfTotalUpdates.longValue() / 32.0f) : Float.valueOf(1.0f);
        }
        RealtimeTaskCache realtimeTaskCache = ((TaskCacheManager)this.taskCacheManager).getRealtimeTaskCache(configId);
        String oldState = null;
        if (realtimeTaskCache != null) {
            oldState = realtimeTaskCache.getState();
        }
        if (!((TaskCacheManager)this.taskCacheManager).isRealtimeTaskChangeNeeded(configId, newState, initProgress, error) || this.forbidOverrideChange(configId, newState, oldState)) {
            listener.onResponse(null);
            return;
        }
        HashMap<String, Object> updatedFields = new HashMap<String, Object>();
        if (coordinatingNode) {
            updatedFields.put("coordinating_node", this.clusterService.localNode().getId());
        }
        if (initProgress != null) {
            updatedFields.put("init_progress", initProgress);
            updatedFields.put("estimated_minutes_left", Math.max(0L, 32L - rcfTotalUpdates) * intervalInMinutes);
        }
        if (newState != null) {
            updatedFields.put("state", newState);
        }
        if (error != null) {
            updatedFields.put("error", error);
        }
        Float finalInitProgress = initProgress;
        String finalError = error;
        String finalNewState = newState;
        this.updateLatestTask(configId, this.realTimeTaskTypes, updatedFields, (ActionListener<UpdateResponse>)ActionListener.wrap(r -> {
            this.logger.debug("Updated latest realtime AD task successfully for config {}", (Object)configId);
            ((TaskCacheManager)this.taskCacheManager).updateRealtimeTaskCache(configId, finalNewState, finalInitProgress, finalError);
            listener.onResponse(r);
        }, e -> {
            this.logger.error("Failed to update realtime task for config " + configId, (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public void updateLatestRealtimeTaskOnCoordinatingNode(String configId, String state, Long rcfTotalUpdates, Long intervalInMinutes, String error, Boolean hasResult, ActionListener<UpdateResponse> listener) {
        this.updateLatestRealtimeTask(configId, state, rcfTotalUpdates, intervalInMinutes, error, true, hasResult, listener);
    }

    public void updateLatestTask(String configId, List<TaskTypeEnum> taskTypes, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        this.getAndExecuteOnLatestConfigLevelTask(configId, taskTypes, task -> {
            if (task.isPresent()) {
                this.updateTask(((TimeSeriesTask)task.get()).getTaskId(), updatedFields, listener);
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException(configId, CommonMessages.CAN_NOT_FIND_LATEST_TASK));
            }
        }, null, false, listener);
    }

    public void getAndExecuteOnLatestConfigLevelTask(Config config, DateRange dateRange, boolean runOnce, User user, TransportService transportService, ActionListener<JobResponse> listener) {
        this.getAndExecuteOnLatestConfigLevelTask(config.getId(), this.getTaskTypes(dateRange), task -> {
            if (!task.isPresent() || ((TimeSeriesTask)task.get()).isDone()) {
                this.updateLatestFlagOfOldTasksAndCreateNewTask(config, dateRange, runOnce, user, TaskState.CREATED, listener);
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.CONFIG_IS_RUNNING, RestStatus.BAD_REQUEST, new Object[0]));
            }
        }, transportService, true, listener);
    }

    public <T> void updateLatestFlagOfOldTasksAndCreateNewTask(Config config, DateRange dateRange, boolean runOnce, User user, TaskState initialState, ActionListener<T> listener) {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest();
        updateByQueryRequest.indices(new String[]{this.stateIndex});
        BoolQueryBuilder query = new BoolQueryBuilder();
        query.filter((QueryBuilder)new TermQueryBuilder(this.configIdFieldName, config.getId()));
        query.filter((QueryBuilder)new TermQueryBuilder("is_latest", true));
        query.filter((QueryBuilder)new TermsQueryBuilder("task_type", TaskType.taskTypeToString(this.getTaskTypes(dateRange, runOnce))));
        updateByQueryRequest.setQuery((QueryBuilder)query);
        updateByQueryRequest.setRefresh(true);
        String script = String.format(Locale.ROOT, "ctx._source.%s=%s;", "is_latest", false);
        updateByQueryRequest.setScript(new Script(script));
        this.client.execute((ActionType)UpdateByQueryAction.INSTANCE, (ActionRequest)updateByQueryRequest, ActionListener.wrap(r -> {
            List bulkFailures = r.getBulkFailures();
            if (bulkFailures.isEmpty()) {
                String coordinatingNode = dateRange == null ? null : this.clusterService.localNode().getId();
                this.createNewTask(config, dateRange, runOnce, user, coordinatingNode, initialState, listener);
            } else {
                this.logger.error("Failed to update old task's state for config: {}, response: {} ", (Object)config.getId(), (Object)r.toString());
                listener.onFailure(((BulkItemResponse.Failure)bulkFailures.get(0)).getCause());
            }
        }, e -> {
            this.logger.error("Failed to reset old tasks as not latest for config " + config.getId(), (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public <T> void getAndExecuteOnLatestConfigLevelTask(String configId, List<TaskTypeEnum> taskTypes, Consumer<Optional<TaskClass>> function, TransportService transportService, boolean resetTaskState, ActionListener<T> listener) {
        this.getAndExecuteOnLatestConfigTask(configId, null, null, taskTypes, function, transportService, resetTaskState, listener);
    }

    public <T> void getAndExecuteOnLatestConfigTask(String configId, String parentTaskId, Entity entity, List<TaskTypeEnum> taskTypes, Consumer<Optional<TaskClass>> function, TransportService transportService, boolean resetTaskState, ActionListener<T> listener) {
        this.getAndExecuteOnLatestTasks(configId, parentTaskId, entity, taskTypes, taskList -> {
            if (taskList != null && taskList.size() > 0) {
                function.accept(Optional.ofNullable((TimeSeriesTask)taskList.get(0)));
            } else {
                function.accept(Optional.empty());
            }
        }, transportService, resetTaskState, 1, listener);
    }

    public List<TaskTypeEnum> getTaskTypes(DateRange dateRange) {
        return this.getTaskTypes(dateRange, false);
    }

    public void stopLatestRealtimeTask(String configId, TaskState state, Exception error, TransportService transportService, ActionListener<JobResponse> listener) {
        this.getAndExecuteOnLatestConfigLevelTask(configId, this.realTimeTaskTypes, adTask -> {
            if (adTask.isPresent() && !((TimeSeriesTask)adTask.get()).isDone()) {
                HashMap<String, String> updatedFields = new HashMap<String, String>();
                updatedFields.put("state", state.name());
                if (error != null) {
                    updatedFields.put("error", ExceptionUtil.getErrorMessage(error));
                }
                ExecutorFunction function = () -> this.updateTask(((TimeSeriesTask)adTask.get()).getTaskId(), updatedFields, (ActionListener<UpdateResponse>)ActionListener.wrap(r -> {
                    if (error == null) {
                        listener.onResponse((Object)new JobResponse(configId));
                    } else {
                        listener.onFailure(error);
                    }
                }, e -> listener.onFailure(e)));
                String coordinatingNode = ((TimeSeriesTask)adTask.get()).getCoordinatingNode();
                if (coordinatingNode != null && transportService != null) {
                    this.cleanConfigCache((TimeSeriesTask)adTask.get(), transportService, function, listener);
                } else {
                    function.execute();
                }
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException("job is already stopped: " + configId, RestStatus.OK, new Object[0]));
            }
        }, null, false, listener);
    }

    protected <T> void resetTaskStateAsStopped(TimeSeriesTask task, ExecutorFunction function, TransportService transportService, ActionListener<T> listener) {
        this.cleanConfigCache(task, transportService, () -> {
            String taskId = task.getTaskId();
            ImmutableMap updatedFields = ImmutableMap.of((Object)"state", (Object)this.stopped.name());
            this.updateTask(taskId, (Map<String, Object>)updatedFields, (ActionListener<UpdateResponse>)ActionListener.wrap(r -> {
                task.setState(this.stopped.name());
                if (function != null) {
                    function.execute();
                }
                if (this.isHistoricalHCTask(task)) {
                    this.resetEntityTasksAsStopped(taskId);
                }
            }, e -> {
                this.logger.error("Failed to update task state as stopped for task " + taskId, (Throwable)e);
                listener.onFailure(e);
            }));
        }, listener);
    }

    public <T> void getAndExecuteOnLatestTasks(String configId, String parentTaskId, Entity entity, List<TaskTypeEnum> taskTypes, Consumer<List<TaskClass>> function, TransportService transportService, boolean resetTaskState, int size, ActionListener<T> listener) {
        BoolQueryBuilder query = new BoolQueryBuilder();
        query.filter((QueryBuilder)new TermQueryBuilder(this.configIdFieldName, configId));
        query.filter((QueryBuilder)new TermQueryBuilder("is_latest", true));
        if (parentTaskId != null) {
            query.filter((QueryBuilder)new TermQueryBuilder("parent_task_id", parentTaskId));
        }
        if (taskTypes != null && taskTypes.size() > 0) {
            query.filter((QueryBuilder)new TermsQueryBuilder("task_type", TaskType.taskTypeToString(taskTypes)));
        }
        if (entity != null && !ParseUtils.isNullOrEmpty(entity.getAttributes())) {
            String path = "entity";
            String entityKeyFieldName = path + ".name";
            String entityValueFieldName = path + ".value";
            for (Map.Entry<String, String> attribute : entity.getAttributes().entrySet()) {
                BoolQueryBuilder entityBoolQuery = new BoolQueryBuilder();
                TermQueryBuilder entityKeyFilterQuery = QueryBuilders.termQuery((String)entityKeyFieldName, (String)attribute.getKey());
                TermQueryBuilder entityValueFilterQuery = QueryBuilders.termQuery((String)entityValueFieldName, (String)attribute.getValue());
                entityBoolQuery.filter((QueryBuilder)entityKeyFilterQuery).filter((QueryBuilder)entityValueFilterQuery);
                NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder(path, (QueryBuilder)entityBoolQuery, ScoreMode.None);
                query.filter((QueryBuilder)nestedQueryBuilder);
            }
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)query).sort("execution_start_time", SortOrder.DESC).size(size);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(sourceBuilder);
        searchRequest.indices(new String[]{this.stateIndex});
        this.client.search(searchRequest, ActionListener.wrap(r -> {
            ArrayList<TimeSeriesTask> tsTasks = new ArrayList<TimeSeriesTask>();
            if (r == null || r.getHits().getTotalHits() == null || r.getHits().getTotalHits().value() == 0L) {
                function.accept(tsTasks);
                return;
            }
            BiCheckedFunction<XContentParser, String, TaskClass, IOException> parserMethod = this.getTaskParser();
            for (SearchHit searchHit : r.getHits()) {
                try {
                    XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, searchHit.getSourceRef());
                    try {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        TimeSeriesTask tsTask = (TimeSeriesTask)parserMethod.apply(parser, searchHit.getId());
                        tsTasks.add(tsTask);
                    }
                    finally {
                        if (parser == null) continue;
                        parser.close();
                    }
                }
                catch (Exception e) {
                    String message = "Failed to parse task for config " + configId + ", task id " + searchHit.getId();
                    this.logger.error(message, (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }
            if (resetTaskState) {
                this.resetLatestConfigTaskState(tsTasks, function, transportService, listener);
            } else {
                function.accept(tsTasks);
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                function.accept(new ArrayList());
            } else if (e instanceof SearchPhaseExecutionException && e.getMessage().contains("No mapping found for")) {
                function.accept(new ArrayList());
            } else {
                this.logger.error("Failed to search task for config " + configId, (Throwable)e);
                listener.onFailure(e);
            }
        }));
    }

    protected <T> void resetRealtimeConfigTaskState(List<TimeSeriesTask> runningRealtimeTasks, ExecutorFunction function, TransportService transportService, ActionListener<T> listener) {
        if (ParseUtils.isNullOrEmpty(runningRealtimeTasks)) {
            function.execute();
            return;
        }
        TimeSeriesTask tsTask = runningRealtimeTasks.get(0);
        String configId = tsTask.getConfigId();
        GetRequest getJobRequest = new GetRequest(".opendistro-anomaly-detector-jobs").id(configId);
        this.client.get(getJobRequest, ActionListener.wrap(r -> {
            if (r.isExists()) {
                try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    Job job = Job.parse(parser);
                    if (!job.isEnabled()) {
                        this.logger.debug("job is disabled, reset realtime task as stopped for config {}", (Object)configId);
                        this.resetTaskStateAsStopped(tsTask, function, transportService, listener);
                    } else {
                        function.execute();
                    }
                }
                catch (IOException e) {
                    this.logger.error(" Failed to parse job " + configId, (Throwable)e);
                    listener.onFailure((Exception)e);
                }
            } else {
                this.logger.debug("job is not found, reset realtime task as stopped for config {}", (Object)configId);
                this.resetTaskStateAsStopped(tsTask, function, transportService, listener);
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                this.logger.debug("job is not found, reset realtime task as stopped for config {}", (Object)configId);
                this.resetTaskStateAsStopped(tsTask, function, transportService, listener);
            } else {
                this.logger.error("Fail to get realtime job for config " + configId, (Throwable)e);
                listener.onFailure(e);
            }
        }));
    }

    public void handleTaskException(TaskClass task, Exception e) {
        String state = TaskState.FAILED.name();
        HashMap<String, Object> updatedFields = new HashMap<String, Object>();
        if (e instanceof DuplicateTaskException) {
            this.logger.warn("There is already one running task for config, configId:" + ((TimeSeriesTask)task).getConfigId() + ". Will delete task " + ((TimeSeriesTask)task).getTaskId());
            this.deleteTask(((TimeSeriesTask)task).getTaskId());
            return;
        }
        if (e instanceof TaskCancelledException) {
            this.logger.info("task cancelled, taskId: {}, configId: {}", (Object)((TimeSeriesTask)task).getTaskId(), (Object)((TimeSeriesTask)task).getConfigId());
            state = this.stopped.name();
            String stoppedBy = ((TaskCancelledException)e).getCancelledBy();
            if (stoppedBy != null) {
                updatedFields.put("stopped_by", stoppedBy);
            }
        } else {
            this.logger.error("Failed to execute batch task, task id: " + ((TimeSeriesTask)task).getTaskId() + ", config id: " + ((TimeSeriesTask)task).getConfigId(), (Throwable)e);
        }
        updatedFields.put("error", ExceptionUtil.getErrorMessage(e));
        updatedFields.put("state", state);
        updatedFields.put("execution_end_time", Instant.now().toEpochMilli());
        this.updateTask(((TimeSeriesTask)task).getTaskId(), updatedFields);
    }

    public void updateTask(String taskId, Map<String, Object> updatedFields) {
        this.updateTask(taskId, updatedFields, (ActionListener<UpdateResponse>)ActionListener.wrap(response -> {
            if (response.status() == RestStatus.OK) {
                this.logger.debug("Updated task successfully: {}, task id: {}", (Object)response.status(), (Object)taskId);
            } else {
                this.logger.error("Failed to update task {}, status: {}", (Object)taskId, (Object)response.status());
            }
        }, e -> this.logger.error("Failed to update task: " + taskId, (Throwable)e)));
    }

    public void updateTask(String taskId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        UpdateRequest updateRequest = new UpdateRequest(this.stateIndex, taskId);
        HashMap<String, Object> updatedContent = new HashMap<String, Object>();
        updatedContent.putAll(updatedFields);
        updatedContent.put("last_update_time", Instant.now().toEpochMilli());
        updateRequest.doc(updatedContent);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        updateRequest.retryOnConflict(2);
        this.client.update(updateRequest, listener);
    }

    public void deleteTask(String taskId) {
        this.deleteTask(taskId, (ActionListener<DeleteResponse>)ActionListener.wrap(r -> this.logger.info("Deleted task {} with status: {}", (Object)taskId, (Object)r.status()), e -> this.logger.error("Failed to delete task " + taskId, (Throwable)e)));
    }

    public void deleteTask(String taskId, ActionListener<DeleteResponse> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(this.stateIndex, taskId);
        this.client.delete(deleteRequest, listener);
    }

    public <T> void createTaskDirectly(TaskClass tsTask, Consumer<IndexResponse> function, ActionListener<T> listener) {
        IndexRequest request = new IndexRequest(this.stateIndex);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            request.source(((TimeSeriesTask)tsTask).toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.index(request, ActionListener.wrap(r -> function.accept((IndexResponse)r), e -> {
                this.logger.error("Failed to create task for config " + tsTask.getConfigId(), (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            this.logger.error("Failed to create task for config " + ((TimeSeriesTask)tsTask).getConfigId(), (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    protected <T> void cleanOldConfigTaskDocs(IndexResponse response, TaskClass tsTask, ResponseTransformer<IndexResponse, T> responseTransformer, ActionListener<T> delegatedListener) {
        BoolQueryBuilder query = new BoolQueryBuilder();
        query.filter((QueryBuilder)new TermQueryBuilder(this.configIdFieldName, ((TimeSeriesTask)tsTask).getConfigId()));
        query.filter((QueryBuilder)new TermQueryBuilder("is_latest", false));
        if (((TimeSeriesTask)tsTask).isHistoricalTask()) {
            query.filter((QueryBuilder)new TermsQueryBuilder("task_type", TaskType.taskTypeToString(this.historicalTaskTypes)));
        } else if (((TimeSeriesTask)tsTask).isRunOnceTask()) {
            query.filter((QueryBuilder)new TermsQueryBuilder("task_type", TaskType.taskTypeToString(this.runOnceTaskTypes)));
        } else {
            query.filter((QueryBuilder)new TermsQueryBuilder("task_type", TaskType.taskTypeToString(this.realTimeTaskTypes)));
        }
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)query).sort("execution_start_time", SortOrder.DESC).from(this.maxOldTaskDocsPerConfig.intValue()).size(AnomalyDetectorSettings.MAX_OLD_AD_TASK_DOCS);
        searchRequest.source(sourceBuilder).indices(new String[]{this.stateIndex});
        String configId = ((TimeSeriesTask)tsTask).getConfigId();
        this.deleteTaskDocs(configId, searchRequest, () -> {
            if (tsTask.isHistoricalTask()) {
                this.runBatchResultAction(response, tsTask, responseTransformer, delegatedListener);
            } else {
                Object transformedResponse = responseTransformer.transform(response);
                delegatedListener.onResponse(transformedResponse);
            }
        }, delegatedListener);
    }

    public <T> void deleteTaskDocs(String configId, SearchRequest searchRequest, ExecutorFunction function, ActionListener<T> listener) {
        ActionListener searchListener = ActionListener.wrap(r -> {
            Iterator iterator = r.getHits().iterator();
            if (iterator.hasNext()) {
                BulkRequest bulkRequest = new BulkRequest();
                while (iterator.hasNext()) {
                    SearchHit searchHit = (SearchHit)iterator.next();
                    try {
                        XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, searchHit.getSourceRef());
                        try {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                            TimeSeriesTask task = null;
                            task = this.analysisType.isAD() ? ADTask.parse(parser, searchHit.getId()) : ForecastTask.parse(parser, searchHit.getId());
                            this.logger.debug("Delete old task: {} of config: {}", (Object)task.getTaskId(), (Object)task.getConfigId());
                            bulkRequest.add(new DeleteRequest(this.stateIndex).id(task.getTaskId()));
                        }
                        finally {
                            if (parser == null) continue;
                            parser.close();
                        }
                    }
                    catch (Exception e2) {
                        listener.onFailure(e2);
                    }
                }
                this.client.execute((ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, ActionListener.wrap(res -> {
                    this.logger.info("Old tasks deleted for config {}", (Object)configId);
                    BulkItemResponse[] bulkItemResponses = res.getItems();
                    if (bulkItemResponses != null && bulkItemResponses.length > 0) {
                        for (BulkItemResponse bulkItemResponse : bulkItemResponses) {
                            if (bulkItemResponse.isFailed()) continue;
                            this.logger.debug("Add config task into cache. Task id: {}", (Object)bulkItemResponse.getId());
                            ((TaskCacheManager)this.taskCacheManager).addDeletedTask(bulkItemResponse.getId());
                        }
                    }
                    this.cleanChildTasksAndResultsOfDeletedTask();
                    function.execute();
                }, e -> {
                    this.logger.warn("Failed to clean tasks for config " + configId, (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                function.execute();
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                function.execute();
            } else {
                listener.onFailure(e);
            }
        });
        this.client.search(searchRequest, searchListener);
    }

    public void cleanChildTasksAndResultsOfDeletedTask() {
        if (!((TaskCacheManager)this.taskCacheManager).hasDeletedTask()) {
            return;
        }
        this.threadPool.schedule(() -> {
            String taskId = ((TaskCacheManager)this.taskCacheManager).pollDeletedTask();
            if (taskId == null) {
                return;
            }
            DeleteByQueryRequest deleteResultsRequest = new DeleteByQueryRequest(new String[]{this.allResultIndexPattern});
            deleteResultsRequest.setQuery((QueryBuilder)new TermsQueryBuilder("task_id", new String[]{taskId}));
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteResultsRequest, ActionListener.wrap(res -> {
                this.logger.debug("Successfully deleted results of task " + taskId);
                DeleteByQueryRequest deleteChildTasksRequest = new DeleteByQueryRequest(new String[]{this.stateIndex});
                deleteChildTasksRequest.setQuery((QueryBuilder)new TermsQueryBuilder("parent_task_id", new String[]{taskId}));
                this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteChildTasksRequest, ActionListener.wrap(r -> {
                    this.logger.debug("Successfully deleted child tasks of task " + taskId);
                    this.cleanChildTasksAndResultsOfDeletedTask();
                }, e -> this.logger.error("Failed to delete child tasks of task " + taskId, (Throwable)e)));
            }, ex -> this.logger.error("Failed to delete results for task " + taskId, (Throwable)ex)));
        }, TimeValue.timeValueSeconds((long)DEFAULT_MAINTAIN_INTERVAL_IN_SECONDS), this.batchTaskThreadPoolName);
    }

    protected void resetEntityTasksAsStopped(String configTaskId) {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest();
        updateByQueryRequest.indices(new String[]{this.stateIndex});
        BoolQueryBuilder query = new BoolQueryBuilder();
        query.filter((QueryBuilder)new TermQueryBuilder("parent_task_id", configTaskId));
        query.filter((QueryBuilder)new TermQueryBuilder("task_type", ADTaskType.HISTORICAL_HC_ENTITY.name()));
        query.filter((QueryBuilder)new TermsQueryBuilder("state", TaskState.NOT_ENDED_STATES));
        updateByQueryRequest.setQuery((QueryBuilder)query);
        updateByQueryRequest.setRefresh(true);
        String script = String.format(Locale.ROOT, "ctx._source.%s='%s';", "state", TaskState.INACTIVE.name());
        updateByQueryRequest.setScript(new Script(script));
        this.client.execute((ActionType)UpdateByQueryAction.INSTANCE, (ActionRequest)updateByQueryRequest, ActionListener.wrap(r -> {
            List bulkFailures = r.getBulkFailures();
            if (ParseUtils.isNullOrEmpty(bulkFailures)) {
                this.logger.debug("Updated {} child entity tasks state for config task {}", (Object)r.getUpdated(), (Object)configTaskId);
            } else {
                this.logger.error("Failed to update child entity task's state for config task {} ", (Object)configTaskId);
            }
        }, e -> this.logger.error("Exception happened when update child entity task's state for config task " + configTaskId, (Throwable)e)));
    }

    public void resetLatestFlagAsFalse(List<TaskClass> tasks) {
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        tasks.forEach(task -> {
            try {
                task.setLatest(false);
                task.setLastUpdateTime(Instant.now());
                IndexRequest indexRequest = new IndexRequest(this.stateIndex).id(task.getTaskId()).source(task.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("Fail to parse task task to XContent, task id " + task.getTaskId(), (Throwable)e);
            }
        });
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.execute((ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, ActionListener.wrap(res -> {
            BulkItemResponse[] bulkItemResponses = res.getItems();
            if (bulkItemResponses != null && bulkItemResponses.length > 0) {
                for (BulkItemResponse bulkItemResponse : bulkItemResponses) {
                    if (!bulkItemResponse.isFailed()) {
                        this.logger.warn("Reset tasks latest flag as false Successfully. Task id: {}", (Object)bulkItemResponse.getId());
                        continue;
                    }
                    this.logger.warn("Failed to reset tasks latest flag as false. Task id: " + bulkItemResponse.getId());
                }
            }
        }, e -> this.logger.warn("Failed to reset AD tasks latest flag as false", (Throwable)e)));
    }

    public void deleteTasks(String configId, ExecutorFunction function, ActionListener<DeleteResponse> listener) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{this.stateIndex});
        BoolQueryBuilder query = new BoolQueryBuilder();
        query.filter((QueryBuilder)new TermQueryBuilder(this.configIdFieldName, configId));
        request.setQuery((QueryBuilder)query);
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
            if (r.getBulkFailures() == null || r.getBulkFailures().size() == 0) {
                this.logger.info("tasks deleted for config {}", (Object)configId);
                this.deleteResultOfConfig(configId);
                function.execute();
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException("Failed to delete all tasks", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, e -> {
            this.logger.info("Failed to delete tasks for " + configId, (Throwable)e);
            if (e instanceof IndexNotFoundException) {
                this.deleteResultOfConfig(configId);
                function.execute();
            } else {
                listener.onFailure(e);
            }
        }));
    }

    public void deleteResultOfConfig(String configId) {
        if (!this.deleteResultWhenDeleteConfig) {
            this.logger.info("Won't delete result for {} as delete result setting is disabled", (Object)configId);
            return;
        }
        this.logger.info("Start to delete results of config {}", (Object)configId);
        DeleteByQueryRequest deleteADResultsRequest = new DeleteByQueryRequest(new String[]{this.allResultIndexPattern});
        deleteADResultsRequest.setQuery((QueryBuilder)new TermQueryBuilder(this.configIdFieldName, configId));
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteADResultsRequest, ActionListener.wrap(response -> this.logger.debug("Successfully deleted results of config " + configId), exception -> {
            this.logger.error("Failed to delete results of config " + configId, (Throwable)exception);
            ((TaskCacheManager)this.taskCacheManager).addDeletedConfig(configId);
        }));
    }

    public void getTask(String taskId, ActionListener<Optional<TaskClass>> listener) {
        GetRequest request = new GetRequest(this.stateIndex, taskId);
        this.client.get(request, ActionListener.wrap(r -> {
            if (r != null && r.isExists()) {
                try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    BiCheckedFunction<XContentParser, String, TaskClass, IOException> parserMethod = this.getTaskParser();
                    TimeSeriesTask tsTask = (TimeSeriesTask)parserMethod.apply(parser, r.getId());
                    listener.onResponse(Optional.ofNullable(tsTask));
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse task " + r.getId(), (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                listener.onResponse(Optional.empty());
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse(Optional.empty());
            } else {
                this.logger.error("Failed to get task " + taskId, (Throwable)e);
                listener.onFailure(e);
            }
        }));
    }

    public void cleanResultOfDeletedConfig() {
        String detectorId = ((TaskCacheManager)this.taskCacheManager).pollDeletedConfig();
        if (detectorId != null) {
            this.deleteResultOfConfig(detectorId);
        }
    }

    public abstract void startHistorical(Config var1, DateRange var2, User var3, TransportService var4, ActionListener<JobResponse> var5);

    protected abstract TaskType getTaskType(Config var1, DateRange var2, boolean var3);

    protected abstract <T> void createNewTask(Config var1, DateRange var2, boolean var3, User var4, String var5, TaskState var6, ActionListener<T> var7);

    public abstract <T> void cleanConfigCache(TimeSeriesTask var1, TransportService var2, ExecutorFunction var3, ActionListener<T> var4);

    protected abstract boolean isHistoricalHCTask(TimeSeriesTask var1);

    protected abstract <T> void resetLatestConfigTaskState(List<TaskClass> var1, Consumer<List<TaskClass>> var2, TransportService var3, ActionListener<T> var4);

    protected abstract <T> void onIndexConfigTaskResponse(IndexResponse var1, TaskClass var2, BiConsumer<IndexResponse, ActionListener<T>> var3, ActionListener<T> var4);

    protected abstract <T> void runBatchResultAction(IndexResponse var1, TaskClass var2, ResponseTransformer<IndexResponse, T> var3, ActionListener<T> var4);

    protected abstract BiCheckedFunction<XContentParser, String, TaskClass, IOException> getTaskParser();

    public abstract void initRealtimeTaskCacheAndCleanupStaleCache(String var1, Config var2, TransportService var3, ActionListener<Boolean> var4);

    public abstract void createRunOnceTaskAndCleanupStaleTasks(String var1, Config var2, TransportService var3, ActionListener<TaskClass> var4);

    public abstract List<TaskTypeEnum> getTaskTypes(DateRange var1, boolean var2);

    protected abstract String triageState(Boolean var1, String var2, Long var3);

    protected abstract boolean forbidOverrideChange(String var1, String var2, String var3);
}

