"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSimplifiedBreadcrumbs", {
  enumerable: true,
  get: function get() {
    return _simplified_breadcrumbs.EuiSimplifiedBreadcrumbs;
  }
});
exports.OuiSimplifiedBreadcrumbs = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../../i18n");

var _inner_text = require("../../inner_text");

var _link = require("../../link");

var _popover = require("../../popover");

var _icon = require("../../icon");

var _services = require("../../../services");

var _breakpoint = require("../../../services/breakpoint");

var _simplified_breadcrumbs = require("../../../eui_components/breadcrumbs/simplified_breadcrumbs/simplified_breadcrumbs");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* Try to fit breadcrumbs with at least 135px into the width of each of the BREAKPOINTS
 *    1. put aside 250px for the last breadcrumb and possible loss due to layout
 *    2. provide at least 135px for each remaining breadcrumb
 *
 *     * OuiBreadcrumbs has 48px padding on the side with a max-width of 160px
 *     * OuiSimplifiedBreadcrumbs has 24px for gap and separator
 *     * To be uniform
 *           160px - 48px + 24px ≈ 135px for each simplified breadcrumb
 *           275px - 48px + 24px ≈ 250px for last simplified breadcrumb and external spacing
 *
 *    numberOfBreadcrumbs = (breakpointWidth - 251) / 136 + 1
 */
var responsiveDefault = {
  xs: 1,
  // Show only one
  s: 3,
  //  (575 - 250) / 135 + 1 = 3.40
  m: 4,
  //  (768 - 250) / 135 + 1 = 4.83
  l: 6,
  //  (992 - 250) / 135 + 1 = 6.49
  xl: 8,
  // (1200 - 250) / 135 + 1 = 8.04
  xxl: 11,
  // (1680 - 250) / 135 + 1 = 11.59
  xxxl: 13 // (1920 - 250) / 135 + 1 = 13.37

};
/*
  xxxl: 1920,
  xxl: 1680,
  xl: 1200,
  l: 992,
  m: 768,
  s: 575,
 */

var limitBreadcrumbs = function limitBreadcrumbs(breadcrumbs, max, allBreadcrumbs) {
  var breadcrumbsAtStart = [];
  var breadcrumbsAtEnd = [];
  var limit = Math.min(max, breadcrumbs.length);
  var start = Math.floor(limit / 2);
  var overflowBreadcrumbs = allBreadcrumbs.slice(start, start + breadcrumbs.length - limit);

  for (var i = 0; i < limit; i++) {
    // We'll alternate with displaying breadcrumbs at the end and at the start, but be biased
    // towards breadcrumbs the end so that if max is an odd number, we'll have one more
    // breadcrumb visible at the end than at the beginning.
    var isEven = i % 2 === 0; // We're picking breadcrumbs from the front AND the back, so we treat each iteration as a
    // half-iteration.

    var normalizedIndex = Math.floor(i * 0.5);
    var indexOfBreadcrumb = isEven ? breadcrumbs.length - 1 - normalizedIndex : normalizedIndex;
    var breadcrumb = breadcrumbs[indexOfBreadcrumb];

    if (isEven) {
      breadcrumbsAtEnd.unshift(breadcrumb);
    } else {
      breadcrumbsAtStart.push(breadcrumb);
    }
  }

  var OuiBreadcrumbCollapsed = function OuiBreadcrumbCollapsed() {
    var _useState = (0, _react.useState)(false),
        _useState2 = (0, _slicedToArray2.default)(_useState, 2),
        isPopoverOpen = _useState2[0],
        setIsPopoverOpen = _useState2[1];

    var ellipsisButton = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiSimplifiedBreadcrumbs.collapsedBadge.ariaLabel",
      default: "Show collapsed breadcrumbs"
    }, function (ariaLabel) {
      return /*#__PURE__*/_react.default.createElement(_link.OuiLink, {
        className: "ouiSimplifiedBreadcrumb ouiSimplifiedBreadcrumb__collapsedLink",
        "aria-label": ariaLabel,
        title: ariaLabel,
        onClick: function onClick() {
          return setIsPopoverOpen(!isPopoverOpen);
        }
      }, "\u2026 ", /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
        type: "arrowDown",
        size: "s"
      }));
    });

    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_popover.OuiPopover, {
      className: "ouiSimplifiedBreadcrumb ouiSimplifiedBreadcrumb--collapsed",
      button: ellipsisButton,
      isOpen: isPopoverOpen,
      closePopover: function closePopover() {
        return setIsPopoverOpen(false);
      }
    }, /*#__PURE__*/_react.default.createElement(OuiSimplifiedBreadcrumbs, {
      className: "ouiSimplifiedBreadcrumbs__inPopover",
      breadcrumbs: overflowBreadcrumbs,
      responsive: false,
      truncate: false,
      hideLastBreadCrumb: false,
      hideTrailingSeparator: true,
      disableTrailingLink: false,
      max: 0
    })), /*#__PURE__*/_react.default.createElement(OuiBreadcrumbSeparator, null));
  };

  if (max < breadcrumbs.length) {
    breadcrumbsAtStart.push( /*#__PURE__*/_react.default.createElement(OuiBreadcrumbCollapsed, {
      key: "collapsed"
    }));
  }

  return [].concat(breadcrumbsAtStart, breadcrumbsAtEnd);
};

var OuiBreadcrumbSeparator = function OuiBreadcrumbSeparator() {
  return (
    /*#__PURE__*/
    // preserveAspectRatio is none so we can stretch it vertically and keep the width fixed
    _react.default.createElement("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 8 12",
      preserveAspectRatio: "none",
      className: "ouiBreadcrumbSeparator"
    }, /*#__PURE__*/_react.default.createElement("path", {
      fill: "currentColor",
      d: "M2 12H0L6 0h2z"
    }))
  );
};

var OuiSimplifiedBreadcrumbs = function OuiSimplifiedBreadcrumbs(_ref) {
  var breadcrumbs = _ref.breadcrumbs,
      className = _ref.className,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? responsiveDefault : _ref$responsive,
      _ref$truncate = _ref.truncate,
      truncate = _ref$truncate === void 0 ? true : _ref$truncate,
      _ref$max = _ref.max,
      max = _ref$max === void 0 ? 5 : _ref$max,
      hideTrailingSeparator = _ref.hideTrailingSeparator,
      disableTrailingLink = _ref.disableTrailingLink,
      hideLastBreadCrumb = _ref.hideLastBreadCrumb,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["breadcrumbs", "className", "responsive", "truncate", "max", "hideTrailingSeparator", "disableTrailingLink", "hideLastBreadCrumb"]);
  // Use the default object if they simply passed `true` for responsive
  var responsiveObject = (0, _typeof2.default)(responsive) === 'object' ? responsive : responsiveDefault;
  var allowedBreakpoints = responsive ? Object.keys(responsiveObject) : undefined;

  var _useState3 = (0, _react.useState)((0, _breakpoint.getBreakpoint)(typeof window === 'undefined' ? -Infinity : window.innerWidth, undefined, allowedBreakpoints)),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      currentBreakpoint = _useState4[0],
      setCurrentBreakpoint = _useState4[1];

  var functionToCallOnWindowResize = (0, _services.throttle)(function () {
    var newBreakpoint = (0, _breakpoint.getBreakpoint)(window.innerWidth, undefined, allowedBreakpoints);

    if (newBreakpoint !== currentBreakpoint) {
      setCurrentBreakpoint(newBreakpoint);
    } // reacts every 50ms to resize changes and always gets the final update

  }, 50); // Add window resize handlers

  (0, _react.useEffect)(function () {
    window.addEventListener('resize', functionToCallOnWindowResize);
    return function () {
      window.removeEventListener('resize', functionToCallOnWindowResize);
    };
  }, [responsive, responsiveObject, functionToCallOnWindowResize]);
  var isInPopover = className === 'ouiSimplifiedBreadcrumbs__inPopover';
  var breadcrumbElements = breadcrumbs.map(function (breadcrumb, index) {
    var text = breadcrumb.text,
        href = breadcrumb.href,
        onClick = breadcrumb.onClick,
        truncate = breadcrumb.truncate,
        breadcrumbClassName = breadcrumb.className,
        breadcrumbRest = (0, _objectWithoutProperties2.default)(breadcrumb, ["text", "href", "onClick", "truncate", "className"]);
    var breadcrumbsLength = breadcrumbs.length;
    var isLastBreadcrumb = index === breadcrumbsLength - 1;
    if (isLastBreadcrumb && hideLastBreadCrumb) return null;
    var isFirstBreadcrumb = index === 0; // If hideLastBreadCrumb, the trailing breadcrumb would be the one before the last

    var isTrailingBreadcrumb = index >= breadcrumbsLength - (hideLastBreadCrumb ? 2 : 1);
    var breadcrumbClasses = (0, _classnames.default)('ouiSimplifiedBreadcrumb', breadcrumbClassName, {
      'ouiSimplifiedBreadcrumb--last': isLastBreadcrumb,
      'ouiSimplifiedBreadcrumb--truncate': truncate
    });
    var link = !(href || onClick) || isTrailingBreadcrumb && disableTrailingLink ? /*#__PURE__*/_react.default.createElement(_inner_text.OuiInnerText, null, function (ref, innerText) {
      return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
        ref: ref,
        className: breadcrumbClasses,
        title: innerText,
        "aria-current": isLastBreadcrumb && !isInPopover ? 'page' : 'false'
      }, breadcrumbRest), text);
    }) : /*#__PURE__*/_react.default.createElement(_inner_text.OuiInnerText, null, function (ref, innerText) {
      return /*#__PURE__*/_react.default.createElement(_link.OuiLink, (0, _extends2.default)({
        ref: ref,
        onClick: onClick,
        href: href,
        className: breadcrumbClasses,
        title: innerText
      }, breadcrumbRest), text);
    });
    var wall = isFirstBreadcrumb ? /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('ouiSimplifiedBreadcrumbWall', {
        'ouiSimplifiedBreadcrumbWall--single': isFirstBreadcrumb && isLastBreadcrumb
      })
    }, link) : link;
    var separator = hideTrailingSeparator && isTrailingBreadcrumb ? null : /*#__PURE__*/_react.default.createElement(OuiBreadcrumbSeparator, null);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, wall, separator);
  }); // The max property collapses any breadcrumbs past the max quantity.
  // This is the same behavior we want for responsiveness.
  // So calculate the max value based on the combination of `max` and `responsive`
  // First, calculate the responsive max value

  var responsiveMax = responsive && responsiveObject[currentBreakpoint] || null; // Second, if both max and responsiveMax are set, use the smaller of the two. Otherwise, use the one that is set.

  var calculatedMax = max && responsiveMax ? Math.min(max, responsiveMax) : max || responsiveMax;
  var limitedBreadcrumbs = calculatedMax ? limitBreadcrumbs(breadcrumbElements, calculatedMax, breadcrumbs) : breadcrumbElements;
  var classes = (0, _classnames.default)('ouiSimplifiedBreadcrumbs', className, {
    'ouiSimplifiedBreadcrumbs--truncate': truncate
  });
  return /*#__PURE__*/_react.default.createElement("nav", (0, _extends2.default)({
    "aria-label": "breadcrumb",
    className: classes
  }, rest), limitedBreadcrumbs);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiSimplifiedBreadcrumbs = OuiSimplifiedBreadcrumbs;
OuiSimplifiedBreadcrumbs.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.
     * Pass a custom #OuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.
     * Omitting or passing a `0` value will show all breadcrumbs.
     *
     * Pass `false` to turn this behavior off.
     *
     * Default: `{ xs: 1, s: 2, m: 4 }`
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.any.isRequired]),

  /**
     * Forces all breadcrumbs to single line and
     * truncates each breadcrumb to a particular width,
     * except for the last item
     */
  truncate: _propTypes.default.bool,

  /**
     * Collapses the inner items past the maximum set here
     * into a single ellipses item
     */
  max: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),

  /**
     * The array of individual #OuiBreadcrumb items
     */
  breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Visible label of the breadcrumb
       */
    text: _propTypes.default.node.isRequired,
    href: _propTypes.default.string,
    onClick: _propTypes.default.func,

    /**
       * Force a max-width on the breadcrumb text
       */
    truncate: _propTypes.default.bool
  }).isRequired).isRequired,
  hideTrailingSeparator: _propTypes.default.bool,
  disableTrailingLink: _propTypes.default.bool,
  hideLastBreadCrumb: _propTypes.default.bool
};
/* OUI -> EUI Aliases: Build-Time */