/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.geospatial.action.IpEnrichmentRequest;
import org.opensearch.geospatial.action.IpEnrichmentResponse;
import org.opensearch.geospatial.ip2geo.dao.Ip2GeoCachedDao;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class IpEnrichmentTransportAction
extends HandledTransportAction<ActionRequest, ActionResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(IpEnrichmentTransportAction.class);
    private final Ip2GeoCachedDao ip2GeoCachedDao;

    @Inject
    public IpEnrichmentTransportAction(TransportService transportService, ActionFilters actionFilters, Ip2GeoCachedDao cachedDao) {
        super("cluster:admin/geospatial/ipenrichment/get", transportService, actionFilters, IpEnrichmentRequest::new);
        this.ip2GeoCachedDao = cachedDao;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<ActionResponse> listener) {
        IpEnrichmentRequest enrichmentRequest = IpEnrichmentRequest.fromActionRequest((ActionRequest)request);
        String ipString = enrichmentRequest.getIpString();
        String dataSourceName = enrichmentRequest.getDatasourceName();
        String indexName = this.ip2GeoCachedDao.getIndexName(dataSourceName);
        Map<String, Object> geoLocationData = this.ip2GeoCachedDao.getGeoData(indexName, ipString);
        log.debug("GeoSpatial IP lookup on IP: [{}], and result [{}]", (Object)ipString, geoLocationData);
        listener.onResponse((Object)new IpEnrichmentResponse(geoLocationData));
    }
}

