/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Map;
import org.tribuo.hash.Hasher;

public final class HashCodeHasher
extends Hasher {
    private static final long serialVersionUID = 2L;
    @Config(mandatory=true, redact=true, description="Salt used in the hash.")
    private transient String salt = null;
    private static final HashCodeHasherProvenance provenance = new HashCodeHasherProvenance();

    private HashCodeHasher() {
    }

    public HashCodeHasher(String salt) {
        this.salt = salt;
    }

    @Override
    public String hash(String name) {
        if (this.salt == null) {
            throw new IllegalStateException("Salt not set");
        }
        String salted = this.salt + name;
        return "" + salted.hashCode();
    }

    @Override
    public void setSalt(String salt) {
        if (!Hasher.validateSalt(salt)) {
            throw new IllegalArgumentException("Salt: '" + salt + ", does not meet the requirements for a salt.");
        }
        this.salt = salt;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return provenance;
    }

    public String toString() {
        return "HashCodeHasher()";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.salt = null;
    }

    public static final class HashCodeHasherProvenance
    implements ConfiguredObjectProvenance {
        private static final long serialVersionUID = 1L;

        HashCodeHasherProvenance() {
        }

        public HashCodeHasherProvenance(Map<String, Provenance> map) {
        }

        public Map<String, Provenance> getConfiguredParameters() {
            return Collections.singletonMap("salt", new StringProvenance("salt", ""));
        }

        public String getClassName() {
            return HashCodeHasher.class.getName();
        }

        public String toString() {
            return this.generateString("Hasher");
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object other) {
            return other instanceof HashCodeHasher;
        }
    }
}

