/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.update_cache;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.transport.update_cache.MLUpdateModelCacheNodeRequest;
import org.opensearch.ml.common.transport.update_cache.MLUpdateModelCacheNodeResponse;
import org.opensearch.ml.common.transport.update_cache.MLUpdateModelCacheNodesRequest;
import org.opensearch.ml.common.transport.update_cache.MLUpdateModelCacheNodesResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UpdateModelCacheTransportAction
extends TransportNodesAction<MLUpdateModelCacheNodesRequest, MLUpdateModelCacheNodesResponse, MLUpdateModelCacheNodeRequest, MLUpdateModelCacheNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateModelCacheTransportAction.class);
    private final MLModelManager mlModelManager;
    private final ClusterService clusterService;
    private final Client client;
    private DiscoveryNodeHelper nodeFilter;
    private final MLStats mlStats;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public UpdateModelCacheTransportAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLStats mlStats, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/models/update_cache", threadPool, clusterService, transportService, actionFilters, MLUpdateModelCacheNodesRequest::new, MLUpdateModelCacheNodeRequest::new, "management", MLUpdateModelCacheNodeResponse.class);
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlStats = mlStats;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected MLUpdateModelCacheNodesResponse newResponse(MLUpdateModelCacheNodesRequest nodesRequest, List<MLUpdateModelCacheNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLUpdateModelCacheNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLUpdateModelCacheNodeRequest newNodeRequest(MLUpdateModelCacheNodesRequest request) {
        return new MLUpdateModelCacheNodeRequest(request);
    }

    protected MLUpdateModelCacheNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLUpdateModelCacheNodeResponse(in);
    }

    protected MLUpdateModelCacheNodeResponse nodeOperation(MLUpdateModelCacheNodeRequest request) {
        return this.createUpdateModelCacheNodeResponse(request.getUpdateModelCacheNodesRequest());
    }

    private MLUpdateModelCacheNodeResponse createUpdateModelCacheNodeResponse(MLUpdateModelCacheNodesRequest mlUpdateModelCacheNodesRequest) {
        String modelId = mlUpdateModelCacheNodesRequest.getModelId();
        HashMap<String, String> modelUpdateStatus = new HashMap<String, String>();
        modelUpdateStatus.put(modelId, "received");
        String localNodeId = this.clusterService.localNode().getId();
        this.mlModelManager.updateModelCache(modelId, (ActionListener<String>)ActionListener.wrap(r -> log.info("Successfully performing in-place update model {} on node {}", (Object)modelId, (Object)localNodeId), e -> log.error("Failed to perform in-place update model for model {} on node {}", (Object)modelId, (Object)localNodeId)));
        return new MLUpdateModelCacheNodeResponse(this.clusterService.localNode(), modelUpdateStatus);
    }
}

