/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class TE {
    private final String encoding;
    private final Map<String, String> parameters;
    private final double quality;

    protected TE(String string, Map<String, String> map, double d) {
        this.encoding = string;
        this.parameters = map;
        this.quality = d;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public double getQuality() {
        return this.quality;
    }

    public static List<TE> parse(StringReader stringReader) throws IOException {
        ArrayList<TE> arrayList = new ArrayList<TE>();
        while (true) {
            String string;
            if ((string = HttpParser.readToken(stringReader)) == null) {
                HttpParser.skipUntil(stringReader, 0, ',');
                continue;
            }
            if (string.isEmpty()) break;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (HttpParser.skipConstant(stringReader, ";") == SkipResult.FOUND) {
                String string2 = HttpParser.readToken(stringReader);
                String string3 = null;
                if (HttpParser.skipConstant(stringReader, "=") == SkipResult.FOUND) {
                    string3 = HttpParser.readTokenOrQuotedString(stringReader, true);
                }
                if (string2 == null || string3 == null) continue;
                hashMap.put(string2, string3);
            }
            double d = 1.0;
            String string4 = (String)hashMap.remove("q");
            if (string4 != null) {
                d = HttpParser.readWeight(new StringReader("q=" + string4), ',');
            }
            if (!(d > 0.0)) continue;
            arrayList.add(new TE(string, hashMap, d));
        }
        return arrayList;
    }
}

