import { Connection } from "vscode-languageserver";
import { WorkspaceFolderContext } from "../services/workspaceManager";
export interface ansibleMetaDataEntryType {
    [name: string]: {
        [name: string]: string | string[] | undefined | object[];
    } | string | string[] | object[] | undefined;
}
export interface ansibleMetaDataType {
    "ansible information"?: ansibleMetaDataEntryType;
    "python information"?: ansibleMetaDataEntryType;
    "ansible-lint information"?: ansibleMetaDataEntryType;
    "execution environment information"?: ansibleMetaDataEntryType | undefined;
}
export declare function getAnsibleMetaData(contextLocal: WorkspaceFolderContext, connectionLocal: Connection | undefined): Promise<ansibleMetaDataType>;
export declare function getResultsThroughCommandRunner(cmd: string, arg: string): Promise<{
    stdout: string;
    stderr: string;
} | undefined>;
