/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ɵɵdefineInjector } from '../di/interface/defs';
import { convertInjectableProviderToFactory } from '../di/util';
import { compileNgModule as render3CompileNgModule } from '../render3/jit/module';
import { makeDecorator } from '../util/decorators';
/**
 * Represents the expansion of an `NgModule` into its scopes.
 *
 * A scope is a set of directives and pipes that are visible in a particular context. Each
 * `NgModule` has two scopes. The `compilation` scope is the set of directives and pipes that will
 * be recognized in the templates of components declared by the module. The `exported` scope is the
 * set of directives and pipes exported by a module (that is, module B's exported scope gets added
 * to module A's compilation scope when module A imports B).
 * @record
 */
export function NgModuleTransitiveScopes() { }
if (false) {
    /** @type {?} */
    NgModuleTransitiveScopes.prototype.compilation;
    /** @type {?} */
    NgModuleTransitiveScopes.prototype.exported;
    /** @type {?} */
    NgModuleTransitiveScopes.prototype.schemas;
}
/**
 * Runtime link information for NgModules.
 *
 * This is the internal data structure used by the runtime to assemble components, directives,
 * pipes, and injectors.
 *
 * NOTE: Always use `ɵɵdefineNgModule` function to create this object,
 * never create the object directly since the shape of this object
 * can change between versions.
 * @record
 * @template T
 */
export function NgModuleDef() { }
if (false) {
    /**
     * Token representing the module. Used by DI.
     * @type {?}
     */
    NgModuleDef.prototype.type;
    /**
     * List of components to bootstrap.
     * @type {?}
     */
    NgModuleDef.prototype.bootstrap;
    /**
     * List of components, directives, and pipes declared by this module.
     * @type {?}
     */
    NgModuleDef.prototype.declarations;
    /**
     * List of modules or `ModuleWithProviders` imported by this module.
     * @type {?}
     */
    NgModuleDef.prototype.imports;
    /**
     * List of modules, `ModuleWithProviders`, components, directives, or pipes exported by this
     * module.
     * @type {?}
     */
    NgModuleDef.prototype.exports;
    /**
     * Cached value of computed `transitiveCompileScopes` for this module.
     *
     * This should never be read directly, but accessed via `transitiveScopesFor`.
     * @type {?}
     */
    NgModuleDef.prototype.transitiveCompileScopes;
    /**
     * The set of schemas that declare elements to be allowed in the NgModule.
     * @type {?}
     */
    NgModuleDef.prototype.schemas;
    /**
     * Unique ID for the module with which it should be registered.
     * @type {?}
     */
    NgModuleDef.prototype.id;
}
/**
 * A wrapper around an NgModule that associates it with the providers.
 *
 * @param T the module type. In Ivy applications, this must be explicitly
 * provided.
 *
 * \@publicApi
 * @record
 * @template T
 */
export function ModuleWithProviders() { }
if (false) {
    /** @type {?} */
    ModuleWithProviders.prototype.ngModule;
    /** @type {?|undefined} */
    ModuleWithProviders.prototype.providers;
}
/**
 * Type of the NgModule decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function NgModuleDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
const ɵ0 = /**
 * @param {?} ngModule
 * @return {?}
 */
(ngModule) => ngModule, ɵ1 = /**
 * Decorator that marks the following class as an NgModule, and supplies
 * configuration metadata for it.
 *
 * * The `declarations` and `entryComponents` options configure the compiler
 * with information about what belongs to the NgModule.
 * * The `providers` options configures the NgModule's injector to provide
 * dependencies the NgModule members.
 * * The `imports` and `exports` options bring in members from other modules, and make
 * this module's members available to others.
 * @param {?} type
 * @param {?} meta
 * @return {?}
 */
(type, meta) => SWITCH_COMPILE_NGMODULE(type, meta);
/**
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const NgModule = makeDecorator('NgModule', (ɵ0), undefined, undefined, (ɵ1));
/**
 * \@description
 * Hook for manual bootstrapping of the application instead of using bootstrap array in \@NgModule
 * annotation.
 *
 * Reference to the current application is provided as a parameter.
 *
 * See ["Bootstrapping"](guide/bootstrapping) and ["Entry components"](guide/entry-components).
 *
 * \@usageNotes
 * ```typescript
 * class AppModule implements DoBootstrap {
 *   ngDoBootstrap(appRef: ApplicationRef) {
 *     appRef.bootstrap(AppComponent); // Or some other component
 *   }
 * }
 * ```
 *
 * \@publicApi
 * @record
 */
export function DoBootstrap() { }
if (false) {
    /**
     * @param {?} appRef
     * @return {?}
     */
    DoBootstrap.prototype.ngDoBootstrap = function (appRef) { };
}
/**
 * @param {?} moduleType
 * @param {?=} metadata
 * @return {?}
 */
function preR3NgModuleCompile(moduleType, metadata) {
    /** @type {?} */
    let imports = (metadata && metadata.imports) || [];
    if (metadata && metadata.exports) {
        imports = [...imports, metadata.exports];
    }
    ((/** @type {?} */ (moduleType))).ngInjectorDef = ɵɵdefineInjector({
        factory: convertInjectableProviderToFactory(moduleType, { useClass: moduleType }),
        providers: metadata && metadata.providers,
        imports: imports,
    });
}
/** @type {?} */
export const SWITCH_COMPILE_NGMODULE__POST_R3__ = render3CompileNgModule;
/** @type {?} */
const SWITCH_COMPILE_NGMODULE__PRE_R3__ = preR3NgModuleCompile;
/** @type {?} */
const SWITCH_COMPILE_NGMODULE = SWITCH_COMPILE_NGMODULE__PRE_R3__;
export { ɵ0, ɵ1 };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmdfbW9kdWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9zcmMvbWV0YWRhdGEvbmdfbW9kdWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O0FBU0EsT0FBTyxFQUFlLGdCQUFnQixFQUFDLE1BQU0sc0JBQXNCLENBQUM7QUFFcEUsT0FBTyxFQUFDLGtDQUFrQyxFQUFDLE1BQU0sWUFBWSxDQUFDO0FBSTlELE9BQU8sRUFBQyxlQUFlLElBQUksc0JBQXNCLEVBQUMsTUFBTSx1QkFBdUIsQ0FBQztBQUNoRixPQUFPLEVBQWdCLGFBQWEsRUFBQyxNQUFNLG9CQUFvQixDQUFDOzs7Ozs7Ozs7OztBQVloRSw4Q0FJQzs7O0lBSEMsK0NBQXNEOztJQUN0RCw0Q0FBbUQ7O0lBQ25ELDJDQUErQjs7Ozs7Ozs7Ozs7Ozs7QUFrQmpDLGlDQStCQzs7Ozs7O0lBN0JDLDJCQUFROzs7OztJQUdSLGdDQUEyQzs7Ozs7SUFHM0MsbUNBQThDOzs7OztJQUc5Qyw4QkFBeUM7Ozs7OztJQU16Qyw4QkFBeUM7Ozs7Ozs7SUFPekMsOENBQXVEOzs7OztJQUd2RCw4QkFBK0I7Ozs7O0lBRy9CLHlCQUFnQjs7Ozs7Ozs7Ozs7O0FBV2xCLHlDQUlDOzs7SUFGQyx1Q0FBa0I7O0lBQ2xCLHdDQUF1Qjs7Ozs7Ozs7QUFTekIsdUNBTUM7Ozs7OztBQTBNZSxDQUFDLFFBQWtCLEVBQUUsRUFBRSxDQUFDLFFBQVE7Ozs7Ozs7Ozs7Ozs7O0FBWTVDLENBQUMsSUFBZSxFQUFFLElBQWMsRUFBRSxFQUFFLENBQUMsdUJBQXVCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQzs7Ozs7O0FBYjVFLE1BQU0sT0FBTyxRQUFRLEdBQXNCLGFBQWEsQ0FDcEQsVUFBVSxRQUFvQyxTQUFTLEVBQUUsU0FBUyxPQVlPOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBc0I3RSxpQ0FBNkU7Ozs7OztJQUE5Qyw0REFBNEM7Ozs7Ozs7QUFFM0UsU0FBUyxvQkFBb0IsQ0FBQyxVQUFxQixFQUFFLFFBQW1COztRQUNsRSxPQUFPLEdBQUcsQ0FBQyxRQUFRLElBQUksUUFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUU7SUFDbEQsSUFBSSxRQUFRLElBQUksUUFBUSxDQUFDLE9BQU8sRUFBRTtRQUNoQyxPQUFPLEdBQUcsQ0FBQyxHQUFHLE9BQU8sRUFBRSxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDMUM7SUFFRCxDQUFDLG1CQUFBLFVBQVUsRUFBcUIsQ0FBQyxDQUFDLGFBQWEsR0FBRyxnQkFBZ0IsQ0FBQztRQUNqRSxPQUFPLEVBQUUsa0NBQWtDLENBQUMsVUFBVSxFQUFFLEVBQUMsUUFBUSxFQUFFLFVBQVUsRUFBQyxDQUFDO1FBQy9FLFNBQVMsRUFBRSxRQUFRLElBQUksUUFBUSxDQUFDLFNBQVM7UUFDekMsT0FBTyxFQUFFLE9BQU87S0FDakIsQ0FBQyxDQUFDO0FBQ0wsQ0FBQzs7QUFHRCxNQUFNLE9BQU8sa0NBQWtDLEdBQUcsc0JBQXNCOztNQUNsRSxpQ0FBaUMsR0FBRyxvQkFBb0I7O01BQ3hELHVCQUF1QixHQUFrQyxpQ0FBaUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7QXBwbGljYXRpb25SZWZ9IGZyb20gJy4uL2FwcGxpY2F0aW9uX3JlZic7XG5pbXBvcnQge0luamVjdG9yVHlwZSwgybXJtWRlZmluZUluamVjdG9yfSBmcm9tICcuLi9kaS9pbnRlcmZhY2UvZGVmcyc7XG5pbXBvcnQge1Byb3ZpZGVyfSBmcm9tICcuLi9kaS9pbnRlcmZhY2UvcHJvdmlkZXInO1xuaW1wb3J0IHtjb252ZXJ0SW5qZWN0YWJsZVByb3ZpZGVyVG9GYWN0b3J5fSBmcm9tICcuLi9kaS91dGlsJztcbmltcG9ydCB7VHlwZX0gZnJvbSAnLi4vaW50ZXJmYWNlL3R5cGUnO1xuaW1wb3J0IHtTY2hlbWFNZXRhZGF0YX0gZnJvbSAnLi4vbWV0YWRhdGEvc2NoZW1hJztcbmltcG9ydCB7TmdNb2R1bGVUeXBlfSBmcm9tICcuLi9yZW5kZXIzJztcbmltcG9ydCB7Y29tcGlsZU5nTW9kdWxlIGFzIHJlbmRlcjNDb21waWxlTmdNb2R1bGV9IGZyb20gJy4uL3JlbmRlcjMvaml0L21vZHVsZSc7XG5pbXBvcnQge1R5cGVEZWNvcmF0b3IsIG1ha2VEZWNvcmF0b3J9IGZyb20gJy4uL3V0aWwvZGVjb3JhdG9ycyc7XG5cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBleHBhbnNpb24gb2YgYW4gYE5nTW9kdWxlYCBpbnRvIGl0cyBzY29wZXMuXG4gKlxuICogQSBzY29wZSBpcyBhIHNldCBvZiBkaXJlY3RpdmVzIGFuZCBwaXBlcyB0aGF0IGFyZSB2aXNpYmxlIGluIGEgcGFydGljdWxhciBjb250ZXh0LiBFYWNoXG4gKiBgTmdNb2R1bGVgIGhhcyB0d28gc2NvcGVzLiBUaGUgYGNvbXBpbGF0aW9uYCBzY29wZSBpcyB0aGUgc2V0IG9mIGRpcmVjdGl2ZXMgYW5kIHBpcGVzIHRoYXQgd2lsbFxuICogYmUgcmVjb2duaXplZCBpbiB0aGUgdGVtcGxhdGVzIG9mIGNvbXBvbmVudHMgZGVjbGFyZWQgYnkgdGhlIG1vZHVsZS4gVGhlIGBleHBvcnRlZGAgc2NvcGUgaXMgdGhlXG4gKiBzZXQgb2YgZGlyZWN0aXZlcyBhbmQgcGlwZXMgZXhwb3J0ZWQgYnkgYSBtb2R1bGUgKHRoYXQgaXMsIG1vZHVsZSBCJ3MgZXhwb3J0ZWQgc2NvcGUgZ2V0cyBhZGRlZFxuICogdG8gbW9kdWxlIEEncyBjb21waWxhdGlvbiBzY29wZSB3aGVuIG1vZHVsZSBBIGltcG9ydHMgQikuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTmdNb2R1bGVUcmFuc2l0aXZlU2NvcGVzIHtcbiAgY29tcGlsYXRpb246IHtkaXJlY3RpdmVzOiBTZXQ8YW55PjsgcGlwZXM6IFNldDxhbnk+O307XG4gIGV4cG9ydGVkOiB7ZGlyZWN0aXZlczogU2V0PGFueT47IHBpcGVzOiBTZXQ8YW55Pjt9O1xuICBzY2hlbWFzOiBTY2hlbWFNZXRhZGF0YVtdfG51bGw7XG59XG5cbi8qKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgdHlwZSDJtcm1TmdNb2R1bGVEZWZXaXRoTWV0YTxULCBEZWNsYXJhdGlvbnMsIEltcG9ydHMsIEV4cG9ydHM+ID0gTmdNb2R1bGVEZWY8VD47XG5cbi8qKlxuICogUnVudGltZSBsaW5rIGluZm9ybWF0aW9uIGZvciBOZ01vZHVsZXMuXG4gKlxuICogVGhpcyBpcyB0aGUgaW50ZXJuYWwgZGF0YSBzdHJ1Y3R1cmUgdXNlZCBieSB0aGUgcnVudGltZSB0byBhc3NlbWJsZSBjb21wb25lbnRzLCBkaXJlY3RpdmVzLFxuICogcGlwZXMsIGFuZCBpbmplY3RvcnMuXG4gKlxuICogTk9URTogQWx3YXlzIHVzZSBgybXJtWRlZmluZU5nTW9kdWxlYCBmdW5jdGlvbiB0byBjcmVhdGUgdGhpcyBvYmplY3QsXG4gKiBuZXZlciBjcmVhdGUgdGhlIG9iamVjdCBkaXJlY3RseSBzaW5jZSB0aGUgc2hhcGUgb2YgdGhpcyBvYmplY3RcbiAqIGNhbiBjaGFuZ2UgYmV0d2VlbiB2ZXJzaW9ucy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBOZ01vZHVsZURlZjxUPiB7XG4gIC8qKiBUb2tlbiByZXByZXNlbnRpbmcgdGhlIG1vZHVsZS4gVXNlZCBieSBESS4gKi9cbiAgdHlwZTogVDtcblxuICAvKiogTGlzdCBvZiBjb21wb25lbnRzIHRvIGJvb3RzdHJhcC4gKi9cbiAgYm9vdHN0cmFwOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKiBMaXN0IG9mIGNvbXBvbmVudHMsIGRpcmVjdGl2ZXMsIGFuZCBwaXBlcyBkZWNsYXJlZCBieSB0aGlzIG1vZHVsZS4gKi9cbiAgZGVjbGFyYXRpb25zOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKiBMaXN0IG9mIG1vZHVsZXMgb3IgYE1vZHVsZVdpdGhQcm92aWRlcnNgIGltcG9ydGVkIGJ5IHRoaXMgbW9kdWxlLiAqL1xuICBpbXBvcnRzOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKlxuICAgKiBMaXN0IG9mIG1vZHVsZXMsIGBNb2R1bGVXaXRoUHJvdmlkZXJzYCwgY29tcG9uZW50cywgZGlyZWN0aXZlcywgb3IgcGlwZXMgZXhwb3J0ZWQgYnkgdGhpc1xuICAgKiBtb2R1bGUuXG4gICAqL1xuICBleHBvcnRzOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKlxuICAgKiBDYWNoZWQgdmFsdWUgb2YgY29tcHV0ZWQgYHRyYW5zaXRpdmVDb21waWxlU2NvcGVzYCBmb3IgdGhpcyBtb2R1bGUuXG4gICAqXG4gICAqIFRoaXMgc2hvdWxkIG5ldmVyIGJlIHJlYWQgZGlyZWN0bHksIGJ1dCBhY2Nlc3NlZCB2aWEgYHRyYW5zaXRpdmVTY29wZXNGb3JgLlxuICAgKi9cbiAgdHJhbnNpdGl2ZUNvbXBpbGVTY29wZXM6IE5nTW9kdWxlVHJhbnNpdGl2ZVNjb3Blc3xudWxsO1xuXG4gIC8qKiBUaGUgc2V0IG9mIHNjaGVtYXMgdGhhdCBkZWNsYXJlIGVsZW1lbnRzIHRvIGJlIGFsbG93ZWQgaW4gdGhlIE5nTW9kdWxlLiAqL1xuICBzY2hlbWFzOiBTY2hlbWFNZXRhZGF0YVtdfG51bGw7XG5cbiAgLyoqIFVuaXF1ZSBJRCBmb3IgdGhlIG1vZHVsZSB3aXRoIHdoaWNoIGl0IHNob3VsZCBiZSByZWdpc3RlcmVkLiAgKi9cbiAgaWQ6IHN0cmluZ3xudWxsO1xufVxuXG4vKipcbiAqIEEgd3JhcHBlciBhcm91bmQgYW4gTmdNb2R1bGUgdGhhdCBhc3NvY2lhdGVzIGl0IHdpdGggdGhlIHByb3ZpZGVycy5cbiAqXG4gKiBAcGFyYW0gVCB0aGUgbW9kdWxlIHR5cGUuIEluIEl2eSBhcHBsaWNhdGlvbnMsIHRoaXMgbXVzdCBiZSBleHBsaWNpdGx5XG4gKiBwcm92aWRlZC5cbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTW9kdWxlV2l0aFByb3ZpZGVyczxcbiAgICBUID0gYW55IC8qKiBUT0RPKGFseGh1Yik6IHJlbW92ZSBkZWZhdWx0IHdoZW4gY2FsbGVycyBwYXNzIGV4cGxpY2l0IHR5cGUgcGFyYW0gKi8+IHtcbiAgbmdNb2R1bGU6IFR5cGU8VD47XG4gIHByb3ZpZGVycz86IFByb3ZpZGVyW107XG59XG5cblxuLyoqXG4gKiBUeXBlIG9mIHRoZSBOZ01vZHVsZSBkZWNvcmF0b3IgLyBjb25zdHJ1Y3RvciBmdW5jdGlvbi5cbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTmdNb2R1bGVEZWNvcmF0b3Ige1xuICAvKipcbiAgICogRGVjb3JhdG9yIHRoYXQgbWFya3MgYSBjbGFzcyBhcyBhbiBOZ01vZHVsZSBhbmQgc3VwcGxpZXMgY29uZmlndXJhdGlvbiBtZXRhZGF0YS5cbiAgICovXG4gIChvYmo/OiBOZ01vZHVsZSk6IFR5cGVEZWNvcmF0b3I7XG4gIG5ldyAob2JqPzogTmdNb2R1bGUpOiBOZ01vZHVsZTtcbn1cblxuLyoqXG4gKiBUeXBlIG9mIHRoZSBOZ01vZHVsZSBtZXRhZGF0YS5cbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTmdNb2R1bGUge1xuICAvKipcbiAgICogVGhlIHNldCBvZiBpbmplY3RhYmxlIG9iamVjdHMgdGhhdCBhcmUgYXZhaWxhYmxlIGluIHRoZSBpbmplY3RvclxuICAgKiBvZiB0aGlzIG1vZHVsZS5cbiAgICpcbiAgICogQHNlZSBbRGVwZW5kZW5jeSBJbmplY3Rpb24gZ3VpZGVdKGd1aWRlL2RlcGVuZGVuY3ktaW5qZWN0aW9uKVxuICAgKiBAc2VlIFtOZ01vZHVsZSBndWlkZV0oZ3VpZGUvcHJvdmlkZXJzKVxuICAgKlxuICAgKiBAdXNhZ2VOb3Rlc1xuICAgKlxuICAgKiBEZXBlbmRlbmNpZXMgd2hvc2UgcHJvdmlkZXJzIGFyZSBsaXN0ZWQgaGVyZSBiZWNvbWUgYXZhaWxhYmxlIGZvciBpbmplY3Rpb25cbiAgICogaW50byBhbnkgY29tcG9uZW50LCBkaXJlY3RpdmUsIHBpcGUgb3Igc2VydmljZSB0aGF0IGlzIGEgY2hpbGQgb2YgdGhpcyBpbmplY3Rvci5cbiAgICogVGhlIE5nTW9kdWxlIHVzZWQgZm9yIGJvb3RzdHJhcHBpbmcgdXNlcyB0aGUgcm9vdCBpbmplY3RvciwgYW5kIGNhbiBwcm92aWRlIGRlcGVuZGVuY2llc1xuICAgKiB0byBhbnkgcGFydCBvZiB0aGUgYXBwLlxuICAgKlxuICAgKiBBIGxhenktbG9hZGVkIG1vZHVsZSBoYXMgaXRzIG93biBpbmplY3RvciwgdHlwaWNhbGx5IGEgY2hpbGQgb2YgdGhlIGFwcCByb290IGluamVjdG9yLlxuICAgKiBMYXp5LWxvYWRlZCBzZXJ2aWNlcyBhcmUgc2NvcGVkIHRvIHRoZSBsYXp5LWxvYWRlZCBtb2R1bGUncyBpbmplY3Rvci5cbiAgICogSWYgYSBsYXp5LWxvYWRlZCBtb2R1bGUgYWxzbyBwcm92aWRlcyB0aGUgYFVzZXJTZXJ2aWNlYCwgYW55IGNvbXBvbmVudCBjcmVhdGVkXG4gICAqIHdpdGhpbiB0aGF0IG1vZHVsZSdzIGNvbnRleHQgKHN1Y2ggYXMgYnkgcm91dGVyIG5hdmlnYXRpb24pIGdldHMgdGhlIGxvY2FsIGluc3RhbmNlXG4gICAqIG9mIHRoZSBzZXJ2aWNlLCBub3QgdGhlIGluc3RhbmNlIGluIHRoZSByb290IGluamVjdG9yLlxuICAgKiBDb21wb25lbnRzIGluIGV4dGVybmFsIG1vZHVsZXMgY29udGludWUgdG8gcmVjZWl2ZSB0aGUgaW5zdGFuY2UgcHJvdmlkZWQgYnkgdGhlaXIgaW5qZWN0b3JzLlxuICAgKlxuICAgKiAjIyMgRXhhbXBsZVxuICAgKlxuICAgKiBUaGUgZm9sbG93aW5nIGV4YW1wbGUgZGVmaW5lcyBhIGNsYXNzIHRoYXQgaXMgaW5qZWN0ZWQgaW5cbiAgICogdGhlIEhlbGxvV29ybGQgTmdNb2R1bGU6XG4gICAqXG4gICAqIGBgYFxuICAgKiBjbGFzcyBHcmVldGVyIHtcbiAgICogICAgZ3JlZXQobmFtZTpzdHJpbmcpIHtcbiAgICogICAgICByZXR1cm4gJ0hlbGxvICcgKyBuYW1lICsgJyEnO1xuICAgKiAgICB9XG4gICAqIH1cbiAgICpcbiAgICogQE5nTW9kdWxlKHtcbiAgICogICBwcm92aWRlcnM6IFtcbiAgICogICAgIEdyZWV0ZXJcbiAgICogICBdXG4gICAqIH0pXG4gICAqIGNsYXNzIEhlbGxvV29ybGQge1xuICAgKiAgIGdyZWV0ZXI6R3JlZXRlcjtcbiAgICpcbiAgICogICBjb25zdHJ1Y3RvcihncmVldGVyOkdyZWV0ZXIpIHtcbiAgICogICAgIHRoaXMuZ3JlZXRlciA9IGdyZWV0ZXI7XG4gICAqICAgfVxuICAgKiB9XG4gICAqIGBgYFxuICAgKi9cbiAgcHJvdmlkZXJzPzogUHJvdmlkZXJbXTtcblxuICAvKipcbiAgICogVGhlIHNldCBvZiBjb21wb25lbnRzLCBkaXJlY3RpdmVzLCBhbmQgcGlwZXMgKFtkZWNsYXJhYmxlc10oZ3VpZGUvZ2xvc3NhcnkjZGVjbGFyYWJsZSkpXG4gICAqIHRoYXQgYmVsb25nIHRvIHRoaXMgbW9kdWxlLlxuICAgKlxuICAgKiBAdXNhZ2VOb3Rlc1xuICAgKlxuICAgKiBUaGUgc2V0IG9mIHNlbGVjdG9ycyB0aGF0IGFyZSBhdmFpbGFibGUgdG8gYSB0ZW1wbGF0ZSBpbmNsdWRlIHRob3NlIGRlY2xhcmVkIGhlcmUsIGFuZFxuICAgKiB0aG9zZSB0aGF0IGFyZSBleHBvcnRlZCBmcm9tIGltcG9ydGVkIE5nTW9kdWxlcy5cbiAgICpcbiAgICogRGVjbGFyYWJsZXMgbXVzdCBiZWxvbmcgdG8gZXhhY3RseSBvbmUgbW9kdWxlLlxuICAgKiBUaGUgY29tcGlsZXIgZW1pdHMgYW4gZXJyb3IgaWYgeW91IHRyeSB0byBkZWNsYXJlIHRoZSBzYW1lIGNsYXNzIGluIG1vcmUgdGhhbiBvbmUgbW9kdWxlLlxuICAgKiBCZSBjYXJlZnVsIG5vdCB0byBkZWNsYXJlIGEgY2xhc3MgdGhhdCBpcyBpbXBvcnRlZCBmcm9tIGFub3RoZXIgbW9kdWxlLlxuICAgKlxuICAgKiAjIyMgRXhhbXBsZVxuICAgKlxuICAgKiBUaGUgZm9sbG93aW5nIGV4YW1wbGUgYWxsb3dzIHRoZSBDb21tb25Nb2R1bGUgdG8gdXNlIHRoZSBgTmdGb3JgXG4gICAqIGRpcmVjdGl2ZS5cbiAgICpcbiAgICogYGBgamF2YXNjcmlwdFxuICAgKiBATmdNb2R1bGUoe1xuICAgKiAgIGRlY2xhcmF0aW9uczogW05nRm9yXVxuICAgKiB9KVxuICAgKiBjbGFzcyBDb21tb25Nb2R1bGUge1xuICAgKiB9XG4gICAqIGBgYFxuICAgKi9cbiAgZGVjbGFyYXRpb25zPzogQXJyYXk8VHlwZTxhbnk+fGFueVtdPjtcblxuICAvKipcbiAgICogVGhlIHNldCBvZiBOZ01vZHVsZXMgd2hvc2UgZXhwb3J0ZWQgW2RlY2xhcmFibGVzXShndWlkZS9nbG9zc2FyeSNkZWNsYXJhYmxlKVxuICAgKiBhcmUgYXZhaWxhYmxlIHRvIHRlbXBsYXRlcyBpbiB0aGlzIG1vZHVsZS5cbiAgICpcbiAgICogQHVzYWdlTm90ZXNcbiAgICpcbiAgICogQSB0ZW1wbGF0ZSBjYW4gdXNlIGV4cG9ydGVkIGRlY2xhcmFibGVzIGZyb20gYW55XG4gICAqIGltcG9ydGVkIG1vZHVsZSwgaW5jbHVkaW5nIHRob3NlIGZyb20gbW9kdWxlcyB0aGF0IGFyZSBpbXBvcnRlZCBpbmRpcmVjdGx5XG4gICAqIGFuZCByZS1leHBvcnRlZC5cbiAgICogRm9yIGV4YW1wbGUsIGBNb2R1bGVBYCBpbXBvcnRzIGBNb2R1bGVCYCwgYW5kIGFsc28gZXhwb3J0c1xuICAgKiBpdCwgd2hpY2ggbWFrZXMgdGhlIGRlY2xhcmFibGVzIGZyb20gYE1vZHVsZUJgIGF2YWlsYWJsZVxuICAgKiB3aGVyZXZlciBgTW9kdWxlQWAgaXMgaW1wb3J0ZWQuXG4gICAqXG4gICAqICMjIyBFeGFtcGxlXG4gICAqXG4gICAqIFRoZSBmb2xsb3dpbmcgZXhhbXBsZSBhbGxvd3MgTWFpbk1vZHVsZSB0byB1c2UgYW55dGhpbmcgZXhwb3J0ZWQgYnlcbiAgICogYENvbW1vbk1vZHVsZWA6XG4gICAqXG4gICAqIGBgYGphdmFzY3JpcHRcbiAgICogQE5nTW9kdWxlKHtcbiAgICogICBpbXBvcnRzOiBbQ29tbW9uTW9kdWxlXVxuICAgKiB9KVxuICAgKiBjbGFzcyBNYWluTW9kdWxlIHtcbiAgICogfVxuICAgKiBgYGBcbiAgICpcbiAgICovXG4gIGltcG9ydHM/OiBBcnJheTxUeXBlPGFueT58TW9kdWxlV2l0aFByb3ZpZGVyczx7fT58YW55W10+O1xuXG4gIC8qKlxuICAgKiBUaGUgc2V0IG9mIGNvbXBvbmVudHMsIGRpcmVjdGl2ZXMsIGFuZCBwaXBlcyBkZWNsYXJlZCBpbiB0aGlzXG4gICAqIE5nTW9kdWxlIHRoYXQgY2FuIGJlIHVzZWQgaW4gdGhlIHRlbXBsYXRlIG9mIGFueSBjb21wb25lbnQgdGhhdCBpcyBwYXJ0IG9mIGFuXG4gICAqIE5nTW9kdWxlIHRoYXQgaW1wb3J0cyB0aGlzIE5nTW9kdWxlLiBFeHBvcnRlZCBkZWNsYXJhdGlvbnMgYXJlIHRoZSBtb2R1bGUncyBwdWJsaWMgQVBJLlxuICAgKlxuICAgKiBBIGRlY2xhcmFibGUgYmVsb25ncyB0byBvbmUgYW5kIG9ubHkgb25lIE5nTW9kdWxlLlxuICAgKiBBIG1vZHVsZSBjYW4gbGlzdCBhbm90aGVyIG1vZHVsZSBhbW9uZyBpdHMgZXhwb3J0cywgaW4gd2hpY2ggY2FzZSBhbGwgb2YgdGhhdCBtb2R1bGUnc1xuICAgKiBwdWJsaWMgZGVjbGFyYXRpb24gYXJlIGV4cG9ydGVkLlxuICAgKlxuICAgKiBAdXNhZ2VOb3Rlc1xuICAgKlxuICAgKiBEZWNsYXJhdGlvbnMgYXJlIHByaXZhdGUgYnkgZGVmYXVsdC5cbiAgICogSWYgdGhpcyBNb2R1bGVBIGRvZXMgbm90IGV4cG9ydCBVc2VyQ29tcG9uZW50LCB0aGVuIG9ubHkgdGhlIGNvbXBvbmVudHMgd2l0aGluIHRoaXNcbiAgICogTW9kdWxlQSBjYW4gdXNlIFVzZXJDb21wb25lbnQuXG4gICAqXG4gICAqIE1vZHVsZUEgY2FuIGltcG9ydCBNb2R1bGVCIGFuZCBhbHNvIGV4cG9ydCBpdCwgbWFraW5nIGV4cG9ydHMgZnJvbSBNb2R1bGVCXG4gICAqIGF2YWlsYWJsZSB0byBhbiBOZ01vZHVsZSB0aGF0IGltcG9ydHMgTW9kdWxlQS5cbiAgICpcbiAgICogIyMjIEV4YW1wbGVcbiAgICpcbiAgICogVGhlIGZvbGxvd2luZyBleGFtcGxlIGV4cG9ydHMgdGhlIGBOZ0ZvcmAgZGlyZWN0aXZlIGZyb20gQ29tbW9uTW9kdWxlLlxuICAgKlxuICAgKiBgYGBqYXZhc2NyaXB0XG4gICAqIEBOZ01vZHVsZSh7XG4gICAqICAgZXhwb3J0czogW05nRm9yXVxuICAgKiB9KVxuICAgKiBjbGFzcyBDb21tb25Nb2R1bGUge1xuICAgKiB9XG4gICAqIGBgYFxuICAgKi9cbiAgZXhwb3J0cz86IEFycmF5PFR5cGU8YW55PnxhbnlbXT47XG5cbiAgLyoqXG4gICAqIFRoZSBzZXQgb2YgY29tcG9uZW50cyB0byBjb21waWxlIHdoZW4gdGhpcyBOZ01vZHVsZSBpcyBkZWZpbmVkLFxuICAgKiBzbyB0aGF0IHRoZXkgY2FuIGJlIGR5bmFtaWNhbGx5IGxvYWRlZCBpbnRvIHRoZSB2aWV3LlxuICAgKlxuICAgKiBGb3IgZWFjaCBjb21wb25lbnQgbGlzdGVkIGhlcmUsIEFuZ3VsYXIgY3JlYXRlcyBhIGBDb21wb25lbnRGYWN0b3J5YFxuICAgKiBhbmQgc3RvcmVzIGl0IGluIHRoZSBgQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyYC5cbiAgICpcbiAgICogQW5ndWxhciBhdXRvbWF0aWNhbGx5IGFkZHMgY29tcG9uZW50cyBpbiB0aGUgbW9kdWxlJ3MgYm9vdHN0cmFwXG4gICAqIGFuZCByb3V0ZSBkZWZpbml0aW9ucyBpbnRvIHRoZSBgZW50cnlDb21wb25lbnRzYCBsaXN0LiBVc2UgdGhpc1xuICAgKiBvcHRpb24gdG8gYWRkIGNvbXBvbmVudHMgdGhhdCBhcmUgYm9vdHN0cmFwcGVkXG4gICAqIHVzaW5nIG9uZSBvZiB0aGUgaW1wZXJhdGl2ZSB0ZWNobmlxdWVzLCBzdWNoIGFzIGBWaWV3Q29udGFpbmVyUmVmLmNyZWF0ZUNvbXBvbmVudCgpYC5cbiAgICpcbiAgICogQHNlZSBbRW50cnkgQ29tcG9uZW50c10oZ3VpZGUvZW50cnktY29tcG9uZW50cylcbiAgICovXG4gIGVudHJ5Q29tcG9uZW50cz86IEFycmF5PFR5cGU8YW55PnxhbnlbXT47XG5cbiAgLyoqXG4gICAqIFRoZSBzZXQgb2YgY29tcG9uZW50cyB0aGF0IGFyZSBib290c3RyYXBwZWQgd2hlblxuICAgKiB0aGlzIG1vZHVsZSBpcyBib290c3RyYXBwZWQuIFRoZSBjb21wb25lbnRzIGxpc3RlZCBoZXJlXG4gICAqIGFyZSBhdXRvbWF0aWNhbGx5IGFkZGVkIHRvIGBlbnRyeUNvbXBvbmVudHNgLlxuICAgKi9cbiAgYm9vdHN0cmFwPzogQXJyYXk8VHlwZTxhbnk+fGFueVtdPjtcblxuICAvKipcbiAgICogVGhlIHNldCBvZiBzY2hlbWFzIHRoYXQgZGVjbGFyZSBlbGVtZW50cyB0byBiZSBhbGxvd2VkIGluIHRoZSBOZ01vZHVsZS5cbiAgICogRWxlbWVudHMgYW5kIHByb3BlcnRpZXMgdGhhdCBhcmUgbmVpdGhlciBBbmd1bGFyIGNvbXBvbmVudHMgbm9yIGRpcmVjdGl2ZXNcbiAgICogbXVzdCBiZSBkZWNsYXJlZCBpbiBhIHNjaGVtYS5cbiAgICpcbiAgICogQWxsb3dlZCB2YWx1ZSBhcmUgYE5PX0VSUk9SU19TQ0hFTUFgIGFuZCBgQ1VTVE9NX0VMRU1FTlRTX1NDSEVNQWAuXG4gICAqXG4gICAqIEBzZWN1cml0eSBXaGVuIHVzaW5nIG9uZSBvZiBgTk9fRVJST1JTX1NDSEVNQWAgb3IgYENVU1RPTV9FTEVNRU5UU19TQ0hFTUFgXG4gICAqIHlvdSBtdXN0IGVuc3VyZSB0aGF0IGFsbG93ZWQgZWxlbWVudHMgYW5kIHByb3BlcnRpZXMgc2VjdXJlbHkgZXNjYXBlIGlucHV0cy5cbiAgICovXG4gIHNjaGVtYXM/OiBBcnJheTxTY2hlbWFNZXRhZGF0YXxhbnlbXT47XG5cbiAgLyoqXG4gICAqIEEgbmFtZSBvciBwYXRoIHRoYXQgdW5pcXVlbHkgaWRlbnRpZmllcyB0aGlzIE5nTW9kdWxlIGluIGBnZXRNb2R1bGVGYWN0b3J5YC5cbiAgICogSWYgbGVmdCBgdW5kZWZpbmVkYCwgdGhlIE5nTW9kdWxlIGlzIG5vdCByZWdpc3RlcmVkIHdpdGhcbiAgICogYGdldE1vZHVsZUZhY3RvcnlgLlxuICAgKi9cbiAgaWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIElmIHRydWUsIHRoaXMgbW9kdWxlIHdpbGwgYmUgc2tpcHBlZCBieSB0aGUgQU9UIGNvbXBpbGVyIGFuZCBzbyB3aWxsIGFsd2F5cyBiZSBjb21waWxlZFxuICAgKiB1c2luZyBKSVQuXG4gICAqXG4gICAqIFRoaXMgZXhpc3RzIHRvIHN1cHBvcnQgZnV0dXJlIEl2eSB3b3JrIGFuZCBoYXMgbm8gZWZmZWN0IGN1cnJlbnRseS5cbiAgICovXG4gIGppdD86IHRydWU7XG59XG5cbi8qKlxuICogQEFubm90YXRpb25cbiAqIEBwdWJsaWNBcGlcbiAqL1xuZXhwb3J0IGNvbnN0IE5nTW9kdWxlOiBOZ01vZHVsZURlY29yYXRvciA9IG1ha2VEZWNvcmF0b3IoXG4gICAgJ05nTW9kdWxlJywgKG5nTW9kdWxlOiBOZ01vZHVsZSkgPT4gbmdNb2R1bGUsIHVuZGVmaW5lZCwgdW5kZWZpbmVkLFxuICAgIC8qKlxuICAgICAqIERlY29yYXRvciB0aGF0IG1hcmtzIHRoZSBmb2xsb3dpbmcgY2xhc3MgYXMgYW4gTmdNb2R1bGUsIGFuZCBzdXBwbGllc1xuICAgICAqIGNvbmZpZ3VyYXRpb24gbWV0YWRhdGEgZm9yIGl0LlxuICAgICAqXG4gICAgICogKiBUaGUgYGRlY2xhcmF0aW9uc2AgYW5kIGBlbnRyeUNvbXBvbmVudHNgIG9wdGlvbnMgY29uZmlndXJlIHRoZSBjb21waWxlclxuICAgICAqIHdpdGggaW5mb3JtYXRpb24gYWJvdXQgd2hhdCBiZWxvbmdzIHRvIHRoZSBOZ01vZHVsZS5cbiAgICAgKiAqIFRoZSBgcHJvdmlkZXJzYCBvcHRpb25zIGNvbmZpZ3VyZXMgdGhlIE5nTW9kdWxlJ3MgaW5qZWN0b3IgdG8gcHJvdmlkZVxuICAgICAqIGRlcGVuZGVuY2llcyB0aGUgTmdNb2R1bGUgbWVtYmVycy5cbiAgICAgKiAqIFRoZSBgaW1wb3J0c2AgYW5kIGBleHBvcnRzYCBvcHRpb25zIGJyaW5nIGluIG1lbWJlcnMgZnJvbSBvdGhlciBtb2R1bGVzLCBhbmQgbWFrZVxuICAgICAqIHRoaXMgbW9kdWxlJ3MgbWVtYmVycyBhdmFpbGFibGUgdG8gb3RoZXJzLlxuICAgICAqL1xuICAgICh0eXBlOiBUeXBlPGFueT4sIG1ldGE6IE5nTW9kdWxlKSA9PiBTV0lUQ0hfQ09NUElMRV9OR01PRFVMRSh0eXBlLCBtZXRhKSk7XG5cbi8qKlxuICogQGRlc2NyaXB0aW9uXG4gKiBIb29rIGZvciBtYW51YWwgYm9vdHN0cmFwcGluZyBvZiB0aGUgYXBwbGljYXRpb24gaW5zdGVhZCBvZiB1c2luZyBib290c3RyYXAgYXJyYXkgaW4gQE5nTW9kdWxlXG4gKiBhbm5vdGF0aW9uLlxuICpcbiAqIFJlZmVyZW5jZSB0byB0aGUgY3VycmVudCBhcHBsaWNhdGlvbiBpcyBwcm92aWRlZCBhcyBhIHBhcmFtZXRlci5cbiAqXG4gKiBTZWUgW1wiQm9vdHN0cmFwcGluZ1wiXShndWlkZS9ib290c3RyYXBwaW5nKSBhbmQgW1wiRW50cnkgY29tcG9uZW50c1wiXShndWlkZS9lbnRyeS1jb21wb25lbnRzKS5cbiAqXG4gKiBAdXNhZ2VOb3Rlc1xuICogYGBgdHlwZXNjcmlwdFxuICogY2xhc3MgQXBwTW9kdWxlIGltcGxlbWVudHMgRG9Cb290c3RyYXAge1xuICogICBuZ0RvQm9vdHN0cmFwKGFwcFJlZjogQXBwbGljYXRpb25SZWYpIHtcbiAqICAgICBhcHBSZWYuYm9vdHN0cmFwKEFwcENvbXBvbmVudCk7IC8vIE9yIHNvbWUgb3RoZXIgY29tcG9uZW50XG4gKiAgIH1cbiAqIH1cbiAqIGBgYFxuICpcbiAqIEBwdWJsaWNBcGlcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEb0Jvb3RzdHJhcCB7IG5nRG9Cb290c3RyYXAoYXBwUmVmOiBBcHBsaWNhdGlvblJlZik6IHZvaWQ7IH1cblxuZnVuY3Rpb24gcHJlUjNOZ01vZHVsZUNvbXBpbGUobW9kdWxlVHlwZTogVHlwZTxhbnk+LCBtZXRhZGF0YT86IE5nTW9kdWxlKTogdm9pZCB7XG4gIGxldCBpbXBvcnRzID0gKG1ldGFkYXRhICYmIG1ldGFkYXRhLmltcG9ydHMpIHx8IFtdO1xuICBpZiAobWV0YWRhdGEgJiYgbWV0YWRhdGEuZXhwb3J0cykge1xuICAgIGltcG9ydHMgPSBbLi4uaW1wb3J0cywgbWV0YWRhdGEuZXhwb3J0c107XG4gIH1cblxuICAobW9kdWxlVHlwZSBhcyBJbmplY3RvclR5cGU8YW55PikubmdJbmplY3RvckRlZiA9IMm1ybVkZWZpbmVJbmplY3Rvcih7XG4gICAgZmFjdG9yeTogY29udmVydEluamVjdGFibGVQcm92aWRlclRvRmFjdG9yeShtb2R1bGVUeXBlLCB7dXNlQ2xhc3M6IG1vZHVsZVR5cGV9KSxcbiAgICBwcm92aWRlcnM6IG1ldGFkYXRhICYmIG1ldGFkYXRhLnByb3ZpZGVycyxcbiAgICBpbXBvcnRzOiBpbXBvcnRzLFxuICB9KTtcbn1cblxuXG5leHBvcnQgY29uc3QgU1dJVENIX0NPTVBJTEVfTkdNT0RVTEVfX1BPU1RfUjNfXyA9IHJlbmRlcjNDb21waWxlTmdNb2R1bGU7XG5jb25zdCBTV0lUQ0hfQ09NUElMRV9OR01PRFVMRV9fUFJFX1IzX18gPSBwcmVSM05nTW9kdWxlQ29tcGlsZTtcbmNvbnN0IFNXSVRDSF9DT01QSUxFX05HTU9EVUxFOiB0eXBlb2YgcmVuZGVyM0NvbXBpbGVOZ01vZHVsZSA9IFNXSVRDSF9DT01QSUxFX05HTU9EVUxFX19QUkVfUjNfXztcbiJdfQ==