"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ts = require("typescript");
var symbol_helper_1 = require("./symbol-helper");
var utilities_1 = require("../../../../utilities");
var ComponentHelper = /** @class */ (function () {
    function ComponentHelper(classHelper, symbolHelper) {
        if (symbolHelper === void 0) { symbolHelper = new symbol_helper_1.SymbolHelper(); }
        this.classHelper = classHelper;
        this.symbolHelper = symbolHelper;
    }
    ComponentHelper.prototype.getComponentChangeDetection = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'changeDetection').pop();
    };
    ComponentHelper.prototype.getComponentEncapsulation = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'encapsulation');
    };
    ComponentHelper.prototype.getComponentPure = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'pure').pop();
    };
    ComponentHelper.prototype.getComponentName = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'name').pop();
    };
    ComponentHelper.prototype.getComponentExportAs = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'exportAs').pop();
    };
    ComponentHelper.prototype.getComponentHost = function (props) {
        return this.getSymbolDepsObject(props, 'host');
    };
    ComponentHelper.prototype.getComponentInputsMetadata = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'inputs');
    };
    ComponentHelper.prototype.getComponentTemplate = function (props) {
        var t = this.symbolHelper.getSymbolDeps(props, 'template', true).pop();
        if (t) {
            t = utilities_1.detectIndent(t, 0);
            t = t.replace(/\n/, '');
            t = t.replace(/ +$/gm, '');
        }
        return t;
    };
    ComponentHelper.prototype.getComponentStyleUrls = function (props) {
        return this.sanitizeUrls(this.symbolHelper.getSymbolDeps(props, 'styleUrls'));
    };
    ComponentHelper.prototype.getComponentStyles = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'styles');
    };
    ComponentHelper.prototype.getComponentModuleId = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'moduleId').pop();
    };
    ComponentHelper.prototype.getComponentOutputs = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'outputs');
    };
    ComponentHelper.prototype.getComponentProviders = function (props) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'providers')
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name); });
    };
    ComponentHelper.prototype.getComponentViewProviders = function (props) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'viewProviders')
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name); });
    };
    ComponentHelper.prototype.getComponentTemplateUrl = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'templateUrl');
    };
    ComponentHelper.prototype.getComponentExampleUrls = function (text) {
        var exampleUrlsMatches = text.match(/<example-url>(.*?)<\/example-url>/g);
        var exampleUrls = undefined;
        if (exampleUrlsMatches && exampleUrlsMatches.length) {
            exampleUrls = exampleUrlsMatches.map(function (val) {
                return val.replace(/<\/?example-url>/g, '');
            });
        }
        return exampleUrls;
    };
    ComponentHelper.prototype.getComponentSelector = function (props) {
        return this.symbolHelper.getSymbolDeps(props, 'selector').pop();
    };
    ComponentHelper.prototype.parseProperties = function (node) {
        var obj = new Map();
        var properties = node.initializer.properties || [];
        properties.forEach(function (prop) {
            obj.set(prop.name.text, prop.initializer.text);
        });
        return obj;
    };
    ComponentHelper.prototype.getSymbolDepsObject = function (props, type, multiLine) {
        var _this = this;
        var deps = props.filter(function (node) { return node.name.text === type; });
        return deps.map(function (x) { return _this.parseProperties(x); }).pop();
    };
    ComponentHelper.prototype.getComponentIO = function (filename, sourceFile, node, fileBody) {
        var _this = this;
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var reducedSource = (fileBody) ? fileBody.statements : sourceFile.statements;
        var res = reducedSource.reduce(function (directive, statement) {
            if (ts.isClassDeclaration(statement)) {
                if (statement.pos === node.pos && statement.end === node.end) {
                    return directive.concat(_this.classHelper.visitClassDeclaration(filename, statement, sourceFile));
                }
            }
            return directive;
        }, []);
        return res[0] || {};
    };
    ComponentHelper.prototype.sanitizeUrls = function (urls) {
        return urls.map(function (url) { return url.replace('./', ''); });
    };
    return ComponentHelper;
}());
exports.ComponentHelper = ComponentHelper;
var ComponentCache = /** @class */ (function () {
    function ComponentCache() {
        this.cache = new Map();
    }
    ComponentCache.prototype.get = function (key) {
        return this.cache.get(key);
    };
    ComponentCache.prototype.set = function (key, value) {
        this.cache.set(key, value);
    };
    return ComponentCache;
}());
exports.ComponentCache = ComponentCache;
//# sourceMappingURL=component-helper.js.map