/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.freeplane.view.swing.map.Drawable;
import org.freeplane.view.swing.map.NodeView;

abstract class DrawableShape
implements Drawable {
    DrawableShape() {
    }

    @Override
    public void draw(Graphics2D g, NodeView nodeView, Rectangle r) {
        Color color = g.getColor();
        Color edgeColor = nodeView.getMainView().getBorderColor();
        Shape shape = this.getShape(r);
        Color fillColor = this.getFillColor(nodeView);
        if (fillColor != null) {
            g.setColor(fillColor);
            g.fill(shape);
        }
        g.setColor(edgeColor);
        this.drawShape(g, shape, r, nodeView);
        g.setColor(color);
    }

    protected void drawShape(Graphics2D g, Shape shape, Rectangle r, NodeView nodeView) {
        g.draw(shape);
    }

    abstract Shape getShape(Rectangle var1);

    protected Color getFillColor(NodeView nodeView) {
        return nodeView.getTextBackground();
    }
}

