/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.TryCatchBlock;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public abstract class JavaAccess<TARGET extends AccessTarget>
implements HasName,
HasDescription,
HasOwner<JavaCodeUnit>,
HasSourceCodeLocation {
    private final JavaCodeUnit origin;
    private final TARGET target;
    private final int lineNumber;
    private final SourceCodeLocation sourceCodeLocation;
    private final boolean declaredInLambda;

    JavaAccess(DomainBuilders.JavaAccessBuilder<TARGET, ?> builder) {
        this.origin = Preconditions.checkNotNull(builder.getOrigin());
        this.target = (AccessTarget)Preconditions.checkNotNull(builder.getTarget());
        this.lineNumber = builder.getLineNumber();
        this.sourceCodeLocation = SourceCodeLocation.of(this.getOriginOwner(), this.lineNumber);
        this.declaredInLambda = builder.isDeclaredInLambda();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return ((AccessTarget)this.target).getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOrigin() {
        return this.origin;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getOriginOwner() {
        return this.getOrigin().getOwner();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getTargetOwner() {
        return ((AccessTarget)this.getTarget()).getOwner();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public TARGET getTarget() {
        return this.target;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOwner() {
        return this.getOrigin();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isDeclaredInLambda() {
        return this.declaredInLambda;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{origin=" + this.origin + ", target=" + this.target + ", lineNumber=" + this.lineNumber + this.additionalToStringFields() + '}';
    }

    String additionalToStringFields() {
        return "";
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        String description = this.origin.getDescription() + " " + this.descriptionVerb() + " " + this.getTarget().getDescription();
        return description + " in " + this.getSourceCodeLocation();
    }

    protected abstract String descriptionVerb();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<TryCatchBlock> getContainingTryBlocks() {
        return this.getOrigin().getTryCatchBlocks().stream().filter(block -> block.getAccessesContainedInTryBlock().contains(this)).collect(ImmutableSet.toImmutableSet());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        private Functions() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class Get {
            private Get() {
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static ChainableFunction<JavaAccess<?>, JavaCodeUnit> origin() {
                return new ChainableFunction<JavaAccess<?>, JavaCodeUnit>(){

                    @Override
                    public JavaCodeUnit apply(JavaAccess<?> input) {
                        return input.getOrigin();
                    }
                };
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public static <A extends JavaAccess<? extends T>, T extends AccessTarget> ChainableFunction<A, T> target() {
                return new ChainableFunction<A, T>(){

                    @Override
                    public T apply(A input) {
                        return ((JavaAccess)input).getTarget();
                    }
                };
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> originOwner(DescribedPredicate<? super JavaClass> predicate) {
            return Predicates.origin(HasOwner.Functions.Get.owner().is(predicate));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> origin(DescribedPredicate<? super JavaCodeUnit> predicate) {
            return predicate.onResultOf(Functions.Get.origin()).as("origin " + predicate.getDescription(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> originOwnerEqualsTargetOwner() {
            return new OriginOwnerEqualsTargetOwnerPredicate();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> targetOwner(DescribedPredicate<? super JavaClass> predicate) {
            return Predicates.target(HasOwner.Functions.Get.owner().is(predicate));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaAccess<?>> target(DescribedPredicate<? super AccessTarget> predicate) {
            return new TargetPredicate(predicate);
        }

        private static class OriginOwnerEqualsTargetOwnerPredicate
        extends DescribedPredicate<JavaAccess<?>> {
            OriginOwnerEqualsTargetOwnerPredicate() {
                super("origin owner equals target owner", new Object[0]);
            }

            @Override
            public boolean test(JavaAccess<?> input) {
                return input.getOriginOwner().equals(input.getTargetOwner());
            }
        }

        static class TargetPredicate<ACCESS extends JavaAccess<? extends TARGET>, TARGET extends AccessTarget>
        extends DescribedPredicate<ACCESS> {
            private final DescribedPredicate<? super TARGET> predicate;

            TargetPredicate(DescribedPredicate<? super TARGET> predicate) {
                super("target " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean test(ACCESS input) {
                return this.predicate.test(((JavaAccess)input).getTarget());
            }
        }
    }
}

