/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.Timer;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

public class DoAutomaticSave
implements ActionListener {
    static final String AUTOSAVE_EXTENSION = "autosave";
    private int changeState;
    private final boolean filesShouldBeDeletedAfterShutdown;
    private final MapModel model;
    private final int numberOfFiles;

    public DoAutomaticSave(MapModel model, int numberOfTempFiles, boolean filesShouldBeDeletedAfterShutdown) {
        this.model = model;
        this.numberOfFiles = numberOfTempFiles > 0 ? numberOfTempFiles : 1;
        this.filesShouldBeDeletedAfterShutdown = filesShouldBeDeletedAfterShutdown;
        this.changeState = model.getNumberOfChangesSinceLastSave();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.model.getNumberOfChangesSinceLastSave() == this.changeState) {
            return;
        }
        this.changeState = this.model.getNumberOfChangesSinceLastSave();
        if (this.changeState == 0) {
            return;
        }
        Timer timer = (Timer)e.getSource();
        timer.stop();
        try {
            ModeController currentModeController = Controller.getCurrentModeController();
            if (!(currentModeController instanceof MModeController)) {
                return;
            }
            UrlManager fileManager = UrlManager.getController();
            if (!(fileManager instanceof MFileManager)) {
                return;
            }
            MModeController modeController = (MModeController)currentModeController;
            URL url = this.model.getURL();
            File file = new File(url != null ? url.getFile() : this.model.getTitle() + ".mm");
            File pathToStore = MFileManager.backupDir(url != null ? file : null);
            pathToStore.mkdirs();
            File tempFile = MFileManager.renameBackupFiles(pathToStore, file, this.numberOfFiles, AUTOSAVE_EXTENSION);
            if (tempFile == null) {
                return;
            }
            if (this.filesShouldBeDeletedAfterShutdown) {
                tempFile.deleteOnExit();
            }
            if (tempFile.isFile() && tempFile.canWrite() || !tempFile.exists() && tempFile.getParentFile().canWrite()) {
                ((MFileManager)fileManager).saveInternal((MMapModel)this.model, tempFile, true);
                modeController.getController().getViewController().out(TextUtils.format((String)"automatically_save_message", (Object[])new Object[]{tempFile}));
            }
        }
        catch (Exception ex) {
            LogUtils.severe((String)"Error in automatic MapModel.save(): ", (Throwable)ex);
        }
    }
}

