/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import com.connectina.swing.fontchooser.JFontChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.dev.colorchooser.ColorChooser;
import org.gephi.ui.components.JColorBlackWhiteSwitcher;
import org.gephi.ui.components.JColorButton;
import org.gephi.ui.components.JDropDownButton;
import org.gephi.ui.components.JPopupButton;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.component.EdgeSettingsPanel;
import org.gephi.visualization.component.GlobalSettingsPanel;
import org.gephi.visualization.component.LabelAttributesPanel;
import org.gephi.visualization.component.LabelSettingsPanel;
import org.gephi.visualization.component.VizExtendedBar;
import org.gephi.visualization.component.VizToolbar;
import org.gephi.visualization.component.VizToolbarGroup;
import org.gephi.visualization.text.ColorMode;
import org.gephi.visualization.text.SizeMode;
import org.gephi.visualization.text.TextManager;
import org.gephi.visualization.text.TextModelImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class VizBarController {
    private VizToolbarGroup[] groups;
    private VizToolbar toolbar;
    private VizExtendedBar extendedBar;

    public VizBarController() {
        this.createDefaultGroups();
    }

    private void createDefaultGroups() {
        this.groups = new VizToolbarGroup[4];
        this.groups[0] = new GlobalGroupBar();
        this.groups[1] = new NodeGroupBar();
        this.groups[2] = new EdgeGroupBar();
        this.groups[3] = new LabelGroupBar();
        VizModel model = VizController.getInstance().getVizModel();
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("init")) {
                    VizModel model = VizController.getInstance().getVizModel();
                    VizBarController.this.toolbar.setEnable(!model.isDefaultModel());
                    ((NodeGroupBar)VizBarController.this.groups[1]).setModelValues(model);
                    ((EdgeGroupBar)VizBarController.this.groups[2]).setModelValues(model);
                    ((LabelGroupBar)VizBarController.this.groups[3]).setModelValues(model);
                }
            }
        });
    }

    public VizToolbar getToolbar() {
        VizModel model = VizController.getInstance().getVizModel();
        this.toolbar = new VizToolbar(this.groups);
        this.toolbar.setEnable(!model.isDefaultModel());
        return this.toolbar;
    }

    public VizExtendedBar getExtendedBar() {
        this.extendedBar = new VizExtendedBar(this.groups);
        return this.extendedBar;
    }

    private static class LabelGroupBar
    implements VizToolbarGroup {
        JComponent[] components = new JComponent[6];

        private LabelGroupBar() {
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Labels.groupBarTitle");
        }

        public void setModelValues(VizModel vizModel) {
            TextModelImpl model = vizModel.getTextModel();
            ((JPopupButton)this.components[0]).setSelectedItem((Object)model.getSizeMode());
            ((JPopupButton)this.components[1]).setSelectedItem((Object)model.getColorMode());
            ((JButton)this.components[2]).setText(model.getNodeFont().getFontName() + ", " + model.getNodeFont().getSize());
            ((JSlider)this.components[3]).setValue((int)(model.getNodeSizeFactor() * 100.0f));
        }

        @Override
        public JComponent[] getToolbarComponents() {
            TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
            final JPopupButton labelSizeModeButton = new JPopupButton();
            TextManager textManager = VizController.getInstance().getTextManager();
            for (SizeMode sm : textManager.getSizeModes()) {
                labelSizeModeButton.addItem((Object)sm, (Icon)sm.getIcon());
            }
            labelSizeModeButton.setSelectedItem((Object)model.getSizeMode());
            labelSizeModeButton.setChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SizeMode sm = (SizeMode)e.getSource();
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    model.setSizeMode(sm);
                }
            });
            labelSizeModeButton.setIcon((Icon)ImageUtilities.loadImageIcon((String)"VisualizationImpl/labelSizeMode.png", (boolean)false));
            labelSizeModeButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Labels.sizeMode"));
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    if (model.getSizeMode() != labelSizeModeButton.getSelectedItem()) {
                        labelSizeModeButton.setSelectedItem((Object)model.getSizeMode());
                    }
                }
            });
            this.components[0] = labelSizeModeButton;
            final JPopupButton labelColorModeButton = new JPopupButton();
            for (ColorMode cm : textManager.getColorModes()) {
                labelColorModeButton.addItem((Object)cm, (Icon)cm.getIcon());
            }
            labelColorModeButton.setSelectedItem((Object)textManager.getModel().getColorMode());
            labelColorModeButton.setChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ColorMode cm = (ColorMode)e.getSource();
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    model.setColorMode(cm);
                }
            });
            labelColorModeButton.setIcon((Icon)ImageUtilities.loadImageIcon((String)"VisualizationImpl/labelColorMode.png", (boolean)false));
            labelColorModeButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Labels.colorMode"));
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    if (model.getColorMode() != labelColorModeButton.getSelectedItem()) {
                        labelColorModeButton.setSelectedItem((Object)model.getColorMode());
                    }
                }
            });
            this.components[1] = labelColorModeButton;
            final JButton fontButton = new JButton(model.getNodeFont().getFontName() + ", " + model.getNodeFont().getSize());
            fontButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Labels.font"));
            fontButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    Font font = JFontChooser.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Font)model.getNodeFont());
                    if (font != null && font != model.getNodeFont()) {
                        model.setNodeFont(font);
                    }
                }
            });
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    fontButton.setText(model.getNodeFont().getFontName() + ", " + model.getNodeFont().getSize());
                }
            });
            this.components[2] = fontButton;
            final JSlider fontSizeSlider = new JSlider(0, 100, (int)(model.getNodeSizeFactor() * 100.0f));
            fontSizeSlider.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Labels.fontScale"));
            fontSizeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    model.setNodeSizeFactor((float)fontSizeSlider.getValue() / 100.0f);
                }
            });
            fontSizeSlider.setPreferredSize(new Dimension(100, 20));
            fontSizeSlider.setMaximumSize(new Dimension(100, 20));
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    if ((int)(model.getNodeSizeFactor() * 100.0f) != fontSizeSlider.getValue()) {
                        fontSizeSlider.setValue((int)(model.getNodeSizeFactor() * 100.0f));
                    }
                }
            });
            this.components[3] = fontSizeSlider;
            final ColorChooser colorChooser = new ColorChooser(model.getNodeColor());
            colorChooser.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Labels.defaultColor"));
            colorChooser.setPreferredSize(new Dimension(16, 16));
            colorChooser.setMaximumSize(new Dimension(16, 16));
            colorChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("color")) {
                        TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                        model.setNodeColor(colorChooser.getColor());
                    }
                }
            });
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    if (!model.getNodeColor().equals(colorChooser.getColor())) {
                        colorChooser.setColor(model.getNodeColor());
                    }
                }
            });
            this.components[4] = colorChooser;
            JButton attributesButton = new JButton();
            attributesButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/configureLabels.png", (boolean)false));
            attributesButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Labels.attributes"));
            attributesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextModelImpl model = VizController.getInstance().getVizModel().getTextModel();
                    LabelAttributesPanel panel = new LabelAttributesPanel();
                    panel.setup(model);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(VizBarController.class, (String)"LabelAttributesPanel.title"), true, 2, null, null);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                        panel.unsetup();
                        return;
                    }
                }
            });
            this.components[5] = attributesButton;
            return this.components;
        }

        @Override
        public JComponent getExtendedComponent() {
            LabelSettingsPanel panel = new LabelSettingsPanel();
            panel.setup();
            return panel;
        }

        @Override
        public boolean hasToolbar() {
            return true;
        }

        @Override
        public boolean hasExtended() {
            return true;
        }
    }

    private static class EdgeGroupBar
    implements VizToolbarGroup {
        JComponent[] components = new JComponent[4];

        private EdgeGroupBar() {
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Edges.groupBarTitle");
        }

        public void setModelValues(VizModel vizModel) {
            ((JToggleButton)this.components[2]).setSelected(vizModel.getTextModel().isShowEdgeLabels());
            ((JSlider)this.components[3]).setValue((int)((vizModel.getEdgeScale() - 0.1f) * 10.0f));
        }

        @Override
        public JComponent[] getToolbarComponents() {
            VizModel vizModel = VizController.getInstance().getVizModel();
            final JToggleButton showEdgeButton = new JToggleButton();
            showEdgeButton.setSelected(vizModel.isShowEdges());
            showEdgeButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Edges.showEdges"));
            showEdgeButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/showEdges.png", (boolean)false));
            showEdgeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VizModel vizModel = VizController.getInstance().getVizModel();
                    vizModel.setShowEdges(showEdgeButton.isSelected());
                }
            });
            vizModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("showEdges")) {
                        VizModel vizModel = VizController.getInstance().getVizModel();
                        if (showEdgeButton.isSelected() != vizModel.isShowEdges()) {
                            showEdgeButton.setSelected(vizModel.isShowEdges());
                        }
                    }
                }
            });
            this.components[0] = showEdgeButton;
            final JToggleButton edgeHasNodeColorButton = new JToggleButton();
            edgeHasNodeColorButton.setSelected(!vizModel.isEdgeHasUniColor());
            edgeHasNodeColorButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Edges.edgeNodeColor"));
            edgeHasNodeColorButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/edgeNodeColor.png", (boolean)false));
            edgeHasNodeColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VizModel vizModel = VizController.getInstance().getVizModel();
                    vizModel.setEdgeHasUniColor(!edgeHasNodeColorButton.isSelected());
                }
            });
            vizModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("edgeHasUniColor")) {
                        VizModel vizModel = VizController.getInstance().getVizModel();
                        if (edgeHasNodeColorButton.isSelected() != !vizModel.isEdgeHasUniColor()) {
                            edgeHasNodeColorButton.setSelected(!vizModel.isEdgeHasUniColor());
                        }
                    }
                }
            });
            this.components[1] = edgeHasNodeColorButton;
            final JToggleButton showLabelsButton = new JToggleButton();
            showLabelsButton.setSelected(vizModel.getTextModel().isShowEdgeLabels());
            showLabelsButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Edges.showLabels"));
            showLabelsButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/showEdgeLabels.png", (boolean)false));
            showLabelsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VizModel vizModel = VizController.getInstance().getVizModel();
                    vizModel.getTextModel().setShowEdgeLabels(showLabelsButton.isSelected());
                }
            });
            vizModel.getTextModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl textModel = VizController.getInstance().getVizModel().getTextModel();
                    if (showLabelsButton.isSelected() != textModel.isShowEdgeLabels()) {
                        showLabelsButton.setSelected(textModel.isShowEdgeLabels());
                    }
                }
            });
            this.components[2] = showLabelsButton;
            final JSlider edgeScaleSlider = new JSlider(0, 100, (int)((vizModel.getEdgeScale() - 0.1f) * 10.0f));
            edgeScaleSlider.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Edges.edgeScale"));
            edgeScaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    VizModel vizModel = VizController.getInstance().getVizModel();
                    if (vizModel.getEdgeScale() != (float)edgeScaleSlider.getValue() / 10.0f + 0.1f) {
                        vizModel.setEdgeScale((float)edgeScaleSlider.getValue() / 10.0f + 0.1f);
                    }
                }
            });
            edgeScaleSlider.setPreferredSize(new Dimension(100, 20));
            edgeScaleSlider.setMaximumSize(new Dimension(100, 20));
            vizModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    VizModel vizModel;
                    if (evt.getPropertyName().equals("edgeScale") && (vizModel = VizController.getInstance().getVizModel()).getEdgeScale() != (float)edgeScaleSlider.getValue() / 10.0f + 0.1f) {
                        edgeScaleSlider.setValue((int)((vizModel.getEdgeScale() - 0.1f) * 10.0f));
                    }
                }
            });
            this.components[3] = edgeScaleSlider;
            return this.components;
        }

        @Override
        public JComponent getExtendedComponent() {
            EdgeSettingsPanel panel = new EdgeSettingsPanel();
            panel.setup();
            return panel;
        }

        @Override
        public boolean hasToolbar() {
            return true;
        }

        @Override
        public boolean hasExtended() {
            return true;
        }
    }

    private static class NodeGroupBar
    implements VizToolbarGroup {
        JComponent[] components = new JComponent[1];

        private NodeGroupBar() {
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Nodes.groupBarTitle");
        }

        public void setModelValues(VizModel vizModel) {
            ((JToggleButton)this.components[0]).setSelected(vizModel.getTextModel().isShowNodeLabels());
        }

        @Override
        public JComponent[] getToolbarComponents() {
            VizModel vizModel = VizController.getInstance().getVizModel();
            final JToggleButton showLabelsButton = new JToggleButton();
            showLabelsButton.setSelected(vizModel.getTextModel().isShowNodeLabels());
            showLabelsButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Nodes.showLabels"));
            showLabelsButton.setIcon(ImageUtilities.loadImageIcon((String)"VisualizationImpl/showNodeLabels.png", (boolean)false));
            showLabelsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VizModel vizModel = VizController.getInstance().getVizModel();
                    vizModel.getTextModel().setShowNodeLabels(showLabelsButton.isSelected());
                }
            });
            vizModel.getTextModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TextModelImpl textModel = VizController.getInstance().getVizModel().getTextModel();
                    if (showLabelsButton.isSelected() != textModel.isShowNodeLabels()) {
                        showLabelsButton.setSelected(textModel.isShowNodeLabels());
                    }
                }
            });
            this.components[0] = showLabelsButton;
            return this.components;
        }

        @Override
        public JComponent getExtendedComponent() {
            return null;
        }

        @Override
        public boolean hasToolbar() {
            return true;
        }

        @Override
        public boolean hasExtended() {
            return true;
        }
    }

    private static class GlobalGroupBar
    implements VizToolbarGroup {
        private GlobalGroupBar() {
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Global.groupBarTitle");
        }

        @Override
        public JComponent[] getToolbarComponents() {
            JComponent[] components = new JComponent[2];
            VizModel vizModel = VizController.getInstance().getVizModel();
            JColorBlackWhiteSwitcher backgroundColorButton = new JColorBlackWhiteSwitcher(vizModel.getBackgroundColor());
            backgroundColorButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Global.background"));
            backgroundColorButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener((JButton)backgroundColorButton){
                final /* synthetic */ JButton val$backgroundColorButton;
                {
                    this.val$backgroundColorButton = jButton;
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    VizModel vizModel = VizController.getInstance().getVizModel();
                    Color backgroundColor = ((JColorBlackWhiteSwitcher)this.val$backgroundColorButton).getColor();
                    vizModel.setBackgroundColor(backgroundColor);
                    TextModelImpl textModel = VizController.getInstance().getVizModel().getTextModel();
                    boolean isDarkBackground = (backgroundColor.getRed() + backgroundColor.getGreen() + backgroundColor.getBlue()) / 3 < 128;
                    textModel.setNodeColor(isDarkBackground ? Color.WHITE : Color.BLACK);
                }
            });
            vizModel.addPropertyChangeListener(new PropertyChangeListener((JButton)backgroundColorButton){
                final /* synthetic */ JButton val$backgroundColorButton;
                {
                    this.val$backgroundColorButton = jButton;
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("backgroundColor")) {
                        VizModel vizModel = VizController.getInstance().getVizModel();
                        if (!((JColorBlackWhiteSwitcher)this.val$backgroundColorButton).getColor().equals(vizModel.getBackgroundColor())) {
                            ((JColorBlackWhiteSwitcher)this.val$backgroundColorButton).setColor(vizModel.getBackgroundColor());
                        }
                    }
                }
            });
            components[0] = backgroundColorButton;
            JPopupMenu screenshotPopup = new JPopupMenu();
            JMenuItem configureScreenshotItem = new JMenuItem(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Global.screenshot.configure"));
            configureScreenshotItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VizController.getInstance().getScreenshotMaker().configure();
                }
            });
            screenshotPopup.add(configureScreenshotItem);
            JDropDownButton screenshotButton = new JDropDownButton((Icon)ImageUtilities.loadImageIcon((String)"VisualizationImpl/screenshot.png", (boolean)false), screenshotPopup);
            screenshotButton.setToolTipText(NbBundle.getMessage(VizBarController.class, (String)"VizToolbar.Global.screenshot"));
            screenshotButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VizController.getInstance().getScreenshotMaker().takeScreenshot();
                }
            });
            components[1] = screenshotButton;
            return components;
        }

        @Override
        public JComponent getExtendedComponent() {
            GlobalSettingsPanel panel = new GlobalSettingsPanel();
            panel.setup();
            return panel;
        }

        @Override
        public boolean hasToolbar() {
            return true;
        }

        @Override
        public boolean hasExtended() {
            return true;
        }
    }
}

