/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes;

import javax.swing.Icon;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.nodes.BasicNodesManipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SelectEdgesOnTable
extends BasicNodesManipulator {
    private Node node;
    private Edge[] edges;

    public void setup(Node[] nodes, Node clickedNode) {
        this.node = clickedNode;
        if (((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).isNodeInGraph(this.node)) {
            this.edges = ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getNodeEdges(this.node);
        }
    }

    public void execute() {
        DataTablesController dtc = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class);
        dtc.setEdgeTableSelection(this.edges);
        dtc.selectEdgesTable();
    }

    public String getName() {
        return NbBundle.getMessage(SelectEdgesOnTable.class, (String)"SelectEdgesOnTable.name");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        return this.edges != null;
    }

    public ManipulatorUI getUI() {
        return null;
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 200;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/table-select-row.png", (boolean)false);
    }
}

