/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import tim.prune.App;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.Unit;
import tim.prune.function.SingleNumericParameterFunction;

public class SetAltitudeTolerance
extends SingleNumericParameterFunction {
    public SetAltitudeTolerance(App app) {
        super(app, 0, 100);
    }

    @Override
    public String getNameKey() {
        return "function.setaltitudetolerance";
    }

    @Override
    public String getDescriptionKey() {
        boolean bl = Config.getUnitSet().getAltitudeUnit().isStandard();
        return "dialog.setaltitudetolerance.text." + (bl ? "metres" : "feet");
    }

    @Override
    public int getCurrentParamValue() {
        int n = Config.getConfigInt("prune.altitudetolerance");
        Unit unit = Config.getUnitSet().getAltitudeUnit();
        if (unit.isStandard()) {
            return n / 100;
        }
        return (int)((double)n * unit.getMultFactorFromStd() / 100.0);
    }

    @Override
    public void completeFunction(int n) {
        Unit unit = Config.getUnitSet().getAltitudeUnit();
        int n2 = n * 100;
        if (!unit.isStandard()) {
            n2 = (int)((double)n * 100.0 / unit.getMultFactorFromStd());
        }
        Config.setConfigInt("prune.altitudetolerance", n2);
        UpdateMessageBroker.informSubscribers(4);
    }
}

