/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "baseDirFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "baseDirPath", "", "toPath", "file", "toFile", "path", "Companion", "kotlin-build-common"})
public class RelativeFileToPathConverter
implements FileToPathConverter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String baseDirPath;
    @NotNull
    private static final String PROJECT_DIR_PLACEHOLDER = "$PROJECT_DIR$";

    public RelativeFileToPathConverter(@Nullable File baseDirFile) {
        File file2 = baseDirFile;
        this.baseDirPath = file2 != null && (file2 = FilesKt.normalize((File)file2)) != null ? FilesKt.getInvariantSeparatorsPath((File)file2) : null;
    }

    @Override
    @NotNull
    public String toPath(@NotNull File file2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String path = FilesKt.getInvariantSeparatorsPath((File)FilesKt.normalize((File)file2));
        if (this.baseDirPath != null && StringsKt.startsWith$default((String)path, (String)this.baseDirPath, (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append(PROJECT_DIR_PLACEHOLDER);
            String string3 = path.substring(this.baseDirPath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string2 = stringBuilder.append(string3).toString();
        } else {
            string2 = path;
        }
        return string2;
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)PROJECT_DIR_PLACEHOLDER, (boolean)false, (int)2, null)) {
            String string2 = this.baseDirPath;
            if (string2 == null) {
                throw new IllegalStateException("Could not get project root dir".toString());
            }
            String basePath = string2;
            StringBuilder stringBuilder = new StringBuilder().append(basePath);
            String string3 = path.substring(13);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            file2 = new File(stringBuilder.append(string3).toString());
        } else {
            file2 = new File(path);
        }
        return file2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/RelativeFileToPathConverter$Companion;", "", "<init>", "()V", "PROJECT_DIR_PLACEHOLDER", "", "kotlin-build-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

