/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShBundle;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ShSuppressInspectionIntention
implements IntentionAction {
    private final String myInspectionCode;
    private final String myMessage;
    private final int myOffset;

    public ShSuppressInspectionIntention(String message, String inspectionCode, int offset) {
        this.myInspectionCode = inspectionCode;
        this.myMessage = message;
        this.myOffset = offset;
    }

    @NotNull
    public String getText() {
        String string = ShBundle.message("sh.suppress.inspection", this.myMessage);
        if (string == null) {
            ShSuppressInspectionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = ShBundle.message("sh.shell.script", new Object[0]);
        if (string == null) {
            ShSuppressInspectionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            ShSuppressInspectionIntention.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            ShSuppressInspectionIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        int lineStartOffset = DocumentUtil.getLineStartOffset((int)this.myOffset, (Document)document);
        CharSequence indent = DocumentUtil.getIndent((Document)document, (int)lineStartOffset);
        document.insertString(lineStartOffset, (CharSequence)(String.valueOf(indent) + "# shellcheck disable=" + this.myInspectionCode + "\n"));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/shellcheck/intention/ShSuppressInspectionIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/shellcheck/intention/ShSuppressInspectionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

