/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.maven.server.MavenArtifactEvent;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;

public final class LongRunningTaskStatus
implements Serializable {
    public static final LongRunningTaskStatus EMPTY = new LongRunningTaskStatus(0, 0, Collections.emptyList(), Collections.emptyList());
    private final int total;
    private final int finished;
    private final List<MavenServerConsoleEvent> consoleEvents;
    private final List<MavenArtifactEvent> downloadEvents;

    public LongRunningTaskStatus(int total, int finished, List<MavenServerConsoleEvent> consoleEvents, List<MavenArtifactEvent> downloadEvents) {
        this.total = total;
        this.finished = finished;
        this.consoleEvents = consoleEvents;
        this.downloadEvents = downloadEvents;
    }

    public int total() {
        return this.total;
    }

    public int finished() {
        return this.finished;
    }

    public double fraction() {
        int t = this.total;
        int f = this.finished;
        if (t == 0) {
            return 0.0;
        }
        return (double)f / (double)t;
    }

    public List<MavenServerConsoleEvent> consoleEvents() {
        return this.consoleEvents;
    }

    public List<MavenArtifactEvent> downloadEvents() {
        return this.downloadEvents;
    }

    public String toString() {
        return "LongRunningTaskStatus[total=" + this.total + ", finished=" + this.finished + ']';
    }
}

