/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.extensions.github.tables;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.markdown.MarkdownBlock;
import org.jetbrains.jewel.markdown.extensions.github.tables.TableHeader;
import org.jetbrains.jewel.markdown.extensions.github.tables.TableRow;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/jewel/markdown/extensions/github/tables/TableBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CustomBlock;", "header", "Lorg/jetbrains/jewel/markdown/extensions/github/tables/TableHeader;", "rows", "", "Lorg/jetbrains/jewel/markdown/extensions/github/tables/TableRow;", "<init>", "(Lorg/jetbrains/jewel/markdown/extensions/github/tables/TableHeader;Ljava/util/List;)V", "getHeader", "()Lorg/jetbrains/jewel/markdown/extensions/github/tables/TableHeader;", "getRows", "()Ljava/util/List;", "rowCount", "", "getRowCount", "()I", "columnCount", "getColumnCount", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.jewel.markdown.extensions.gfmTables"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGitHubTableProcessorExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubTableProcessorExtension.kt\norg/jetbrains/jewel/markdown/extensions/github/tables/TableBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1#2:167\n1740#3,3:168\n*S KotlinDebug\n*F\n+ 1 GitHubTableProcessorExtension.kt\norg/jetbrains/jewel/markdown/extensions/github/tables/TableBlock\n*L\n148#1:168,3\n*E\n"})
public final class TableBlock
implements MarkdownBlock.CustomBlock {
    @NotNull
    private final TableHeader header;
    @NotNull
    private final List<TableRow> rows;
    private final int rowCount;
    private final int columnCount;
    public static final int $stable = 8;

    public TableBlock(@NotNull TableHeader header, @NotNull List<TableRow> rows) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this.header = header;
        this.rows = rows;
        this.rowCount = this.rows.size() + 1;
        if (!(!((Collection)this.header.getCells()).isEmpty())) {
            boolean $i$a$-require-TableBlock$22 = false;
            String $i$a$-require-TableBlock$22 = "Header cannot be empty";
            throw new IllegalArgumentException($i$a$-require-TableBlock$22.toString());
        }
        int headerColumns = this.header.getCells().size();
        if (!((Collection)this.rows).isEmpty()) {
            boolean bl;
            int bodyColumns;
            block7: {
                bodyColumns = ((TableRow)CollectionsKt.first(this.rows)).getCells().size();
                Iterable $this$all$iv = this.rows;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        TableRow it = (TableRow)element$iv;
                        boolean bl2 = false;
                        if (it.getCells().size() == bodyColumns) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean $i$a$-require-TableBlock$52 = false;
                String $i$a$-require-TableBlock$52 = "Inconsistent cell count in table body";
                throw new IllegalArgumentException($i$a$-require-TableBlock$52.toString());
            }
            if (!(headerColumns == bodyColumns)) {
                boolean bl3 = false;
                String string = "Inconsistent cell count between table body and header";
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.columnCount = headerColumns;
    }

    @NotNull
    public final TableHeader getHeader() {
        return this.header;
    }

    @NotNull
    public final List<TableRow> getRows() {
        return this.rows;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }

    @NotNull
    public final TableHeader component1() {
        return this.header;
    }

    @NotNull
    public final List<TableRow> component2() {
        return this.rows;
    }

    @NotNull
    public final TableBlock copy(@NotNull TableHeader header, @NotNull List<TableRow> rows) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        return new TableBlock(header, rows);
    }

    public static /* synthetic */ TableBlock copy$default(TableBlock tableBlock, TableHeader tableHeader, List list, int n, Object object) {
        if ((n & 1) != 0) {
            tableHeader = tableBlock.header;
        }
        if ((n & 2) != 0) {
            list = tableBlock.rows;
        }
        return tableBlock.copy(tableHeader, list);
    }

    @NotNull
    public String toString() {
        return "TableBlock(header=" + this.header + ", rows=" + this.rows + ")";
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = result * 31 + ((Object)this.rows).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TableBlock)) {
            return false;
        }
        TableBlock tableBlock = (TableBlock)other;
        if (!Intrinsics.areEqual((Object)this.header, (Object)tableBlock.header)) {
            return false;
        }
        return Intrinsics.areEqual(this.rows, tableBlock.rows);
    }
}

